/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.pag.VirtualCallSite;
import qilin.pta.toolkits.debloaterx.HeapContainerQuery;
import qilin.pta.toolkits.debloaterx.InterFlowAnalysis;
import qilin.pta.toolkits.debloaterx.XPAG;
import qilin.util.PTAUtils;
import qilin.util.Stopwatch;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.NumberedString;
import soot.util.queue.QueueReader;

public class XUtility {
    protected final PTA pta;
    protected final PAG pag;
    protected final Map<AllocNode, HeapContainerQuery> o2HCQ = new ConcurrentHashMap<AllocNode, HeapContainerQuery>();
    protected final Map<AllocNode, Set<SparkField>> o2Fields = new ConcurrentHashMap<AllocNode, Set<SparkField>>();
    protected final Map<Type, Set<SparkField>> t2Fields = new ConcurrentHashMap<Type, Set<SparkField>>();
    protected final Map<AllocNode, Map<SparkField, Set<VarNode>>> o2nonThisFStores = new ConcurrentHashMap<AllocNode, Map<SparkField, Set<VarNode>>>();
    protected final Map<Type, Map<SparkField, Set<VarNode>>> t2nonThisFStores = new ConcurrentHashMap<Type, Map<SparkField, Set<VarNode>>>();
    protected final Map<AllocNode, Map<SparkField, Set<VarNode>>> o2nonThisFLoads = new ConcurrentHashMap<AllocNode, Map<SparkField, Set<VarNode>>>();
    protected final Map<Type, Map<SparkField, Set<VarNode>>> t2nonThisFLoads = new ConcurrentHashMap<Type, Map<SparkField, Set<VarNode>>>();
    protected final Map<AllocNode, Set<SootMethod>> o2InvokedMethods = new HashMap<AllocNode, Set<SootMethod>>();
    protected final Map<Type, Set<SootMethod>> t2InvokedMethods = new HashMap<Type, Set<SootMethod>>();
    protected final Map<SootMethod, Set<AllocNode>> m2receiverObjects = new HashMap<SootMethod, Set<AllocNode>>();
    protected final Set<Type> rawOrPolyTypes = new HashSet<Type>();
    protected final XPAG xpag;
    protected final InterFlowAnalysis interfa;

    public XUtility(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        Stopwatch stopwatch = Stopwatch.newAndStart("HackUtility construction");
        this.buildHeapFieldsMapping();
        this.buildHeapMethodsMapping();
        this.computeRawOrPolyTypes();
        this.xpag = new XPAG(pta, this);
        this.interfa = new InterFlowAnalysis(this);
        stopwatch.stop();
        System.out.println(stopwatch);
    }

    public PTA getPta() {
        return this.pta;
    }

    public XPAG getXpag() {
        return this.xpag;
    }

    public InterFlowAnalysis getInterFlowAnalysis() {
        return this.interfa;
    }

    private boolean isImpreciseType(Type type) {
        if (type == RefType.v("java.lang.Object")) {
            return true;
        }
        if (type instanceof RefType) {
            RefType refType = (RefType)type;
            SootClass sc = refType.getSootClass();
            return sc.isAbstract() || sc.isInterface() || sc.getShortName().startsWith("Abstract");
        }
        return false;
    }

    public boolean isCoarseType(Type type) {
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            type = at.getElementType();
        }
        return this.isImpreciseType(type) || this.rawOrPolyTypes().contains(type);
    }

    private void computeRawOrPolyTypes() {
        HashSet<Object> types = new HashSet<Object>();
        for (AllocNode heap : this.pag.getAllocNodes()) {
            Type type = heap.getType();
            if (type instanceof ArrayType) {
                ArrayType at = (ArrayType)type;
                Type et = at.getElementType();
                if (this.isImpreciseType(et)) {
                    this.rawOrPolyTypes.add(et);
                    continue;
                }
                types.add(et);
                continue;
            }
            for (SparkField field : this.getFields(heap)) {
                Type ft = field.getType();
                if (ft instanceof ArrayType) {
                    ArrayType fat = (ArrayType)ft;
                    ft = fat.getElementType();
                }
                if (this.isImpreciseType(ft)) {
                    this.rawOrPolyTypes.add(ft);
                    this.rawOrPolyTypes.add(type);
                    continue;
                }
                types.add(type);
                types.add(ft);
            }
        }
        boolean continueUpdating = true;
        while (continueUpdating) {
            continueUpdating = false;
            for (Type type : types) {
                for (SparkField field : this.getFields(type)) {
                    Type ft = field.getType();
                    if (!this.isCoarseType(ft) || !this.rawOrPolyTypes.add(type)) continue;
                    continueUpdating = true;
                }
            }
        }
    }

    private Set<Type> rawOrPolyTypes() {
        return this.rawOrPolyTypes;
    }

    private void buildHeapFieldsMappingIn(SootMethod method) {
        Map f2bsx;
        Map f2bs;
        boolean isNonthisBase;
        SparkField field;
        MethodPAG srcmpag = this.pag.getMethodPAG(method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
        HashSet<FieldRefNode> stores = new HashSet<FieldRefNode>();
        HashSet<FieldRefNode> loads = new HashSet<FieldRefNode>();
        HashSet<Node> thisAliases = new HashSet<Node>();
        thisAliases.add(thisRef);
        Object reader = srcmpag.getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            Node from = (Node)((QueueReader)reader).next();
            Node to = (Node)((QueueReader)reader).next();
            if (from instanceof LocalVarNode) {
                if (to instanceof FieldRefNode) {
                    FieldRefNode frn = (FieldRefNode)to;
                    stores.add(frn);
                }
                if (!thisAliases.contains(from) || !(to instanceof LocalVarNode)) continue;
                thisAliases.add(to);
                continue;
            }
            if (!(from instanceof FieldRefNode)) continue;
            FieldRefNode frn = (FieldRefNode)from;
            loads.add(frn);
        }
        for (FieldRefNode frn : stores) {
            LocalVarNode storeBase = (LocalVarNode)frn.getBase();
            field = frn.getField();
            isNonthisBase = !thisAliases.contains(storeBase);
            for (AllocNode heap : this.pta.reachingObjects(storeBase).toCIPointsToSet().toCollection()) {
                this.o2Fields.computeIfAbsent(heap, k -> ConcurrentHashMap.newKeySet()).add(field);
                this.t2Fields.computeIfAbsent(heap.getType(), k -> ConcurrentHashMap.newKeySet()).add(field);
                if (!isNonthisBase) continue;
                f2bs = this.o2nonThisFStores.computeIfAbsent(heap, k -> new ConcurrentHashMap());
                f2bs.computeIfAbsent(field, k -> ConcurrentHashMap.newKeySet()).add(storeBase);
                f2bsx = this.t2nonThisFStores.computeIfAbsent(heap.getType(), k -> new ConcurrentHashMap());
                f2bsx.computeIfAbsent(field, k -> ConcurrentHashMap.newKeySet()).add(storeBase);
            }
        }
        for (FieldRefNode frn : loads) {
            LocalVarNode loadBase = (LocalVarNode)frn.getBase();
            field = frn.getField();
            isNonthisBase = !thisAliases.contains(loadBase);
            for (AllocNode heap : this.pta.reachingObjects(loadBase).toCIPointsToSet().toCollection()) {
                this.o2Fields.computeIfAbsent(heap, k -> ConcurrentHashMap.newKeySet()).add(field);
                this.t2Fields.computeIfAbsent(heap.getType(), k -> ConcurrentHashMap.newKeySet()).add(field);
                if (!isNonthisBase) continue;
                f2bs = this.o2nonThisFLoads.computeIfAbsent(heap, k -> new ConcurrentHashMap());
                f2bs.computeIfAbsent(field, k -> ConcurrentHashMap.newKeySet()).add(loadBase);
                f2bsx = this.t2nonThisFLoads.computeIfAbsent(heap.getType(), k -> new ConcurrentHashMap());
                f2bsx.computeIfAbsent(field, k -> ConcurrentHashMap.newKeySet()).add(loadBase);
            }
        }
    }

    private void buildHeapFieldsMapping() {
        this.pta.getNakedReachableMethods().stream().filter(m4 -> !m4.isPhantom()).forEach(this::buildHeapFieldsMappingIn);
    }

    private void buildHeapMethodsMapping() {
        CallGraph callgraph = this.pta.getCallGraph();
        HashSet<VirtualCallSite> vcallsites = new HashSet<VirtualCallSite>();
        for (Edge edge : callgraph) {
            SootMethod tgtM = edge.tgt();
            if (tgtM.isStatic() || tgtM.isPhantom()) continue;
            Stmt s2 = edge.srcStmt();
            InvokeExpr ie = s2.getInvokeExpr();
            if (ie instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                LocalVarNode receiver = this.pag.findLocalVarNode(iie.getBase());
                NumberedString subSig = iie.getMethodRef().getSubSignature();
                VirtualCallSite virtualCallSite = new VirtualCallSite(receiver, s2, edge.src(), iie, subSig, Edge.ieToKind(iie));
                vcallsites.add(virtualCallSite);
                continue;
            }
            throw new RuntimeException("ie could not be of " + ie.getClass());
        }
        for (VirtualCallSite vcallsite : vcallsites) {
            InstanceInvokeExpr iie = vcallsite.iie();
            LocalVarNode receiver = this.pag.findLocalVarNode(iie.getBase());
            for (AllocNode heap : this.pta.reachingObjects(receiver).toCIPointsToSet().toCollection()) {
                QueueReader<SootMethod> reader = PTAUtils.dispatch(heap.getType(), vcallsite);
                while (reader.hasNext()) {
                    SootMethod tgtM = reader.next();
                    this.m2receiverObjects.computeIfAbsent(tgtM, k -> new HashSet()).add(heap);
                    this.o2InvokedMethods.computeIfAbsent(heap, k -> new HashSet()).add(tgtM);
                    this.t2InvokedMethods.computeIfAbsent(heap.getType(), k -> new HashSet()).add(tgtM);
                }
            }
        }
    }

    public Set<AllocNode> getReceiverObjects(SootMethod method) {
        return this.m2receiverObjects.getOrDefault(method, Collections.emptySet());
    }

    public Set<SootMethod> getInvokedMethods(AllocNode heap) {
        return this.o2InvokedMethods.getOrDefault(heap, Collections.emptySet());
    }

    public HeapContainerQuery getHCQ(AllocNode heap) {
        HeapContainerQuery hcq = this.o2HCQ.get(heap);
        if (hcq == null) {
            hcq = new HeapContainerQuery(this, heap);
            this.o2HCQ.put(heap, hcq);
        }
        return hcq;
    }

    public Set<SparkField> getFields() {
        Set tmp = this.o2Fields.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet<SparkField> ret = new HashSet<SparkField>();
        for (SparkField field : tmp) {
            Type type = field.getType();
            if (!this.isCoarseType(type)) continue;
            ret.add(field);
        }
        return ret;
    }

    public Set<SparkField> getFields(AllocNode heap) {
        return this.o2Fields.getOrDefault(heap, Collections.emptySet());
    }

    public Set<SparkField> getFields(Type type) {
        if (type instanceof RefType) {
            RefType refType = (RefType)type;
            Set ret = this.t2Fields.get(refType);
            if (ret != null) {
                return ret;
            }
            ret = this.t2Fields.computeIfAbsent(refType, k -> new HashSet());
            for (AllocNode heap : this.o2Fields.keySet()) {
                if (!PTAScene.v().getOrMakeFastHierarchy().canStoreType(heap.getType(), refType)) continue;
                for (SparkField sparkField : this.o2Fields.get(heap)) {
                    if (sparkField instanceof SootField) {
                        SootField sf = (SootField)sparkField;
                        RefType declType = sf.getDeclaringClass().getType();
                        if (!PTAScene.v().getOrMakeFastHierarchy().canStoreType(type, declType)) continue;
                        ret.add(sparkField);
                        continue;
                    }
                    throw new RuntimeException(sparkField + ";" + sparkField.getClass());
                }
            }
            return ret;
        }
        return Collections.emptySet();
    }

    public boolean hasNonThisStoreOnField(AllocNode heap, SparkField field) {
        Map field2bases = this.o2nonThisFStores.getOrDefault(heap, Collections.emptyMap());
        return field2bases.containsKey(field);
    }

    public boolean hasNonThisLoadFromField(AllocNode heap, SparkField field) {
        Map field2bases = this.o2nonThisFLoads.getOrDefault(heap, Collections.emptyMap());
        return field2bases.containsKey(field);
    }
}

