/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ConstantNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.pta.toolkits.debloaterx.Edge;
import qilin.pta.toolkits.debloaterx.EdgeKind;
import qilin.pta.toolkits.debloaterx.XUtility;
import qilin.util.PTAUtils;
import soot.RefLikeType;
import soot.RefType;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.SparkField;
import soot.util.queue.QueueReader;

public class XPAG {
    protected final Map<Node, Set<Edge>> outEdges = new ConcurrentHashMap<Node, Set<Edge>>();
    protected final PTA pta;
    protected final PAG pag;
    private final LocalVarNode dummyThis;
    protected final XUtility utility;

    public XPAG(PTA pta, XUtility utility) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.utility = utility;
        this.dummyThis = new LocalVarNode("DUMMYTHIS", RefType.v("java.lang.Object"), null);
        this.buildGraph(pta.getNakedReachableMethods());
    }

    protected void buildGraph(Collection<SootMethod> reachables) {
        reachables.parallelStream().forEach(this::buildInternal);
    }

    protected void buildInternal(SootMethod method) {
        this.buildInternalWithInline(method);
    }

    protected void buildInternalWithInline(SootMethod method) {
        MethodPAG srcmpag = this.pag.getMethodPAG(method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        VarNode thisNode = srcnf.caseThis();
        this.addThisEdge((LocalVarNode)thisNode);
        Object reader = srcmpag.getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            Node from = (Node)((QueueReader)reader).next();
            Node to = (Node)((QueueReader)reader).next();
            if (from instanceof LocalVarNode) {
                if (to instanceof LocalVarNode) {
                    this.addAssignEdge((LocalVarNode)from, (LocalVarNode)to);
                    continue;
                }
                if (!(to instanceof FieldRefNode)) continue;
                FieldRefNode fr = (FieldRefNode)to;
                this.addStoreEdge((LocalVarNode)from, (LocalVarNode)fr.getBase(), fr.getField());
                continue;
            }
            if (from instanceof AllocNode) {
                if (!(to instanceof LocalVarNode)) continue;
                this.addNewEdge((AllocNode)from, (LocalVarNode)to);
                continue;
            }
            if (!(from instanceof FieldRefNode)) continue;
            FieldRefNode fr = (FieldRefNode)from;
            this.addLoadEdge((LocalVarNode)fr.getBase(), (LocalVarNode)to, fr.getField());
        }
        for (Unit u : srcmpag.getInvokeStmts()) {
            Value dest;
            Stmt s2 = (Stmt)u;
            InvokeExpr ie = s2.getInvokeExpr();
            int numArgs = ie.getArgCount();
            Value[] args = new Value[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                Value arg = ie.getArg(i);
                if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
                args[i] = arg;
            }
            LocalVarNode retDest = null;
            if (s2 instanceof AssignStmt && (dest = ((AssignStmt)s2).getLeftOp()).getType() instanceof RefLikeType) {
                retDest = this.pag.findLocalVarNode(dest);
            }
            if (ie instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                LocalVarNode receiver = this.pag.findLocalVarNode(iie.getBase());
                if (iie instanceof SpecialInvokeExpr) {
                    SpecialInvokeExpr sie = (SpecialInvokeExpr)iie;
                    this.inline(s2, sie.getMethod());
                    continue;
                }
                this.modelVirtualCall(numArgs, args, receiver, retDest);
                continue;
            }
            if (!(ie instanceof StaticInvokeExpr)) continue;
            StaticInvokeExpr sie = (StaticInvokeExpr)ie;
            SootMethod target = sie.getMethod();
            this.inline(s2, target);
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (!(method.getParameterType(i) instanceof RefLikeType) || PTAUtils.isPrimitiveArrayType(method.getParameterType(i))) continue;
            LocalVarNode param = (LocalVarNode)srcnf.caseParm(i);
            this.addParamEdge(param);
        }
        if (!method.isStatic()) {
            this.addParamEdge((LocalVarNode)srcnf.caseThis());
        }
        if (method.getReturnType() instanceof RefLikeType && !PTAUtils.isPrimitiveArrayType(method.getReturnType())) {
            this.addReturnEdge((LocalVarNode)srcnf.caseRet());
        }
    }

    private void modelVirtualCall(int numArgs, Value[] args, LocalVarNode receiver, LocalVarNode retDest) {
        for (int i = 0; i < numArgs; ++i) {
            ValNode argNode;
            if (args[i] == null || !((argNode = this.pag.findValNode(args[i])) instanceof LocalVarNode)) continue;
            this.addCStoreEdge((LocalVarNode)argNode, receiver);
        }
        if (retDest != null) {
            this.addCLoadEdge(receiver, retDest);
        }
        this.addCStoreEdge(receiver, receiver);
    }

    private void inline(Stmt invokeStmt, SootMethod method) {
        Value dest;
        InvokeExpr ie = invokeStmt.getInvokeExpr();
        int numArgs = ie.getArgCount();
        Value[] args = new Value[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            Value arg = ie.getArg(i);
            if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
            args[i] = arg;
        }
        LocalVarNode retDest = null;
        if (invokeStmt instanceof AssignStmt && (dest = ((AssignStmt)invokeStmt).getLeftOp()).getType() instanceof RefLikeType) {
            retDest = this.pag.findLocalVarNode(dest);
        }
        LocalVarNode receiver = null;
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            receiver = this.pag.findLocalVarNode(iie.getBase());
        }
        MethodPAG mpag = this.pag.getMethodPAG(method);
        MethodNodeFactory nodeFactory = mpag.nodeFactory();
        if (numArgs != method.getParameterCount()) {
            return;
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (args[i] == null || !(method.getParameterType(i) instanceof RefLikeType) || PTAUtils.isPrimitiveArrayType(method.getParameterType(i))) continue;
            LocalVarNode param = (LocalVarNode)nodeFactory.caseParm(i);
            ValNode argVal = this.pag.findValNode(args[i]);
            if (!(argVal instanceof LocalVarNode)) continue;
            LocalVarNode argNode = (LocalVarNode)argVal;
            this.addAssignEdge(argNode, param);
        }
        if (retDest != null && method.getReturnType() instanceof RefLikeType && !PTAUtils.isPrimitiveArrayType(method.getReturnType())) {
            this.addAssignEdge((LocalVarNode)nodeFactory.caseRet(), retDest);
        }
        if (receiver != null) {
            this.addAssignEdge(receiver, (LocalVarNode)nodeFactory.caseThis());
        }
    }

    protected void addNormalEdge(Edge edge) {
        this.outEdges.computeIfAbsent(edge.from, k -> ConcurrentHashMap.newKeySet()).add(edge);
    }

    protected void addNewEdge(AllocNode from, LocalVarNode to) {
        if (from.getMethod() == null && !(from instanceof ConstantNode)) {
            return;
        }
        Edge newEdge = new Edge(from, to, null, EdgeKind.NEW);
        this.addNormalEdge(newEdge);
        Edge iNewEdge = new Edge(to, from, null, EdgeKind.INEW);
        this.addNormalEdge(iNewEdge);
    }

    protected void addAssignEdge(LocalVarNode from, LocalVarNode to) {
        Edge assignEdge = new Edge(from, to, null, EdgeKind.ASSIGN);
        this.addNormalEdge(assignEdge);
        Edge iAssignEdge = new Edge(to, from, null, EdgeKind.IASSIGN);
        this.addNormalEdge(iAssignEdge);
    }

    protected void addStoreEdge(LocalVarNode from, LocalVarNode base, SparkField field) {
        Edge storeEdge = new Edge(from, base, field, EdgeKind.STORE);
        this.addNormalEdge(storeEdge);
        Edge iStoreEdge = new Edge(base, from, field, EdgeKind.ISTORE);
        this.addNormalEdge(iStoreEdge);
    }

    protected void addLoadEdge(LocalVarNode base, LocalVarNode to, SparkField field) {
        Edge loadEdge = new Edge(base, to, field, EdgeKind.LOAD);
        this.addNormalEdge(loadEdge);
        Edge iLoadEdge = new Edge(to, base, field, EdgeKind.ILOAD);
        this.addNormalEdge(iLoadEdge);
    }

    protected void addCStoreEdge(LocalVarNode from, LocalVarNode base) {
        Edge cstoreEdge = new Edge(from, base, null, EdgeKind.CSTORE);
        this.addNormalEdge(cstoreEdge);
        Edge iCstoreEdge = new Edge(base, from, null, EdgeKind.ICSTORE);
        this.addNormalEdge(iCstoreEdge);
    }

    protected void addCLoadEdge(LocalVarNode base, LocalVarNode to) {
        Edge cLoadEdge = new Edge(base, to, null, EdgeKind.CLOAD);
        this.addNormalEdge(cLoadEdge);
        Edge iCloadEdge = new Edge(to, base, null, EdgeKind.ICLOAD);
        this.addNormalEdge(iCloadEdge);
    }

    protected void addThisEdge(LocalVarNode thisNode) {
        Edge thisEdge = new Edge(thisNode, this.dummyThis, null, EdgeKind.THIS);
        this.addNormalEdge(thisEdge);
        Edge ithisEdge = new Edge(this.dummyThis, thisNode, null, EdgeKind.ITHIS);
        this.addNormalEdge(ithisEdge);
    }

    protected void addParamEdge(LocalVarNode param) {
        Edge paramEdge = new Edge(param, param, null, EdgeKind.PARAM);
        this.addNormalEdge(paramEdge);
    }

    protected void addReturnEdge(LocalVarNode ret) {
        Edge retEdge = new Edge(ret, ret, null, EdgeKind.RETURN);
        this.addNormalEdge(retEdge);
    }

    public Set<Edge> getOutEdges(Node node) {
        return this.outEdges.getOrDefault(node, Collections.emptySet());
    }

    public LocalVarNode getDummyThis() {
        return this.dummyThis;
    }
}

