/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.HashSet;
import java.util.Set;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.core.pag.VirtualCallSite;
import qilin.pta.toolkits.debloaterx.Edge;
import qilin.pta.toolkits.debloaterx.EdgeKind;
import qilin.pta.toolkits.debloaterx.HeapContainerQuery;
import qilin.pta.toolkits.debloaterx.State;
import qilin.pta.toolkits.debloaterx.XPAG;
import qilin.pta.toolkits.debloaterx.XUtility;
import qilin.util.PTAUtils;
import qilin.util.Pair;
import qilin.util.queue.UniqueQueue;
import soot.ArrayType;
import soot.RefLikeType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.SparkField;
import soot.util.NumberedString;
import soot.util.queue.QueueReader;

public class IntraFlowAnalysis {
    private final PAG pag;
    private final XUtility utility;
    private final SootMethod method;
    protected final XPAG xpag;
    protected final Set<LocalVarNode> params = new HashSet<LocalVarNode>();

    public IntraFlowAnalysis(XUtility utility, SootMethod method) {
        this.utility = utility;
        this.pag = utility.getPta().getPag();
        this.method = method;
        this.xpag = utility.getXpag();
        this.collectParams();
    }

    protected void collectParams() {
        MethodPAG srcmpag = this.pag.getMethodPAG(this.method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        VarNode thisNode = srcnf.caseThis();
        for (int i = 0; i < this.method.getParameterCount(); ++i) {
            if (!(this.method.getParameterType(i) instanceof RefLikeType) || PTAUtils.isPrimitiveArrayType(this.method.getParameterType(i))) continue;
            LocalVarNode param = (LocalVarNode)srcnf.caseParm(i);
            this.params.add(param);
        }
        this.params.add((LocalVarNode)thisNode);
    }

    Set<Node> epsilon(Node node) {
        UniqueQueue queue = new UniqueQueue();
        for (Edge edge : this.xpag.getOutEdges(node)) {
            queue.add(edge.to);
        }
        HashSet<Node> visit = new HashSet<Node>();
        while (!queue.isEmpty()) {
            Node front = (Node)queue.poll();
            visit.add(front);
            for (Edge edge : this.xpag.getOutEdges(front)) {
                if (edge.kind != EdgeKind.ASSIGN || visit.contains(edge.to)) continue;
                queue.add(edge.to);
            }
        }
        return visit;
    }

    public boolean isDirectlyReturnedHeap(AllocNode heap) {
        Set<Node> visit = this.epsilon(heap);
        boolean flag = false;
        for (Node node : visit) {
            LocalVarNode lvn;
            if (!(node instanceof LocalVarNode) || !(lvn = (LocalVarNode)node).isReturn()) continue;
            flag = true;
        }
        return flag;
    }

    public boolean isContentFromParam(AllocNode heap) {
        Type heapType = heap.getType();
        if (heapType instanceof RefType) {
            return this.isInstanceObjectContentFromParam(heap);
        }
        return this.isArrayContentFromParam(heap);
    }

    private boolean isInstanceObjectContentFromParam(AllocNode heap) {
        Set<Node> paramInArgs = this.collectParamInArguments(heap);
        if (paramInArgs.isEmpty()) {
            return false;
        }
        UniqueQueue queue = new UniqueQueue();
        HashSet<Node> visited = new HashSet<Node>();
        queue.addAll(this.params);
        while (!queue.isEmpty()) {
            Node front = (Node)queue.poll();
            if (paramInArgs.contains(front)) {
                return true;
            }
            visited.add(front);
            for (Edge edge : this.xpag.getOutEdges(front)) {
                if (edge.kind != EdgeKind.ASSIGN && edge.kind != EdgeKind.CLOAD && edge.kind != EdgeKind.LOAD || visited.contains(edge.to)) continue;
                queue.add(edge.to);
            }
        }
        return false;
    }

    private Set<Node> collectParamInArguments(AllocNode heap) {
        RefType type = (RefType)heap.getType();
        Set<Node> x = this.epsilon(heap);
        HashSet<Node> ret = new HashSet<Node>();
        HeapContainerQuery hcq = this.utility.getHCQ(heap);
        Set<LocalVarNode> inParams = hcq.getInParamsToCSFields();
        MethodPAG srcmpag = this.pag.getMethodPAG(this.method);
        for (Unit u : srcmpag.getInvokeStmts()) {
            InstanceInvokeExpr iie;
            LocalVarNode receiver;
            Stmt s2 = (Stmt)u;
            InvokeExpr ie = s2.getInvokeExpr();
            if (!(ie instanceof InstanceInvokeExpr) || !x.contains(receiver = this.pag.findLocalVarNode((iie = (InstanceInvokeExpr)ie).getBase()))) continue;
            int numArgs = ie.getArgCount();
            Value[] args = new Value[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                Value arg = ie.getArg(i);
                if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
                args[i] = arg;
            }
            NumberedString subSig = iie.getMethodRef().getSubSignature();
            VirtualCallSite virtualCallSite = new VirtualCallSite(receiver, s2, this.method, iie, subSig, soot.jimple.toolkits.callgraph.Edge.ieToKind(iie));
            QueueReader<SootMethod> targets = PTAUtils.dispatch(type, virtualCallSite);
            while (targets.hasNext()) {
                SootMethod target = targets.next();
                MethodPAG tgtmpag = this.pag.getMethodPAG(target);
                MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
                int numParms = target.getParameterCount();
                if (numParms != numArgs) {
                    System.out.println(target);
                }
                for (int i = 0; i < numParms; ++i) {
                    ValNode argNode;
                    if (!(target.getParameterType(i) instanceof RefLikeType) || args[i] == null || !((argNode = this.pag.findValNode(args[i])) instanceof LocalVarNode)) continue;
                    LocalVarNode lvn = (LocalVarNode)argNode;
                    LocalVarNode param = (LocalVarNode)tgtnf.caseParm(i);
                    if (!inParams.contains(param)) continue;
                    ret.add(lvn);
                }
            }
        }
        return ret;
    }

    private boolean isArrayContentFromParam(AllocNode heap) {
        if (!(heap.getType() instanceof ArrayType)) {
            return false;
        }
        Set<Node> x = this.epsilon(heap);
        UniqueQueue queue = new UniqueQueue();
        HashSet<Node> visited = new HashSet<Node>();
        queue.addAll(this.params);
        while (!queue.isEmpty()) {
            Node front = (Node)queue.poll();
            visited.add(front);
            for (Edge edge : this.xpag.getOutEdges(front)) {
                if (!(edge.kind != EdgeKind.ASSIGN && edge.kind != EdgeKind.CLOAD && edge.kind != EdgeKind.LOAD || visited.contains(edge.to))) {
                    queue.add(edge.to);
                }
                if (edge.kind != EdgeKind.STORE || !x.contains(edge.to)) continue;
                return true;
            }
        }
        return false;
    }

    private State nextState(State currState, EdgeKind kind) {
        switch (currState) {
            case O: {
                if (kind != EdgeKind.NEW) break;
                return State.VPlus;
            }
            case VPlus: {
                if (kind == EdgeKind.ASSIGN) {
                    return State.VPlus;
                }
                if (kind != EdgeKind.STORE) break;
                return State.VMinus;
            }
            case VMinus: {
                if (kind == EdgeKind.IASSIGN) {
                    return State.VMinus;
                }
                if (kind == EdgeKind.ILOAD) {
                    return State.VMinus;
                }
                if (kind != EdgeKind.INEW) break;
                return State.O;
            }
        }
        return State.Error;
    }

    private Set<Pair<Node, State>> getNextNodeStates(Pair<Node, State> nodeState, Set<Node> thisAlias, Set<SparkField> stFields) {
        Node node = nodeState.getFirst();
        State state = nodeState.getSecond();
        HashSet<Pair<Node, State>> ret = new HashSet<Pair<Node, State>>();
        for (Edge edge : this.xpag.getOutEdges(node)) {
            Type type;
            State nextState = this.nextState(state, edge.kind);
            if (nextState == State.Error) continue;
            if (edge.kind == EdgeKind.STORE && thisAlias.contains(edge.to)) {
                type = edge.field.getType();
                if (!this.utility.isCoarseType(type)) continue;
                stFields.add(edge.field);
                continue;
            }
            if (edge.kind == EdgeKind.ILOAD && thisAlias.contains(edge.to)) {
                type = edge.field.getType();
                if (!this.utility.isCoarseType(type)) continue;
                stFields.add(edge.field);
                continue;
            }
            ret.add(new Pair<Node, State>(edge.to, nextState));
        }
        return ret;
    }

    public Set<SparkField> retrieveStoreFields(AllocNode heap) {
        HashSet<SparkField> ret = new HashSet<SparkField>();
        MethodPAG srcmpag = this.pag.getMethodPAG(this.method);
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        VarNode thisNode = srcnf.caseThis();
        Set<Node> thisAlias = this.epsilon(thisNode);
        UniqueQueue queue = new UniqueQueue();
        HashSet<Pair> visited = new HashSet<Pair>();
        queue.add(new Pair<AllocNode, State>(heap, State.O));
        while (!queue.isEmpty()) {
            Pair front = (Pair)queue.poll();
            visited.add(front);
            Set<Pair<Node, State>> nextStates = this.getNextNodeStates(front, thisAlias, ret);
            for (Pair<Node, State> nextState : nextStates) {
                if (visited.contains(nextState)) continue;
                queue.add(nextState);
            }
        }
        return ret;
    }
}

