/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.toolkits.debloaterx.ContainerFinder;
import qilin.pta.toolkits.debloaterx.HeapContainerQuery;
import qilin.pta.toolkits.debloaterx.IntraFlowAnalysis;
import qilin.pta.toolkits.debloaterx.XUtility;
import soot.RefLikeType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.pag.SparkField;

public class DebloaterX {
    private final PTA pta;
    private final PAG pag;
    private final ContainerFinder containerFinder;
    private final XUtility utility;
    protected final Set<AllocNode> ctxDepHeaps = ConcurrentHashMap.newKeySet();
    protected final Set<AllocNode> containerFactory = ConcurrentHashMap.newKeySet();
    protected final Set<AllocNode> containerWrapper = ConcurrentHashMap.newKeySet();
    protected final Set<AllocNode> innerContainer = ConcurrentHashMap.newKeySet();

    public DebloaterX(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        this.utility = new XUtility(pta);
        this.containerFinder = new ContainerFinder(pta, this.utility);
        this.containerFinder.run();
    }

    private boolean isAFactoryCreatedContainer(AllocNode heap, IntraFlowAnalysis mpag) {
        SootMethod method = heap.getMethod();
        if (method.isStatic()) {
            Type type = method.getReturnType();
            if (!(type instanceof RefLikeType)) {
                return false;
            }
            MethodPAG methodPag = this.pag.getMethodPAG(method);
            VarNode mRet = methodPag.nodeFactory().caseRet();
            if (this.pta.reachingObjects(mRet).toCIPointsToSet().toCollection().contains(heap)) {
                return mpag.isDirectlyReturnedHeap(heap);
            }
        }
        return false;
    }

    private boolean isAContainerWrapper(AllocNode heap, IntraFlowAnalysis mpag) {
        SootMethod method = heap.getMethod();
        if (method.isStatic()) {
            return false;
        }
        Type type = method.getReturnType();
        if (!(type instanceof RefLikeType)) {
            return false;
        }
        MethodPAG methodPag = this.pag.getMethodPAG(method);
        VarNode mRet = methodPag.nodeFactory().caseRet();
        PointsToSet pts = this.pta.reachingObjects(mRet);
        Collection<AllocNode> ptsSet = pts.toCIPointsToSet().toCollection();
        if (ptsSet.contains(heap) && mpag.isDirectlyReturnedHeap(heap)) {
            return mpag.isContentFromParam(heap);
        }
        return false;
    }

    private boolean isAnInnerContainer(AllocNode heap, IntraFlowAnalysis mpag) {
        SootMethod method = heap.getMethod();
        if (method.isStatic()) {
            return false;
        }
        Set<SparkField> fields = mpag.retrieveStoreFields(heap);
        if (fields.isEmpty()) {
            return false;
        }
        Set<AllocNode> objects = this.utility.getReceiverObjects(method);
        for (AllocNode revobj : objects) {
            if (!(revobj.getType() instanceof RefType)) continue;
            HeapContainerQuery hcq = this.utility.getHCQ(revobj);
            for (SparkField field : fields) {
                if (!hcq.isCSField(field)) continue;
                return true;
            }
        }
        return false;
    }

    public void run() {
        HashMap<SootMethod, Set> m2o = new HashMap<SootMethod, Set>();
        for (AllocNode heap : this.pag.getAllocNodes()) {
            SootMethod method2 = heap.getMethod();
            if (method2 == null || method2.isStaticInitializer()) continue;
            m2o.computeIfAbsent(method2, k -> new HashSet()).add(heap);
        }
        m2o.keySet().parallelStream().forEach(method -> {
            IntraFlowAnalysis ifa = new IntraFlowAnalysis(this.utility, (SootMethod)method);
            for (AllocNode heap : (Set)m2o.get(method)) {
                if (!this.containerFinder.isAContainer(heap)) continue;
                if (this.isAFactoryCreatedContainer(heap, ifa)) {
                    this.containerFactory.add(heap);
                    this.ctxDepHeaps.add(heap);
                }
                if (this.isAContainerWrapper(heap, ifa)) {
                    this.containerWrapper.add(heap);
                    this.ctxDepHeaps.add(heap);
                }
                if (!this.isAnInnerContainer(heap, ifa)) continue;
                this.innerContainer.add(heap);
                this.ctxDepHeaps.add(heap);
            }
        });
        System.out.println("#OBJECTS:" + this.pag.getAllocNodes().size());
        System.out.println("#CS:" + this.ctxDepHeaps.size());
        System.out.println("#CI:" + (this.pag.getAllocNodes().size() - this.ctxDepHeaps.size()));
        System.out.println("#ContainerFactory:" + this.containerFactory.size());
        System.out.println("#ContainerWrapper:" + this.containerWrapper.size());
        System.out.println("#InnerContainer:" + this.innerContainer.size());
        int onlyInFactory = Sets.difference(Sets.difference(this.containerFactory, this.containerWrapper), this.innerContainer).size();
        int onlyInWrapper = Sets.difference(Sets.difference(this.containerWrapper, this.containerFactory), this.innerContainer).size();
        int onlyInInner = Sets.difference(Sets.difference(this.innerContainer, this.containerWrapper), this.containerFactory).size();
        int inAll = Sets.intersection(Sets.intersection(this.innerContainer, this.containerWrapper), this.containerFactory).size();
        int onlyInFactoryAndWrapper = Sets.difference(Sets.intersection(this.containerFactory, this.containerWrapper), this.innerContainer).size();
        int onlyInFactoryAndInner = Sets.difference(Sets.intersection(this.containerFactory, this.innerContainer), this.containerWrapper).size();
        int onlyInWrapperAndInner = Sets.difference(Sets.intersection(this.containerWrapper, this.innerContainer), this.containerFactory).size();
        System.out.println("#onlyInFactory:" + onlyInFactory);
        System.out.println("#onlyInWrapper:" + onlyInWrapper);
        System.out.println("#onlyInInner:" + onlyInInner);
        System.out.println("#inAll:" + inAll);
        System.out.println("#onlyInFactoryAndWrapper:" + onlyInFactoryAndWrapper);
        System.out.println("#onlyInFactoryAndInner:" + onlyInFactoryAndInner);
        System.out.println("#onlyInWrapperAndInner:" + onlyInWrapperAndInner);
        System.out.println("#SUM:" + (onlyInFactory + onlyInWrapper + onlyInInner + inAll + onlyInFactoryAndWrapper + onlyInFactoryAndInner + onlyInWrapperAndInner));
        System.out.println("venn3(subsets = (" + onlyInFactory + "," + onlyInWrapper + "," + onlyInFactoryAndWrapper + "," + onlyInInner + "," + onlyInFactoryAndInner + "," + onlyInWrapperAndInner + ", " + inAll + "))");
    }

    public Set<AllocNode> getCtxDepHeaps() {
        return this.ctxDepHeaps;
    }
}

