/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.debloaterx;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.spark.pag.SparkField;
import soot.util.queue.QueueReader;

public class CollectionHeuristic {
    protected final PTA pta;
    protected final PAG pag;
    protected final Map<Type, Set<SparkField>> t2Fields = new ConcurrentHashMap<Type, Set<SparkField>>();
    protected final Set<Type> containerType = ConcurrentHashMap.newKeySet();
    protected final Set<AllocNode> ctxDepHeaps = ConcurrentHashMap.newKeySet();

    public Set<AllocNode> getCtxDepHeaps() {
        return this.ctxDepHeaps;
    }

    public CollectionHeuristic(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
    }

    private void buildHeapFieldsMappingIn(SootMethod method) {
        SparkField field;
        MethodPAG srcmpag = this.pag.getMethodPAG(method);
        HashSet<FieldRefNode> stores = new HashSet<FieldRefNode>();
        HashSet<FieldRefNode> loads = new HashSet<FieldRefNode>();
        Object reader = srcmpag.getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            Node from = (Node)((QueueReader)reader).next();
            Node to = (Node)((QueueReader)reader).next();
            if (from instanceof LocalVarNode) {
                if (!(to instanceof FieldRefNode)) continue;
                FieldRefNode frn = (FieldRefNode)to;
                stores.add(frn);
                continue;
            }
            if (!(from instanceof FieldRefNode)) continue;
            FieldRefNode frn = (FieldRefNode)from;
            loads.add(frn);
        }
        for (FieldRefNode frn : stores) {
            LocalVarNode storeBase = (LocalVarNode)frn.getBase();
            field = frn.getField();
            for (AllocNode heap : this.pta.reachingObjects(storeBase).toCIPointsToSet().toCollection()) {
                this.t2Fields.computeIfAbsent(heap.getType(), k -> ConcurrentHashMap.newKeySet()).add(field);
            }
        }
        for (FieldRefNode frn : loads) {
            LocalVarNode loadBase = (LocalVarNode)frn.getBase();
            field = frn.getField();
            for (AllocNode heap : this.pta.reachingObjects(loadBase).toCIPointsToSet().toCollection()) {
                this.t2Fields.computeIfAbsent(heap.getType(), k -> ConcurrentHashMap.newKeySet()).add(field);
            }
        }
    }

    private void buildHeapFieldsMapping() {
        this.pta.getNakedReachableMethods().stream().filter(m4 -> !m4.isPhantom()).forEach(this::buildHeapFieldsMappingIn);
    }

    private boolean isImplementingCollection(SootClass sc) {
        HashSet<SootClass> allInterfaces = new HashSet<SootClass>(sc.getInterfaces());
        while (sc.hasSuperclass()) {
            sc = sc.getSuperclass();
            allInterfaces.addAll(sc.getInterfaces());
        }
        HashSet<SootClass> worklist = new HashSet<SootClass>();
        for (SootClass tmp : allInterfaces) {
            while (tmp.hasSuperclass() && tmp.getSuperclass().isInterface()) {
                worklist.add(tmp.getSuperclass());
                tmp = tmp.getSuperclass();
            }
        }
        allInterfaces.addAll(worklist);
        boolean flag = false;
        for (SootClass interf : allInterfaces) {
            if (interf.getType() != RefType.v("java.util.Collection")) continue;
            flag = true;
        }
        return flag;
    }

    private boolean isNestedInClassImplementCollection(SootClass sc) {
        if (!sc.isInnerClass()) {
            return false;
        }
        SootClass outer = sc.getOuterClass();
        if (this.isImplementingCollection(outer)) {
            return true;
        }
        return this.isNestedInClassImplementCollection(outer);
    }

    private void computeContainerTypes() {
        ArrayType at;
        block0: for (Type type : this.t2Fields.keySet()) {
            if (type instanceof RefType) {
                RefType refType = (RefType)type;
                SootClass sc = refType.getSootClass();
                if (this.isImplementingCollection(sc) || this.isNestedInClassImplementCollection(sc)) {
                    this.containerType.add(type);
                    continue;
                }
                for (SparkField sf : this.t2Fields.get(type)) {
                    if (sf.getType() != RefType.v("java.lang.Object")) continue;
                    this.containerType.add(type);
                    continue block0;
                }
                continue;
            }
            if (type instanceof ArrayType) {
                at = (ArrayType)type;
                if (at.baseType != RefType.v("java.lang.Object")) continue;
                this.containerType.add(at);
                continue;
            }
            System.out.println(type);
        }
        HashMap ft2t = new HashMap();
        for (Type type : this.t2Fields.keySet()) {
            if (type instanceof RefType) {
                for (SparkField sf : this.t2Fields.get(type)) {
                    Type sft = sf.getType();
                    if (sft instanceof ArrayType) {
                        ArrayType at2 = (ArrayType)sft;
                        sft = at2.baseType;
                    }
                    ft2t.computeIfAbsent(sft, k -> new HashSet()).add(type);
                }
                continue;
            }
            if (!(type instanceof ArrayType)) continue;
            at = (ArrayType)type;
            ft2t.computeIfAbsent(at.baseType, k -> new HashSet()).add(type);
        }
        HashSet<Type> hashSet = new HashSet<Type>();
        this.containerType.addAll(ft2t.getOrDefault(RefType.v("java.lang.Object"), Collections.emptySet()));
        for (Type t1 : this.containerType) {
            for (Type t2 : ft2t.getOrDefault(t1, Collections.emptySet())) {
                if (this.containerType.contains(t2)) continue;
                hashSet.add(t2);
            }
        }
        while (!hashSet.isEmpty()) {
            this.containerType.addAll(hashSet);
            HashSet<Type> hashSet2 = new HashSet<Type>();
            for (Type t1 : hashSet) {
                for (Type t2 : ft2t.getOrDefault(t1, Collections.emptySet())) {
                    if (this.containerType.contains(t2)) continue;
                    hashSet2.add(t2);
                }
            }
            hashSet.clear();
            hashSet.addAll(hashSet2);
        }
        System.out.println("#ContainerType:" + this.containerType.size());
    }

    private void computeContextDependentObjects() {
        for (AllocNode heap : this.pag.getAllocNodes()) {
            if (!this.containerType.contains(heap.getType())) continue;
            this.ctxDepHeaps.add(heap);
        }
        System.out.println("#OBJECTS:" + this.pag.getAllocNodes().size());
        System.out.println("#CS:" + this.ctxDepHeaps.size());
        System.out.println("#CI:" + (this.pag.getAllocNodes().size() - this.ctxDepHeaps.size()));
    }

    public void run() {
        this.buildHeapFieldsMapping();
        this.computeContainerTypes();
        this.computeContextDependentObjects();
    }
}

