/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.conch;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.VarNode;
import qilin.pta.toolkits.conch.AbstractPAG;
import qilin.pta.toolkits.conch.DFA;
import qilin.pta.toolkits.conch.PathEdge;
import qilin.pta.toolkits.conch.TranEdge;
import qilin.util.PTAUtils;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.Edge;

public class LeakAnalysis
extends AbstractPAG {
    private final Map<Node, Set<PathEdge>> pathEdges = new ConcurrentHashMap<Node, Set<PathEdge>>();
    private final Set<PathEdge> initialSeeds = ConcurrentHashMap.newKeySet();
    private final Set<AllocNode> result = ConcurrentHashMap.newKeySet();

    public LeakAnalysis(PTA prePTA) {
        super(prePTA);
        this.build();
        this.solve();
    }

    @Override
    protected void solve() {
        System.out.println("start analysis!");
        super.solve();
        System.out.println("finish MFG analysis!");
    }

    @Override
    protected void submitInitialSeeds() {
        this.initialSeeds.forEach(pe -> this.executor.execute(new PathEdgeProcessingTask((PathEdge)pe)));
    }

    @Override
    protected void addThrowEdge(Node throwNode) {
        super.addThrowEdge(throwNode);
        this.initialSeeds.add(new PathEdge(throwNode, DFA.State.B, throwNode, DFA.State.B));
    }

    @Override
    protected void addParamEdge(LocalVarNode param) {
        super.addParamEdge(param);
        this.initialSeeds.add(new PathEdge(param, DFA.State.F, param, DFA.State.F));
    }

    @Override
    protected void addReturnEdge(LocalVarNode mret) {
        super.addReturnEdge(mret);
        this.initialSeeds.add(new PathEdge(mret, DFA.State.B, mret, DFA.State.B));
    }

    @Override
    protected void addNewEdge(AllocNode from, LocalVarNode to) {
        super.addNewEdge(from, to);
        this.initialSeeds.add(new PathEdge(from, DFA.State.O, from, DFA.State.O));
    }

    private void addPathEdge(PathEdge pe) {
        Node tgtNode = pe.getTgtNode();
        this.pathEdges.computeIfAbsent(tgtNode, k -> ConcurrentHashMap.newKeySet()).add(pe);
    }

    private boolean containPathEdge(PathEdge pe) {
        Node tgtNode = pe.getTgtNode();
        return this.pathEdges.getOrDefault(tgtNode, Collections.emptySet()).contains(pe);
    }

    private void propagate(PathEdge pe) {
        if (!this.containPathEdge(pe)) {
            this.executor.execute(new PathEdgeProcessingTask(pe));
        }
    }

    private void addSummaryEdge(TranEdge tranEdge) {
        Node src = tranEdge.getSource();
        Node tgt = tranEdge.getTarget();
        DFA.TranCond tranCond = tranEdge.getTranCond();
        this.sumEdges.computeIfAbsent(src, k -> ConcurrentHashMap.newKeySet()).add(tranEdge);
        for (PathEdge pe : this.pathEdges.getOrDefault(src, Collections.emptySet())) {
            DFA.State tgtState = pe.getTgtState();
            DFA.State nextState = DFA.nextState(tgtState, tranCond);
            if (nextState == DFA.State.ERROR) continue;
            PathEdge nPE = new PathEdge(pe.getSrcNode(), pe.getSrcState(), tgt, nextState);
            this.propagate(nPE);
        }
    }

    public boolean isLeakObject(AllocNode heap) {
        return this.result.contains(heap);
    }

    private class PathEdgeProcessingTask
    implements Runnable {
        PathEdge pe;

        public PathEdgeProcessingTask(PathEdge pe) {
            this.pe = pe;
        }

        @Override
        public void run() {
            LeakAnalysis.this.addPathEdge(this.pe);
            DFA.State initState = this.pe.getSrcState();
            Node sourceNode = this.pe.getSrcNode();
            DFA.State targetState = this.pe.getTgtState();
            Node targetNode = this.pe.getTgtNode();
            for (TranEdge e : LeakAnalysis.this.outAndSummaryEdges(targetNode)) {
                LocalVarNode r;
                Stmt invokeStmt;
                MethodPAG srcmpag;
                SootMethod srcMethod;
                Edge edge;
                Iterator<Edge> it;
                SootMethod containingMethod;
                Node newTargetNode = e.getTarget();
                DFA.TranCond tranCond = e.getTranCond();
                DFA.State nextState = DFA.nextState(targetState, tranCond);
                if (nextState == DFA.State.ERROR || initState == DFA.State.B && nextState == DFA.State.O) continue;
                PathEdge nPE = new PathEdge(sourceNode, initState, newTargetNode, nextState);
                LeakAnalysis.this.propagate(nPE);
                if (nextState != DFA.State.E) continue;
                if (initState == DFA.State.O) {
                    AllocNode sourceHeap = (AllocNode)sourceNode;
                    LeakAnalysis.this.result.add(sourceHeap);
                    containingMethod = sourceHeap.getMethod();
                    it = LeakAnalysis.this.callGraph.edgesInto(containingMethod);
                    while (it.hasNext()) {
                        VarNode ret;
                        LocalVarNode r2;
                        edge = it.next();
                        srcMethod = edge.src();
                        srcmpag = LeakAnalysis.this.prePAG.getMethodPAG(srcMethod);
                        invokeStmt = (Stmt)edge.srcUnit();
                        if (targetState != DFA.State.F || (r2 = PTAUtils.paramToArg(LeakAnalysis.this.prePAG, invokeStmt, srcmpag, ret = (VarNode)targetNode)) == null) continue;
                        AllocNode s2 = LeakAnalysis.this.getSymbolicHeapOf(srcMethod, invokeStmt);
                        LeakAnalysis.this.addSummaryEdge(new TranEdge(s2, r2, DFA.TranCond.NEW));
                        LeakAnalysis.this.addSummaryEdge(new TranEdge(r2, s2, DFA.TranCond.I_NEW));
                    }
                    continue;
                }
                if (initState == DFA.State.F) {
                    LocalVarNode pj = (LocalVarNode)sourceNode;
                    containingMethod = pj.getMethod();
                    it = LeakAnalysis.this.callGraph.edgesInto(containingMethod);
                    while (it.hasNext()) {
                        VarNode ret;
                        edge = it.next();
                        srcMethod = edge.src();
                        srcmpag = LeakAnalysis.this.prePAG.getMethodPAG(srcMethod);
                        invokeStmt = (Stmt)edge.srcUnit();
                        LocalVarNode aj = PTAUtils.paramToArg(LeakAnalysis.this.prePAG, invokeStmt, srcmpag, pj);
                        if (targetState == DFA.State.B && sourceNode != targetNode) {
                            VarNode pi = (VarNode)targetNode;
                            LocalVarNode ai = PTAUtils.paramToArg(LeakAnalysis.this.prePAG, invokeStmt, srcmpag, pi);
                            if (ai == null || aj == null || ai == aj) continue;
                            LeakAnalysis.this.addSummaryEdge(new TranEdge(aj, ai, DFA.TranCond.INTER_STORE));
                            continue;
                        }
                        if (targetState != DFA.State.F || (r = PTAUtils.paramToArg(LeakAnalysis.this.prePAG, invokeStmt, srcmpag, ret = (VarNode)targetNode)) == null || aj == null) continue;
                        LeakAnalysis.this.addSummaryEdge(new TranEdge(aj, r, DFA.TranCond.INTER_ASSIGN));
                    }
                    continue;
                }
                if (initState != DFA.State.B || targetState != DFA.State.B) continue;
                LocalVarNode retOrThrow = (LocalVarNode)sourceNode;
                containingMethod = retOrThrow.getMethod();
                it = LeakAnalysis.this.callGraph.edgesInto(containingMethod);
                VarNode pi = (VarNode)this.pe.getTgtNode();
                while (it.hasNext()) {
                    Edge edge2 = it.next();
                    SootMethod srcMethod2 = edge2.src();
                    MethodPAG srcmpag2 = LeakAnalysis.this.prePAG.getMethodPAG(srcMethod2);
                    Stmt invokeStmt2 = (Stmt)edge2.srcUnit();
                    LocalVarNode ai = PTAUtils.paramToArg(LeakAnalysis.this.prePAG, invokeStmt2, srcmpag2, pi);
                    r = PTAUtils.paramToArg(LeakAnalysis.this.prePAG, invokeStmt2, srcmpag2, retOrThrow);
                    if (r == null || ai == null) continue;
                    LeakAnalysis.this.addSummaryEdge(new TranEdge(r, ai, DFA.TranCond.I_INTER_LOAD));
                }
            }
        }
    }
}

