/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.conch;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.VarNode;
import qilin.pta.toolkits.conch.AbstractPAG;
import qilin.pta.toolkits.conch.DFA;
import qilin.pta.toolkits.conch.TranEdge;
import qilin.util.PTAUtils;
import soot.SootMethod;
import soot.jimple.AssignStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.Edge;

public class DepOnParamAnalysis
extends AbstractPAG {
    private final Map<Node, Set<Node>> pathEdges = new ConcurrentHashMap<Node, Set<Node>>();
    private final Set<Node> initialSeeds = ConcurrentHashMap.newKeySet();

    public DepOnParamAnalysis(PTA prePTA) {
        super(prePTA);
        this.build();
        this.solve();
    }

    @Override
    protected void solve() {
        System.out.println("start analysis!");
        super.solve();
        System.out.println("finish PFG analysis!");
    }

    @Override
    protected void addParamEdge(LocalVarNode param) {
        super.addParamEdge(param);
        this.initialSeeds.add(param);
    }

    @Override
    protected void addNewEdge(AllocNode from, LocalVarNode to) {
        super.addNewEdge(from, to);
        this.initialSeeds.add(from);
    }

    @Override
    protected void submitInitialSeeds() {
        for (Node node : this.initialSeeds) {
            this.propagate(node, node);
        }
    }

    private void propagate(Node srcParam, Node currNode) {
        Set fromParams = this.pathEdges.computeIfAbsent(currNode, k -> ConcurrentHashMap.newKeySet());
        if (!fromParams.contains(srcParam)) {
            this.executor.execute(new PathEdgeProcessingTask(srcParam, currNode));
        }
    }

    private void addSummaryEdge(TranEdge tranEdge) {
        Node src = tranEdge.getSource();
        Node tgt = tranEdge.getTarget();
        DFA.TranCond tranCond = tranEdge.getTranCond();
        this.sumEdges.computeIfAbsent(src, k -> ConcurrentHashMap.newKeySet()).add(tranEdge);
        for (Node srcParam : this.pathEdges.getOrDefault(src, Collections.emptySet())) {
            DFA.State nextState = DFA.nextState2(tranCond);
            if (nextState == DFA.State.ERROR) continue;
            this.propagate(srcParam, tgt);
        }
    }

    public Set<Node> fetchReachableParamsOf(Node node) {
        return this.pathEdges.getOrDefault(node, Collections.emptySet());
    }

    private class PathEdgeProcessingTask
    implements Runnable {
        private final Node sourceParam;
        private final Node currNode;

        public PathEdgeProcessingTask(Node param, Node node) {
            this.sourceParam = param;
            this.currNode = node;
        }

        @Override
        public void run() {
            DepOnParamAnalysis.this.pathEdges.computeIfAbsent(this.currNode, k -> ConcurrentHashMap.newKeySet()).add(this.sourceParam);
            for (TranEdge e : DepOnParamAnalysis.this.outAndSummaryEdges(this.currNode)) {
                SootMethod containingMethod;
                Node nextNode = e.getTarget();
                DFA.TranCond tranCond = e.getTranCond();
                DFA.State nextState = DFA.nextState2(tranCond);
                if (nextState == DFA.State.ERROR) continue;
                DepOnParamAnalysis.this.propagate(this.sourceParam, nextNode);
                if (nextState != DFA.State.E) continue;
                Node node = this.sourceParam;
                if (node instanceof LocalVarNode) {
                    LocalVarNode pj = (LocalVarNode)node;
                    containingMethod = pj.getMethod();
                } else {
                    AllocNode heap = (AllocNode)this.sourceParam;
                    containingMethod = heap.getMethod();
                }
                Iterator<Edge> it = DepOnParamAnalysis.this.callGraph.edgesInto(containingMethod);
                while (it.hasNext()) {
                    Edge edge = it.next();
                    SootMethod srcMethod = edge.src();
                    MethodPAG srcmpag = DepOnParamAnalysis.this.prePAG.getMethodPAG(srcMethod);
                    MethodNodeFactory srcnf = srcmpag.nodeFactory();
                    Stmt invokeStmt = (Stmt)edge.srcUnit();
                    if (!(invokeStmt instanceof AssignStmt)) continue;
                    AssignStmt assignStmt = (AssignStmt)invokeStmt;
                    VarNode r = (VarNode)srcnf.getNode(assignStmt.getLeftOp());
                    Node node2 = this.sourceParam;
                    if (node2 instanceof LocalVarNode) {
                        LocalVarNode pj = (LocalVarNode)node2;
                        LocalVarNode aj = PTAUtils.paramToArg(DepOnParamAnalysis.this.prePAG, invokeStmt, srcmpag, pj);
                        if (aj == null) continue;
                        DepOnParamAnalysis.this.addSummaryEdge(new TranEdge(aj, r, DFA.TranCond.INTER_ASSIGN));
                        continue;
                    }
                    AllocNode symbolHeap = DepOnParamAnalysis.this.getSymbolicHeapOf(srcMethod, invokeStmt);
                    DepOnParamAnalysis.this.addSummaryEdge(new TranEdge(symbolHeap, r, DFA.TranCond.NEW));
                    DepOnParamAnalysis.this.propagate(symbolHeap, symbolHeap);
                }
            }
        }
    }
}

