/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;

public class ToolUtil {
    public static VarNode getThis(PAG pag, SootMethod m4) {
        MethodNodeFactory mthdNF = pag.getMethodPAG(m4).nodeFactory();
        return mthdNF.caseThis();
    }

    public static Set<VarNode> getParameters(PAG pag, SootMethod m4) {
        MethodNodeFactory mthdNF = pag.getMethodPAG(m4).nodeFactory();
        HashSet<VarNode> ret = new HashSet<VarNode>();
        for (int i = 0; i < m4.getParameterCount(); ++i) {
            if (!(m4.getParameterType(i) instanceof RefLikeType)) continue;
            VarNode param = mthdNF.caseParm(i);
            ret.add(param);
        }
        return ret;
    }

    public static Set<VarNode> getRetVars(PAG pag, SootMethod m4) {
        MethodNodeFactory mthdNF = pag.getMethodPAG(m4).nodeFactory();
        if (m4.getReturnType() instanceof RefLikeType) {
            VarNode ret = mthdNF.caseRet();
            return Collections.singleton(ret);
        }
        return Collections.emptySet();
    }

    public static int pointsToSetSizeOf(PTA pta, VarNode var) {
        return pta.reachingObjects(var).toCIPointsToSet().size();
    }

    public static boolean isInnerType(RefType pInner, RefType pOuter) {
        String pInnerStr = pInner.toString();
        while (!pInnerStr.startsWith(pOuter.toString() + "$")) {
            SootClass sc = pOuter.getSootClass();
            if (sc.hasSuperclass()) {
                pOuter = sc.getSuperclass().getType();
                continue;
            }
            return false;
        }
        return true;
    }
}

