/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.sets.PointsToSet;
import qilin.util.PTAUtils;
import qilin.util.graph.DirectedGraph;
import soot.SootMethod;
import soot.util.queue.QueueReader;

public class OAG
implements DirectedGraph<AllocNode> {
    protected final PTA pta;
    protected final Map<AllocNode, Set<AllocNode>> successors;
    protected final Map<AllocNode, Set<AllocNode>> predecessors;
    protected final Set<AllocNode> nodes = new HashSet<AllocNode>();
    protected Collection<AllocNode> rootNodes;
    protected Collection<AllocNode> tailNodes;
    Map<AllocNode, Collection<AllocNode>> reachableMap = new HashMap<AllocNode, Collection<AllocNode>>();

    public OAG(PTA prePta) {
        this.pta = prePta;
        this.predecessors = new HashMap<AllocNode, Set<AllocNode>>();
        this.successors = new HashMap<AllocNode, Set<AllocNode>>();
    }

    public void build() {
        this.buildOAG();
        this.rootNodes = this.computeRootNodes();
        this.tailNodes = this.computeTailNodes();
    }

    @Override
    public Collection<AllocNode> allNodes() {
        return this.nodes;
    }

    @Override
    public Collection<AllocNode> predsOf(AllocNode p) {
        return this.getPredsOf(p);
    }

    @Override
    public Collection<AllocNode> succsOf(AllocNode p) {
        return this.getSuccsOf(p);
    }

    public Collection<AllocNode> rootNodes() {
        return this.rootNodes;
    }

    public Collection<AllocNode> tailNodes() {
        return this.tailNodes;
    }

    public Set<AllocNode> getPredsOf(AllocNode n) {
        return this.predecessors.getOrDefault(n, Collections.emptySet());
    }

    public Set<AllocNode> getSuccsOf(AllocNode n) {
        return this.successors.getOrDefault(n, Collections.emptySet());
    }

    public int getInDegreeOf(AllocNode n) {
        return this.getPredsOf(n).size();
    }

    public boolean reaches(AllocNode source, AllocNode dest) {
        Collection<AllocNode> reachableNodes = this.reachableMap.get(source);
        if (reachableNodes == null) {
            reachableNodes = this.computeReachableNodes(source);
            this.reachableMap.put(source, reachableNodes);
        }
        return reachableNodes.contains(dest);
    }

    protected void buildOAG() {
        Map<LocalVarNode, Set<AllocNode>> pts = PTAUtils.calcStaticThisPTS(this.pta);
        for (SootMethod method : this.pta.getNakedReachableMethods()) {
            if (method.isPhantom()) continue;
            MethodPAG srcmpag = this.pta.getPag().getMethodPAG(method);
            MethodNodeFactory srcnf = srcmpag.nodeFactory();
            LocalVarNode thisRef = (LocalVarNode)srcnf.caseThis();
            Object reader = srcmpag.getInternalReader().clone();
            while (((QueueReader)reader).hasNext()) {
                Node from = (Node)((QueueReader)reader).next();
                Node to = (Node)((QueueReader)reader).next();
                if (!(from instanceof AllocNode)) continue;
                AllocNode tgt = (AllocNode)from;
                if (PTAUtils.isFakeMainMethod(method)) {
                    AllocNode src2 = this.pta.getRootNode();
                    this.addEdge(src2, tgt);
                    continue;
                }
                if (method.isStatic()) {
                    pts.getOrDefault(thisRef, Collections.emptySet()).forEach(src -> this.addEdge((AllocNode)src, tgt));
                    continue;
                }
                PointsToSet thisPts = this.pta.reachingObjects(thisRef).toCIPointsToSet();
                Iterator<AllocNode> it = thisPts.iterator();
                while (it.hasNext()) {
                    AllocNode src3 = it.next();
                    this.addEdge(src3, tgt);
                }
            }
        }
    }

    protected void addEdge(AllocNode src, AllocNode tgt) {
        this.nodes.add(src);
        this.nodes.add(tgt);
        this.predecessors.computeIfAbsent(tgt, k -> new HashSet()).add(src);
        this.successors.computeIfAbsent(src, k -> new HashSet()).add(tgt);
    }

    public int nodeSize() {
        return this.nodes.size();
    }

    public int edgeSize() {
        int ret = 0;
        for (AllocNode obj : this.predecessors.keySet()) {
            ret += this.predecessors.get(obj).size();
        }
        return ret;
    }
}

