/*
 * Decompiled with CFR 0.152.
 */
package qilin.pta.toolkits.bean;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import qilin.core.context.ContextElements;
import qilin.core.pag.AllocNode;
import qilin.parm.ctxcons.CtxConstructor;
import qilin.pta.toolkits.bean.ContextSelector;
import qilin.pta.toolkits.common.OAG;
import qilin.util.Triple;

public class RepresentativeContextSelector
extends ContextSelector {
    public RepresentativeContextSelector(OAG oag, int depth) {
        super(oag, depth);
    }

    @Override
    protected void selectContext(OAG oag) {
        this.contextMap = new HashMap();
        oag.tailNodes().forEach(node -> this.mergeContextMap(this.selectContext(oag, (AllocNode)node)));
        oag.allNodes().forEach(node -> {
            if (!this.contextMap.containsKey(node)) {
                this.mergeContextMap(this.selectContext(oag, (AllocNode)node));
            }
        });
    }

    private Map<AllocNode, Set<ContextElements>> selectContext(OAG oag, AllocNode dest) {
        HashMap<AllocNode, Set<ContextElements>> tempContextMap = new HashMap<AllocNode, Set<ContextElements>>();
        LinkedList<Triple<AllocNode, ContextElements, Boolean>> worklist = new LinkedList<Triple<AllocNode, ContextElements, Boolean>>();
        this.initialWorkList(worklist, oag, dest);
        while (!worklist.isEmpty()) {
            Triple triple = (Triple)worklist.poll();
            AllocNode heap = (AllocNode)triple.getFirst();
            ContextElements ctx = (ContextElements)triple.getSecond();
            boolean split = (Boolean)triple.getThird();
            if (!tempContextMap.containsKey(heap)) {
                tempContextMap.put(heap, new HashSet());
            }
            if (!((Set)tempContextMap.get(heap)).add(ctx)) continue;
            Set<AllocNode> reachSuccs = this.selectReachNodes(oag.getSuccsOf(heap), dest, oag);
            boolean isFork = reachSuccs.size() > 1;
            reachSuccs.forEach(succ -> {
                Set ctxs;
                ContextElements newCtx;
                boolean isJoinSucc = oag.getInDegreeOf((AllocNode)succ) > 1;
                boolean succSplit = split;
                if (split && isJoinSucc && !ctx.contains(heap)) {
                    newCtx = ContextElements.newContext(ctx, heap, this.depth);
                    succSplit = false;
                } else {
                    newCtx = ctx;
                }
                if (isFork) {
                    succSplit = true;
                }
                if ((ctxs = (Set)tempContextMap.get(succ)) == null || !ctxs.contains(newCtx)) {
                    this.addAllocation(ctx, heap, newCtx, (AllocNode)succ);
                    worklist.add(new Triple<AllocNode, ContextElements, Boolean>((AllocNode)succ, newCtx, succSplit));
                }
            });
        }
        return tempContextMap;
    }

    private void mergeContextMap(Map<AllocNode, Set<ContextElements>> anoContextMap) {
        anoContextMap.forEach((heap, ctxs) -> {
            if (this.contextMap.containsKey(heap)) {
                ((Set)this.contextMap.get(heap)).addAll(ctxs);
            } else {
                this.contextMap.put(heap, ctxs);
            }
        });
    }

    private Set<AllocNode> selectReachNodes(Collection<AllocNode> nodes, AllocNode dest, OAG oag) {
        return nodes.stream().filter(node -> oag.reaches((AllocNode)node, dest)).collect(Collectors.toSet());
    }

    private void initialWorkList(Queue<Triple<AllocNode, ContextElements, Boolean>> worklist, OAG oag, AllocNode node) {
        Set<AllocNode> reachRoots = this.selectReachNodes(oag.rootNodes(), node, oag);
        boolean split = reachRoots.size() > 1;
        ContextElements emptyCtx = (ContextElements)CtxConstructor.emptyContext;
        reachRoots.forEach(root -> worklist.add(new Triple<AllocNode, ContextElements, Boolean>((AllocNode)root, ContextElements.newContext(emptyCtx, root, this.depth), split)));
    }
}

