/*
 * Decompiled with CFR 0.152.
 */
package qilin.parm.heapabst;

import java.util.Set;
import qilin.core.pag.AllocNode;
import qilin.core.pag.MergedNewExpr;
import qilin.core.pag.PAG;
import qilin.parm.heapabst.HeapAbstractor;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import soot.RefLikeType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;

public class HeuristicAbstractor
implements HeapAbstractor {
    private final PAG pag;
    private final Set<Type> mergedTypes = DataFactory.createSet();

    public HeuristicAbstractor(PAG pag) {
        this.pag = pag;
        this.mergedTypes.add(RefType.v("java.lang.StringBuffer"));
        this.mergedTypes.add(RefType.v("java.lang.StringBuilder"));
    }

    @Override
    public AllocNode abstractHeap(AllocNode heap) {
        Type type = heap.getType();
        SootMethod m4 = heap.getMethod();
        if (this.mergedTypes.contains(type) || PTAUtils.isThrowable(type) && this.mergedTypes.add(type)) {
            return this.pag.makeAllocNode(MergedNewExpr.v((RefLikeType)type), type, null);
        }
        return heap;
    }
}

