/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.solver;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.builder.CallGraphBuilder;
import qilin.core.builder.ExceptionHandler;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ExceptionThrowSite;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.FieldValNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.core.pag.VirtualCallSite;
import qilin.core.sets.DoublePointsToSet;
import qilin.core.sets.HybridPointsToSet;
import qilin.core.sets.P2SetVisitor;
import qilin.core.sets.PointsToSetInternal;
import qilin.core.solver.Propagator;
import qilin.util.PTAUtils;
import soot.Context;
import soot.Kind;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.toolkits.callgraph.Edge;
import soot.options.Options;
import soot.util.NumberedString;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class Solver
extends Propagator {
    private final TreeSet<ValNode> valNodeWorkList = new TreeSet();
    private final PAG pag;
    private final PTA pta;
    private final CallGraphBuilder cgb;
    private final ExceptionHandler eh;
    private final ChunkedQueue<ExceptionThrowSite> throwSiteQueue = new ChunkedQueue();
    private final ChunkedQueue<VirtualCallSite> virtualCallSiteQueue = new ChunkedQueue();
    private final ChunkedQueue<Node> edgeQueue = new ChunkedQueue();
    private final ChunkedQueue<MethodOrMethodContext> rmQueue = new ChunkedQueue();

    public Solver(PTA pta) {
        this.cgb = pta.getCgb();
        this.cgb.setRMQueue(this.rmQueue);
        this.pag = pta.getPag();
        this.pag.setEdgeQueue(this.edgeQueue);
        this.eh = pta.getExceptionHandler();
        this.pta = pta;
    }

    @Override
    public void propagate() {
        QueueReader<MethodOrMethodContext> newRMs = this.rmQueue.reader();
        QueueReader<Node> newPAGEdges = this.edgeQueue.reader();
        QueueReader<ExceptionThrowSite> newThrows = this.throwSiteQueue.reader();
        QueueReader<VirtualCallSite> newCalls = this.virtualCallSiteQueue.reader();
        this.cgb.initReachableMethods();
        this.processStmts(newRMs);
        this.pag.getAlloc().forEach((a, set) -> set.forEach(v -> this.propagatePTS((ValNode)v, (AllocNode)a)));
        while (!this.valNodeWorkList.isEmpty()) {
            ValNode curr = this.valNodeWorkList.pollFirst();
            assert (curr != null);
            DoublePointsToSet pts = curr.getP2Set();
            HybridPointsToSet newset = pts.getNewSet();
            this.pag.simpleLookup(curr).forEach(to -> this.propagatePTS((ValNode)to, newset));
            if (curr instanceof VarNode) {
                VarNode mSrc = (VarNode)curr;
                Collection<ExceptionThrowSite> throwSites = this.eh.throwSitesLookUp(mSrc);
                for (ExceptionThrowSite site : throwSites) {
                    this.eh.exceptionDispatch(newset, site);
                }
                this.handleStoreAndLoadOnBase(mSrc);
                Collection<VirtualCallSite> sites = this.cgb.callSitesLookUp(mSrc);
                for (VirtualCallSite site : sites) {
                    this.cgb.virtualCallDispatch(newset, site);
                }
                this.processStmts(newRMs);
            }
            pts.flushNew();
            this.activateConstraints(newCalls, newRMs, newThrows, newPAGEdges);
        }
    }

    public void processStmts(Iterator<MethodOrMethodContext> newRMs) {
        while (newRMs.hasNext()) {
            MethodOrMethodContext momc = newRMs.next();
            SootMethod method = momc.method();
            if (method.isPhantom()) continue;
            MethodPAG mpag = this.pag.getMethodPAG(method);
            this.addToPAG(mpag, momc.context());
            if (CoreConfig.v().getPtaConfig().clinitMode == CoreConfig.ClinitMode.ONFLY) {
                Iterator<SootMethod> it = mpag.triggeredClinits();
                while (it.hasNext()) {
                    SootMethod sm = it.next();
                    this.cgb.injectCallEdge(sm.getDeclaringClass().getType(), this.pta.parameterize(sm, this.pta.emptyContext()), Kind.CLINIT);
                }
            }
            this.recordCallStmts(momc, mpag.getInvokeStmts());
            this.recordThrowStmts(momc, mpag.stmt2wrapperedTraps.keySet());
        }
    }

    private void recordCallStmts(MethodOrMethodContext m4, Collection<Unit> units) {
        for (Unit u : units) {
            VarNode recNode;
            Stmt s2 = (Stmt)u;
            if (!s2.containsInvokeExpr()) continue;
            InvokeExpr ie = s2.getInvokeExpr();
            if (ie instanceof InstanceInvokeExpr) {
                NumberedString subSig;
                VirtualCallSite virtualCallSite;
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                Local receiver = (Local)iie.getBase();
                recNode = this.cgb.getReceiverVarNode(receiver, m4);
                if (!this.cgb.recordVirtualCallSite(recNode, virtualCallSite = new VirtualCallSite(recNode, s2, m4, iie, subSig = iie.getMethodRef().getSubSignature(), Edge.ieToKind(iie)))) continue;
                this.virtualCallSiteQueue.add(virtualCallSite);
                continue;
            }
            SootMethod tgt = ie.getMethod();
            if (tgt != null) {
                recNode = this.pag.getMethodPAG(m4.method()).nodeFactory().caseThis();
                recNode = (VarNode)this.pta.parameterize(recNode, m4.context());
                if (ie instanceof DynamicInvokeExpr) continue;
                this.cgb.addStaticEdge(m4, s2, tgt, Edge.ieToKind(ie));
                continue;
            }
            if (Options.v().ignore_resolution_errors()) continue;
            throw new InternalError("Unresolved target " + ie.getMethod() + ". Resolution error should have occured earlier.");
        }
    }

    private void recordThrowStmts(MethodOrMethodContext m4, Collection<Stmt> stmts) {
        for (Stmt stmt : stmts) {
            ExceptionThrowSite throwSite;
            VarNode throwNode;
            Node src;
            SootMethod sm = m4.method();
            MethodPAG mpag = this.pag.getMethodPAG(sm);
            MethodNodeFactory nodeFactory = mpag.nodeFactory();
            if (stmt.containsInvokeExpr()) {
                src = nodeFactory.makeInvokeStmtThrowVarNode(stmt, sm);
            } else {
                assert (stmt instanceof ThrowStmt);
                ThrowStmt ts = (ThrowStmt)stmt;
                src = nodeFactory.getNode(ts.getOp());
            }
            if (!this.eh.addThrowSite(throwNode = (VarNode)this.pta.parameterize(src, m4.context()), throwSite = new ExceptionThrowSite(throwNode, stmt, m4))) continue;
            this.throwSiteQueue.add(throwSite);
        }
    }

    private void addToPAG(MethodPAG mpag, Context cxt) {
        Set contexts = this.pag.getMethod2ContextsMap().computeIfAbsent(mpag, k1 -> new HashSet());
        if (!contexts.add(cxt)) {
            return;
        }
        Object reader = mpag.getInternalReader().clone();
        while (((QueueReader)reader).hasNext()) {
            Node from = (Node)((QueueReader)reader).next();
            Node to = (Node)((QueueReader)reader).next();
            if (from instanceof AllocNode) {
                AllocNode heap = (AllocNode)from;
                from = this.pta.heapAbstractor().abstractHeap(heap);
            }
            if (from instanceof AllocNode && to instanceof GlobalVarNode) {
                this.pag.addGlobalPAGEdge(from, to);
                continue;
            }
            from = this.pta.parameterize(from, cxt);
            to = this.pta.parameterize(to, cxt);
            if (from instanceof AllocNode) {
                this.handleImplicitCallToFinalizerRegister((AllocNode)from);
            }
            this.pag.addEdge(from, to);
        }
    }

    private void handleImplicitCallToFinalizerRegister(AllocNode heap) {
        if (PTAUtils.supportFinalize(heap)) {
            SootMethod rm = PTAScene.v().getMethod("<java.lang.ref.Finalizer: void register(java.lang.Object)>");
            MethodPAG tgtmpag = this.pag.getMethodPAG(rm);
            MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
            Node parm = tgtnf.caseParm(0);
            Context calleeCtx = this.pta.emptyContext();
            AllocNode baseHeap = heap.base();
            parm = this.pta.parameterize(parm, calleeCtx);
            this.pag.addEdge(heap, parm);
            this.cgb.injectCallEdge(baseHeap, this.pta.parameterize(rm, calleeCtx), Kind.STATIC);
        }
    }

    private void handleStoreAndLoadOnBase(VarNode base) {
        for (FieldRefNode fr : base.getAllFieldRefs()) {
            for (VarNode v : this.pag.storeInvLookup(fr)) {
                this.handleStoreEdge(base.getP2Set().getNewSet(), fr.getField(), v);
            }
            for (VarNode to : this.pag.loadLookup(fr)) {
                this.handleLoadEdge(base.getP2Set().getNewSet(), fr.getField(), to);
            }
        }
    }

    private void handleStoreEdge(PointsToSetInternal baseHeaps, final SparkField field, final ValNode from) {
        baseHeaps.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                if (Solver.this.disallowStoreOrLoadOn((AllocNode)n)) {
                    return;
                }
                FieldValNode fvn = Solver.this.pag.makeFieldValNode(field);
                ValNode oDotF = (ValNode)this.pta.parameterize(fvn, PTAUtils.plusplusOp((AllocNode)n));
                Solver.this.pag.addEdge(from, oDotF);
            }
        });
    }

    private void handleLoadEdge(PointsToSetInternal baseHeaps, final SparkField field, final ValNode to) {
        baseHeaps.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                if (Solver.this.disallowStoreOrLoadOn((AllocNode)n)) {
                    return;
                }
                FieldValNode fvn = Solver.this.pag.makeFieldValNode(field);
                ValNode oDotF = (ValNode)this.pta.parameterize(fvn, PTAUtils.plusplusOp((AllocNode)n));
                Solver.this.pag.addEdge(oDotF, to);
            }
        });
    }

    private void activateConstraints(QueueReader<VirtualCallSite> newCalls, QueueReader<MethodOrMethodContext> newRMs, QueueReader<ExceptionThrowSite> newThrows, QueueReader<Node> addedEdges) {
        while (newCalls.hasNext()) {
            while (newCalls.hasNext()) {
                VirtualCallSite site = newCalls.next();
                VarNode receiver = site.recNode();
                this.cgb.virtualCallDispatch(receiver.getP2Set().getOldSet(), site);
            }
            this.processStmts(newRMs);
        }
        while (newThrows.hasNext()) {
            ExceptionThrowSite ets = newThrows.next();
            VarNode throwNode = ets.getThrowNode();
            this.eh.exceptionDispatch(throwNode.getP2Set().getOldSet(), ets);
        }
        while (addedEdges.hasNext()) {
            Node addedSrc = addedEdges.next();
            Node addedTgt = addedEdges.next();
            if (addedSrc instanceof VarNode && addedTgt instanceof VarNode || addedSrc instanceof ContextField || addedTgt instanceof ContextField) {
                ValNode srcv = (ValNode)addedSrc;
                ValNode tgtv = (ValNode)addedTgt;
                this.propagatePTS(tgtv, srcv.getP2Set().getOldSet());
                continue;
            }
            if (addedSrc instanceof FieldRefNode) {
                FieldRefNode srcfrn = (FieldRefNode)addedSrc;
                this.handleLoadEdge(srcfrn.getBase().getP2Set().getOldSet(), srcfrn.getField(), (ValNode)addedTgt);
                continue;
            }
            if (addedTgt instanceof FieldRefNode) {
                FieldRefNode tgtfrn = (FieldRefNode)addedTgt;
                this.handleStoreEdge(tgtfrn.getBase().getP2Set().getOldSet(), tgtfrn.getField(), (ValNode)addedSrc);
                continue;
            }
            if (!(addedSrc instanceof AllocNode)) continue;
            this.propagatePTS((ValNode)((VarNode)addedTgt), (AllocNode)addedSrc);
        }
    }

    protected void propagatePTS(final ValNode pointer, PointsToSetInternal other) {
        final DoublePointsToSet addTo = pointer.getP2Set();
        P2SetVisitor p2SetVisitor = new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                if (PTAUtils.addWithTypeFiltering(addTo, pointer.getType(), n)) {
                    this.returnValue = true;
                }
            }
        };
        other.forall(p2SetVisitor);
        if (p2SetVisitor.getReturnValue()) {
            this.valNodeWorkList.add(pointer);
        }
    }

    protected void propagatePTS(ValNode pointer, AllocNode heap) {
        if (PTAUtils.addWithTypeFiltering(pointer.getP2Set(), pointer.getType(), heap)) {
            this.valNodeWorkList.add(pointer);
        }
    }

    private boolean disallowStoreOrLoadOn(AllocNode heap) {
        AllocNode base = heap.base();
        return PTAUtils.isEmptyArray(base);
    }
}

