/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.reflection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import qilin.core.PTAScene;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import soot.SootMethod;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public abstract class ReflectionModel {
    protected final String sigForName = "<java.lang.Class: java.lang.Class forName(java.lang.String)>";
    protected final String sigForName2 = "<java.lang.Class: java.lang.Class forName(java.lang.String,boolean,java.lang.ClassLoader)>";
    protected final String sigClassNewInstance = "<java.lang.Class: java.lang.Object newInstance()>";
    protected final String sigConstructorNewInstance = "<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>";
    protected final String sigMethodInvoke = "<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>";
    protected final String sigFieldSet = "<java.lang.reflect.Field: void set(java.lang.Object,java.lang.Object)>";
    protected final String sigFieldGet = "<java.lang.reflect.Field: java.lang.Object get(java.lang.Object)>";
    protected final String sigArrayNewInstance = "<java.lang.reflect.Array: java.lang.Object newInstance(java.lang.Class,int)>";
    protected final String sigArrayGet = "<java.lang.reflect.Array: java.lang.Object get(java.lang.Object,int)>";
    protected final String sigArraySet = "<java.lang.reflect.Array: void set(java.lang.Object,int,java.lang.Object)>";
    protected final String sigReifiedField = "<java.lang.Class: java.lang.reflect.Field getField(java.lang.String)>";
    protected final String sigReifiedDeclaredField = "<java.lang.Class: java.lang.reflect.Field getDeclaredField(java.lang.String)>";
    protected final String sigReifiedFieldArray = "<java.lang.Class: java.lang.reflect.Field[] getFields()>";
    protected final String sigReifiedDeclaredFieldArray = "<java.lang.Class: java.lang.reflect.Field[] getDeclaredFields()>";
    protected final String sigReifiedMethod = "<java.lang.Class: java.lang.reflect.Method getMethod(java.lang.String,java.lang.Class[])>";
    protected final String sigReifiedDeclaredMethod = "<java.lang.Class: java.lang.reflect.Method getDeclaredMethod(java.lang.String,java.lang.Class[])>";
    protected final String sigReifiedMethodArray = "<java.lang.Class: java.lang.reflect.Method[] getMethods()>";
    protected final String sigReifiedDeclaredMethodArray = "<java.lang.Class: java.lang.reflect.Method[] getDeclaredMethods()>";

    private Collection<Unit> transform(Stmt s2) {
        InvokeExpr ie = s2.getInvokeExpr();
        return switch (ie.getMethodRef().getSignature()) {
            case "<java.lang.Class: java.lang.Class forName(java.lang.String)>", "<java.lang.Class: java.lang.Class forName(java.lang.String,boolean,java.lang.ClassLoader)>" -> this.transformClassForName(s2);
            case "<java.lang.Class: java.lang.Object newInstance()>" -> this.transformClassNewInstance(s2);
            case "<java.lang.reflect.Constructor: java.lang.Object newInstance(java.lang.Object[])>" -> this.transformContructorNewInstance(s2);
            case "<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>" -> this.transformMethodInvoke(s2);
            case "<java.lang.reflect.Field: void set(java.lang.Object,java.lang.Object)>" -> this.transformFieldSet(s2);
            case "<java.lang.reflect.Field: java.lang.Object get(java.lang.Object)>" -> this.transformFieldGet(s2);
            case "<java.lang.reflect.Array: java.lang.Object newInstance(java.lang.Class,int)>" -> this.transformArrayNewInstance(s2);
            case "<java.lang.reflect.Array: java.lang.Object get(java.lang.Object,int)>" -> this.transformArrayGet(s2);
            case "<java.lang.reflect.Array: void set(java.lang.Object,int,java.lang.Object)>" -> this.transformArraySet(s2);
            default -> Collections.emptySet();
        };
    }

    public void buildReflection(SootMethod m4) {
        if (!PTAScene.v().reflectionBuilt.add(m4)) {
            return;
        }
        Map<Unit, Collection<Unit>> newUnits = DataFactory.createMap();
        UnitPatchingChain units = PTAUtils.getMethodBody(m4).getUnits();
        for (Unit u : units) {
            Stmt s2 = (Stmt)u;
            if (!s2.containsInvokeExpr()) continue;
            newUnits.put(u, this.transform(s2));
        }
        for (Unit unit : newUnits.keySet()) {
            units.insertAfter((Collection)newUnits.get(unit), unit);
        }
    }

    abstract Collection<Unit> transformClassForName(Stmt var1);

    abstract Collection<Unit> transformClassNewInstance(Stmt var1);

    abstract Collection<Unit> transformContructorNewInstance(Stmt var1);

    abstract Collection<Unit> transformMethodInvoke(Stmt var1);

    abstract Collection<Unit> transformFieldSet(Stmt var1);

    abstract Collection<Unit> transformFieldGet(Stmt var1);

    abstract Collection<Unit> transformArrayNewInstance(Stmt var1);

    abstract Collection<Unit> transformArrayGet(Stmt var1);

    abstract Collection<Unit> transformArraySet(Stmt var1);
}

