/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.pag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.natives.NativeMethodDriver;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ClassConstantNode;
import qilin.core.pag.ContextAllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextMethod;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.FieldValNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.StringConstantNode;
import qilin.core.pag.ValNode;
import qilin.core.pag.VarNode;
import qilin.core.reflection.NopReflectionModel;
import qilin.core.reflection.ReflectionModel;
import qilin.core.reflection.TamiflexModel;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import soot.ArrayType;
import soot.Body;
import soot.Context;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ClassConstant;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.internal.JArrayRef;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JimpleLocal;
import soot.jimple.spark.pag.SparkField;
import soot.util.ArrayNumberer;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class PAG {
    protected final NativeMethodDriver nativeDriver;
    protected final ReflectionModel reflectionModel;
    protected final Map<VarNode, Map<Context, ContextVarNode>> contextVarNodeMap;
    protected final Map<AllocNode, Map<Context, ContextAllocNode>> contextAllocNodeMap;
    protected final Map<SootMethod, Map<Context, MethodOrMethodContext>> contextMethodMap;
    protected final Map<MethodPAG, Set<Context>> addedContexts;
    protected final Map<Context, Map<SparkField, ContextField>> contextFieldMap;
    protected ArrayNumberer<AllocNode> allocNodeNumberer = new ArrayNumberer();
    protected ArrayNumberer<ValNode> valNodeNumberer = new ArrayNumberer();
    protected ArrayNumberer<FieldRefNode> fieldRefNodeNumberer = new ArrayNumberer();
    private static AtomicInteger maxFinishNumber = new AtomicInteger(0);
    protected final Map<Object, AllocNode> valToAllocNode;
    protected final Map<Object, ValNode> valToValNode;
    protected final Map<SootMethod, MethodPAG> methodToPag;
    protected final Set<SootField> globals;
    protected final Set<Local> locals;
    protected ChunkedQueue<Node> edgeQueue;
    protected final Map<ValNode, Set<ValNode>> simple;
    protected final Map<ValNode, Set<ValNode>> simpleInv;
    protected final Map<FieldRefNode, Set<VarNode>> load;
    protected final Map<VarNode, Set<FieldRefNode>> loadInv;
    protected final Map<AllocNode, Set<VarNode>> alloc;
    protected final Map<VarNode, Set<AllocNode>> allocInv;
    protected final Map<VarNode, Set<FieldRefNode>> store;
    protected final Map<FieldRefNode, Set<VarNode>> storeInv;
    protected final PTA pta;

    public PAG(PTA pta) {
        this.pta = pta;
        this.simple = DataFactory.createMap();
        this.simpleInv = DataFactory.createMap();
        this.load = DataFactory.createMap();
        this.loadInv = DataFactory.createMap();
        this.alloc = DataFactory.createMap();
        this.allocInv = DataFactory.createMap();
        this.store = DataFactory.createMap();
        this.storeInv = DataFactory.createMap();
        this.nativeDriver = new NativeMethodDriver();
        this.reflectionModel = this.createReflectionModel();
        this.contextVarNodeMap = DataFactory.createMap(16000);
        this.contextAllocNodeMap = DataFactory.createMap(6000);
        this.contextMethodMap = DataFactory.createMap(6000);
        this.addedContexts = DataFactory.createMap();
        this.contextFieldMap = DataFactory.createMap(6000);
        this.valToAllocNode = DataFactory.createMap(10000);
        this.valToValNode = DataFactory.createMap(100000);
        this.methodToPag = DataFactory.createMap();
        this.globals = DataFactory.createSet(100000);
        this.locals = DataFactory.createSet(100000);
    }

    public void setEdgeQueue(ChunkedQueue<Node> edgeQueue) {
        this.edgeQueue = edgeQueue;
    }

    public Map<AllocNode, Set<VarNode>> getAlloc() {
        return this.alloc;
    }

    public Map<ValNode, Set<ValNode>> getSimple() {
        return this.simple;
    }

    public Map<ValNode, Set<ValNode>> getSimpleInv() {
        return this.simpleInv;
    }

    public Map<FieldRefNode, Set<VarNode>> getLoad() {
        return this.load;
    }

    public Map<FieldRefNode, Set<VarNode>> getStoreInv() {
        return this.storeInv;
    }

    public PTA getPta() {
        return this.pta;
    }

    public QueueReader<Node> edgeReader() {
        return this.edgeQueue.reader();
    }

    protected <K, V> boolean addToMap(Map<K, Set<V>> m4, K key, V value) {
        Set valueList = m4.computeIfAbsent(key, k -> DataFactory.createSet(4));
        return valueList.add(value);
    }

    private boolean addAllocEdge(AllocNode from, VarNode to) {
        if (this.addToMap(this.alloc, from, to)) {
            this.addToMap(this.allocInv, to, from);
            return true;
        }
        return false;
    }

    private boolean addSimpleEdge(ValNode from, ValNode to) {
        if (this.addToMap(this.simple, from, to)) {
            this.addToMap(this.simpleInv, to, from);
            return true;
        }
        return false;
    }

    private boolean addStoreEdge(VarNode from, FieldRefNode to) {
        if (this.addToMap(this.storeInv, to, from)) {
            this.addToMap(this.store, from, to);
            return true;
        }
        return false;
    }

    private boolean addLoadEdge(FieldRefNode from, VarNode to) {
        if (this.addToMap(this.load, from, to)) {
            this.addToMap(this.loadInv, to, from);
            return true;
        }
        return false;
    }

    public void addGlobalPAGEdge(Node from, Node to) {
        from = this.pta.parameterize(from, this.pta.emptyContext());
        to = this.pta.parameterize(to, this.pta.emptyContext());
        this.addEdge(from, to);
    }

    public final void addEdge(Node from, Node to) {
        if (this.addEdgeIntenal(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
        }
    }

    private boolean addEdgeIntenal(Node from, Node to) {
        if (from instanceof ValNode) {
            if (to instanceof ValNode) {
                return this.addSimpleEdge((ValNode)from, (ValNode)to);
            }
            return this.addStoreEdge((VarNode)from, (FieldRefNode)to);
        }
        if (from instanceof FieldRefNode) {
            return this.addLoadEdge((FieldRefNode)from, (VarNode)to);
        }
        AllocNode heap = (AllocNode)from;
        return this.addAllocEdge(heap, (VarNode)to);
    }

    protected <K, V> Set<V> lookup(Map<K, Set<V>> m4, K key) {
        return m4.getOrDefault(key, Collections.emptySet());
    }

    public Set<VarNode> allocLookup(AllocNode key) {
        return this.lookup(this.alloc, key);
    }

    public Set<AllocNode> allocInvLookup(VarNode key) {
        return this.lookup(this.allocInv, key);
    }

    public Set<ValNode> simpleLookup(ValNode key) {
        return this.lookup(this.simple, key);
    }

    public Set<ValNode> simpleInvLookup(ValNode key) {
        return this.lookup(this.simpleInv, key);
    }

    public Set<FieldRefNode> loadInvLookup(VarNode key) {
        return this.lookup(this.loadInv, key);
    }

    public Set<VarNode> loadLookup(FieldRefNode key) {
        return this.lookup(this.load, key);
    }

    public Set<FieldRefNode> storeLookup(VarNode key) {
        return this.lookup(this.store, key);
    }

    public Set<VarNode> storeInvLookup(FieldRefNode key) {
        return this.lookup(this.storeInv, key);
    }

    public static int nextFinishNumber() {
        return maxFinishNumber.incrementAndGet();
    }

    public ArrayNumberer<AllocNode> getAllocNodeNumberer() {
        return this.allocNodeNumberer;
    }

    public ArrayNumberer<FieldRefNode> getFieldRefNodeNumberer() {
        return this.fieldRefNodeNumberer;
    }

    public ArrayNumberer<ValNode> getValNodeNumberer() {
        return this.valNodeNumberer;
    }

    public Collection<ValNode> getValNodes() {
        return this.valToValNode.values();
    }

    public Collection<AllocNode> getAllocNodes() {
        return this.valToAllocNode.values();
    }

    public Set<SootField> getGlobalPointers() {
        return this.globals;
    }

    public Set<Local> getLocalPointers() {
        return this.locals;
    }

    public ValNode findValNode(Object value) {
        return this.valToValNode.get(value);
    }

    public AllocNode findAllocNode(Object obj) {
        return this.valToAllocNode.get(obj);
    }

    public AllocNode makeAllocNode(Object newExpr, Type type, SootMethod m4) {
        AllocNode ret = this.valToAllocNode.get(newExpr);
        if (ret == null) {
            ret = new AllocNode(newExpr, type, m4);
            this.valToAllocNode.put(newExpr, ret);
            this.allocNodeNumberer.add(ret);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("NewExpr " + newExpr + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public AllocNode makeStringConstantNode(StringConstant sc) {
        AllocNode ret;
        StringConstant stringConstant = sc;
        if (!CoreConfig.v().getPtaConfig().stringConstants) {
            stringConstant = StringConstant.v("STRING_NODE");
        }
        if ((ret = this.valToAllocNode.get(stringConstant)) == null) {
            ret = new StringConstantNode(stringConstant);
            this.valToAllocNode.put(stringConstant, ret);
            this.allocNodeNumberer.add(ret);
        }
        return ret;
    }

    public AllocNode makeClassConstantNode(ClassConstant cc) {
        AllocNode ret = this.valToAllocNode.get(cc);
        if (ret == null) {
            ret = new ClassConstantNode(cc);
            this.valToAllocNode.put(cc, ret);
            this.allocNodeNumberer.add(ret);
        }
        return ret;
    }

    public GlobalVarNode makeGlobalVarNode(Object value, Type type) {
        GlobalVarNode ret = (GlobalVarNode)this.valToValNode.get(value);
        if (ret == null) {
            ret = (GlobalVarNode)this.valToValNode.computeIfAbsent(value, k -> new GlobalVarNode(value, type));
            this.valNodeNumberer.add(ret);
            if (value instanceof SootField) {
                this.globals.add((SootField)value);
            }
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public LocalVarNode makeLocalVarNode(Object value, Type type, SootMethod method) {
        LocalVarNode ret = (LocalVarNode)this.valToValNode.get(value);
        if (ret == null) {
            ret = new LocalVarNode(value, type, method);
            this.valToValNode.put(value, ret);
            this.valNodeNumberer.add(ret);
            if (value instanceof Local) {
                Local local = (Local)value;
                if (local.getNumber() == 0) {
                    PTAScene.v().getLocalNumberer().add(local);
                }
                this.locals.add(local);
            }
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public FieldValNode makeFieldValNode(SparkField field) {
        FieldValNode ret = (FieldValNode)this.valToValNode.get(field);
        if (ret == null) {
            ret = new FieldValNode(field);
            this.valToValNode.put(field, ret);
            this.valNodeNumberer.add(ret);
        }
        return ret;
    }

    public FieldRefNode makeFieldRefNode(VarNode base, SparkField field) {
        FieldRefNode ret = base.dot(field);
        if (ret == null) {
            ret = new FieldRefNode(base, field);
            this.fieldRefNodeNumberer.add(ret);
        }
        return ret;
    }

    public ContextVarNode makeContextVarNode(VarNode base, Context context) {
        Map contextMap = this.contextVarNodeMap.computeIfAbsent(base, k1 -> DataFactory.createMap());
        ContextVarNode ret = (ContextVarNode)contextMap.get(context);
        if (ret == null) {
            ret = new ContextVarNode(base, context);
            contextMap.put(context, ret);
            this.valNodeNumberer.add(ret);
        }
        return ret;
    }

    public ContextAllocNode makeContextAllocNode(AllocNode allocNode, Context context) {
        Map contextMap = this.contextAllocNodeMap.computeIfAbsent(allocNode, k1 -> DataFactory.createMap());
        ContextAllocNode ret = (ContextAllocNode)contextMap.get(context);
        if (ret == null) {
            ret = new ContextAllocNode(allocNode, context);
            contextMap.put(context, ret);
            this.allocNodeNumberer.add(ret);
        }
        return ret;
    }

    public MethodOrMethodContext makeContextMethod(Context context, SootMethod method) {
        Map contextMap = this.contextMethodMap.computeIfAbsent(method, k1 -> DataFactory.createMap());
        return contextMap.computeIfAbsent(context, k -> new ContextMethod(method, context));
    }

    public AllocNode getAllocNode(Object val) {
        return this.valToAllocNode.get(val);
    }

    public Map<MethodPAG, Set<Context>> getMethod2ContextsMap() {
        return this.addedContexts;
    }

    public Collection<ContextField> getContextFields() {
        return this.contextFieldMap.values().stream().flatMap(m4 -> m4.values().stream()).collect(Collectors.toSet());
    }

    public Map<VarNode, Map<Context, ContextVarNode>> getContextVarNodeMap() {
        return this.contextVarNodeMap;
    }

    public Map<AllocNode, Map<Context, ContextAllocNode>> getContextAllocNodeMap() {
        return this.contextAllocNodeMap;
    }

    public Map<SootMethod, Map<Context, MethodOrMethodContext>> getContextMethodMap() {
        return this.contextMethodMap;
    }

    public Map<Context, Map<SparkField, ContextField>> getContextFieldVarNodeMap() {
        return this.contextFieldMap;
    }

    public ContextField makeContextField(Context context, FieldValNode fieldValNode) {
        SparkField field = fieldValNode.getField();
        Map field2odotf = this.contextFieldMap.computeIfAbsent(context, k -> DataFactory.createMap());
        ContextField ret = (ContextField)field2odotf.get(field);
        if (ret == null) {
            ret = new ContextField(context, field);
            field2odotf.put(field, ret);
            this.valNodeNumberer.add(ret);
        }
        return ret;
    }

    public Collection<VarNode> getVarNodes(Local local) {
        Map<Context, ContextVarNode> subMap = this.contextVarNodeMap.get(this.findLocalVarNode(local));
        if (subMap == null) {
            return Collections.emptySet();
        }
        return new HashSet<VarNode>(subMap.values());
    }

    public GlobalVarNode findGlobalVarNode(Object value) {
        return (GlobalVarNode)this.findValNode(value);
    }

    public LocalVarNode findLocalVarNode(Object value) {
        ValNode ret = this.findValNode(value);
        if (ret instanceof LocalVarNode) {
            return (LocalVarNode)ret;
        }
        return null;
    }

    public ContextVarNode findContextVarNode(Local baseValue, Context context) {
        Map<Context, ContextVarNode> contextMap = this.contextVarNodeMap.get(this.findLocalVarNode(baseValue));
        return contextMap == null ? null : contextMap.get(context);
    }

    protected ReflectionModel createReflectionModel() {
        ReflectionModel model = CoreConfig.v().getAppConfig().REFLECTION_LOG != null && CoreConfig.v().getAppConfig().REFLECTION_LOG.length() > 0 ? new TamiflexModel() : new NopReflectionModel();
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodPAG getMethodPAG(SootMethod m4) {
        Body body;
        if (this.methodToPag.containsKey(m4)) {
            return this.methodToPag.get(m4);
        }
        Body body2 = body = PTAUtils.getMethodBody(m4);
        synchronized (body2) {
            if (this.methodToPag.containsKey(m4)) {
                return this.methodToPag.get(m4);
            }
            if (m4.isConcrete()) {
                this.reflectionModel.buildReflection(m4);
            }
            if (m4.isNative()) {
                this.nativeDriver.buildNative(m4);
            } else if (PTAScene.v().arraycopyBuilt.add(m4)) {
                this.handleArrayCopy(m4);
            }
        }
        return this.methodToPag.computeIfAbsent(m4, k -> new MethodPAG(this, m4, body));
    }

    private void handleArrayCopy(SootMethod method) {
        Map<Unit, Collection> newUnits = DataFactory.createMap();
        Body body = PTAUtils.getMethodBody(method);
        for (Unit unit : body.getUnits()) {
            Value dstArr;
            Value srcArr;
            StaticInvokeExpr sie;
            SootMethod sm;
            String sig;
            InvokeExpr invokeExpr;
            Stmt s2 = (Stmt)unit;
            if (!s2.containsInvokeExpr() || !((invokeExpr = s2.getInvokeExpr()) instanceof StaticInvokeExpr) || !(sig = (sm = (sie = (StaticInvokeExpr)invokeExpr).getMethod()).getSignature()).equals("<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>") || PTAUtils.isPrimitiveArrayType((srcArr = sie.getArg(0)).getType())) continue;
            RefType objType = RefType.v("java.lang.Object");
            if (srcArr.getType() == objType) {
                JimpleLocal localSrc = new JimpleLocal("intermediate/" + body.getLocalCount(), ArrayType.v(objType, 1));
                body.getLocals().add(localSrc);
                newUnits.computeIfAbsent(unit, k -> new HashSet()).add(new JAssignStmt(localSrc, srcArr));
                srcArr = localSrc;
            }
            if (PTAUtils.isPrimitiveArrayType((dstArr = sie.getArg(2)).getType())) continue;
            if (dstArr.getType() == objType) {
                JimpleLocal localDst = new JimpleLocal("intermediate/" + body.getLocalCount(), ArrayType.v(objType, 1));
                body.getLocals().add(localDst);
                newUnits.computeIfAbsent(unit, k -> new HashSet()).add(new JAssignStmt(localDst, dstArr));
                dstArr = localDst;
            }
            JArrayRef src = new JArrayRef(srcArr, IntConstant.v(0));
            JArrayRef dst = new JArrayRef(dstArr, IntConstant.v(0));
            JimpleLocal local = new JimpleLocal("nativeArrayCopy" + body.getLocalCount(), RefType.v("java.lang.Object"));
            body.getLocals().add(local);
            newUnits.computeIfAbsent(unit, k -> DataFactory.createSet()).add(new JAssignStmt(local, src));
            newUnits.computeIfAbsent(unit, k -> DataFactory.createSet()).add(new JAssignStmt(dst, local));
        }
        for (Unit unit : newUnits.keySet()) {
            body.getUnits().insertAfter((Collection)newUnits.get(unit), unit);
        }
    }

    public void resetPointsToSet() {
        this.addedContexts.clear();
        this.contextVarNodeMap.values().stream().flatMap(m4 -> m4.values().stream()).forEach(ValNode::discardP2Set);
        this.contextFieldMap.values().stream().flatMap(m4 -> m4.values().stream()).forEach(ValNode::discardP2Set);
        this.valToValNode.values().forEach(ValNode::discardP2Set);
        this.addedContexts.clear();
    }
}

