/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.pag;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import soot.Body;
import soot.RefType;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.Jimple;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.util.Chain;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class MethodPAG {
    private final ChunkedQueue<Node> internalEdges = new ChunkedQueue();
    private final QueueReader<Node> internalReader = this.internalEdges.reader();
    private final Set<SootMethod> clinits = DataFactory.createSet();
    private final Collection<Unit> invokeStmts = DataFactory.createSet();
    public Body body;
    private final Map<Node, Set<Node>> exceptionEdges = DataFactory.createMap();
    protected MethodNodeFactory nodeFactory;
    SootMethod method;
    public final Map<Stmt, List<Trap>> stmt2wrapperedTraps = DataFactory.createMap();
    public final Map<Node, Map<Stmt, List<Trap>>> node2wrapperedTraps = DataFactory.createMap();

    public MethodPAG(PAG pag, SootMethod m4, Body body) {
        this.method = m4;
        this.nodeFactory = new MethodNodeFactory(pag, this);
        this.body = body;
        this.build();
    }

    public SootMethod getMethod() {
        return this.method;
    }

    public MethodNodeFactory nodeFactory() {
        return this.nodeFactory;
    }

    public Collection<Unit> getInvokeStmts() {
        return this.invokeStmts;
    }

    public boolean addCallStmt(Unit unit) {
        return this.invokeStmts.add(unit);
    }

    protected void build() {
        if (this.method.getSignature().equals("<org.apache.xerces.parsers.XML11Configuration: boolean getFeature0(java.lang.String)>")) {
            return;
        }
        this.buildException();
        this.buildNormal();
        this.addMiscEdges();
    }

    protected void buildNormal() {
        if (this.method.isStatic()) {
            PTAUtils.clinitsOf(this.method.getDeclaringClass()).forEach(this::addTriggeredClinit);
        }
        for (Unit unit : this.body.getUnits()) {
            try {
                this.nodeFactory.handleStmt((Stmt)unit);
            }
            catch (Exception e) {
                System.out.println("Warning:" + e);
            }
        }
    }

    protected void buildException() {
        if (!CoreConfig.v().getPtaConfig().preciseExceptions) {
            return;
        }
        Chain<Trap> traps = this.body.getTraps();
        UnitPatchingChain units = this.body.getUnits();
        Set inTraps = DataFactory.createSet();
        traps.forEach(trap -> units.iterator(trap.getBeginUnit(), trap.getEndUnit()).forEachRemaining(unit -> {
            if (unit == trap.getEndUnit()) {
                return;
            }
            inTraps.add(unit);
            Stmt stmt = (Stmt)unit;
            Node src = null;
            if (stmt.containsInvokeExpr()) {
                src = this.nodeFactory.makeInvokeStmtThrowVarNode(stmt, this.method);
            } else if (stmt instanceof ThrowStmt) {
                ThrowStmt ts = (ThrowStmt)stmt;
                src = this.nodeFactory.getNode(ts.getOp());
            }
            if (src != null) {
                this.addStmtTrap(src, stmt, (Trap)trap);
            }
        }));
        for (Unit unit : this.body.getUnits()) {
            if (inTraps.contains(unit)) continue;
            Stmt stmt = (Stmt)unit;
            Node src = null;
            if (stmt.containsInvokeExpr()) {
                src = this.nodeFactory.makeInvokeStmtThrowVarNode(stmt, this.method);
            } else if (stmt instanceof ThrowStmt) {
                ThrowStmt ts = (ThrowStmt)stmt;
                src = this.nodeFactory.getNode(ts.getOp());
            }
            if (src == null) continue;
            this.node2wrapperedTraps.computeIfAbsent(src, k -> DataFactory.createMap());
            this.stmt2wrapperedTraps.computeIfAbsent(stmt, k -> DataFactory.createList());
        }
    }

    private void addStmtTrap(Node src, Stmt stmt, Trap trap) {
        Map stmt2Traps = this.node2wrapperedTraps.computeIfAbsent(src, k -> DataFactory.createMap());
        List trapList = stmt2Traps.computeIfAbsent(stmt, k -> DataFactory.createList());
        trapList.add(trap);
        this.stmt2wrapperedTraps.computeIfAbsent(stmt, k -> DataFactory.createList()).add(trap);
    }

    protected void addMiscEdges() {
        if (this.method.getSignature().equals("<java.lang.ref.Reference: void <init>(java.lang.Object,java.lang.ref.ReferenceQueue)>")) {
            StaticFieldRef sfr = Jimple.v().newStaticFieldRef(RefType.v("java.lang.ref.Reference").getSootClass().getFieldByName("pending").makeRef());
            this.addInternalEdge(this.nodeFactory.caseThis(), this.nodeFactory.getNode(sfr));
        }
    }

    public void addInternalEdge(Node src, Node dst) {
        if (src == null) {
            return;
        }
        this.internalEdges.add(src);
        this.internalEdges.add(dst);
    }

    public QueueReader<Node> getInternalReader() {
        return this.internalReader;
    }

    public void addTriggeredClinit(SootMethod clinit) {
        this.clinits.add(clinit);
    }

    public Iterator<SootMethod> triggeredClinits() {
        return this.clinits.iterator();
    }

    public void addExceptionEdge(Node from, Node to) {
        this.exceptionEdges.computeIfAbsent(from, k -> DataFactory.createSet()).add(to);
    }

    public Map<Node, Set<Node>> getExceptionEdges() {
        return this.exceptionEdges;
    }
}

