/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder;

import qilin.CoreConfig;
import qilin.core.PTAScene;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ArrayElement;
import qilin.core.pag.FieldRefNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.Parm;
import qilin.core.pag.VarNode;
import qilin.util.PTAUtils;
import qilin.util.Pair;
import soot.ArrayType;
import soot.Local;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.JNewArrayExpr;

public class MethodNodeFactory {
    protected PAG pag;
    protected MethodPAG mpag;
    protected SootMethod method;

    public MethodNodeFactory(PAG pag, MethodPAG mpag) {
        this.pag = pag;
        this.mpag = mpag;
        this.method = mpag.getMethod();
    }

    public Node getNode(Value v) {
        if (v instanceof Local) {
            Local l = (Local)v;
            return this.caseLocal(l);
        }
        if (v instanceof CastExpr) {
            CastExpr castExpr = (CastExpr)v;
            return this.caseCastExpr(castExpr);
        }
        if (v instanceof NewExpr) {
            NewExpr ne = (NewExpr)v;
            return this.caseNewExpr(ne);
        }
        if (v instanceof StaticFieldRef) {
            StaticFieldRef sfr = (StaticFieldRef)v;
            return this.caseStaticFieldRef(sfr);
        }
        if (v instanceof NewArrayExpr) {
            NewArrayExpr nae = (NewArrayExpr)v;
            return this.caseNewArrayExpr(nae);
        }
        if (v instanceof ArrayRef) {
            ArrayRef ar = (ArrayRef)v;
            return this.caseArrayRef(ar);
        }
        if (v instanceof ClassConstant) {
            ClassConstant cc = (ClassConstant)v;
            return this.caseClassConstant(cc);
        }
        if (v instanceof StringConstant) {
            StringConstant sc = (StringConstant)v;
            return this.caseStringConstant(sc);
        }
        if (v instanceof CaughtExceptionRef) {
            CaughtExceptionRef cef = (CaughtExceptionRef)v;
            return this.caseCaughtExceptionRef(cef);
        }
        if (v instanceof ParameterRef) {
            ParameterRef pr = (ParameterRef)v;
            return this.caseParameterRef(pr);
        }
        if (v instanceof NullConstant) {
            NullConstant nc = (NullConstant)v;
            return this.caseNullConstant(nc);
        }
        if (v instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)v;
            return this.caseInstanceFieldRef(ifr);
        }
        if (v instanceof ThisRef) {
            return this.caseThis();
        }
        if (v instanceof NewMultiArrayExpr) {
            NewMultiArrayExpr nmae = (NewMultiArrayExpr)v;
            return this.caseNewMultiArrayExpr(nmae);
        }
        System.out.println(v + ";;" + v.getClass());
        return null;
    }

    public final void handleStmt(Stmt s2) {
        if (s2.containsInvokeExpr()) {
            this.mpag.addCallStmt(s2);
            this.handleInvokeStmt(s2);
        } else {
            this.handleIntraStmt(s2);
        }
    }

    protected void handleInvokeStmt(Stmt s2) {
        Value l;
        InvokeExpr ie = s2.getInvokeExpr();
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Value arg = ie.getArg(i);
            if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
            this.getNode(arg);
        }
        if (s2 instanceof AssignStmt && (l = ((AssignStmt)s2).getLeftOp()).getType() instanceof RefLikeType) {
            this.getNode(l);
        }
        if (ie instanceof InstanceInvokeExpr) {
            this.getNode(((InstanceInvokeExpr)ie).getBase());
        }
    }

    private void resolveClinit(StaticFieldRef staticFieldRef) {
        PTAUtils.clinitsOf(staticFieldRef.getField().getDeclaringClass()).forEach(this.mpag::addTriggeredClinit);
    }

    private void handleIntraStmt(Stmt s2) {
        s2.apply(new AbstractStmtSwitch<Object>(){

            @Override
            public void caseAssignStmt(AssignStmt as) {
                Value l = as.getLeftOp();
                Value r = as.getRightOp();
                if (l instanceof StaticFieldRef) {
                    MethodNodeFactory.this.resolveClinit((StaticFieldRef)l);
                } else if (r instanceof StaticFieldRef) {
                    MethodNodeFactory.this.resolveClinit((StaticFieldRef)r);
                }
                if (!(l.getType() instanceof RefLikeType)) {
                    return;
                }
                if (r instanceof CastExpr && !(((CastExpr)r).getOp().getType() instanceof RefLikeType)) {
                    return;
                }
                if (!(r.getType() instanceof RefLikeType)) {
                    throw new RuntimeException("Type mismatch in assignment (rhs not a RefLikeType) " + as + " in method " + MethodNodeFactory.this.method.getSignature());
                }
                Node dest = MethodNodeFactory.this.getNode(l);
                Node src = MethodNodeFactory.this.getNode(r);
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            @Override
            public void caseReturnStmt(ReturnStmt rs) {
                if (!(rs.getOp().getType() instanceof RefLikeType)) {
                    return;
                }
                Node retNode = MethodNodeFactory.this.getNode(rs.getOp());
                MethodNodeFactory.this.mpag.addInternalEdge(retNode, MethodNodeFactory.this.caseRet());
            }

            @Override
            public void caseIdentityStmt(IdentityStmt is) {
                if (!(is.getLeftOp().getType() instanceof RefLikeType)) {
                    return;
                }
                Node dest = MethodNodeFactory.this.getNode(is.getLeftOp());
                Node src = MethodNodeFactory.this.getNode(is.getRightOp());
                MethodNodeFactory.this.mpag.addInternalEdge(src, dest);
            }

            @Override
            public void caseThrowStmt(ThrowStmt ts) {
                if (!CoreConfig.v().getPtaConfig().preciseExceptions) {
                    MethodNodeFactory.this.mpag.addInternalEdge(MethodNodeFactory.this.getNode(ts.getOp()), MethodNodeFactory.this.getNode(PTAScene.v().getFieldGlobalThrow()));
                }
            }
        });
    }

    private VarNode caseLocal(Local l) {
        return this.pag.makeLocalVarNode(l, l.getType(), this.method);
    }

    private AllocNode caseNewArrayExpr(NewArrayExpr nae) {
        return this.pag.makeAllocNode(nae, nae.getType(), this.method);
    }

    private AllocNode caseNewExpr(NewExpr ne) {
        SootClass cl = PTAScene.v().loadClassAndSupport(ne.getType().toString());
        PTAUtils.clinitsOf(cl).forEach(this.mpag::addTriggeredClinit);
        return this.pag.makeAllocNode(ne, ne.getType(), this.method);
    }

    private FieldRefNode caseInstanceFieldRef(InstanceFieldRef ifr) {
        SootField sf = ifr.getField();
        if (sf == null) {
            sf = new SootField(ifr.getFieldRef().name(), ifr.getType(), 1);
            System.out.println("Warnning:" + ifr + " is resolved to be a null field in Scene.");
        }
        return this.pag.makeFieldRefNode(this.pag.makeLocalVarNode(ifr.getBase(), ifr.getBase().getType(), this.method), sf);
    }

    private VarNode caseNewMultiArrayExpr(NewMultiArrayExpr nmae) {
        Type t2;
        ArrayType type = (ArrayType)nmae.getType();
        int pos = 0;
        AllocNode prevAn = this.pag.makeAllocNode(new JNewArrayExpr((Type)type, nmae.getSize(pos)), type, this.method);
        LocalVarNode prevVn = this.pag.makeLocalVarNode(prevAn.getNewExpr(), prevAn.getType(), this.method);
        this.mpag.addInternalEdge(prevAn, prevVn);
        LocalVarNode ret = prevVn;
        while ((t2 = type.getElementType()) instanceof ArrayType) {
            type = (ArrayType)t2;
            Value sizeVal = ++pos < nmae.getSizeCount() ? nmae.getSize(pos) : IntConstant.v(1);
            AllocNode an = this.pag.makeAllocNode(new JNewArrayExpr((Type)type, sizeVal), type, this.method);
            LocalVarNode vn = this.pag.makeLocalVarNode(an.getNewExpr(), an.getType(), this.method);
            this.mpag.addInternalEdge(an, vn);
            this.mpag.addInternalEdge(vn, this.pag.makeFieldRefNode(prevVn, ArrayElement.v()));
            prevVn = vn;
        }
        return ret;
    }

    private VarNode caseCastExpr(CastExpr ce) {
        Node opNode = this.getNode(ce.getOp());
        LocalVarNode castNode = this.pag.makeLocalVarNode(ce, ce.getCastType(), this.method);
        this.mpag.addInternalEdge(opNode, castNode);
        return castNode;
    }

    public VarNode caseThis() {
        RefType type = this.method.isStatic() ? RefType.v("java.lang.Object") : this.method.getDeclaringClass().getType();
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, -1), type, this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public VarNode caseParm(int index) {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, index), this.method.getParameterType(index), this.method);
        ret.setInterProcTarget();
        return ret;
    }

    public VarNode caseRet() {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, -2), this.method.getReturnType(), this.method);
        ret.setInterProcSource();
        return ret;
    }

    public VarNode caseMethodThrow() {
        LocalVarNode ret = this.pag.makeLocalVarNode(new Parm(this.method, -3), RefType.v("java.lang.Throwable"), this.method);
        ret.setInterProcSource();
        return ret;
    }

    public final FieldRefNode caseArray(VarNode base) {
        return this.pag.makeFieldRefNode(base, ArrayElement.v());
    }

    private Node caseCaughtExceptionRef(CaughtExceptionRef cer) {
        if (CoreConfig.v().getPtaConfig().preciseExceptions) {
            return this.pag.makeLocalVarNode(cer, cer.getType(), this.method);
        }
        return this.getNode(PTAScene.v().getFieldGlobalThrow());
    }

    private FieldRefNode caseArrayRef(ArrayRef ar) {
        return this.caseArray(this.caseLocal((Local)ar.getBase()));
    }

    private VarNode caseParameterRef(ParameterRef pr) {
        return this.caseParm(pr.getIndex());
    }

    private VarNode caseStaticFieldRef(StaticFieldRef sfr) {
        return this.pag.makeGlobalVarNode(sfr.getField(), sfr.getField().getType());
    }

    private Node caseNullConstant(NullConstant nr) {
        return null;
    }

    private VarNode caseStringConstant(StringConstant sc) {
        AllocNode stringConstantNode = this.pag.makeStringConstantNode(sc);
        GlobalVarNode stringConstantVar = this.pag.makeGlobalVarNode(sc, RefType.v("java.lang.String"));
        this.mpag.addInternalEdge(stringConstantNode, stringConstantVar);
        LocalVarNode vn = this.pag.makeLocalVarNode(new Pair<SootMethod, StringConstant>(this.method, sc), RefType.v("java.lang.String"), this.method);
        this.mpag.addInternalEdge(stringConstantVar, vn);
        return vn;
    }

    public LocalVarNode makeInvokeStmtThrowVarNode(Stmt invoke, SootMethod method) {
        return this.pag.makeLocalVarNode(invoke, RefType.v("java.lang.Throwable"), method);
    }

    public final VarNode caseClassConstant(ClassConstant cc) {
        AllocNode classConstant = this.pag.makeClassConstantNode(cc);
        GlobalVarNode classConstantVar = this.pag.makeGlobalVarNode(cc, RefType.v("java.lang.Class"));
        this.mpag.addInternalEdge(classConstant, classConstantVar);
        LocalVarNode vn = this.pag.makeLocalVarNode(new Pair<SootMethod, ClassConstant>(this.method, cc), RefType.v("java.lang.Class"), this.method);
        this.mpag.addInternalEdge(classConstantVar, vn);
        return vn;
    }
}

