/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import qilin.CoreConfig;
import qilin.core.ArtificialMethod;
import qilin.util.PTAUtils;
import soot.EntryPoints;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.VoidType;
import soot.jimple.JimpleBody;

public class FakeMainFactory
extends ArtificialMethod {
    public static int implicitCallEdges;
    private final SootClass fakeClass;

    public FakeMainFactory() {
        this.localStart = 0;
        this.fakeClass = new SootClass("FakeMain");
        this.fakeClass.setResolvingLevel(3);
        this.method = new SootMethod("fakeMain", null, VoidType.v());
        this.method.setModifiers(8);
        SootField currentThread = new SootField("currentThread", RefType.v("java.lang.Thread"), 8);
        SootField globalThrow = new SootField("globalThrow", RefType.v("java.lang.Exception"), 8);
        this.fakeClass.addMethod(this.method);
        this.fakeClass.addField(currentThread);
        this.fakeClass.addField(globalThrow);
    }

    private List<SootMethod> getEntryPoints() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        if (CoreConfig.v().getPtaConfig().clinitMode == CoreConfig.ClinitMode.FULL) {
            ret.addAll(EntryPoints.v().clinits());
        } else {
            ret.addAll(Collections.emptySet());
        }
        if (CoreConfig.v().getPtaConfig().singleentry) {
            List<SootMethod> entries = EntryPoints.v().application();
            if (entries.isEmpty()) {
                throw new RuntimeException("Must specify MAINCLASS when appmode enabled!!!");
            }
            ret.addAll(entries);
        } else {
            System.out.println("include implicit entry!");
            ret.addAll(EntryPoints.v().application());
            ret.addAll(EntryPoints.v().implicit());
        }
        System.out.println("#EntrySize:" + ret.size());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootMethod getFakeMain() {
        if (this.body == null) {
            FakeMainFactory fakeMainFactory = this;
            synchronized (fakeMainFactory) {
                if (this.body == null) {
                    this.method.setSource((m4, phaseName) -> new JimpleBody(this.method));
                    this.body = PTAUtils.getMethodBody(this.method);
                    this.makeFakeMain();
                }
            }
        }
        return this.method;
    }

    public Value getFieldCurrentThread() {
        return this.getStaticFieldRef("FakeMain", "currentThread");
    }

    public Value getFieldGlobalThrow() {
        return this.getStaticFieldRef("FakeMain", "globalThrow");
    }

    private void makeFakeMain() {
        implicitCallEdges = 0;
        for (SootMethod entry : this.getEntryPoints()) {
            if (!entry.isStatic()) continue;
            if (entry.getSubSignature().equals("void main(java.lang.String[])")) {
                Value mockStr = this.getNew(RefType.v("java.lang.String"));
                Value strArray = this.getNewArray(RefType.v("java.lang.String"));
                this.addAssign(this.getArrayRef(strArray), mockStr);
                this.addInvoke(entry.getSignature(), strArray);
                ++implicitCallEdges;
                continue;
            }
            if (CoreConfig.v().getPtaConfig().clinitMode == CoreConfig.ClinitMode.ONFLY && entry.isStaticInitializer()) continue;
            this.addInvoke(entry.getSignature(), new Value[0]);
            ++implicitCallEdges;
        }
        if (CoreConfig.v().getPtaConfig().singleentry) {
            return;
        }
        Value sv = this.getNextLocal(RefType.v("java.lang.String"));
        Value mainThread = this.getNew(RefType.v("java.lang.Thread"));
        Value mainThreadGroup = this.getNew(RefType.v("java.lang.ThreadGroup"));
        Value systemThreadGroup = this.getNew(RefType.v("java.lang.ThreadGroup"));
        Value gCurrentThread = this.getFieldCurrentThread();
        this.addAssign(gCurrentThread, mainThread);
        Value vRunnable = this.getNextLocal(RefType.v("java.lang.Runnable"));
        Value lThreadGroup = this.getNextLocal(RefType.v("java.lang.ThreadGroup"));
        this.addInvoke(mainThread, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.String)>", mainThreadGroup, sv);
        Value tmpThread = this.getNew(RefType.v("java.lang.Thread"));
        this.addInvoke(tmpThread, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.Runnable)>", lThreadGroup, vRunnable);
        this.addInvoke(tmpThread, "<java.lang.Thread: void exit()>", new Value[0]);
        this.addInvoke(systemThreadGroup, "<java.lang.ThreadGroup: void <init>()>", new Value[0]);
        this.addInvoke(mainThreadGroup, "<java.lang.ThreadGroup: void <init>(java.lang.ThreadGroup,java.lang.String)>", systemThreadGroup, sv);
        Value lThread = this.getNextLocal(RefType.v("java.lang.Thread"));
        Value lThrowable = this.getNextLocal(RefType.v("java.lang.Throwable"));
        Value tmpThreadGroup = this.getNew(RefType.v("java.lang.ThreadGroup"));
        this.addInvoke(tmpThreadGroup, "<java.lang.ThreadGroup: void uncaughtException(java.lang.Thread,java.lang.Throwable)>", lThread, lThrowable);
        Value defaultClassLoader = this.getNew(RefType.v("sun.misc.Launcher$AppClassLoader"));
        this.addInvoke(defaultClassLoader, "<java.lang.ClassLoader: void <init>()>", new Value[0]);
        Value vClass = this.getNextLocal(RefType.v("java.lang.Class"));
        Value vDomain = this.getNextLocal(RefType.v("java.security.ProtectionDomain"));
        this.addInvoke(defaultClassLoader, "<java.lang.ClassLoader: java.lang.Class loadClassInternal(java.lang.String)>", sv);
        this.addInvoke(defaultClassLoader, "<java.lang.ClassLoader: void checkPackageAccess(java.lang.Class,java.security.ProtectionDomain)>", vClass, vDomain);
        this.addInvoke(defaultClassLoader, "<java.lang.ClassLoader: void addClass(java.lang.Class)>", vClass);
        Value privilegedActionException = this.getNew(RefType.v("java.security.PrivilegedActionException"));
        Value gLthrow = this.getNextLocal(RefType.v("java.lang.Exception"));
        this.addInvoke(privilegedActionException, "<java.security.PrivilegedActionException: void <init>(java.lang.Exception)>", gLthrow);
    }
}

