/*
 * Decompiled with CFR 0.152.
 */
package qilin.core.builder;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.core.builder.MethodNodeFactory;
import qilin.core.pag.AllocNode;
import qilin.core.pag.CallSite;
import qilin.core.pag.LocalVarNode;
import qilin.core.pag.MethodPAG;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.pag.VirtualCallSite;
import qilin.core.sets.P2SetVisitor;
import qilin.core.sets.PointsToSetInternal;
import qilin.util.DataFactory;
import qilin.util.PTAUtils;
import soot.Context;
import soot.Kind;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.JInvokeStmt;
import soot.jimple.internal.JStaticInvokeExpr;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public class CallGraphBuilder {
    protected final Map<VarNode, Collection<VirtualCallSite>> receiverToSites;
    protected final Map<SootMethod, Map<Object, Stmt>> methodToInvokeStmt;
    protected final Set<MethodOrMethodContext> reachMethods;
    private ChunkedQueue<MethodOrMethodContext> rmQueue;
    protected final Set<Edge> calledges;
    protected final PTA pta;
    protected final PAG pag;
    protected CallGraph cicg;

    public CallGraphBuilder(PTA pta) {
        this.pta = pta;
        this.pag = pta.getPag();
        PTAScene.v().setCallGraph(new CallGraph());
        this.receiverToSites = DataFactory.createMap(PTAScene.v().getLocalNumberer().size());
        this.methodToInvokeStmt = DataFactory.createMap();
        this.reachMethods = DataFactory.createSet();
        this.calledges = DataFactory.createSet();
    }

    public void setRMQueue(ChunkedQueue<MethodOrMethodContext> rmQueue) {
        this.rmQueue = rmQueue;
    }

    public Collection<MethodOrMethodContext> getReachableMethods() {
        return this.reachMethods;
    }

    public Map<VarNode, Collection<VirtualCallSite>> getReceiverToSitesMap() {
        return this.receiverToSites;
    }

    public Collection<VirtualCallSite> callSitesLookUp(VarNode receiver) {
        return this.receiverToSites.getOrDefault(receiver, Collections.emptySet());
    }

    public CallGraph getCallGraph() {
        if (this.cicg == null) {
            this.constructCallGraph();
        }
        return PTAScene.v().getCallGraph();
    }

    public CallGraph getCICallGraph() {
        if (this.cicg == null) {
            this.constructCallGraph();
        }
        return this.cicg;
    }

    private void constructCallGraph() {
        this.cicg = new CallGraph();
        Map map = DataFactory.createMap();
        this.calledges.forEach(e -> {
            PTAScene.v().getCallGraph().addEdge((Edge)e);
            SootMethod src = e.src();
            SootMethod tgt = e.tgt();
            Unit unit = e.srcUnit();
            Map submap = map.computeIfAbsent(unit, k -> DataFactory.createMap());
            Set set = submap.computeIfAbsent(src, k -> DataFactory.createSet());
            if (set.add(tgt)) {
                this.cicg.addEdge(new Edge(src, e.srcUnit(), tgt, e.kind()));
            }
        });
    }

    public List<MethodOrMethodContext> getEntryPoints() {
        Node thisRef = this.pag.getMethodPAG(PTAScene.v().getFakeMainMethod()).nodeFactory().caseThis();
        thisRef = this.pta.parameterize(thisRef, this.pta.emptyContext());
        this.pag.addEdge(this.pta.getRootNode(), thisRef);
        return Collections.singletonList(this.pta.parameterize(PTAScene.v().getFakeMainMethod(), this.pta.emptyContext()));
    }

    public void initReachableMethods() {
        for (MethodOrMethodContext momc : this.getEntryPoints()) {
            if (!this.reachMethods.add(momc)) continue;
            this.rmQueue.add(momc);
        }
    }

    public VarNode getReceiverVarNode(Local receiver, MethodOrMethodContext m4) {
        LocalVarNode base = this.pag.makeLocalVarNode(receiver, receiver.getType(), m4.method());
        return (VarNode)this.pta.parameterize(base, m4.context());
    }

    protected void dispatch(AllocNode receiverNode, VirtualCallSite site) {
        Type type = receiverNode.getType();
        QueueReader<SootMethod> targets = PTAUtils.dispatch(type, site);
        while (targets.hasNext()) {
            SootMethod target = targets.next();
            if (site.iie() instanceof SpecialInvokeExpr) {
                RefType calleeDeclType = target.getDeclaringClass().getType();
                if (!Scene.v().getFastHierarchy().canStoreType(type, calleeDeclType)) continue;
            }
            this.addVirtualEdge(site.container(), site.getUnit(), target, site.kind(), receiverNode);
        }
    }

    private void addVirtualEdge(MethodOrMethodContext caller, Unit callStmt, SootMethod callee, Kind kind, AllocNode receiverNode) {
        Context tgtContext = this.pta.createCalleeCtx(caller, receiverNode, new CallSite(callStmt), callee);
        MethodOrMethodContext cstarget = this.pta.parameterize(callee, tgtContext);
        this.handleCallEdge(new Edge(caller, callStmt, cstarget, kind));
        Node thisRef = this.pag.getMethodPAG(callee).nodeFactory().caseThis();
        thisRef = this.pta.parameterize(thisRef, cstarget.context());
        this.pag.addEdge(receiverNode, thisRef);
    }

    public void injectCallEdge(Object heapOrType, MethodOrMethodContext callee, Kind kind) {
        Map stmtMap = this.methodToInvokeStmt.computeIfAbsent(callee.method(), k -> DataFactory.createMap());
        if (!stmtMap.containsKey(heapOrType)) {
            JStaticInvokeExpr ie = new JStaticInvokeExpr(callee.method().makeRef(), Collections.emptyList());
            JInvokeStmt stmt = new JInvokeStmt(ie);
            stmtMap.put(heapOrType, stmt);
            this.handleCallEdge(new Edge(this.pta.parameterize(PTAScene.v().getFakeMainMethod(), this.pta.emptyContext()), (Unit)stmtMap.get(heapOrType), callee, kind));
        }
    }

    public void addStaticEdge(MethodOrMethodContext caller, Unit callStmt, SootMethod calleem, Kind kind) {
        Context typeContext = this.pta.createCalleeCtx(caller, null, new CallSite(callStmt), calleem);
        MethodOrMethodContext callee = this.pta.parameterize(calleem, typeContext);
        this.handleCallEdge(new Edge(caller, callStmt, callee, kind));
    }

    protected void handleCallEdge(Edge edge) {
        if (this.calledges.add(edge)) {
            MethodOrMethodContext callee = edge.getTgt();
            if (this.reachMethods.add(callee)) {
                this.rmQueue.add(callee);
            }
            this.processCallAssign(edge);
        }
    }

    public boolean recordVirtualCallSite(VarNode receiver, VirtualCallSite site) {
        Collection sites = this.receiverToSites.computeIfAbsent(receiver, k -> DataFactory.createSet());
        return sites.add(site);
    }

    public void virtualCallDispatch(PointsToSetInternal p2set, final VirtualCallSite site) {
        p2set.forall(new P2SetVisitor(this.pta){

            @Override
            public void visit(Node n) {
                CallGraphBuilder.this.dispatch((AllocNode)n, site);
            }
        });
    }

    private void processCallAssign(Edge e) {
        Value dest;
        MethodPAG srcmpag = this.pag.getMethodPAG(e.src());
        MethodPAG tgtmpag = this.pag.getMethodPAG(e.tgt());
        Stmt s2 = (Stmt)e.srcUnit();
        Context srcContext = e.srcCtxt();
        Context tgtContext = e.tgtCtxt();
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
        SootMethod tgtmtd = tgtmpag.getMethod();
        InvokeExpr ie = s2.getInvokeExpr();
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Type tgtType;
            Value arg = ie.getArg(i);
            if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant || !((tgtType = tgtmtd.getParameterType(i)) instanceof RefLikeType)) continue;
            Node argNode = srcnf.getNode(arg);
            argNode = this.pta.parameterize(argNode, srcContext);
            Node parm = tgtnf.caseParm(i);
            parm = this.pta.parameterize(parm, tgtContext);
            this.pag.addEdge(argNode, parm);
        }
        if (s2 instanceof AssignStmt && (dest = ((AssignStmt)s2).getLeftOp()).getType() instanceof RefLikeType) {
            Node destNode = srcnf.getNode(dest);
            destNode = this.pta.parameterize(destNode, srcContext);
            if (tgtmtd.getReturnType() instanceof RefLikeType) {
                Node retNode = tgtnf.caseRet();
                retNode = this.pta.parameterize(retNode, tgtContext);
                this.pag.addEdge(retNode, destNode);
            }
        }
        if (CoreConfig.v().getPtaConfig().preciseExceptions) {
            Node throwNode = tgtnf.caseMethodThrow();
            throwNode = this.pta.parameterize(throwNode, tgtContext);
            MethodNodeFactory mnf = srcmpag.nodeFactory();
            Node dst = mnf.makeInvokeStmtThrowVarNode(s2, srcmpag.getMethod());
            dst = this.pta.parameterize(dst, srcContext);
            this.pag.addEdge(throwNode, dst);
        }
    }
}

