/*
 * Decompiled with CFR 0.152.
 */
package qilin.core;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import qilin.util.DataFactory;
import soot.AnySubType;
import soot.ArrayType;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.SpecialInvokeExpr;
import soot.util.NumberedString;
import soot.util.queue.ChunkedQueue;

public class VirtualCalls {
    private static volatile VirtualCalls instance = null;
    private final Map<Type, Map<NumberedString, SootMethod>> typeToVtbl = DataFactory.createMap(Scene.v().getTypeNumberer().size());
    protected Map<Type, Set<Type>> baseToSubTypes = DataFactory.createMap();

    private VirtualCalls() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VirtualCalls v() {
        if (instance != null) return instance;
        Class<VirtualCalls> clazz = VirtualCalls.class;
        synchronized (VirtualCalls.class) {
            if (instance != null) return instance;
            instance = new VirtualCalls();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void reset() {
        instance = null;
    }

    public SootMethod resolveSpecial(SpecialInvokeExpr iie, NumberedString subSig, SootMethod container2) {
        return this.resolveSpecial(iie, subSig, container2, false);
    }

    public SootMethod resolveSpecial(SpecialInvokeExpr iie, NumberedString subSig, SootMethod container2, boolean appOnly) {
        SootMethod target = iie.getMethod();
        if (Scene.v().getFastHierarchy().canStoreType(container2.getDeclaringClass().getType(), target.getDeclaringClass().getType()) && container2.getDeclaringClass().getType() != target.getDeclaringClass().getType() && !target.getName().equals("<init>") && subSig != Scene.v().getSubSigNumberer().findOrAdd("void <clinit>()")) {
            return this.resolveNonSpecial(container2.getDeclaringClass().getSuperclass().getType(), subSig, appOnly);
        }
        return target;
    }

    public SootMethod resolveNonSpecial(RefType t2, NumberedString subSig) {
        return this.resolveNonSpecial(t2, subSig, false);
    }

    public SootMethod resolveNonSpecial(RefType t2, NumberedString subSig, boolean appOnly) {
        Map vtbl = this.typeToVtbl.computeIfAbsent(t2, k -> DataFactory.createMap(8));
        SootMethod ret = (SootMethod)vtbl.get(subSig);
        if (ret != null) {
            return ret;
        }
        SootClass cls = t2.getSootClass();
        if (appOnly && cls.isLibraryClass()) {
            return null;
        }
        SootMethod m4 = cls.getMethodUnsafe(subSig);
        if (m4 != null) {
            if (!m4.isAbstract()) {
                ret = m4;
            }
        } else {
            SootClass c = cls.getSuperclassUnsafe();
            if (c != null) {
                ret = this.resolveNonSpecial(c.getType(), subSig);
            }
        }
        if (ret == null) {
            return null;
        }
        vtbl.put(subSig, ret);
        return ret;
    }

    public void resolve(Type t2, Type declaredType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets) {
        this.resolve(t2, declaredType, null, subSig, container2, targets);
    }

    public void resolve(Type t2, Type declaredType, Type sigType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets) {
        this.resolve(t2, declaredType, sigType, subSig, container2, targets, false);
    }

    public void resolve(Type t2, Type declaredType, Type sigType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly) {
        if (declaredType instanceof ArrayType) {
            declaredType = RefType.v("java.lang.Object");
        }
        if (sigType instanceof ArrayType) {
            sigType = RefType.v("java.lang.Object");
        }
        if (t2 instanceof ArrayType) {
            t2 = RefType.v("java.lang.Object");
        }
        if (declaredType != null && !Scene.v().getFastHierarchy().canStoreType(t2, declaredType)) {
            return;
        }
        if (sigType != null && !Scene.v().getFastHierarchy().canStoreType(t2, sigType)) {
            return;
        }
        if (t2 instanceof RefType) {
            SootMethod target = this.resolveNonSpecial((RefType)t2, subSig, appOnly);
            if (target != null) {
                targets.add(target);
            }
        } else if (t2 instanceof AnySubType) {
            RefType base = ((AnySubType)t2).getBase();
            this.resolveAnySubType(declaredType, sigType, subSig, container2, targets, appOnly, base);
        } else if (!(t2 instanceof NullType)) {
            throw new RuntimeException("oops " + t2);
        }
    }

    protected void resolveAnySubType(Type declaredType, Type sigType, NumberedString subSig, SootMethod container2, ChunkedQueue<SootMethod> targets, boolean appOnly, RefType base) {
        Set<Type> subTypes = this.baseToSubTypes.get(base);
        if (subTypes != null && !subTypes.isEmpty()) {
            for (Type st : subTypes) {
                this.resolve(st, declaredType, sigType, subSig, container2, targets, appOnly);
            }
            return;
        }
        HashSet<RefType> newSubTypes = new HashSet<RefType>();
        newSubTypes.add(base);
        LinkedList<SootClass> worklist = new LinkedList<SootClass>();
        HashSet<SootClass> workset = new HashSet<SootClass>();
        SootClass cl = base.getSootClass();
        if (workset.add(cl)) {
            worklist.add(cl);
        }
        while (!worklist.isEmpty()) {
            cl = (SootClass)worklist.removeFirst();
            if (cl.isInterface()) {
                for (SootClass c : Scene.v().getFastHierarchy().getAllImplementersOfInterface(cl)) {
                    if (!workset.add(c)) continue;
                    worklist.add(c);
                }
                continue;
            }
            if (cl.isConcrete()) {
                this.resolve(cl.getType(), declaredType, sigType, subSig, container2, targets, appOnly);
                newSubTypes.add(cl.getType());
            }
            for (SootClass c : Scene.v().getFastHierarchy().getSubclassesOf(cl)) {
                if (!workset.add(c)) continue;
                worklist.add(c);
            }
        }
        this.baseToSubTypes.computeIfAbsent(base, k -> DataFactory.createSet()).addAll(newSubTypes);
    }
}

