/*
 * Decompiled with CFR 0.152.
 */
package qilin.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import qilin.core.PointsToAnalysis;
import qilin.core.builder.CallGraphBuilder;
import qilin.core.builder.ExceptionHandler;
import qilin.core.pag.AllocNode;
import qilin.core.pag.ArrayElement;
import qilin.core.pag.CallSite;
import qilin.core.pag.ContextAllocNode;
import qilin.core.pag.ContextField;
import qilin.core.pag.ContextVarNode;
import qilin.core.pag.GlobalVarNode;
import qilin.core.pag.Node;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.sets.HybridPointsToSet;
import qilin.core.sets.PointsToSet;
import qilin.core.sets.PointsToSetInternal;
import qilin.core.sets.UnmodifiablePointsToSet;
import qilin.core.solver.Propagator;
import qilin.parm.ctxcons.CtxConstructor;
import qilin.parm.heapabst.HeapAbstractor;
import qilin.parm.select.CtxSelector;
import soot.Context;
import soot.Local;
import soot.MethodOrMethodContext;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.toolkits.callgraph.CallGraph;

public abstract class PTA
implements PointsToAnalysis {
    protected AllocNode rootNode;
    protected PAG pag = this.createPAG();
    protected CallGraph callGraph;
    protected CallGraphBuilder cgb = this.createCallGraphBuilder();
    protected ExceptionHandler eh = new ExceptionHandler(this);
    private Set<SootMethod> nakedReachables = null;

    public PTA() {
        AllocNode rootBase = this.pag.makeAllocNode("ROOT", RefType.v("java.lang.Object"), null);
        this.rootNode = new ContextAllocNode(rootBase, CtxConstructor.emptyContext);
    }

    protected abstract PAG createPAG();

    protected abstract CallGraphBuilder createCallGraphBuilder();

    public void run() {
        this.pureRun();
    }

    public void pureRun() {
        this.getPropagator().propagate();
    }

    public PAG getPag() {
        return this.pag;
    }

    public CallGraphBuilder getCgb() {
        return this.cgb;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.eh;
    }

    public CallGraph getCallGraph() {
        if (this.callGraph == null) {
            this.callGraph = this.cgb.getCICallGraph();
        }
        return this.callGraph;
    }

    public Collection<MethodOrMethodContext> getReachableMethods() {
        return this.cgb.getReachableMethods();
    }

    public Collection<SootMethod> getNakedReachableMethods() {
        if (this.nakedReachables == null) {
            this.nakedReachables = new HashSet<SootMethod>();
            this.cgb.getReachableMethods().forEach(momc -> this.nakedReachables.add(momc.method()));
        }
        return this.nakedReachables;
    }

    protected abstract Propagator getPropagator();

    public abstract Node parameterize(Node var1, Context var2);

    public abstract MethodOrMethodContext parameterize(SootMethod var1, Context var2);

    public abstract AllocNode getRootNode();

    public abstract Context emptyContext();

    public abstract Context createCalleeCtx(MethodOrMethodContext var1, AllocNode var2, CallSite var3, SootMethod var4);

    public abstract HeapAbstractor heapAbstractor();

    public abstract CtxConstructor ctxConstructor();

    public abstract CtxSelector ctxSelector();

    @Override
    public PointsToSet reachingObjects(Local l) {
        HybridPointsToSet ret = new HybridPointsToSet();
        this.pag.getVarNodes(l).forEach(vn -> ret.addAll(vn.getP2Set(), null));
        return new UnmodifiablePointsToSet(this, ret);
    }

    @Override
    public PointsToSet reachingObjects(Node n) {
        PointsToSetInternal ret;
        if (n instanceof ContextVarNode) {
            ContextVarNode cvn = (ContextVarNode)n;
            ret = cvn.getP2Set();
        } else if (n instanceof ContextField) {
            ContextField cf = (ContextField)n;
            ret = cf.getP2Set();
        } else {
            VarNode varNode = (VarNode)n;
            ret = new HybridPointsToSet();
            if (this.pag.getContextVarNodeMap().containsKey(varNode)) {
                this.pag.getContextVarNodeMap().get(varNode).values().forEach(vn -> ret.addAll(vn.getP2Set(), null));
            }
        }
        return new UnmodifiablePointsToSet(this, ret);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s2) {
        return this.reachingObjectsInternal(s2, (SparkField)ArrayElement.v());
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l) {
        ContextVarNode n = this.pag.findContextVarNode(l, c);
        PointsToSetInternal pts = n == null ? HybridPointsToSet.getEmptySet() : n.getP2Set();
        return new UnmodifiablePointsToSet(this, pts);
    }

    @Override
    public PointsToSet reachingObjects(Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(l), f);
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s2, SootField f) {
        if (f.isStatic()) {
            throw new RuntimeException("The parameter f must be an *instance* field.");
        }
        return this.reachingObjectsInternal(s2, (SparkField)f);
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(c, l), f);
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        PointsToSetInternal ret;
        if (f.isStatic()) {
            GlobalVarNode n = this.pag.findGlobalVarNode(f);
            ret = n == null ? HybridPointsToSet.getEmptySet() : n.getP2Set();
        } else {
            ret = new HybridPointsToSet();
            this.pag.getContextFieldVarNodeMap().values().stream().filter(map -> map.containsKey(f)).forEach(map -> {
                ContextField contextField = (ContextField)map.get(f);
                ret.addAll(contextField.getP2Set(), null);
            });
        }
        return new UnmodifiablePointsToSet(this, ret);
    }

    public PointsToSet reachingObjectsInternal(PointsToSet bases, SparkField f) {
        HybridPointsToSet ret = new HybridPointsToSet();
        this.pag.getContextFieldVarNodeMap().values().stream().filter(map -> map.containsKey(f)).forEach(map -> {
            ContextField contextField = (ContextField)map.get(f);
            AllocNode base = contextField.getBase();
            if (bases.contains(base)) {
                ret.addAll(contextField.getP2Set(), null);
            }
        });
        return new UnmodifiablePointsToSet(this, ret);
    }

    public PointsToSet reachingObjectsInternal(AllocNode heap, SparkField f) {
        HybridPointsToSet ret = new HybridPointsToSet();
        this.pag.getContextFieldVarNodeMap().values().stream().filter(map -> map.containsKey(f)).forEach(map -> {
            ContextField contextField = (ContextField)map.get(f);
            AllocNode base = contextField.getBase();
            if (heap.equals(base)) {
                ret.addAll(contextField.getP2Set(), null);
            }
        });
        return new UnmodifiablePointsToSet(this, ret);
    }

    @Override
    public boolean mayAlias(Local l1, Local l2) {
        PointsToSet pts1 = this.reachingObjects(l1).toCIPointsToSet();
        PointsToSet pts2 = this.reachingObjects(l2).toCIPointsToSet();
        return pts1.hasNonEmptyIntersection(pts2);
    }
}

