/*
 * Decompiled with CFR 0.152.
 */
package qilin.core;

import java.util.Arrays;
import java.util.List;
import qilin.core.PTAScene;
import soot.ArrayType;
import soot.Body;
import soot.RefType;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.jimple.internal.JArrayRef;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.internal.JInterfaceInvokeExpr;
import soot.jimple.internal.JInvokeStmt;
import soot.jimple.internal.JNewArrayExpr;
import soot.jimple.internal.JNewExpr;
import soot.jimple.internal.JReturnStmt;
import soot.jimple.internal.JStaticInvokeExpr;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.jimple.internal.JimpleLocal;

public abstract class ArtificialMethod {
    protected SootMethod method;
    protected Body body;
    protected Value thisLocal;
    protected Value[] paraLocals;
    protected int paraStart;
    protected int localStart;

    protected Value getThis() {
        if (this.thisLocal == null) {
            RefType type = this.method.getDeclaringClass().getType();
            ThisRef thisRef = new ThisRef(type);
            this.thisLocal = this.getLocal(type, 0);
            this.addIdentity(this.thisLocal, thisRef);
        }
        return this.thisLocal;
    }

    protected Value getPara(int index) {
        Value paraLocal = this.paraLocals[index];
        if (paraLocal == null) {
            Type type = this.method.getParameterType(index);
            return this.getPara(index, type);
        }
        return paraLocal;
    }

    protected Value getPara(int index, Type type) {
        Value paraLocal = this.paraLocals[index];
        if (paraLocal == null) {
            ParameterRef paraRef = new ParameterRef(type, index);
            paraLocal = this.getLocal(type, this.paraStart + index);
            this.addIdentity(paraLocal, paraRef);
            this.paraLocals[index] = paraLocal;
        }
        return paraLocal;
    }

    private void addIdentity(Value lValue, Value rValue) {
        this.body.getUnits().add(new JIdentityStmt(lValue, rValue));
    }

    protected Value getNew(RefType type) {
        JNewExpr newExpr = new JNewExpr(type);
        Value local = this.getNextLocal(type);
        this.addAssign(local, newExpr);
        return local;
    }

    protected Value getNewArray(RefType type) {
        JNewArrayExpr newExpr = new JNewArrayExpr((Type)type, IntConstant.v(1));
        Value local = this.getNextLocal(ArrayType.v(type, 1));
        this.addAssign(local, newExpr);
        return local;
    }

    protected Value getNextLocal(Type type) {
        return this.getLocal(type, this.localStart++);
    }

    private Value getLocal(Type type, int index) {
        JimpleLocal local = new JimpleLocal("r" + index, type);
        this.body.getLocals().add(local);
        return local;
    }

    protected void addReturn(Value ret) {
        this.body.getUnits().add(new JReturnStmt(ret));
    }

    protected Value getStaticFieldRef(String className, String name) {
        return Jimple.v().newStaticFieldRef(RefType.v(className).getSootClass().getFieldByName(name).makeRef());
    }

    protected Value getArrayRef(Value base) {
        return new JArrayRef(base, IntConstant.v(0));
    }

    protected void addInvoke(Value receiver, String sig, Value ... args) {
        SootMethodRef methodRef = PTAScene.v().getMethod(sig).makeRef();
        List<Value> argsL = Arrays.asList(args);
        AbstractInstanceInvokeExpr invoke = methodRef.getDeclaringClass().isInterface() ? new JInterfaceInvokeExpr(receiver, methodRef, argsL) : new JVirtualInvokeExpr(receiver, methodRef, argsL);
        this.body.getUnits().add(new JInvokeStmt(invoke));
    }

    protected Value getInvoke(Value receiver, String sig, Value ... args) {
        SootMethodRef methodRef = PTAScene.v().getMethod(sig).makeRef();
        List<Value> argsL = Arrays.asList(args);
        AbstractInstanceInvokeExpr invoke = methodRef.getDeclaringClass().isInterface() ? new JInterfaceInvokeExpr(receiver, methodRef, argsL) : new JVirtualInvokeExpr(receiver, methodRef, argsL);
        Value rx = this.getNextLocal(methodRef.getReturnType());
        this.addAssign(rx, invoke);
        return rx;
    }

    protected void addInvoke(String sig, Value ... args) {
        SootMethodRef methodRef = PTAScene.v().getMethod(sig).makeRef();
        List<Value> argsL = Arrays.asList(args);
        this.body.getUnits().add(new JInvokeStmt(new JStaticInvokeExpr(methodRef, (List<? extends Value>)argsL)));
    }

    protected Value getInvoke(String sig, Value ... args) {
        SootMethodRef methodRef = PTAScene.v().getMethod(sig).makeRef();
        List<Value> argsL = Arrays.asList(args);
        Value rx = this.getNextLocal(methodRef.getReturnType());
        this.addAssign(rx, new JStaticInvokeExpr(methodRef, (List<? extends Value>)argsL));
        return rx;
    }

    protected void addAssign(Value lValue, Value rValue) {
        this.body.getUnits().add(new JAssignStmt(lValue, rValue));
    }
}

