/*
 * Decompiled with CFR 0.152.
 */
package qilin;

import java.util.List;
import soot.SourceLocator;

public class CoreConfig {
    protected static CoreConfig coreConfig = null;
    protected CorePTAConfiguration ptaConfig;
    protected final ApplicationConfiguration appConfig = new ApplicationConfiguration();
    protected final OutputConfiguration outConfig = new OutputConfiguration();

    public static CoreConfig v() {
        if (coreConfig == null) {
            throw new RuntimeException("Core configuration is not initialized!");
        }
        return coreConfig;
    }

    public static void reset() {
        coreConfig = null;
    }

    public CorePTAConfiguration getPtaConfig() {
        return this.ptaConfig;
    }

    public ApplicationConfiguration getAppConfig() {
        return this.appConfig;
    }

    public OutputConfiguration getOutConfig() {
        return this.outConfig;
    }

    public static class ApplicationConfiguration {
        public String APP_PATH = ".";
        public String JRE = null;
        public String LIB_PATH = null;
        public String REFLECTION_LOG = null;
        public String MAIN_CLASS = null;
        public List<String> INCLUDE = null;
        public List<String> EXCLUDE = null;
        public boolean INCLUDE_ALL = false;
    }

    public static class OutputConfiguration {
        public String outDir = SourceLocator.v().getOutputDir();
        public boolean dumpJimple = false;
        public boolean dumppts = false;
        public boolean dumplibpts = false;
        public boolean dumpCallGraph = false;
        public boolean dumppag = false;
        public boolean dumpStats = false;
    }

    public static class CorePTAConfiguration {
        public boolean singleentry = false;
        public ClinitMode clinitMode = ClinitMode.ONFLY;
        public boolean mergeHeap = false;
        public boolean preciseArrayElement = false;
        public boolean stringConstants = false;
        public boolean preciseExceptions = false;
        public boolean enforceEmptyCtxForIgnoreTypes = false;
        public String ptaName;
    }

    public static enum ClinitMode {
        FULL,
        ONFLY,
        APP;

    }
}

