/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import polyglot.util.FormatResult;
import polyglot.util.Item;
import polyglot.util.MaxLevels;
import polyglot.util.Overrun;
import polyglot.util.TextItem;

class BlockItem
extends Item {
    BlockItem parent;
    Item first;
    Item last;
    int indent;
    Map containsBreaks = new HashMap();

    BlockItem(BlockItem parent_, int indent_) {
        this.parent = parent_;
        this.last = null;
        this.first = null;
        this.indent = indent_;
    }

    void add(Item it) {
        if (this.first == null) {
            this.first = it;
        } else {
            if (it instanceof TextItem && this.last instanceof TextItem) {
                TextItem lasts = (TextItem)this.last;
                lasts.appendTextItem((TextItem)it);
                return;
            }
            this.last.next = it;
        }
        this.last = it;
    }

    FormatResult formatN(int lmargin, int pos, int rmargin, int fin, MaxLevels m4, int minLevel, int minLevelUnified) throws Overrun {
        int childfin = fin;
        if (childfin + BlockItem.getMinPosWidth(this.next, m4) > rmargin) {
            childfin = rmargin - BlockItem.getMinPosWidth(this.next, m4);
        }
        while (true) {
            FormatResult fr = BlockItem.format(this.first, pos + this.indent, pos, rmargin, childfin, new MaxLevels(m4.maxLevelInner, m4.maxLevelInner), 0, 0);
            int minLevel2 = Math.max(minLevel, fr.minLevel);
            int minLevelU2 = Math.max(minLevelUnified, fr.minLevel);
            try {
                return BlockItem.format(this.next, lmargin, fr.pos, rmargin, fin, m4, minLevel2, minLevelU2);
            }
            catch (Overrun o) {
                if (o.type == 1) {
                    o.type = 2;
                    throw o;
                }
                childfin -= o.amount;
                continue;
            }
            break;
        }
    }

    int sendOutput(PrintWriter o, int lmargin, int pos, boolean success, Item last) throws IOException {
        Item it = this.first;
        lmargin = pos + this.indent;
        while (it != null) {
            pos = it.sendOutput(o, lmargin, pos, success, last);
            if (last != null && it == last) {
                throw new IOException();
            }
            it = it.next;
        }
        return pos;
    }

    int selfMinWidth(MaxLevels m4) {
        return BlockItem.getMinWidth(this.first, new MaxLevels(m4.maxLevelInner, m4.maxLevelInner));
    }

    int selfMinPosWidth(MaxLevels m4) {
        return BlockItem.getMinPosWidth(this.first, new MaxLevels(m4.maxLevelInner, m4.maxLevelInner));
    }

    int selfMinIndent(MaxLevels m4) {
        return BlockItem.getMinIndent(this.first, new MaxLevels(m4.maxLevelInner, m4.maxLevelInner));
    }

    boolean selfContainsBreaks(MaxLevels m4) {
        if (this.containsBreaks.containsKey(m4)) {
            return this.containsBreaks.get(m4) != null;
        }
        boolean result = BlockItem.containsBreaks(this.first, new MaxLevels(m4.maxLevelInner, m4.maxLevelInner));
        this.containsBreaks.put(m4, result ? m4 : null);
        return result;
    }

    String selfToString() {
        if (this.indent == 0) {
            return "[" + this.first + "]";
        }
        return "[" + this.indent + this.first + "]";
    }
}

