/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.Report;
import polyglot.types.reflect.ClassFile;
import polyglot.util.InternalCompilerError;

public class ClassFileLoader {
    private ExtensionInfo extensionInfo;
    Map zipCache = new HashMap();
    Set packageCache;
    Map dirContentsCache = new HashMap();
    static final Object not_found = new Object();
    static Collection verbose = new HashSet();

    public ClassFileLoader(ExtensionInfo ext) {
        this.packageCache = new HashSet();
        this.extensionInfo = ext;
    }

    public boolean packageExists(File dir, String name) {
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "looking in " + dir + " for " + name.replace('.', File.separatorChar));
        }
        try {
            if (dir.getName().endsWith(".jar") || dir.getName().endsWith(".zip")) {
                String entryName = name.replace('.', '/');
                if (this.packageCache.contains(entryName)) {
                    return true;
                }
                this.loadZip(dir);
                return this.packageCache.contains(entryName);
            }
            String entryName = name.replace('.', File.separatorChar);
            File f = new File(dir, entryName);
            return f.exists() && f.isDirectory();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new InternalCompilerError(e);
        }
        return false;
    }

    public ClassFile loadClass(File dir, String name) {
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "looking in " + dir + " for " + name.replace('.', File.separatorChar) + ".class");
        }
        try {
            if (dir.getName().endsWith(".jar") || dir.getName().endsWith(".zip")) {
                ZipFile zip = this.loadZip(dir);
                String entryName = name.replace('.', '/') + ".class";
                return this.loadFromZip(dir, zip, entryName);
            }
            return this.loadFromFile(name, dir);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new InternalCompilerError(e);
        }
        return null;
    }

    ZipFile loadZip(File dir) throws IOException {
        Object o = this.zipCache.get(dir);
        if (o != not_found) {
            ZipFile zip = (ZipFile)o;
            if (zip != null) {
                return zip;
            }
            if (!dir.exists()) {
                this.zipCache.put(dir, not_found);
            } else {
                if (Report.should_report(verbose, 2)) {
                    Report.report(2, "Opening zip " + dir);
                }
                zip = dir.getName().endsWith(".jar") ? new JarFile(dir) : new ZipFile(dir);
                this.zipCache.put(dir, zip);
                Enumeration<? extends ZipEntry> i = zip.entries();
                while (i.hasMoreElements()) {
                    ZipEntry ei = i.nextElement();
                    String n = ei.getName();
                    int index = n.indexOf(47);
                    while (index >= 0) {
                        this.packageCache.add(n.substring(0, index));
                        index = n.indexOf(47, index + 1);
                    }
                }
                return zip;
            }
        }
        throw new FileNotFoundException(dir.getAbsolutePath());
    }

    ClassFile loadFromZip(File source, ZipFile zip, String entryName) throws IOException {
        ZipEntry entry;
        if (Report.should_report(verbose, 2)) {
            Report.report(2, "Looking for " + entryName + " in " + zip.getName());
        }
        if (zip != null && (entry = zip.getEntry(entryName)) != null) {
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "found zip entry " + entry);
            }
            InputStream in = zip.getInputStream(entry);
            ClassFile c = this.loadFromStream(source, in, entryName);
            in.close();
            return c;
        }
        return null;
    }

    ClassFile loadFromFile(String name, File dir) throws IOException {
        String firstPart;
        HashSet<String> dirContents = (HashSet<String>)this.dirContentsCache.get(dir);
        if (dirContents == null) {
            dirContents = new HashSet<String>();
            this.dirContentsCache.put(dir, dirContents);
            if (dir.exists() && dir.isDirectory()) {
                String[] contents = dir.list();
                for (int j = 0; j < contents.length; ++j) {
                    dirContents.add(contents[j]);
                }
            }
        }
        StringBuffer filenameSB = new StringBuffer(name.length() + 8);
        int firstSeparator = -1;
        filenameSB.append(name);
        for (int i = 0; i < filenameSB.length(); ++i) {
            if (filenameSB.charAt(i) != '.') continue;
            filenameSB.setCharAt(i, File.separatorChar);
            if (firstSeparator != -1) continue;
            firstSeparator = i;
        }
        filenameSB.append(".class");
        String filename = filenameSB.toString();
        String string = firstPart = firstSeparator == -1 ? filename : filename.substring(0, firstSeparator);
        if (!dirContents.contains(firstPart)) {
            return null;
        }
        File file = new File(dir, filename);
        FileInputStream in = new FileInputStream(file);
        if (Report.should_report(verbose, 3)) {
            Report.report(3, "found " + file);
        }
        ClassFile c = this.loadFromStream(file, in, name);
        in.close();
        return c;
    }

    ClassFile loadFromStream(File source, InputStream in, String name) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int n = 0;
        do {
            if ((n = in.read(buf)) < 0) continue;
            out.write(buf, 0, n);
        } while (n >= 0);
        byte[] bytecode = out.toByteArray();
        try {
            if (Report.should_report(verbose, 3)) {
                Report.report(3, "defining class " + name);
            }
            return this.extensionInfo.createClassFile(source, bytecode);
        }
        catch (ClassFormatError e) {
            throw new IOException(e.getMessage());
        }
    }

    static {
        verbose.add("loader");
    }
}

