/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.analysis.ClassPathResolver;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.analysis.DexClassProvider;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.iface.MultiDexContainer;

public class PathEntryLoader {
    Opcodes opcodes;
    final Set<File> loadedFiles = Sets.newHashSet();
    final List<ClassProvider> classProviders = Lists.newArrayList();

    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public List<ClassProvider> getClassProviders() {
        return this.classProviders;
    }

    public PathEntryLoader(Opcodes opcodes) {
        this.opcodes = opcodes;
    }

    @Nonnull
    public List<ClassProvider> getResolvedClassProviders() {
        return this.classProviders;
    }

    public void loadEntry(@Nonnull File entryFile, boolean loadOatDependencies) throws IOException, NoDexException {
        List<String> oatDependencies;
        MultiDexContainer<? extends DexBackedDexFile> container2;
        if (this.loadedFiles.contains(entryFile)) {
            return;
        }
        try {
            container2 = DexFileFactory.loadDexContainer(entryFile, this.opcodes);
        }
        catch (DexFileFactory.UnsupportedFileTypeException ex) {
            throw new ClassPathResolver.ResolveException(ex);
        }
        List<String> entryNames = container2.getDexEntryNames();
        if (entryNames.isEmpty()) {
            throw new NoDexException("%s contains no dex file", entryFile);
        }
        this.loadedFiles.add(entryFile);
        for (String entryName : entryNames) {
            this.classProviders.add(new DexClassProvider(container2.getEntry(entryName).getDexFile()));
        }
        if (loadOatDependencies && container2 instanceof OatFile && !(oatDependencies = ((OatFile)container2).getBootClassPath()).isEmpty()) {
            try {
                this.loadOatDependencies(entryFile.getParentFile(), oatDependencies);
            }
            catch (ClassPathResolver.NotFoundException ex) {
                throw new ClassPathResolver.ResolveException(ex, "Error while loading oat file %s", entryFile);
            }
            catch (NoDexException ex) {
                throw new ClassPathResolver.ResolveException(ex, "Error while loading dependencies for oat file %s", entryFile);
            }
        }
    }

    private void loadOatDependencies(@Nonnull File directory, @Nonnull List<String> oatDependencies) throws IOException, NoDexException, ClassPathResolver.NotFoundException {
        for (String oatDependency : oatDependencies) {
            String oatDependencyName = this.getFilenameForOatDependency(oatDependency);
            File file = new File(directory, oatDependencyName);
            if (!file.exists()) {
                throw new ClassPathResolver.NotFoundException("Cannot find dependency %s in %s", oatDependencyName, directory);
            }
            this.loadEntry(file, false);
        }
    }

    @Nonnull
    private String getFilenameForOatDependency(String oatDependency) {
        int index = oatDependency.lastIndexOf(47);
        String dependencyLeaf = oatDependency.substring(index + 1);
        if (dependencyLeaf.endsWith(".art")) {
            return dependencyLeaf.substring(0, dependencyLeaf.length() - 4) + ".oat";
        }
        return dependencyLeaf;
    }

    static class NoDexException
    extends Exception {
        public NoDexException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs));
        }
    }
}

