/*
 * Decompiled with CFR 0.152.
 */
package heros.flowfunc;

import com.google.common.collect.Sets;
import heros.FlowFunction;
import heros.flowfunc.Identity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Compose<D>
implements FlowFunction<D> {
    private final FlowFunction<D>[] funcs;

    private Compose(FlowFunction<D> ... funcs) {
        this.funcs = funcs;
    }

    @Override
    public Set<D> computeTargets(D source) {
        HashSet<D> curr = Sets.newHashSet();
        curr.add(source);
        for (FlowFunction flowFunction : this.funcs) {
            HashSet<D> next = Sets.newHashSet();
            for (Object d : curr) {
                next.addAll(flowFunction.computeTargets(d));
            }
            curr = next;
        }
        return curr;
    }

    public static <D> FlowFunction<D> compose(FlowFunction<D> ... funcs) {
        ArrayList<FlowFunction<D>> list = new ArrayList<FlowFunction<D>>();
        for (FlowFunction<D> f : funcs) {
            if (f == Identity.v()) continue;
            list.add(f);
        }
        if (list.size() == 1) {
            return (FlowFunction)list.get(0);
        }
        if (list.isEmpty()) {
            return Identity.v();
        }
        return new Compose<D>(list.toArray(new FlowFunction[list.size()]));
    }
}

