/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Semigroup;
import fj.data.List;
import fj.data.Option;

public final class Integers {
    public static final F<Integer, F<Integer, Integer>> add = Semigroup.intAdditionSemigroup.sum();
    public static final F<Integer, F<Integer, Integer>> multiply = Semigroup.intMultiplicationSemigroup.sum();
    public static final F<Integer, F<Integer, Integer>> subtract = Function.curry(new F2<Integer, Integer, Integer>(){

        @Override
        public Integer f(Integer x, Integer y) {
            return x - y;
        }
    });
    public static final F<Integer, Integer> negate = new F<Integer, Integer>(){

        @Override
        public Integer f(Integer x) {
            return x * -1;
        }
    };
    public static final F<Integer, Integer> abs = new F<Integer, Integer>(){

        @Override
        public Integer f(Integer x) {
            return Math.abs(x);
        }
    };
    public static final F<Integer, F<Integer, Integer>> remainder = Function.curry(new F2<Integer, Integer, Integer>(){

        @Override
        public Integer f(Integer a, Integer b) {
            return a % b;
        }
    });
    public static final F<Integer, F<Integer, Integer>> power = Function.curry(new F2<Integer, Integer, Integer>(){

        @Override
        public Integer f(Integer a, Integer b) {
            return (int)StrictMath.pow(a.intValue(), b.intValue());
        }
    });
    public static final F<Integer, Boolean> even = new F<Integer, Boolean>(){

        @Override
        public Boolean f(Integer i) {
            return i % 2 == 0;
        }
    };
    public static final F<Integer, Boolean> gtZero = new F<Integer, Boolean>(){

        @Override
        public Boolean f(Integer i) {
            return i > 0;
        }
    };
    public static final F<Integer, Boolean> gteZero = new F<Integer, Boolean>(){

        @Override
        public Boolean f(Integer i) {
            return i >= 0;
        }
    };
    public static final F<Integer, Boolean> ltZero = new F<Integer, Boolean>(){

        @Override
        public Boolean f(Integer i) {
            return i < 0;
        }
    };
    public static final F<Integer, Boolean> lteZero = new F<Integer, Boolean>(){

        @Override
        public Boolean f(Integer i) {
            return i <= 0;
        }
    };

    private Integers() {
        throw new UnsupportedOperationException();
    }

    public static int sum(List<Integer> ints) {
        return Monoid.intAdditionMonoid.sumLeft(ints);
    }

    public static int product(List<Integer> ints) {
        return Monoid.intMultiplicationMonoid.sumLeft(ints);
    }

    public static F<String, Option<Integer>> fromString() {
        return new F<String, Option<Integer>>(){

            @Override
            public Option<Integer> f(String s2) {
                try {
                    return Option.some(Integer.valueOf(s2));
                }
                catch (NumberFormatException ignored) {
                    return Option.none();
                }
            }
        };
    }
}

