/*
 * Decompiled with CFR 0.152.
 */
package driver;

import driver.PTAPattern;
import qilin.core.PTA;
import qilin.parm.ctxcons.CallsiteCtxConstructor;
import qilin.parm.ctxcons.HybObjCtxConstructor;
import qilin.parm.ctxcons.ObjCtxConstructor;
import qilin.parm.ctxcons.TypeCtxConstructor;
import qilin.pta.PTAConfig;
import qilin.pta.tools.BeanPTA;
import qilin.pta.tools.CallSiteSensPTA;
import qilin.pta.tools.DataDrivenPTA;
import qilin.pta.tools.DebloatedPTA;
import qilin.pta.tools.EaglePTA;
import qilin.pta.tools.HybridObjectSensPTA;
import qilin.pta.tools.MahjongPTA;
import qilin.pta.tools.ObjectSensPTA;
import qilin.pta.tools.SelectxPTA;
import qilin.pta.tools.Spark;
import qilin.pta.tools.TunnelingPTA;
import qilin.pta.tools.TurnerPTA;
import qilin.pta.tools.TypeSensPTA;
import qilin.pta.tools.ZipperPTA;

public class PTAFactory {
    public static PTA createPTA(PTAPattern ptaPattern) {
        switch (ptaPattern.getContextKind()) {
            case HYBOBJ: {
                switch (ptaPattern.getApproach()) {
                    case DATADRIVEN: {
                        HybObjCtxConstructor ctxCons = new HybObjCtxConstructor();
                        return new DataDrivenPTA(ctxCons);
                    }
                    case TUNNELING: {
                        HybObjCtxConstructor ctxCons = new HybObjCtxConstructor();
                        return new TunnelingPTA(ctxCons, ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
                    }
                }
                return new HybridObjectSensPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
            }
            case OBJECT: {
                switch (ptaPattern.getApproach()) {
                    case EAGLE: {
                        assert (ptaPattern.getContextDepth() == ptaPattern.getHeapContextDepth() + 1);
                        EaglePTA eagle = new EaglePTA(ptaPattern.getContextDepth());
                        if (PTAConfig.v().getPtaConfig().ctxDebloating) {
                            return new DebloatedPTA(eagle, PTAConfig.v().getPtaConfig().debloatApproach);
                        }
                        return eagle;
                    }
                    case BEAN: {
                        ObjCtxConstructor ctxCons = new ObjCtxConstructor();
                        return new BeanPTA(ctxCons);
                    }
                    case TURNER: {
                        return new TurnerPTA(ptaPattern.getContextDepth());
                    }
                    case ZIPPER: {
                        ObjCtxConstructor ctxCons = new ObjCtxConstructor();
                        ZipperPTA zipperPTA = new ZipperPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth(), ctxCons);
                        if (PTAConfig.v().getPtaConfig().ctxDebloating) {
                            return new DebloatedPTA(zipperPTA, PTAConfig.v().getPtaConfig().debloatApproach);
                        }
                        return zipperPTA;
                    }
                    case MAHJONG: {
                        ObjCtxConstructor ctxCons = new ObjCtxConstructor();
                        MahjongPTA mahjongPTA = new MahjongPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth(), ctxCons);
                        if (PTAConfig.v().getPtaConfig().ctxDebloating) {
                            return new DebloatedPTA(mahjongPTA, PTAConfig.v().getPtaConfig().debloatApproach);
                        }
                        return mahjongPTA;
                    }
                    case DATADRIVEN: {
                        ObjCtxConstructor ctxCons = new ObjCtxConstructor();
                        return new DataDrivenPTA(ctxCons);
                    }
                    case TUNNELING: {
                        ObjCtxConstructor ctxCons = new ObjCtxConstructor();
                        return new TunnelingPTA(ctxCons, ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
                    }
                }
                ObjectSensPTA kobj = new ObjectSensPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
                if (PTAConfig.v().getPtaConfig().ctxDebloating) {
                    return new DebloatedPTA(kobj, PTAConfig.v().getPtaConfig().debloatApproach);
                }
                return kobj;
            }
            case TYPE: {
                switch (ptaPattern.getApproach()) {
                    case DATADRIVEN: {
                        TypeCtxConstructor ctxCons = new TypeCtxConstructor();
                        return new DataDrivenPTA(ctxCons);
                    }
                    case TUNNELING: {
                        TypeCtxConstructor ctxCons = new TypeCtxConstructor();
                        return new TunnelingPTA(ctxCons, ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
                    }
                }
                return new TypeSensPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
            }
            case CALLSITE: {
                switch (ptaPattern.getApproach()) {
                    case ZIPPER: {
                        CallsiteCtxConstructor ctxCons = new CallsiteCtxConstructor();
                        return new ZipperPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth(), ctxCons);
                    }
                    case MAHJONG: {
                        CallsiteCtxConstructor ctxCons = new CallsiteCtxConstructor();
                        return new MahjongPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth(), ctxCons);
                    }
                    case DATADRIVEN: {
                        CallsiteCtxConstructor ctxCons = new CallsiteCtxConstructor();
                        return new DataDrivenPTA(ctxCons);
                    }
                    case TUNNELING: {
                        CallsiteCtxConstructor ctxCons = new CallsiteCtxConstructor();
                        return new TunnelingPTA(ctxCons, ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
                    }
                    case SELECTX: {
                        return new SelectxPTA(ptaPattern.getContextDepth());
                    }
                }
                return new CallSiteSensPTA(ptaPattern.getContextDepth(), ptaPattern.getHeapContextDepth());
            }
        }
        return new Spark();
    }
}

