/*
 * Decompiled with CFR 0.152.
 */
package driver;

import driver.Main;
import driver.PTAFactory;
import driver.PTAPattern;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import qilin.core.PTA;
import qilin.core.pag.AllocNode;
import qilin.core.pag.PAG;
import qilin.core.pag.VarNode;
import qilin.core.sets.PointsToSet;
import qilin.pta.PTAConfig;
import qilin.util.Util;
import soot.Local;

public class PTAComparator {
    static final boolean verbose = true;
    public static int count;
    public static int count2;

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-pta=")) continue;
            list.add(arg);
        }
        PTAComparator.runCompare(list.toArray(new String[0]), "2o", "E-2o");
    }

    public static void runCompare(String[] args, String ptaPtn1, String ptaPtn2) {
        PTSComparator comparator = new PTSComparator();
        String[] ptaArg1 = Util.concat(args, new String[]{"-pta=" + ptaPtn1});
        ((Comparator)comparator).record(Main.run(ptaArg1));
        PTAConfig.v().getPtaConfig().ptaPattern = new PTAPattern(ptaPtn2);
        PTA pta = PTAFactory.createPTA(PTAConfig.v().getPtaConfig().ptaPattern);
        pta.pureRun();
        ((Comparator)comparator).compare(pta);
        comparator.out.close();
        count = comparator.count;
        count2 = comparator.count2;
    }

    static class PTSComparator
    extends Comparator {
        private final Map<Object, Set<Object>> valToOldAllocs = new HashMap<Object, Set<Object>>();
        private final Map<Object, Set<Object>> valToNewAllocs = new HashMap<Object, Set<Object>>();

        PTSComparator() {
        }

        private Set<Object> getOldAllocs(Object val) {
            return this.valToOldAllocs.computeIfAbsent(val, k -> new HashSet());
        }

        private Set<Object> getNewAllocs(Object val) {
            return this.valToNewAllocs.computeIfAbsent(val, k -> new HashSet());
        }

        @Override
        void record(PTA pta) {
            pta.getPag().getValNodes().forEach(valNode -> {
                if (valNode instanceof VarNode) {
                    VarNode varNode = (VarNode)valNode;
                    Set<Object> allocSites = this.getOldAllocs(varNode.getVariable());
                    PointsToSet pts = pta.reachingObjects(varNode).toCIPointsToSet();
                    Iterator<AllocNode> it = pts.iterator();
                    while (it.hasNext()) {
                        AllocNode n = it.next();
                        allocSites.add(n.getNewExpr());
                    }
                }
            });
        }

        @Override
        void compare(PTA pta) {
            this.count = 0;
            PAG pag = pta.getPag();
            pag.getValNodes().forEach(valNode -> {
                if (valNode instanceof VarNode) {
                    VarNode varNode = (VarNode)valNode;
                    Set<Object> allocSites = this.getNewAllocs(varNode.getVariable());
                    PointsToSet pts1 = pta.reachingObjects(varNode).toCIPointsToSet();
                    Iterator<AllocNode> it = pts1.iterator();
                    while (it.hasNext()) {
                        AllocNode n = it.next();
                        allocSites.add(n.getNewExpr());
                    }
                }
            });
            this.valToNewAllocs.forEach((val, allocSites) -> {
                if (val.toString().contains("Parm THIS_NODE")) {
                    return;
                }
                Set<Object> oldAllocSites = this.getOldAllocs(val);
                if (oldAllocSites == null) {
                    oldAllocSites = Collections.emptySet();
                }
                if (!oldAllocSites.equals(allocSites)) {
                    this.out.println("\nPoint-to sets not equal!");
                    if (val instanceof Local) {
                        this.out.println("local: " + pag.findLocalVarNode(val).getMethod() + ": " + val);
                    } else {
                        this.out.println("not local: " + pag.findValNode(val) + ": " + val);
                    }
                    this.out.println("Old Points-to set:" + oldAllocSites.size());
                    this.out.println("New Points-to set:" + allocSites.size());
                    int diff = allocSites.size() - oldAllocSites.size();
                    if (diff > 0) {
                        this.count += diff;
                    } else if (diff < 0) {
                        this.count2 -= diff;
                    }
                    this.out.println("difference:" + diff);
                    if (diff > 0) {
                        allocSites.removeAll(oldAllocSites);
                        allocSites.forEach(a -> this.out.println(pag.findAllocNode(a)));
                    } else if (diff < 0) {
                        oldAllocSites.removeAll((Collection<?>)allocSites);
                        oldAllocSites.forEach(a -> this.out.println(pag.findAllocNode(a)));
                    }
                }
            });
            this.out.println("\nTotal pts over:" + this.count);
            this.out.println("\nTotal pts lose:" + this.count2);
        }
    }

    static abstract class Comparator {
        protected int count;
        protected int count2;
        PrintStream out = System.out;

        abstract void record(PTA var1);

        abstract void compare(PTA var1);
    }
}

