/*
 * Decompiled with CFR 0.152.
 */
package driver;

import driver.PTAFactory;
import driver.PTAOption;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qilin.CoreConfig;
import qilin.core.PTA;
import qilin.core.PTAScene;
import qilin.pta.PTAConfig;
import qilin.util.MemoryWatcher;
import qilin.util.PTAUtils;
import qilin.util.Stopwatch;
import soot.PackManager;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.options.Options;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static PTA run(String[] args) {
        new PTAOption().parseCommandLine(args);
        Main.setupSoot();
        if (PTAConfig.v().getOutConfig().dumpJimple) {
            String jimplePath = PTAConfig.v().getAppConfig().APP_PATH.replace(".jar", "");
            PTAUtils.dumpJimple(jimplePath);
            System.out.println("Jimple files have been dumped to: " + jimplePath);
        }
        PTA pta = PTAFactory.createPTA(PTAConfig.v().getPtaConfig().ptaPattern);
        pta.run();
        return pta;
    }

    public static void mainRun(String[] args) {
        Stopwatch ptaTimer = Stopwatch.newAndStart("Main PTA (including pre-analysis)");
        long pid = ProcessHandle.current().pid();
        MemoryWatcher memoryWatcher = new MemoryWatcher(pid, "Main PTA");
        memoryWatcher.start();
        Main.run(args);
        ptaTimer.stop();
        System.out.println(ptaTimer);
        memoryWatcher.stop();
        System.out.println(memoryWatcher);
    }

    public static void setupSoot() {
        Main.setSootOptions(PTAConfig.v());
        Main.setSootClassPath(PTAConfig.v());
        PTAScene.v().addBasicClasses();
        PTAScene.v().loadNecessaryClasses();
    }

    private static void setSootOptions(PTAConfig config) {
        ArrayList<String> dirs = new ArrayList<String>();
        CoreConfig.ApplicationConfiguration appConfig = config.getAppConfig();
        dirs.add(appConfig.APP_PATH);
        Options.v().set_process_dir(dirs);
        if (appConfig.MAIN_CLASS == null) {
            appConfig.MAIN_CLASS = PTAUtils.findMainFromMetaInfo(appConfig.APP_PATH);
        }
        if (appConfig.MAIN_CLASS != null) {
            Options.v().set_main_class(appConfig.MAIN_CLASS);
        }
        if (appConfig.INCLUDE_ALL) {
            Options.v().set_include_all(true);
        }
        if (appConfig.INCLUDE != null) {
            Options.v().set_include(appConfig.INCLUDE);
        }
        if (appConfig.EXCLUDE != null) {
            Options.v().set_no_bodies_for_excluded(true);
            Options.v().set_exclude(appConfig.EXCLUDE);
        }
        Main.configureCallgraphAlg(config.callgraphAlg);
        Options.v().setPhaseOption("jb", "use-original-names:true");
        Options.v().setPhaseOption("jb", "model-lambdametafactory:false");
        Options.v().set_output_format(1);
        if (appConfig.REFLECTION_LOG != null) {
            Options.v().setPhaseOption("cg", "reflection-log:" + appConfig.REFLECTION_LOG);
        }
        Options.v().set_keep_line_number(true);
        Options.v().set_full_resolver(true);
        Options.v().set_src_prec(2);
        Options.v().set_allow_phantom_refs(true);
    }

    private static void setSootClassPath(PTAConfig config) {
        ArrayList<String> cps = new ArrayList<String>();
        CoreConfig.ApplicationConfiguration appConfig = config.getAppConfig();
        cps.add(appConfig.APP_PATH);
        cps.addAll(Main.getLibJars(appConfig.LIB_PATH));
        cps.addAll(Main.getJreJars(appConfig.JRE));
        String classpath = String.join((CharSequence)File.pathSeparator, cps);
        logger.info("Setting Soot ClassPath: {}", (Object)classpath);
        System.setProperty("soot.class.path", classpath);
    }

    private static Collection<String> getJreJars(String JRE) {
        if (JRE == null) {
            return Collections.emptySet();
        }
        String jreLibDir = JRE + File.separator + "lib";
        return FileUtils.listFiles(new File(jreLibDir), new String[]{"jar"}, false).stream().map(File::toString).collect(Collectors.toList());
    }

    private static Collection<String> getLibJars(String LIB_PATH) {
        if (LIB_PATH == null) {
            return Collections.emptySet();
        }
        File libFile = new File(LIB_PATH);
        if (libFile.exists()) {
            if (libFile.isDirectory()) {
                return FileUtils.listFiles(libFile, new String[]{"jar"}, true).stream().map(File::toString).collect(Collectors.toList());
            }
            if (libFile.isFile()) {
                if (libFile.getName().endsWith(".jar")) {
                    return Collections.singletonList(LIB_PATH);
                }
                logger.error("Project not configured properly. Application library path {} is not a jar file.", (Object)libFile);
                System.exit(1);
            }
        }
        logger.error("Project not configured properly. Application library path {} is not correct.", (Object)libFile);
        System.exit(1);
        return null;
    }

    private static void configureCallgraphAlg(PTAConfig.CallgraphAlgorithm cgAlg) {
        switch (cgAlg) {
            case CHA: {
                Options.v().setPhaseOption("cg.cha", "on");
                break;
            }
            case VTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "vta:true");
                break;
            }
            case RTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "rta:true");
                Options.v().setPhaseOption("cg.spark", "on-fly-cg:false");
                break;
            }
            case GEOM: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "geom-pta:true");
                Options.v().setPhaseOption("cg.spark", "geom-encoding:Geom");
                Options.v().setPhaseOption("cg.spark", "geom-worklist:PQ");
                break;
            }
            case SPARK: {
                Options.v().setPhaseOption("cg.spark", "on");
                break;
            }
            case QILIN: {
                break;
            }
        }
    }

    public static CallGraph runCallgraphAlg(String[] args) {
        new PTAOption().parseCommandLine(args);
        Main.setupSoot();
        if (PTAConfig.v().getOutConfig().dumpJimple) {
            String jimplePath = PTAConfig.v().getAppConfig().APP_PATH.replace(".jar", "");
            PTAUtils.dumpJimple(jimplePath);
            System.out.println("Jimple files have been dumped to: " + jimplePath);
        }
        logger.info("Constructing the callgraph using " + PTAConfig.v().callgraphAlg + "...");
        if (PTAConfig.v().callgraphAlg == PTAConfig.CallgraphAlgorithm.QILIN) {
            PTA pta = PTAFactory.createPTA(PTAConfig.v().getPtaConfig().ptaPattern);
            pta.run();
        } else {
            PackManager.v().getPack("cg").apply();
        }
        CallGraph cg = PTAScene.v().getCallGraph();
        System.out.println("#CALLGRAPH:" + cg.size());
        return cg;
    }

    public static void mainCG(String[] args) {
        Stopwatch cgTimer = Stopwatch.newAndStart("Main CG");
        long pid = ProcessHandle.current().pid();
        MemoryWatcher memoryWatcher = new MemoryWatcher(pid, "Main CG");
        memoryWatcher.start();
        Main.runCallgraphAlg(args);
        cgTimer.stop();
        System.out.println(cgTimer);
        memoryWatcher.stop();
        System.out.println(memoryWatcher);
    }

    public static void main(String[] args) {
        Main.mainRun(args);
    }
}

