# Quant-Finance-Resources
**Courses, Articles and many more which can help beginners or professionals.**

*Finance is mostly details, and just having the ability to systematize and categorize and focus on details can be a huge advantage.* by Micheal Burry 

This resources are specifically meant for **STEM grads**. Most of the courses are Math or Coding heavy. Take it at your own risk.

### About me
I work as a Quant Trader in High Frequency Trading firm focused on Indian Markets in Equities and F&O. I did my Masters (M.Tech) and Bachelors (B.Tech) from [IIT Madras](https://www.iitm.ac.in/) in Automotive Engineering.

## Courses and Lectures
> **Note:** The courses listed below will NOT show any Coursera or Youtube Fams, because those courses are open for all (Anyone can take it,    Medical doctor or lawyer can if needed.) I don't want to (or want you to) spend time in these courses because these courses give you a flavor of the subject and not deep understanding. Being an engineer, I want to (wish the same for you) use my already learned mathematics skills to advance further in the topic and dive deep, to do some meaningful work and push the boundary.

> If you had Udemy courses and say "I know ML", I will lash you with a wet noodle (No offense to udemy).

### Mathematics
 * **Numerical Linear Algebra for Coders** by [fast.ai](https://www.fast.ai) 
 * **Introduction to Probability** by [MIT OCW](https://ocw.mit.edu/resources/res-6-012-introduction-to-probability-spring-2018/index.htm)
 * **Topics in Mathematics with Applications in Finance** by *MIT Mathematics* [Lecture Page](https://ocw.mit.edu/courses/mathematics/18-s096-topics-in-mathematics-with-applications-in-finance-fall-2013/)
 
### AI
 * **Machine Learning** by *Tom Mitchell* [CMU Course Page](http://www.cs.cmu.edu/~tom/10701_sp11/)
 * **Introduction to Reinforcement Learning** by *David Silver* from DeepMind (AlphaGo, AlphaZero etc. creator) [Youtube Playlist of the course](https://www.youtube.com/playlist?list=PLqYmG7hTraZDM-OYHWgPebj2MfCFzFObQ)

### Quant Finance
 * **Quantopian Lectures** for Python and Statistics [Lectures](https://gist.github.com/ih2502mk/50d8f7feb614c8676383431b056f4291)
 * **Global Financial Crisis** (Finance only) by *Timothy F. Geithner* (U.S. Secretary of the Treasury during crisis) Very good course for beginners in Finance or interested in Crisis analysis. [Coursera course](https://www.coursera.org/learn/global-financial-crisis)
 * **Introduction to Market Microstructures** by *Paul Besson* (Paul heads Euronext's quantitative research department) [Lecture Page](https://www.institutlouisbachelier.org/mooc/practical-introduction-to-market-microstructure/)

 
## Coding 
### Python
 * (Book) **Python for Finance**: Analyze Big Financial Data by *Yves Hilpisch* (Citadel Recommended)
 * 

### C++
 * (Book) **Accelerated C++** by *Andrew Koenig, Barbara E. Moo* (If you have good background in coding and in OOP like python, Java programmers)
 * (Book) **Effective Modern C++** by *Scott Meyers* 

## Books
### Mathematics
  * **Statistics** (4th edition) by *David Freedman, Robert Pisani, Roger Purves*  (Citadel Recommended)
  * **How to Lie with Statistics** by *Darrell Huff* (Interesting takes on how you can manipulate human perception with Graph)
  * **Thinking Strategically** by *Avinash Dixit and Barry Nalebuff* (Game theory book) (Citadel Recommended)
  * **Analysis of Financial Time Series** by *Ruey S. Tsay* (Good for Time Series Analysis)
  
### AI
  * **Deep Learning** by Ian Goodfellow et al.
  * **Reinforcement Learning An Introduction** by *Sutton and Barto* 
  
### Quant Finance
  * **Options, Futures, and other Derivatives** by *John C Hull*  (Citadel Recommended)
    - You will first need to have sound understanding of Financial Markets (Not expertise, but understanding is necessary.)
  * **Advances in Financial Machine Learning** by *Marcos Lopez de Prado*
  * **Financial Calculus: An Introduction to Derivative Pricing** by Martin Baxter (He ran Quant for Lehman and Nomura)
  * 

## Articles
* **The Gambler Who Cracked the Horse-Racing Code** in Bloomberg Businessweek [here](https://www.bloomberg.com/news/features/2018-05-03/the-gambler-who-cracked-the-horse-racing-code)
* **Learning and Understanding in the Mirror of Mathematics, Ch.1,2** by Misha Gromov [available here](https://www.ihes.fr/~gromov/wp-content/uploads/2018/08/Learning-understanding-two-chapters-aug24-2018.pdf)
* **High-Frequency Cross-Market Trading: Model Free measurements and Applications** (Good view on US HFT Market and Networks) [pdf of presentation](https://pdfs.semanticscholar.org/ca89/1deaf301c5cbbed9a8890aca431ad4e28fae.pdf)

## Papers
 * **Beating the bookies with their own numbers - and how the online sports betting market is rigged** [Paper](https://arxiv.org/abs/1710.02824)
 * **Machine Learning for Trading** by *Gordon Ritter* [Paper](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3015609) (Talks about implementation of RL into Finance)
 * **Deep Hedging** by *Hans Buehler et al.* (JP Morgan Quants from London Office) [Paper](https://arxiv.org/pdf/1802.03042.pdf)
   - This paper has been already implemented by JPM [Article](https://cdoreview.com/asset-management-and-trading/jp-morgan-unleashes-deep-hedging-on-single-stocks-other-portfolios/)
   - Hedging Vanilla OTC Products using RL
 * **A Stochastic Model for Order Book Dynamics** by *Rama Cont et al.* [Paper](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=1273160)
 * **Price dynamics in a Markovian limit order market** by *Rama Cont et al.* [Paper](https://arxiv.org/pdf/1104.4596.pdf)

## Psychology 
 * **48 Laws of Power** by *Robert Greene*

## Blogs
 * [Fast AI](https://www.fast.ai/) Awesome courses and blogs
 * [http://koaning.io/](http://koaning.io/) by *Vincent D. Warmerdam* (Use of Simple Mathematics into ML)
 * [Colah's Blog](http://colah.github.io/) by *Christopher Olah* (Ex OpenAI and Google Brain)
 * [Quantitative Trading](http://epchan.blogspot.com/) by *E P Chan* (Authored multiple books including Machine Trading, Algorithmic Trading)
 * [Distill Research Journal](https://distill.pub/) (About ML algorithms research papers presented with interactive visualization for better understanding)
 * [Sebastian Ruder's Blog](https://ruder.io/) (Seb is Research Scientist at Deep Mind, NLP Research)
 * [Systematic Edge](https://systematicedge.wordpress.com/) (HFT Market making and relative value strategy, Algo trader in Chicago)
 * [SNIPER IN MAHWAH & FRIENDS](https://sniperinmahwah.wordpress.com/) Blog on HFT Networks and latency
 * [Quantitative Research and Trading](http://jonathankinlay.com/) by *Jonathan Kinlay* (PhD in Economics, Previously NYU Stern and CMU Prof)
 * [Applied Probability Notes](https://appliedprobability.blog/) by *Neil Walton* (PhD, Ex Head of Probability and Statistics group at University of Manchester) Applied Probability is main theme for Optimization, Game theory, Dynamic Programming and RL  

## Interview Prep
 * **Probability and Market** by *Jane Street* [pdf](https://www.janestreet.com/static/pdfs/trading-interview.pdf) 
 > **PS**: I am weak at grammar and someone told there are too many mistakes here, instead of fixing it..! It's open source for a reason...
