# -*- coding:utf-8 -*-
# @Time: 2021/2/8 12:54
# @Author: Zhanyi Hou
# @Email: 1295752786@qq.com
# @File: base.py

# -*- coding:utf-8 -*-
# @Time: 2021/2/7 21:00
# @Author: Zhanyi Hou
# @Email: 1295752786@qq.com
# @File: datamerge.py
from typing import List

from PySide2.QtCore import Qt
from pmgwidgets import PMGPanelDialog, PMGPanel
from pyminer_comm.base import is_pyminer_service_started
from pyminer_comm import get_var_names, get_var, set_var, run_command
from pmtoolbox import input_identifier
from qtpy.QtWidgets import QDialog, QDialogButtonBox, QVBoxLayout, QSpinBox, QApplication, QMessageBox, QPushButton, \
    QComboBox


class BaseDFOperationDialog(QDialog):
    def __init__(self, ):
        super(BaseDFOperationDialog, self).__init__()
        self.setLayout(QVBoxLayout())
        names = get_var_names()
        self.combo_box = QComboBox()
        self.combo_box.addItems(names)
        self.panel = PMGPanel()
        self.setWindowFlags(self.windowFlags() | Qt.WindowStaysOnTopHint)
        self.button_box = QDialogButtonBox()
        self.button_preview = QPushButton(self.tr('Preview'))
        self.button_store = QPushButton(self.tr('Save to Var'))

        self.button_box.setStandardButtons(QDialogButtonBox.Cancel | QDialogButtonBox.Help)
        self.button_box.layout().addWidget(self.button_preview)
        self.button_box.layout().addWidget(self.button_store)
        self.button_preview.clicked.connect(self.preview)
        # self.button_box.accepted.connect(self.accept)
        self.button_store.clicked.connect(self.store)
        self.button_box.rejected.connect(self.close)
        self.layout().addWidget(self.combo_box)
        self.layout().addWidget(self.panel)
        self.layout().addWidget(self.button_box)

    def store(self):
        code = self.get_assignment_code()
        if code != '':
            run_command(command=code, hint_text=self.get_prompt_template() + code, hidden=False)

    def preview(self) -> None:
        code = self.get_value_code()
        if code != '':
            run_command(command=code, hint_text=self.get_prompt_template() + code, hidden=False)

    def accept(self) -> None:
        code = self.get_code()
        if code != '':
            run_command(command=code, hint_text=self.get_prompt_template() + code, hidden=False)

    def get_prompt_template(self) -> str:
        return ''

    def kwargs_to_str(self, kwargs: dict) -> str:
        args_str = ''
        for k, v in kwargs.items():
            args_str += '{k}={v},'.format(k=k, v=repr(v))
        return args_str

    def get_code(self) -> str:
        return ''

    def get_value_code(self) -> str:
        """
        获取一段代码，这段代码应当有返回值，而不是赋值代码。
        :return:
        """
        return ''

    def get_assignment_code(self) -> str:
        """
        获取赋值语句
        :return:
        """
        code = self.get_value_code()
        identifier = input_identifier(parent=self, default_name=self.combo_box.currentText())
        if identifier != '':
            code = identifier + ' = ' + code
            return code
        return ''


if __name__ == '__main__':
    app = QApplication([])
    md = BaseDFOperationDialog()
    md.show()
    app.exec_()
