"""
ipython的颜色不是由qss决定的，而是由自身决定的。
qss在这个文件中定义。

Created on 2020/8/24
@author: Irony
@email: 892768447@qq.com
@file: consolewidget
@description: Console Widget
"""
import os
from pmgwidgets import PMDockObject, PMGIpythonConsole


class ConsoleWidget(PMGIpythonConsole, PMDockObject):

    def __init__(self, *args, **kwargs):
        super(ConsoleWidget, self).__init__(*args, **kwargs)
        self.is_first_execution = True
        self.confirm_restart = False
        self.commands_pool = []

    def _handle_kernel_died(self, since_last_heartbit):
        self.is_first_execution = True
        self.restart_kernel(None, True)
        self.initialize_ipython_builtins()
        self.execute_command('')
        return True

    def setup_ui(self):
        super().setup_ui()
        style = self.lib.Program.get_settings()['theme']
        self.change_ui_theme(style)

    def connect_to_datamanager(self, data_manager):
        self.data_manager = data_manager
        self.lib = self.data_manager

    def initialize_ipython_builtins(self):
        from pmgwidgets import get_parent_path
        path = get_parent_path(__file__, 5)
        cmd = 'import sys;sys.path.append(r\'%s\')' % path
        self.execute_command(cmd, True, '')
        ini_py = os.path.join(
            self.lib.get_main_program_dir(),
            'extensions',
            'packages',
            'ipython_console',
            'initialize.py')
        self.execute_file(ini_py, hidden=True)
        for source, hidden, hint_text in self.commands_pool:
            self.execute_command(source, hidden, hint_text)

    def _update_list(self):
        try:
            super(ConsoleWidget, self)._update_list()
        except BaseException:
            import traceback
            traceback.print_exc()

    def _handle_complete_reply(self, msg):
        """
        重写，加上trycatch，直接禁用了没有其他的变化，故不做类型标注。
        :param msg:
        :return:
        """
        try:
            super()._handle_complete_reply(msg)
        except BaseException:
            import traceback
            traceback.print_exc()

    def _banner_default(self):
        """
        自定义控制台开始的文字
        Returns:
        """
        return 'Welcome To PyMiner!\n'

    def is_source_code_legal(self, source_code: str) -> bool:
        """
        判断注入到shell的命令是否合法，不合法的话，就避免执行这个函数。
        :param source_code:
        :return:
        """
        s = source_code.strip()
        if s != '' and s in ('%reset', 'reset'):
            return False
        return True


if __name__ == '__main__':
    import sys
    import cgitb

    cgitb.enable(format='text')
    from PyQt5.QtWidgets import QApplication

    app = QApplication(sys.argv)
    w = ConsoleWidget()
    w.show()
    w.setup_ui()

    sys.exit(app.exec_())
