# coding=utf-8
__author__ = '侯展意'

import base64
import json
import warnings
import zlib
from typing import List, Callable
import logging
import sys
import cloudpickle
import time
import socket

logger = logging.getLogger(__name__)

from PyQt5.QtWidgets import QApplication
from PyQt5.QtCore import QObject, QThread, pyqtSignal, QTimer


def parse_splicing_packets(packet_bytes: bytes) -> List[bytes]:
    return packet_bytes.split(b'PMEND')


class PMGThreadWorker(QObject):
    def __init__(self):
        super(PMGThreadWorker, self).__init__()
        self.quit = False
        self.work_loop_fcn = None
        self.on_exit_fcn = None

    def work(self):
        while (1):
            self.work_loop_fcn()
            if self.quit:
                break
        # self.thread().quit()

    def on_exit(self):
        if callable(self.on_exit_fcn):
            self.on_exit_fcn()
        self.quit = True


class PMQThreadObject(QObject):
    signal_server_message_received = pyqtSignal(dict)
    signal_data_changed = pyqtSignal(str)

    def __init__(self, parent=None, worker:QObject=None):
        super().__init__(parent)
        self.thread_recv = QThread()
        self.worker_recv = worker
        self.worker_recv.moveToThread(self.thread_recv)
        self.thread_recv.started.connect(self.worker_recv.work)  # self.worker_recv.work)
        self.thread_recv.start()

    def terminate(self):
        print('client quit')
        logger.info('client quit')
        self.worker_recv.on_exit()
        # self.worker_recv.close_socket()
        self.thread_recv.quit()
        self.thread_recv.wait(500)


class PMQThreadManager(QObject):
    signal_server_message_received = pyqtSignal(dict)
    signal_data_changed = pyqtSignal(str)

    def __init__(self, parent=None, work_fcn: Callable = None, loop_fcn: Callable = None, exit_fcn: Callable = None):
        super().__init__(parent)
        self.thread_recv = QThread()
        self.worker_recv = PMGThreadWorker()

        if work_fcn is not None and loop_fcn is not None:
            raise ValueError('work_fcn and loop_fcn cannot be both not None at the same time!')
        if work_fcn is not None:
            self.worker_recv.work = work_fcn
        else:
            self.worker_recv.work_loop_fcn = loop_fcn
        self.worker_recv.moveToThread(self.thread_recv)
        self.thread_recv.started.connect(self.worker_recv.work)  # self.worker_recv.work)
        self.worker_recv.on_exit_fcn = exit_fcn
        self.thread_recv.start()

    def shut_down(self):
        print('client quit')
        logger.info('client quit')
        self.worker_recv.on_exit()
        # self.worker_recv.close_socket()
        self.thread_recv.quit()
        self.thread_recv.wait(500)


if __name__ == '__main__':
    def loop():
        print(123)
        time.sleep(0.4)


    def exit():
        print('thread exits!')


    app = QApplication(sys.argv)
    c = PMQThreadManager(loop_fcn=loop, exit_fcn=exit)
    time.sleep(2)
    c.shut_down()
    sys.exit(app.exec_())
