<p></p>
<p></p>

<p align="center">
<img src="pyminer2/ui/source/icons/logo.png" height="80"/> 
</p>


<div align="center">

[![Stars](https://gitee.com/py2cn/pyminer/badge/star.svg?theme=gvp)](https://gitee.com/py2cn/pyminer/stargazers)
[![Platform](https://img.shields.io/badge/python-v3.8-blue)](https://img.shields.io/badge/python-v3.7-blue)
[![Platform](https://img.shields.io/badge/PyQt5-v5.15.0-blue)](https://img.shields.io/badge/PyQt5-v5.15.0-blue)
[![License](https://img.shields.io/badge/license-GPL-blue)](https://img.shields.io/badge/license-GPL-blue)

</div>

<div align="center">
    <a src="https://img.shields.io/badge/QQ%e7%be%a4-orange">
        <img src="https://img.shields.io/badge/QQ%e7%be%a4-945391275-orange">
    </a>
    <a src="https://img.shields.io/badge/QQ-454017698-orange">
        <img src="https://img.shields.io/badge/QQ-454017698-orange">
    </a>
</div>

<p></p>
<p></p>

<div align="center">

`PyMiner` 是跨平台的，基于数据工作空间的数学工具。

</div>
PyMiner一款基于数据工作空间的数学工具，通过加载插件的方式实现不同的需求，用易于操作的形式完成数学计算相关工作。

<p></p>
<p></p>

## 🎉 技术说明

项目开发环境支持跨平台，windows,linux,mac 都支持！如果使用出现问题，欢迎提issue，建议使用Python3.8+PyQt5.15，基于python虚拟环境进行开发。

<p></p>
<p></p>

## 🎁 文档地址
[https://gitee.com/py2cn/pyminer/wikis](https://gitee.com/py2cn/pyminer/wikis)

<p></p>
<p></p>

## ⏳ 当前进度
[https://gitee.com/py2cn/pyminer/board](https://gitee.com/py2cn/pyminer/board)


## 🚄 开源地址

- Gitee：[https://gitee.com/py2cn/pyminer](https://gitee.com/py2cn/pyminer)
- GitHub：[https://github.com/aboutlong/pyminer](https://github.com/aboutlong/pyminer)

<p></p>
<p></p>

## 🥂 安装体验

<p></p>
<p></p>

#### Windows安装

```bash
#第一步：下载源代码
git clone https://gitee.com/py2cn/pyminer.git
#第二步：同步安装依赖包和PyMiner，如果遇到安装失败的情况需要手动安装
python -m pip install -i https://mirrors.cloud.tencent.com/pypi/simple -r requirements.txt
#第三步：运行主程序
python app2.py
```

#### Linux安装

```bash
#第一步：下载源代码
git clone https://gitee.com/py2cn/pyminer.git
#第二步：同步安装依赖包和PyMiner，如果遇到安装失败的情况需要手动安装
python3 -m pip install -i https://mirrors.cloud.tencent.com/pypi/simple -r requirements_linux.txt
#第三步：运行主程序
python3 app2.py
```

## 🌻 项目成员

<a href="https://gitee.com/hzy15610046011" target="_blank" margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAAFB0lEQVR4Xu1aaU9bRxQ9rAnBmLIaiiG4doIxYAPCrAWrlFZtkCr1Y39Yf0Jb9UNVqVWSpiKhQMtiUwwpEArEgbAYs3shbAGqO8bWM3Hwe+Y9U4mZb8Z3nu+cOffMufNI+va778/AB5I4EEEWcCDOq4EDwYGIFEbOCM4IzoioZoGXBi8NXhq8NC7rJLhGcI3gGsE1gmuEiPsWRcUyR61Gfk4OFlZWcPz2rYh0ri9EUSDqKithNdcgOTkZO14vBp1OLLnXJK02MyMDR8fHigOpKBBfdnRApy1hC9/2evHTk99RmJeHrtYW0AKljMOjY/Q57JhffC1lmuhYxYDQ5OXh84/bkJWZyZJ58dKF3pERlGg0cQGxf3CA3hE7KzMlhmJA1FeZYK2uRkpKCg6PjtDvGMXc4iIKc3PRXGtBxu3bMdeTlpqGrMw7SEpKgn9vD08G/sT69nbMefEEKAbE111dKC4sYDm51zfwc0+P5Pw+aWpEpV7P5m3t7uLHR48lP0PsBEWAMOn1aKmrw630NJycnMAxOYmxqWmxOYXjvurshLZIwz6TyP7a2yv5GWInKAJEt82GuyUfshx2fT487OuH1+8Xm1M47pvuB8jJzmafp+bn0Wd3SH6G2AmyA2G4Wwab1Ypb6eksh+U1D3559gzCRYlNLlYcHck/PHwUK0zU97IDIaTzjQWipuI+mi0WpKWmhnchxIgv2tuRnaUK/z01JYWdBldxnF5/AL8NDIja8VhBsjGC7PQDWweys7IifjMEhPCPFNNt68AHajUD4l/XK/SPjsbKVdHvZQOCzJOhrOydZKMB0WiuQb3JxKw3eYw+h0MxxygWPVmAaKiuQn1VFYjuNM7OzhjthRoRSogc52dtbVCrgo7z4PAQe/v7YvNlceQyh8cnZDVXsgAhLAvaYXKB1HVGA4LKp7wk2H/EOwi4nsEhrHg88T7inXmyAEFPba2vQ829e5hdWGT9RcgICUujyWJGrdHIbPdVxv8aCGqmPirVMspS13kRiCqDAc21tcxtMqZ4PHjc1x8+NYTN2OnpKcamp2F//s9V8JI0VzZGCH9V6CWIEU+HhlgnWlwQ7D0Cb97gjxE7Xrvd4Wk3AghyluQtyGPotFr8PTXFLLNw3BggYvH0RgAx88rF+g+h44wFjJjvo3kUMfOixSREIzgQ593nxMwMyHSlCnqQi7uiVqkiGEP3GL5AAKdn7//vx7XNTdla84QwgsTyshHNX5A7nV1YwNOh4XjZLmnetQNx0V/Q0Up3GaQnxIrply4MJKAhu1YgmsxmmI0V4ZIge/7XmBMlmkLcLy9n/QqVxqrHg5GJ5/BsbUnaZSnB1wJEaXERmi21KMgN9iM06L3F8Pg48xfEBrq/oLjQoJc8rqUlOKdfYMfnk7JGUbEJBYIudU0GA/Jzc5B83p2GnCZZc9KE0CAwOpuboCstjYglhvj8frg3NrC46mbgyDESAsTmzjYq9YZwnxFKnDTAtbyMwTHne1txi9GIOlMl7kR5DyJk0VXBSAgQ1Gt82toCrSZ4NU9NFR19ZLXFvAsldpCWVOh0yFapmHbQqTI5Ny+bkCoChK3RiqL8fLbo0FlPFzLtDQ3w7QUwOTuH1fX1uDaR3pTpSrWgOxDSC7kEVBEg4lrhNU/iQJxvAAeCAxFZi5wRnBGcEVHPJ14avDR4afDSuMy8co3gGsE1gmsE1wgRLT4XSy6WkTT5D8Yz8d8Z2/SVAAAAAElFTkSuQmCC" height="40"/></a>
<a href="https://gitee.com/py2cn_admin" target="_blank"  margin="5" style='margin:5px'><img src="https://portrait.gitee.com/uploads/avatars/user/100/301972_py2cn_1578919767.png!avatar60" height="40"/></a>
<a href="https://gitee.com/junruoyu-zheng" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAACXElEQVR4Xu2YS0hUURzGvwuZMysxCSKIQEFhUJFMFy2SQEUYY9QBUQtsTBepjELiC0Q0H2DgA12UGQxoEGUQuAiCiKBcmERggohKvjEZJRIfV5iRexoXg8Nw4A4Xxe+sZg6Hw///3e/73XOPEn87xwsOKBTivwsohC8NFIJC+IORjqAj6IiAhwVGg9FgNBiNYF8SZAQZQUaQEWSExH0LYUlYEpaE5ZmBZUttBfKs6aLejU03Gjv6MPFjSgJ1+pecKlhSCN8DpRAUwj/bdAQdQUcEfN8xGowGo8FoBDsMkxFkBBlBRpxrRuTbsuAosCHqUiRW1zeQ+6DqfDqioqQQD4vyEBZ2AUsr6yiva8PiytoJMdoanLBl3RHz87+XkVPs1H/jIrmDIRczjsJclDsKYAq/CPf2XzR3DeDL+OSJEl/2tCL1RoKYn11YhN1RLdmG/mWGCJF26yZaaisRFRkBj8eD0bGPeNL93K/6REssnjbX4OqVy2L+87cJOBs79XcouYMhQmi1uPrbkZxoEWX929mF6/V7DA6/Ff9TkuLx+FExLHExUBQFB6qKZ643GHr1TrIN/csME+Ke3Yqqsvswm02iaq/Xi/0DVfsBkylcCHA8pmfmUFLdhN29ff0dSu5gmBBaPfXOUtizMwQrAg1NHA2SHb0v8P3nL8kWQrPMUCG0ku9mpqHIbkX09Wsw+5ygqof4497Ch09fMTQyaqgTjmU0XIjQPL/Q70IhfJpSCArhHy86go6gIwK+chgNRoPRYDSCnUfJCDKCjCAjyAiJr3bCkrAkLAlLwlIClkc2rHwEe1AdUAAAAABJRU5ErkJggg==" height="40"/></a>
<a href="https://gitee.com/lvvl" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAACX0lEQVR4Xu2bz4vTQBiG30mbND+6UfGi4EFFEK8rsqAuKx7EP9M/QzytKMIiiuJJFPcoiKLbbdOkaTIyk7jt2rSpwuI68861Lc08fM/7fTOl4uujAwkuCIKoqoAgahsIgiCOByMrghXBimgcFqgG1aAaVGPVSYIZwYxgRjAjmBFr3LcwLBmWDEuG5T8Ly/hBBPdiR3+/zIHkVYr0/WSN6ALcCx30t0M4oQBKYPwuQ/ImW+uzf/OmEw3LeRDq4YofJQ53ExQHZeuzGg0CEsj2cwyfjS0H8QeKmF0RdR2so4ixIMpEwvEF4KiyALJPOYbPlytiLIj8cwHhAd3zdReZAMnr5V3EaBDphwn6Wz5ET2hJiu8lDp82dxGjQQyejBBt+fCve4BioRT5mGP4YlER40GILhA/jOYUkRi9TDWQ+WU8CLXZ3jUX0S0fwpspMthNUA5mg5YVIBSM/u1AA1mmiDUgnNhBfC9E55zqp4DMJIZ7KSb7lSLWgGhSZPqtwODxCHJqGQityN0AvaszRdTpdLSX2lURCkTnjIONnUVF5Lg08xiuJks1RzQtNVeEm6qLVK9OvxRI3mbo3wnMu49YBUIrsh2gd6VWpKwGLfdS1z4QWhHVRc7WXURfZMlq1jDphqqtItS2tSI3fQj3N4FsA7GgyC8eNoJQisT3Q6iB62jZCEIrcsNDtOkD3RqFrSDU9jd2AniX67D430G0XlWfojec6O8ap2ifrY9CEDUigiCI47awIlgRrIjGDkI1qAbVoBqrxktmBDOCGcGMYEa0HsL53/AjROwa7BrsGo2J8RPW2YlZzjPz/wAAAABJRU5ErkJggg==" height="40"/></a>
<a href="https://gitee.com/panhaoyu" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAAE10lEQVR4Xu2bXWwUVRTH/zM7Ox+7Cy1UsN0KLdvWokCgPhljIjEmJmIMMcKD8kCqBA1qIIaIsWoJxhQFwe/PGlBDNCaGF4gPxBCDiSYYopa0Jf0u21IqJaW7O7OzOzvm3lm3LF2adec6G5N7n/owO3vP7/7P/5xzNxWmz1TY4AsCB+GogIPIZgMHwUHkGyNXBFcEV0TBZoGnBk8Nnho8NeabJLhHcI/gHsE9gntEEfct3CzLZpa+ELTIAViJHpjRw0WclTePeKsIXwiB5k5Iix6g0VnTZ2AM74M1c9abaOf5Fk9ByOEdUJbthiBV5rZkm1EYIx1ITXxVVhiegiCRSpX3Q13xBsRAM7kpdILPGEhNfgt98GXAipUFiOcgaJTEJxrfh7/qYUCQsoHbsGZ+gzG4pyypUh4Q2dCV5W1QwtsB34KcCjLGAIzBNqSnTnqqjLKCIJH6l2yGWr8Xglwz6xupSRhDe5G6/LVnMMoOgmZKxb3QGg5C1IhvOMuKnUOi+wnY5pgnMDwDodS9ClEOO0EmumFG38kLkEAINH8OMbgaGf0C9P4XaHn1ankGItTyC8TASgfE9GnEuzbOiZHAUOvaYE4cRfrqKa8Y0O9hDkKQw7Cta3PKYDEgbhY5SR2lZhukyvuQmjoF/cJTzCExB6HW74Mcfpr2Blb8PIzBl2i+uwERXHMSvoX30ODt5AgSva3MSyxzEFrTh/AvfZxuOpPoQezc3fRvNyCU23ZBWfYiIKqAnUIy+gGSw+1MVcEcRHD1cfgq1jteMPMr4n886BqEqDYgcOc3ELUmB3D8d8T+3MC0C2ULwhdCaO2PELXb6YZTf30PvbfVNQjyArXhbcjVWwGIFIAx9BrMS53MVMEUhFS5HlrTxxDkasBOwxz7CMbQK0xA+Jc8BjVyIDewkc4z0e2kIIvFFIRcsw1qfTsgBol+YQy1wxz/jAkI6jPrTkMMrvtPTJMpCDXyFuSaJ6l87dQk9L7nkJ76gRkIpyI94wxqGQPJ0f1IXjzEQhBs+4jrjZIMT4nzm5Ax+pmBkKo2Qms8BEFaRN/JMj2YKYI6+6rvIKoRp2JM/4R41yO50yqlfJJGyjYnkdF7Z9+Tlx7DSPRspX2K28UMBOkdtEgH4FtIChzM8U4YA7tdgdAa34VUtQHpKydo70CAaI3vwX/rFudSx7oGfWAPUpePueXALjXyytsNRkmNrohZ48ZotOYv4L/l0azCnPkkz5ALAC+VCBtFkP5hzQmIwbVZR58r2VJAXO85qYkvofc9j1yJ9i+GFe+COfYJveZzu5iAIAC0yH74FtwFCHLB6bIUELPl0oZ56SiM/p00Xrl2J6zYWaZjOhMQ/5wGGaOV2h3OSY1/mndI/xaEL9SCwMojEJQ6MmkhOXoQydE33R78TT/PFMR8uwy1/AwxsIo+UsysQC5ylNpnqcLs9FXofbuQvnL8/w8icMcxSIsfmg0ko9M2vOASREAM5K77iwHnlpBnivAv3QJ1xet5P+4UtXnSQUYPIznSUdTjpT7kGQhqctWtkMPbISrLAVGbf892GrZ5EcnxI578RuopiFJPy4vPcRBZyhwEB5GfcFwRXBFcEYV7OP7PbQ4X7hHcI7hHcI+Yr1XnHsE9gnsE9wjuEUVcaHCz5GaZL5O/Adf8pacTFVJYAAAAAElFTkSuQmCC" height="40"/></a>
<a href="https://gitee.com/892768447" target="_blank"  margin="5" style='margin:5px'><img src="https://portrait.gitee.com/uploads/avatars/user/24/74606_892768447_1578916388.png!avatar60" height="40"/></a>
<a href="https://gitee.com/fireinice" target="_blank"  margin="5" style='margin:5px'><img src="https://portrait.gitee.com/uploads/avatars/user/2457/7373699_fireinice_1585479305.png!avatar60" height="40"/></a>
<a href="https://gitee.com/houxinluo" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAABM0lEQVR4Xu2aMQrCQBQF3xIUxBOIJ1BB8BxCGi9jIwgewdY7WFtZWVjbCtY2NlYhxAi6CoElLgmJEMY6S8jzzex+jRksd6n4yBDEuwUEYWkgCILIipFG0Aga4TwsgAZogAZo5E0SOAJH4AgcgSM8fm9BlsgSWSLLv8lyFY40m/Rf97/eI823Jx0vNw91SeG4p8V0qG47UJyk2hwuWu/PXmuLXFSpLAnCfiUEQRBZOmkEjaARzh0LNEADNH6iUeS091nTqJMlQdhZI0lTRfFDvm+lGCN1WoGMxKzB0CWmz69KGMNtFARBENkNlkbQCBrhPHSCBmg0GI0yg1bdayv9X6PuhylzP4Kw6REEQWRBohE0gkY4NxfQAA3QAI28kyeOwBE4AkfgCI/5HFkiS2SJLPNU8QThDTljz/nugQAAAABJRU5ErkJggg==" height="40"/></a>
<a href="https://gitee.com/fzgandw" target="_blank"  margin="5" style='margin:5px'><img src="https://portrait.gitee.com/uploads/avatars/user/2661/7985556_fzgandw_1598515660.png!avatar60" height="40"/></a>
<a href="https://gitee.com/olxjdqj" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAABEklEQVR4Xu3YParCQBQG0Cu4BTcguDs38Jpn5WasFBSyigcPXIN9QPzHCJomEMKMRbQ41jMQvtzvOJnB7ndchV8MBPGaAkHUbRCEIJowmggTYSJaDwuqoRqqoRpdXxKMYAQjGMGIhPsWWMISlrD8CixH0yKGo8nzWQ5/iyhXPwmE9bekNywFUb9UQQii2W8TYSJMROt/nmqohmqoRteBmBGMYAQjGJFwbQBLWMISlrDMxLK6niLut4RdEdXlEGUxj9N2nbT+3UUfubzNedjqvI9yM4vj/zJnW/ZaQdSR9RZE9ivqeYMgTERz5EyEiTARrQyrhmqohmp0ndEYwQhGMIIRCV+ysIQlLGEJS1gmJFAveQCBfEScIengwAAAAABJRU5ErkJggg==" height="40"/></a>
<a href="https://gitee.com/wfifi" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,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" height="40"/></a>
<a href="https://gitee.com/BigBossQzz" target="_blank"  margin="5" style='margin:5px'><img src="https://portrait.gitee.com/uploads/avatars/user/1760/5280558_BigBossQzz_1598407750.png!avatar60" height="40"/></a>
<a href="https://gitee.com/gavinee" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,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" height="40"/></a>
<a href="https://gitee.com/wudenggang" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAAE0klEQVR4Xu2Zb2xTVRjGn9u1naUbXec22MZgCImIMYgOXIjbwj8nCSSAxoQPSDREQ6bRRE0kYsiCZh+URBINShYI8IEEUIyMGBEhIJpFR4AYEFAMbqx06+zWlXZ0/UfOHbeee7337pbe6/rh7bem99xzzvO+7+99zqlQ9/kfadAHAgkxlgUkxL1qICFICDkYKSMoIygjVM0ClQaVBpUGlYbeSYIYQYwgRhAjiBEG7lsIlgRLgiXBkmD5f8Fy6UNF2NxYAU+hDckUcOC3IezoHNCdvmGGG1uaKlDqKhCfi6fS2Ht+EF90BXXHNc8uxrsN5Shy2gyPMaCDOZe30z0OfLKiCjUehzjnmRsRvPXdLd35X60rxYb5XjhsQuY5I+PeqC/DusdKUGADgiNJfHC6Hz/+HTGyV91nTGuf25sr0VjrFie7MRTHhq+6EY1r/2XCPy+tsCcUx5vf+tAdimsumh93ZSCG9V/25CwCe4FpQvARHi9SfAYNx1JIpNJiiURGU/j45wA6roZVNzfJIWDv2umoLXGASXz0yjC2ne7PLyF4Towm09hzfhDt59TrfeXDxXh7UTncThuuD44iGE1iQbULqTRw+HIIH50NqG6On2MkkcannQM4eCmUX0KwaO1eU4NZXqe4sI5rYbSe6lNd5DtPl+P5uR4wPDAusFKQ6v5i3x1s/Pqm6rhNCx7E+sdLRK74wgls/v4WLgdi+SUEW82Hy6bimVlF4sL06rd99TTMm/JAhvp/BkczXac/ksDWk33o8o38Z4M8H9jvm472miKCqYxgL9v4ZClemu+Fs0BAXySBLSf8uOC/I1tsXZULrUumoMJtz1D/nC+aqf1YIo1dXUHsuzgoG8dn3HgldD/qmAZLNjnvDbRq+MV5XrxSV4pCuyDLGj7ax6/fxnsn/LL98O8eD6oTLgRbwP7najCnrFATfFL5KKnPdx0G0JeP9MjaL59tRtpstmKYmhFs8vebKrBqzmQwm/RL7whaOv6tYz69lRnDRzwUS6HtTD9++Ot2Zj88f4wYrwkXgk99ZeT49qdGfSmb1Gy69JtRKz7hQvAwVEaWt8fKbNHLpoXTXGhdPBVlkwpMtdW8WKaXBns53x73XxjCzl//Eef8bGU1Fla7NA9mLzzqwWv1ZXDZ5T5BC7DZRl3veUuEYCfRNY+McULqALytVmMAW+Tc8kK0La9EVbFdBOX2nwL45uqwjDtqHcUMQSwRgo8sM0vrDnVDaauVXUHajJQ1vFeQ+KDlMfJWCD6yA9Ektp7yo6m2KGOr9aLK2+/Om1HxjkIyYHquM1cxLMkItqidq6rBwClFsXGmW7TV2RzI2HH+8KUhtDw1xg29c0jeCiFFVhCAY9fCeKLSJdZ+Nkd09izLimdnF4v71DuZ5q0QPBN+D8Qwo8QJZqiMXKZIdpuZLn84jple57h3FXkrBN8lYsk07IIAm83YZYpkt9nm4kmIAlphqy33EcoOIH03epmivNhl41mJvH7Ml2vgNcdbBks2I+8k2fdsLlOklsnGGb0Zz0UlS4XgzxZskWq2Wmvx/OFNy4DlsnHlWEuFMHOhVr+LhLinMAlBQsiLjTKCMoIyQrUBUWlQaVBpUGnouVNiBDGCGEGMIEYYOMMTLAmWBEuCpR4q7gJAqTY8I+99qgAAAABJRU5ErkJggg==" height="40"/></a>
<a href="https://gitee.com/py2cn_admin" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAABOElEQVR4Xu2ZMQrCMBSGX2/i5uwFPIGjB9BzuHoCV++gm5O6OnZTEGcLnQQXwWoFDdJgDG+oScGva0Ob/vn/L695SXs2KIVLEoR4uQAhTBoQAiFsMOIIHIEjnMUC0SAaRINo+P4kYASMgBEwAkYozluAJbAElsCykbAcd4bSb3U/5na9FzLdL2SymysQV9+QaLBECLOIVSHyy0k2+fZ5pyhvsspSWWdpfcuteFIjHHE4H6W3HCmm+7shCBG7jqhGA0eYXQMhEEKEaDi2T6JBNIjGuyKCETDCLo9xBI7AEc5fRqJBNIgG0fCdJ8EIGAEjYASMUJy6A0tg+R2WdLpoAttHdVWv/F03XMHToEOi9T6DfqXiZQgRuwmsWKSgQ3AEjrANhyNwBI5wQphoEA2iQTR8FRqMMOo8ACOBabofxKKyAAAAAElFTkSuQmCC" height="40"/></a>
<a href="https://gitee.com/nwljy" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAACX0lEQVR4Xu2bz4vTQBiG30mbND+6UfGi4EFFEK8rsqAuKx7EP9M/QzytKMIiiuJJFPcoiKLbbdOkaTIyk7jt2rSpwuI68861Lc08fM/7fTOl4uujAwkuCIKoqoAgahsIgiCOByMrghXBimgcFqgG1aAaVGPVSYIZwYxgRjAjmBFr3LcwLBmWDEuG5T8Ly/hBBPdiR3+/zIHkVYr0/WSN6ALcCx30t0M4oQBKYPwuQ/ImW+uzf/OmEw3LeRDq4YofJQ53ExQHZeuzGg0CEsj2cwyfjS0H8QeKmF0RdR2so4ixIMpEwvEF4KiyALJPOYbPlytiLIj8cwHhAd3zdReZAMnr5V3EaBDphwn6Wz5ET2hJiu8lDp82dxGjQQyejBBt+fCve4BioRT5mGP4YlER40GILhA/jOYUkRi9TDWQ+WU8CLXZ3jUX0S0fwpspMthNUA5mg5YVIBSM/u1AA1mmiDUgnNhBfC9E55zqp4DMJIZ7KSb7lSLWgGhSZPqtwODxCHJqGQityN0AvaszRdTpdLSX2lURCkTnjIONnUVF5Lg08xiuJks1RzQtNVeEm6qLVK9OvxRI3mbo3wnMu49YBUIrsh2gd6VWpKwGLfdS1z4QWhHVRc7WXURfZMlq1jDphqqtItS2tSI3fQj3N4FsA7GgyC8eNoJQisT3Q6iB62jZCEIrcsNDtOkD3RqFrSDU9jd2AniX67D430G0XlWfojec6O8ap2ifrY9CEDUigiCI47awIlgRrIjGDkI1qAbVoBqrxktmBDOCGcGMYEa0HsL53/AjROwa7BrsGo2J8RPW2YlZzjPz/wAAAABJRU5ErkJggg==" height="40"/></a>
<a href="https://gitee.com/tangtang666" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAABHUlEQVR4Xu3YO4qEQBhF4b8TXYzL0NjFmAiGrkvBVbgVE2Ga7jERfMEg3QOfqWVRXM89VvmIiJ9wxUMQvxQIYmmDIASxFiMiEIGIzc2CaqiGaqjG0UmCIziCIziCIy78byFLsiRLsvyYLNu2jbquI0mSC7o6HtL3fRRF8ed59ia4VZaCWGJvmiaqqtol4kVKmqbv0fM8xzRNu298GIYoy/J/EnG26q7rIs/z97BxHCPLsrNHbrt/azXOVi2IJSFBCGJdFkQgAhGbHxDVUA3VUI2j3SVHcARHcARHnJ3BI4IsyZIsyZIsL8jym4Z89OetIL4pgWUtiBDEGktEIAIRm6pWDdVQDdU42sdxBEdwBEdwxIXTLlmSJVmS5ZEqnjhi2AGX5AhBAAAAAElFTkSuQmCC" height="40"/></a>
<a href="https://gitee.com/dechin" target="_blank"  margin="5" style='margin:5px'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEIAAABCCAYAAADjVADoAAAC0UlEQVR4Xu2YT0iTcRzGn70zKVthWVJzEVSrKPs7EoJEMoLw0KUunaNDlzoEHurSqUM3CyIQ6c8pqFskQbYKp1iWaeqWoo1NWzrX3NpwOLe98b66cLnGhv7eXtjzXt7D3r3s+9nzfN739zM0X2iVwQMGgphPAUEstIEgCCJTjEwEE8FEZH1ZYDVYDVaD1ci1kqAj6Ag6go6gI/LYb6EsKUvKkrL8b7JsuF4Dc3VFHqoCkvEU4rEEAu4wvtrH4Pk4mdf3VuoiobIsBETGQDLgHw2h67EL/pHQSs2a8z6agZCTMhLxZPZ+SgaUlBoBQ+bH0UAMjpZBjPdNCYehGYjQeBTPGtv/OdDajathra3CnpMWrNtc9gdK0BuB/W4vQt+jQmHoBkR6SgVI3eWDMO+rUGHIMjDa4cPbe33FBUKZtrzKhFNXj2CDxaQOHwvH8e7+F6EV0V0i0n/7obM7cPScFcZVkpoK1ysPOh86haVCtyDWbynDmcZjUM7KMTk8jec3u4oPhDLx6Ws2bLdVqsNHpmJ43fQZgW9hITB0mwhl2hMXq7G3fpsqzdnoHBwtA3C/nyg+ELbzViiukEokzMUS6HgwiBGHjyAIgolgNVQP1F46oL5yp1+q2pv74e3xF58jGm7UwLx/fhn/a2IGL293q2cRh24fn5W7ylF/5TBMm9aoc/sGfqL11gcRDNR76hbE4kdnKimj/4Ub3U+GigvE34suZV/CfqdX6CaN7hKxZBmekuFq8wpdcOmqGkoKdtdZsPP4Vigw0rtVQU8EbU09wiSZ7ppmici1VScZJRhLpSX9V54QnY+cQvchNAdRiOUUaD5nEJ+eDgv1wuLfpFkicoKQoW7szkzPqoMPvRnDD1ewEHbLvlYoiGX/Og1vQBALsAmCIDJ7x0QwEUxE1mcRq8FqsBqsRq4XVTqCjqAj6Ag6Io/lPGVJWVKWlCVlmYcsfwMrVQjz8fzYbAAAAABJRU5ErkJggg==" height="40"/></a>

## 📱 联系我们

作者：PyMiner Development Team

邮箱：aboutlong@qq.com

欢迎各位开发者大佬加入 


##  🚥 许可说明
本项目遵循GPL许可证。此外，对个人用户来说，本项目支持自由修改源码和使用，但是不支持任何未经授权许可的商用或其他盈利性行为，也不支持任何未经授权申请著作权的行为。如有违反以上许可，本项目管理团队有权进行否决。
许可解释权归属 PyMiner Development Team。

##  📸 预览截图

基本界面
![avatar](pyminer2/ui/source/screenshot/main.png)

查看变量
![avatar](pyminer2/ui/source/screenshot/check_data.png)

代码提示
![avatar](pyminer2/ui/source/screenshot/code.png)

