package com.publiccms.entities.trade;
// Generated 2021-6-26 22:14:06 by Hibernate Tools 6.0.0-SNAPSHOT

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

/**
 * TradeOrderProduct generated by hbm2java
 */
@Entity
@Table(name = "trade_order_product")
@DynamicUpdate
public class TradeOrderProduct implements java.io.Serializable {

    /**
    *
    */
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * order id<p>
     * 订单id
     */
    @GeneratorColumn(title = "订单", condition = true)
    private long orderId;
    /**
     * content id<p>
     * 内容id
     */
    @GeneratorColumn(title = "内容")
    private long contentId;
    /**
     * product id<p>
     * 产品id
     */
    @GeneratorColumn(title = "产品")
    private long productId;
    /**
     * price<p>
     * 价格
     */
    @GeneratorColumn(title = "价格")
    private BigDecimal price;
    /**
     * quantity<p>
     * 数量
     */
    @GeneratorColumn(title = "数量")
    private int quantity;
    /**
     * amount<p>
     * 金额
     */
    @GeneratorColumn(title = "金额")
    private BigDecimal amount;
    /**
     * remark<p>
     * 备注
     */
    @GeneratorColumn(title = "备注")
    private String remark;

    public TradeOrderProduct() {
    }

    public TradeOrderProduct(short siteId, long orderId, long contentId, long productId, BigDecimal price, int quantity,
            BigDecimal amount) {
        this.siteId = siteId;
        this.orderId = orderId;
        this.contentId = contentId;
        this.productId = productId;
        this.price = price;
        this.quantity = quantity;
        this.amount = amount;
    }

    public TradeOrderProduct(short siteId, long orderId, long contentId, long productId, BigDecimal price, int quantity,
            BigDecimal amount, String remark) {
        this.siteId = siteId;
        this.orderId = orderId;
        this.contentId = contentId;
        this.productId = productId;
        this.price = price;
        this.quantity = quantity;
        this.amount = amount;
        this.remark = remark;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)

    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "order_id", nullable = false)
    public long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    @Column(name = "content_id", nullable = false)
    public long getContentId() {
        return this.contentId;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    @Column(name = "product_id", nullable = false)
    public long getProductId() {
        return this.productId;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    @Column(name = "price", nullable = false, precision = 10)
    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @Column(name = "quantity", nullable = false)
    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Column(name = "amount", nullable = false, precision = 10)
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Column(name = "remark")
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
