package com.publiccms.entities.cms;
// Generated 2020-7-1 18:53:08 by Hibernate Tools 6.0.0-SNAPSHOT

import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.constraints.Length;

/**
 * CmsSurveyQuestion generated by hbm2java
 */
@Entity
@Table(name = "cms_survey_question")
@DynamicUpdate
public class CmsSurveyQuestion implements java.io.Serializable {

    /**
    *
    */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    /**
     * survey id<p>
     * 问卷id
     */
    @GeneratorColumn(title = "问卷", condition = true)
    private long surveyId;
    /**
     * title<p>
     * 标题
     */
    @GeneratorColumn(title = "标题")
    @NotBlank
    @Length(max = 100)
    private String title;
    /**
     * score<p>
     * 分数
     */
    @GeneratorColumn(title = "分数")
    private Integer score;
    /**
     * question type[radio,select,checkbox,text,file,picture]<p>
     * 问题类型[radio:单选,select:下拉选择,checkbox:复选框,text:文字,file:文件,picture:图片]
     */
    @GeneratorColumn(title = "问题类型", condition = true)
    private String questionType;
    /**
     * cover<p>
     * 图片
     */
    @GeneratorColumn(title = "图片")
    private String cover;
    /**
     * answer<p>
     * 答案
     */
    @GeneratorColumn(title = "答案")
    private String answer;
    /**
     * sort<p>
     * 排序
     */
    @GeneratorColumn(title = "排序", order = true)
    private int sort;

    public CmsSurveyQuestion() {
    }

    public CmsSurveyQuestion(long surveyId, String title, int sort) {
        this.surveyId = surveyId;
        this.title = title;
        this.sort = sort;
    }

    public CmsSurveyQuestion(long surveyId, String title, Integer score, String questionType, String cover, String answer,
            int sort) {
        this.surveyId = surveyId;
        this.title = title;
        this.score = score;
        this.questionType = questionType;
        this.cover = cover;
        this.answer = answer;
        this.sort = sort;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "survey_id", nullable = false)
    public long getSurveyId() {
        return this.surveyId;
    }

    public void setSurveyId(long surveyId) {
        this.surveyId = surveyId;
    }

    @Column(name = "title", nullable = false, length = 100)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "score")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    @Column(name = "question_type", nullable = false, length = 20)
    public String getQuestionType() {
        return this.questionType;
    }

    public void setQuestionType(String questionType) {
        this.questionType = questionType;
    }

    @Column(name = "cover")
    public String getCover() {
        return this.cover;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    @Column(name = "answer")
    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    @Column(name="sort", nullable=false)
    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

}
