package com.publiccms.entities.cms;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * CmsDictionary generated by hbm2java
 */
@Entity
@Table(name = "cms_dictionary")
@DynamicUpdate
public class CmsDictionary implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "ID")
    private CmsDictionaryId id;
    /**
     * name<p>
     * 名称
     */
    @GeneratorColumn(title = "名称")
    @NotNull
    @Length(max = 100)
    private String name;
    /**
     * child depth<p>
     * 子级深度
     */
    @GeneratorColumn(title = "子级深度")
    @Max(10)
    private int childDepth;

    public CmsDictionary() {
    }

    public CmsDictionary(CmsDictionaryId id, String name, int childDepth) {
        this.id = id;
        this.name = name;
        this.childDepth = childDepth;
    }

    @EmbeddedId
    @AttributeOverrides({ @AttributeOverride(name = "id", column = @Column(name = "id", nullable = false, length = 20)),
            @AttributeOverride(name = "siteId", column = @Column(name = "site_id", nullable = false)) })
    public CmsDictionaryId getId() {
        return this.id;
    }

    public void setId(CmsDictionaryId id) {
        this.id = id;
    }

    @Column(name = "name", nullable = false, length = 100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "child_depth", nullable = false)
    public int getChildDepth() {
        return this.childDepth;
    }

    public void setChildDepth(int childDepth) {
        this.childDepth = childDepth;
    }

}
