import type { Selector } from 'webdriverio';

import checkIfElementExists from '../lib/checkIfElementExists.js';

/**
 * Perform on click action on the given element
 * @param  {String}   action  The action to perform (click or doubleClick)
 * @param  {String}   type    Type of the element (link or selector)
 * @param  {String}   selector Element selector
 */
export default async (
  action: 'click' | 'doubleClick',
  type: 'link' | 'selector',
  selector: Selector
): Promise<void> => {
  /**
   * Element to perform the action on
   * @type {String}
   */
  const selector2 = type === 'link' ? `=${selector as string}` : selector;

  /**
   * The method to call on the browser object
   * @type {String}
   */
  const method = action === 'click' ? 'click' : 'doubleClick';

  await checkIfElementExists(selector2);

  await $(selector2)[method]();
};
