# Enhanced Blockchain-Based Decentralized Public Auditing for Cloud Storage

## Project Description
This project focuses on creating a privacy-preserving authentication protocol specifically designed for cloud storage. It aims to enhance data security by preventing unauthorized access and ensuring data confidentiality during both data access and sharing.

## Goal of the Project
**Purpose:** The main purpose is to secure sensitive data stored in the cloud and protect it from unauthorized access, thus guaranteeing data integrity and confidentiality.

## Problem Solved
This protocol addresses the issue of unauthorized access by implementing a decentralized auditing system that ensures data security and privacy. With this solution, data breaches and unauthorized access to sensitive information are minimized.

## Installation Instructions
### Clone the Repository
git clone https://github.com/Preethi0502/Enhanced-Blockchain-Based-Decentralized-Public-Auditing-for-Cloud-Storage.git
### Open in Microsoft Visual Studio
Navigate to the downloaded repository folder and open the solution (.sln) file in Microsoft Visual Studio.
### Database Setup in SQL Server
Open SQL Server Management Studio.
Use the SQL scripts provided in the repository (if you have scripts included) to set up the necessary tables, permissions, and other database requirements.
Ensure that SQL Server is configured to allow the application to connect to it.
## How to Run the Demo
### Configure the Database
Confirm that your SQL Server instance is running and that the database structure is set up based on the provided scripts.
### Run the Application
In Microsoft Visual Studio, open the solution and build the project.
Start the application by pressing F5 or selecting Run. This should launch the application locally.
### Simulate Access and Permissions
Follow any additional instructions in the project to create test users, initiate access requests, and test the dynamic permission management features.
## Technologies Used
**Blockchain:** for decentralized auditing and transaction records.
**Attribute-Based Access Control (ABAC):** for flexible access control.
**Proxy Re-Encryption:** to securely share encrypted data without exposing decryption keys.
### Tools:
**ASP.NET:** for the web application framework.
**Visual C#:** as the primary programming language.
**SQL Server:** for database management.
**Microsoft Visual Studio:** as the integrated development environment.
## Important Features and Impact
**Key Functionalities:**
Anonymous access requests.
Data integrity verification.
Dynamic permission management for data access and sharing.
**Outcomes:**
Enhanced security and reduced unauthorized access incidents.
Positive user feedback regarding ease of use and confidence in data security.
Reduction in data breaches, contributing to overall improved data protection.
