Please see [#158](https://github.com/orgs/Pokemon-PythonRed/discussions/158) for why this project is closing.

Thanks to everyone who was part of this.

---

<div align="center">

<h1>Pokémon PythonRed Version</h1>
<p>(a fangame)</p>
<hr>
<p>
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed"><img src="https://gpvc.arturio.dev/Pokemon-PythonRed"></a> <!--Views-->
  <!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
<a href='#contributors'><img src='https://img.shields.io/badge/contributors-27-brightgreen'></a>
<!-- ALL-CONTRIBUTORS-BADGE:END --> <!--Contributors-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/LICENSE"><img src="https://img.shields.io/github/license/Pokemon-PythonRed/Pokemon-PythonRed?color=brightgreen"></a> <!--License-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/issues"><img src="https://img.shields.io/github/issues/Pokemon-PythonRed/Pokemon-PythonRed"></a> <!--Issues-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/pulls"><img src="https://img.shields.io/github/issues-pr/Pokemon-PythonRed/Pokemon-PythonRed"></a> <!--Pulls-->
</p>
<p>
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/stargazers"><img src="https://img.shields.io/github/stars/Pokemon-PythonRed/Pokemon-PythonRed"/></a> <!--Stars-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/network/members"><img src="https://img.shields.io/github/forks/Pokemon-PythonRed/Pokemon-PythonRed"></a> <!--Forks-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed"><img src="https://img.shields.io/github/repo-size/Pokemon-PythonRed/Pokemon-PythonRed"></a> <!--Repo Size-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed"><img src="https://img.shields.io/tokei/lines/github/Pokemon-PythonRed/Pokemon-PythonRed"></a> <!--Lines-->
</p>
<p>
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/main.yml"><img src="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/main.yml/badge.svg?branch=master"></a> <!--Main-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/codeql-analysis.yml"><img src="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/codeql-analysis.yml/badge.svg?branch=master"></a> <!--CodeQL-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/open.yml"><img src="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/open.yml/badge.svg?branch=master"></a> <!--Open-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/close.yml"><img src="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/actions/workflows/close.yml/badge.svg?branch=master"></a> <!--Close-->
</p>
<p>
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/tags/latest"><img src="https://shields.io/github/v/tag/Pokemon-PythonRed/Pokemon-PythonRed?sort=semver&color=inactive"></a> <!--Latest-->
  <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/releases"><img src="https://shields.io/github/downloads/Pokemon-PythonRed/Pokemon-PythonRed/total?color=inactive"></a> <!--Downloads-->
</p>

---

<h6><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/discussions/59">Project Status Updates</a></h6>

</div>

---

## Summary & Important Notes

- This is a game written in Python 3 and based on the `Pokémon Red` game. However, it is not intended to be a perfect recreation; think of it as a remix.
- Prior in-depth knowledge of the Pokémon franchise, especially the video game series, is recommended and may be required to fully enjoy this game.
- This project ([@Pokemon-PythonRed](https://github.com/Pokemon-PythonRed "Pokémon PythonRed Homepage") and anything found within) is not endorsed by Nintendo, GAME FREAK, Creatures Inc., or The Pokémon Company. This is an independent, fan-made game.
- This game's plot is a work of fiction! Any references to real people or events are completely coincidental.
- Pokémon PythonRed is a work-in-progress and is intended to be a long-term project. The owners feel no rush to meet community deadlines or expectations. Please be considerate.
- Any problems with the game can be reported in [issues](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/issues "Pokémon PythonRed Issues").

---

## Community

If you or someone else has been offended or treated poorly by a member of our community, please submit a complaint.

For report options, please see [the Enforcement section of the Code of Conduct](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/CODE_OF_CONDUCT.md#enforcement).

---

## References

For more information on various topics regarding this project, please visit the following links:

- [Code Of Conduct](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/CODE_OF_CONDUCT.md "Pokémon PythonRed Code Of Conduct")
- [Contributing Guidelines](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/CONTRIBUTING.md "Pokémon PythonRed Contributing Guidelines")
- [Contributors List](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed#contributors "Pokémon PythonRed Contributors")
- ~~[Current Tasks](https://github.com/orgs/Pokemon-PythonRed/projects/1 "Pokémon PythonRed Current Tasks")~~ (closed)
- [Discussions](https://github.com/orgs/Pokemon-PythonRed/discussions "Pokémon PythonRed Discussions")
- [Installation Guide](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed#installation "Pokémon PythonRed Installation")
- [Issue Management](https://github.com/orgs/Pokemon-PythonRed/projects/2 "Pokémon PythonRed Issue Management")
- [License](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/LICENSE "Pokémon PythonRed License")
- [Project Status Updates](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/discussions/59)
- [Security Policy](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/SECURITY.md "Pokémon PythonRed Security Policy")

---

## Contributors

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors "All-Contributors Repository") specification ([emoji key](https://allcontributors.org/docs/en/emoji-key "All-Contributors Emoji Key"), [command issue](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/issues/13 "Pokémon PythonRed All-Contributors Command Issue")). [See what you can do to contribute](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/CONTRIBUTING.md "Pokémon PythonRed CONTRIBUTING.md").
<!--
Bot command template:
@all-contributors please add @<username> for <contributions>
-->
<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center"><a href="https://allcontributors.org"><img src="https://avatars.githubusercontent.com/u/46410174?v=4?s=100" width="100px;" alt="All Contributors"/><br /><sub><b>All Contributors</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=all-contributors" title="Documentation">📖</a></td>
      <td align="center"><a href="https://github.com/features/security"><img src="https://avatars.githubusercontent.com/u/27347476?v=4?s=100" width="100px;" alt="Dependabot"/><br /><sub><b>Dependabot</b></sub></a><br /><a href="#infra-dependabot" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center"><a href="https://github.com/DonJayamanne"><img src="https://avatars.githubusercontent.com/u/1948812?v=4?s=100" width="100px;" alt="Don Jayamanne"/><br /><sub><b>Don Jayamanne</b></sub></a><br /><a href="#tool-donjayamanne" title="Tools">🔧</a></td>
      <td align="center"><a href="https://github.com/features/actions"><img src="https://avatars.githubusercontent.com/u/44036562?v=4?s=100" width="100px;" alt="GitHub Actions"/><br /><sub><b>GitHub Actions</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=actions" title="Code">💻</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=actions" title="Documentation">📖</a> <a href="#infra-actions" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=actions" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://github.com/valensce"><img src="https://avatars.githubusercontent.com/u/85430198?v=4?s=100" width="100px;" alt="I'm special ;)"/><br /><sub><b>I'm special ;)</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=Specialist-Mathematics" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://github.com/valensce"><img src="https://avatars.githubusercontent.com/u/83048878?v=4?s=100" width="100px;" alt="Ikuto Tsukiyomi"/><br /><sub><b>Ikuto Tsukiyomi</b></sub></a><br /><a href="#design-Isabel-Lifu" title="Design">🎨</a> <a href="#ideas-Isabel-Lifu" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center"><a href="https://joeblownn.github.io"><img src="https://avatars.githubusercontent.com/u/101370883?v=4?s=100" width="100px;" alt="Joe"/><br /><sub><b>Joe</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=joeblownn" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://turnipguy30.github.io"><img src="https://avatars.githubusercontent.com/u/50542928?v=4?s=100" width="100px;" alt="JohnnySD"/><br /><sub><b>JohnnySD</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=TurnipGuy30" title="Code">💻</a> <a href="#data-TurnipGuy30" title="Data">🔣</a> <a href="#ideas-TurnipGuy30" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-TurnipGuy30" title="Maintenance">🚧</a> <a href="#platform-TurnipGuy30" title="Packaging/porting to new platform">📦</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=TurnipGuy30" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://github.com/JeremyLARDENOIS"><img src="https://avatars.githubusercontent.com/u/37746231?v=4?s=100" width="100px;" alt="Jérémy LARDENOIS"/><br /><sub><b>Jérémy LARDENOIS</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=jeremyLARDENOIS" title="Code">💻</a> <a href="#mentoring-jeremyLARDENOIS" title="Mentoring">🧑‍🏫</a> <a href="#platform-jeremyLARDENOIS" title="Packaging/porting to new platform">📦</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=jeremyLARDENOIS" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://opensource.microsoft.com"><img src="https://avatars.githubusercontent.com/u/6154722?v=4?s=100" width="100px;" alt="Microsoft"/><br /><sub><b>Microsoft</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=microsoft" title="Code">💻</a> <a href="#plugin-microsoft" title="Plugin/utility libraries">🔌</a> <a href="#tool-microsoft" title="Tools">🔧</a></td>
      <td align="center"><a href="https://github.com/ionutvmi"><img src="https://avatars.githubusercontent.com/u/3531898?v=4?s=100" width="100px;" alt="Mihai Ionut Vilcu"/><br /><sub><b>Mihai Ionut Vilcu</b></sub></a><br /><a href="#tool-ionutvmi" title="Tools">🔧</a></td>
      <td align="center"><a href="https://nandovieira.com"><img src="https://avatars.githubusercontent.com/u/3009?v=4?s=100" width="100px;" alt="Nando Vieira"/><br /><sub><b>Nando Vieira</b></sub></a><br /><a href="#tool-fnando" title="Tools">🔧</a></td>
      <td align="center"><a href="https://github.com/nasserkessas"><img src="https://avatars.githubusercontent.com/u/59720679?v=4?s=100" width="100px;" alt="Nasser Kessas"/><br /><sub><b>Nasser Kessas</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=nasserkessas" title="Code">💻</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=nasserkessas" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://github.com/NilsJPWerner"><img src="https://avatars.githubusercontent.com/u/10968348?v=4?s=100" width="100px;" alt="Nils Werner"/><br /><sub><b>Nils Werner</b></sub></a><br /><a href="#tool-nilsjpwerner" title="Tools">🔧</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://discord.com/invite/xzsAKZVfxP"><img src="https://avatars.githubusercontent.com/u/87019852?v=4?s=100" width="100px;" alt="Porsce <3"/><br /><sub><b>Porsce <3</b></sub></a><br /><a href="#design-Porsce" title="Design">🎨</a></td>
      <td align="center"><a href="https://ravanger101.github.io/"><img src="https://avatars.githubusercontent.com/u/86346730?v=4?s=100" width="100px;" alt="Ravanger_101"/><br /><sub><b>Ravanger_101</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=Ravanger101" title="Code">💻</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=Ravanger101" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://www.linkedin.com/in/richard-st-germaine-a62642182/"><img src="https://avatars.githubusercontent.com/u/97212886?v=4?s=100" width="100px;" alt="Richard St Germaine"/><br /><sub><b>Richard St Germaine</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=stger040" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://github.com/MuLKy-bot"><img src="https://avatars.githubusercontent.com/u/84059778?v=4?s=100" width="100px;" alt="Sam"/><br /><sub><b>Sam</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=MuLKy-bot" title="Tests">⚠️</a></td>
      <td align="center"><a href="http://shanalikhan.github.io"><img src="https://avatars.githubusercontent.com/u/8774556?v=4?s=100" width="100px;" alt="Shan Khan"/><br /><sub><b>Shan Khan</b></sub></a><br /><a href="#plugin-shanalikhan" title="Plugin/utility libraries">🔌</a> <a href="#tool-shanalikhan" title="Tools">🔧</a></td>
      <td align="center"><a href="https://sourcery.ai"><img src="https://avatars.githubusercontent.com/u/36609879?v=4?s=100" width="100px;" alt="Sourcery"/><br /><sub><b>Sourcery</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=sourcery-ai" title="Code">💻</a></td>
      <td align="center"><a href="https://trunk.io"><img src="https://avatars.githubusercontent.com/u/74779146?v=4?s=100" width="100px;" alt="Trunk"/><br /><sub><b>Trunk</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=trunk-io" title="Code">💻</a> <a href="#tool-trunk-io" title="Tools">🔧</a></td>
    </tr>
    <tr>
      <td align="center"><a href="https://discord.gg/xzsAKZVfxP"><img src="https://avatars.githubusercontent.com/u/79883837?v=4?s=100" width="100px;" alt="Val=fλ"/><br /><sub><b>Val=fλ</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=Valensce" title="Code">💻</a> <a href="#design-Valensce" title="Design">🎨</a> <a href="#ideas-Valensce" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-Valensce" title="Maintenance">🚧</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=Valensce" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://www.youtube.com/channel/UCkmpUFuS0qBFD1I37o4yA3w"><img src="https://avatars.githubusercontent.com/u/86031610?v=4?s=100" width="100px;" alt="Valerie"/><br /><sub><b>Valerie</b></sub></a><br /><a href="#design-Valerimatical" title="Design">🎨</a></td>
      <td align="center"><a href="https://github.com/cweijan"><img src="https://avatars.githubusercontent.com/u/27798227?v=4?s=100" width="100px;" alt="WeiJian Chen "/><br /><sub><b>WeiJian Chen </b></sub></a><br /><a href="#plugin-cweijan" title="Plugin/utility libraries">🔌</a></td>
      <td align="center"><a href="https://github.com/basedpainnn"><img src="https://avatars.githubusercontent.com/u/93128221?v=4?s=100" width="100px;" alt="basedpainnn"/><br /><sub><b>basedpainnn</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=basedpainnn" title="Tests">⚠️</a></td>
      <td align="center"><a href="https://apple.com/"><img src="https://avatars.githubusercontent.com/u/81336967?v=4?s=100" width="100px;" alt="hacking-mudkip"/><br /><sub><b>hacking-mudkip</b></sub></a><br /><a href="#data-hacking-mudkip" title="Data">🔣</a> <a href="#ideas-hacking-mudkip" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center"><a href="http://jbloves27.repl.co"><img src="https://avatars.githubusercontent.com/u/76911308?v=4?s=100" width="100px;" alt="just a weeb"/><br /><sub><b>just a weeb</b></sub></a><br /><a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=JBYT27" title="Code">💻</a> <a href="#infra-JBYT27" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="#mentoring-JBYT27" title="Mentoring">🧑‍🏫</a> <a href="https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/commits?author=JBYT27" title="Tests">⚠️</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

---

## Installation

### Startup

- To play the game, you will need:
  - Windows or Linux OS
  - Python 3 (aka CPython 3.x)
- Follow [this link](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/archive/refs/heads/master.zip) to download a `.zip` file of this repository. Once it downloads, unzip and open it.
- You will need to open a command line in the folder, then run the following command to install dependencies:

```sh
python -m pip install -r requirements.txt
```

- Finally, open `main.py` in the `app` folder.

- If you encounter any problems when opening the game, feel free to [create an issue](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/issues/new "Pokémon PythonRed Issues").

  - If you want to contribute to the project, please see [the Contributing Guidelines](https://github.com/Pokemon-PythonRed/Pokemon-PythonRed/blob/master/CONTRIBUTING.md).

### Controls

- When `>` is shown, press <kbd>⏎ Enter</kbd> to continue. You may need to input text first.
- When text bullets are shown, you need to enter the character next to the option you choose.
- In the overworld, navigation bullets are <kbd>WASD</kbd> for directional movement, then lettered for interactions. Other commands might also be available.
  - Enter the <kbd>M</kbd> command from the overworld to open the menu.
- When `Y/N` is shown, you can enter <kbd>Y</kbd> or <kbd>N</kbd> for "yes" or "no" respectively.
- When reading through next normally, you can press any key to proceed.

#### Examples

No text needed, just press <kbd>⏎ Enter</kbd>:

```console
Press Enter to continue.

>_
```

Type text from a bullet point (e.g. <kbd>1</kbd> or <kbd>2</kbd>), then press <kbd>⏎ Enter</kbd>:

```console
Choose an option.

[1] - Save
[2] - Quit

>_
```

Type any variant of `yes`, `y`, `no`, or `n`, then press <kbd>⏎ Enter</kbd>:

```console
Would you like to save? Y/N

>_
```

Press any key:

```console
OAK: Hello there! Welcome to the world of POKéMON!
_
```

---

## Extras

Here's some extra information that isn't required to play the game, but might still be interesting.

<details><summary>Technicalities</summary>

---

### Technicalities

Since this is a Python game, some elements will have to be changed from the original version. Here are some examples of challenging changes.

#### Save data and saving

The game has to keep track of the many variables that make up a Save File. These include:

- Trainer info
- Party / Box info
- If a place has been visited, for Fly locations (each city separately)
- If cutscenes have been triggered
- Event flags
- Pokédex
- Game mechanic settings for accessibility

These are stored in a Python `dictionary` variable, which is then saved to the external file `.ppr-save` via Python's `json` module.

#### Game data

Not to be confused with save data, game data is composed of the numbers and calculations that the game uses. These include:

- Pokémon info
- Trainer battle info
- Save file templates

Large sets of data may be stored as `.json` files in the project folder. This is done to keep the program files concise. These files may be added, removed, or changed at any time.

Save file templates contain all the things the game must keep track of between sessions. On each save or load, the player's file is automatically updated with the latest data, in case an update was performed. This means that when the game is updated, the player can copy their `.ppr-save` file into the new version, and the save file will automatically be updated with the latest data.

#### Menus

Pokémon Red is full of menus that look like the following:

```
Would you like to save your progress?
> Save
  Don't Save
```

This has been changed to be more suitable for a text-adventure game:

```console
Would you like to save your progress? Y/N

>_
```

This is done with code similar to the following:

```python
import json
save = {
  # Save Data
}
print('Would you like to save your progress? Y/N')
  saveOption = ' '
  while saveOption.lower()[0] not in ['y', 'n']:
    saveOption = input('>') + ' '
  if saveOption.lower()[0] in ['y']:
    open('.ppr-save', 'w').write(json.dumps(save))
    print('Game saved successfully!')
```

#### Save management

The user can use multiple save files by moving or backing up their `.ppr-save` file to a different directory on their device. This has been implemented in the interest of user-friendliness and safety. Save files can easily be backed up, reset, or shared.

---

</details>

<details><summary>Mystery Gifts</summary>

---

### Mystery Gifts

Pokémon games use Mystery Gifts to bring communities together and incentivise players to take part in events, and Pokémon PythonRed is no different. Codes can be given out in planned giveaway events to specific people, left online to be found by anyone, or even given in-person to specific people. Most of them are online, so you should try looking in places [@TurnipGuy30](https://github.com/TurnipGuy30) has been.

#### Technical information

As of the time of writing, Mystery Gifts have not yet been implemented into the game. The base game will have to be completed first. For now, keep track of any codes you find.

#### Formatting

Pokémon PythonRed Mystery Gift codes are easy to identify because they will always be given in the following format:

```
Pokémon PythonRed Mystery Gift #20: "POKEMONPYTHONRED"
```

(Yes, this is a valid code. Consider it a free trial. You're welcome.)

#### Possible rewards

Redeemed codes will reward a player with in-game items or Pokémon.

#### Recipient responsibilities

Any person or group who finds or receives a code has no responsibility to keep it to themselves unless otherwise stated by the giver of the code.

#### Summary

Mystery Gifts are meant to unite the community and provide a fun way to interact with the game.

---

</details>
