import random
from direct.directnotify import DirectNotifyGlobal
from pirates.quest.QuestDNA import QuestDNA
from pirates.quest.QuestTaskDNA import *
from pirates.quest.QuestPrereq import *
from pirates.quest.QuestReward import *
from pirates.quest.QuestConstants import QuestItems
from pirates.quest.QuestConstants import PropIds, NPCIds
from pirates.quest.QuestConstants import Bribes, PokerPots, ExpRewards
from pirates.quest.QuestConstants import Probability, Attempts, DoubleRepTime
from pirates.battle import EnemyGlobals
from pirates.ship import ShipGlobals
from pirates.pirate import AvatarTypes
from pirates.pirate.AvatarType import AvatarType
from pirates.tutorial import TutorialGlobals
from pirates.piratesbase import PiratesGlobals
from pirates.ai import HolidayGlobals
from pirates.makeapirate import JewelryGlobals, TattooGlobals, ClothingGlobals
from pirates.economy.EconomyGlobals import ItemId
from pirates.world.LocationConstants import LocationIds
INSTANCE_REF_TYPE_AREA = 0
INSTANCE_REF_TYPE_OBJECT = 1
AUTO_TRIGGER_OBJ_EXISTS = 0
QuestDict = {'Chapter1.rung1': QuestDNA(obsolete=False, questInt=1000, finalizeInfo=({'type': 'cutscene','sceneId': '1.1.1: Jail Break','sendEvent': 'doneJackIntro'}, {'type': 'cutscene','sceneId': '1.1.2: Jail Break (continued)','waitEvent': 'makeAPirateComplete'}), combineOp=QuestDNA.OR, droppable=False, playStinger=False, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_GOT_SEACHEST, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'Chapter1.rung3': QuestDNA(obsolete=False, questInt=1002, tasks=(VisitTaskDNA(goalLocation=LocationIds.RAMBLESHACK_DOCK, npcId=TutorialGlobals.STUMPY_BOAT_UID),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), finalizeInfo=({'type': 'cutscene','sceneId': "1.2: Beck's Boat",'giverId': 'tutorial_stumpy','altInteractiveId': TutorialGlobals.STUMPY_BOAT_UID}, {'type': 'cutscene','sceneId': '1.3: Jolly Roger','giverId': 'tutorial_stumpy','waitEvent': 'tutorialJROnStage'}), combineOp=QuestDNA.OR, droppable=False, playStinger=False, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_MET_JOLLY_ROGER, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2_visit_will_turner': QuestDNA(obsolete=False, questInt=2000, tasks=(VisitTaskDNA(autoTriggerInfo=(AUTO_TRIGGER_OBJ_EXISTS, [NPCIds.WILL_TURNER]), goalLocation=LocationIds.RAMBLESHACK_DOCK, npcId=NPCIds.WILL_TURNER),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), finalizeInfo=({'type': 'cutscene','sceneId': '2.1: Will Turner Sword','preloadInfo': ['2.1.b: Sword Tut end'],'giverId': NPCIds.WILL_TURNER}, {'type': 'dialog','sceneId': 'quest_tut_blacksmith_intro_100_v2','giverId': NPCIds.WILL_TURNER}, {'type': 'cutscene','sceneId': '2.1.b: Sword Tut end','giverId': NPCIds.WILL_TURNER}), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_GOT_CUTLASS, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2.2defeatSkeletons': QuestDNA(obsolete=False, questInt=2001, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ALL, goalLocation=LocationIds.PORT_ROYAL_GRAVEYARD, enemyType=AvatarTypes.WillBurybones, num=3, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_KILLED_1_SKELETON, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2_visit_tia_dalma': QuestDNA(obsolete=False, questInt=2002, tasks=(VisitTaskDNA(autoTriggerInfo=(AUTO_TRIGGER_OBJ_EXISTS, [NPCIds.TIA_DALMA_PR]), npcId=NPCIds.TIA_DALMA_PR),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), finalizeInfo=({'type': 'cutscene','sceneId': '2.2: Tia Dalma Compass','giverId': NPCIds.TIA_DALMA_PR,'waitEvent': 'leaveTunnelDone'}, {'type': 'dialog','sceneId': 'quest_tut_tia_dalma_compass_intro_100','giverId': NPCIds.TIA_DALMA_PR}, {'type': 'dialog','sceneId': 'quest_tut_tia_dalma_compass_finish','giverId': NPCIds.TIA_DALMA_PR}), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.TIA_DALMA_PR), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_GOT_COMPASS, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2.4recoverOrders': QuestDNA(obsolete=False, questInt=2003, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, goalLocation=LocationIds.GOVERNORS_MANSION_COURTYARD, item=QuestItems.ReleaseOrders, num=1, enemyType=AvatarTypes.Cadet, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2.5deliverOrders': QuestDNA(obsolete=False, questInt=2004, tasks=(DeliverItemTaskDNA(location=LocationIds.GOVERNORS_MANSION, autoTriggerInfo=(AUTO_TRIGGER_OBJ_EXISTS, [NPCIds.ELIZABETH]), item=QuestItems.ReleaseOrders, num=1, npcId=NPCIds.ELIZABETH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), finalizeInfo={'type': 'cutscene','sceneId': '2.3: Elizabeth Swan ','giverId': NPCIds.ELIZABETH}, returnGiverIds=(NPCIds.ELIZABETH,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2.9visitDarby': QuestDNA(obsolete=False, questInt=2008, tasks=(VisitTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, npcId=NPCIds.DARBY_DRYDOCK),), rewards=(ShipReward(amount=1), ReputationReward(amount=ExpRewards.TRIVIAL)), finalizeInfo=({'type': 'dialog','sceneId': 'quest_tut_darby_ship1','giverId': NPCIds.DARBY_DRYDOCK}, {'type': 'dialog','sceneId': 'quest_tut_darby_ship2','giverId': NPCIds.DARBY_DRYDOCK,'waitEvent': 'tutorialShipConstructed'}), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_GOT_SHIP, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2.10visitDockworker': QuestDNA(obsolete=False, questInt=2009, tasks=(DeployShipTaskDNA(location=LocationIds.PORT_ROYAL_ALL, goalLocation=LocationIds.PORT_ROYAL_DINGHY),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c2.11visitBarbossa': QuestDNA(obsolete=False, questInt=2010, tasks=(VisitTaskDNA(location=LocationIds.ANVIL_CAVE_BARBOSA, autoTriggerInfo=(AUTO_TRIGGER_OBJ_EXISTS, [NPCIds.BARBOSSA]), npcId=NPCIds.BARBOSSA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), finalizeInfo=({'type': 'cutscene','sceneId': '2.4: Capt Barbossa Intro','preloadInfo': ['2.4.b: Capt Barbossa Pistol Finish'],'giverId': NPCIds.BARBOSSA}, {'type': 'dialog','sceneId': 'quest_tut_barbossa_pistol_tutorial','giverId': NPCIds.BARBOSSA}, {'type': 'cutscene','sceneId': '2.4.b: Capt Barbossa Pistol Finish','giverId': NPCIds.BARBOSSA}, {'type': 'dialog','sceneId': 'quest_tut_barbossa_lookout_tutorial','giverId': NPCIds.BARBOSSA}), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.BARBOSSA), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_GOT_PISTOL, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3visitJack': QuestDNA(obsolete=False, questInt=3000, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, autoTriggerInfo=(AUTO_TRIGGER_OBJ_EXISTS, [NPCIds.JACK, NPCIds.CARVER]), npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), finalizeInfo={'type': 'cutscene','sceneId': '2.5: Jack Sparrow in Bar','giverId': NPCIds.JACK}, instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, checkPoint=PiratesGlobals.TUT_CHAPTER3_STARTED, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3visitJoshamee': QuestDNA(obsolete=False, questInt=3001, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2.5.5visitOrinda': QuestDNA(obsolete=False, questInt=3350, tasks=(VisitTaskDNA(npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2.5captureMontrose': QuestDNA(obsolete=False, questInt=3351, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_MONTROSE, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_WARSHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JOSHAMEE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2.6visitCarver': QuestDNA(obsolete=False, questInt=3352, tasks=(VisitTaskDNA(npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2.7deliverPint': QuestDNA(obsolete=False, questInt=3353, tasks=(DeliverItemTaskDNA(item=QuestItems.Pint, num=1, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOSHAMEE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3.4captureMontrose': QuestDNA(obsolete=False, questInt=3752, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_MONTROSE, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_COLOSSUS, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3.5maroonMontrose': QuestDNA(obsolete=False, questInt=3753, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_MONTROSE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3.6deliverMap': QuestDNA(obsolete=False, questInt=3754, tasks=(DeliverItemTaskDNA(item=QuestItems.Map, num=1, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.LARGE), TreasureMapReward(amount=1)), returnGiverIds=(NPCIds.JOSHAMEE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3.7recoverPearl': QuestDNA(obsolete=False, questInt=3755, tasks=(BossBattleTaskDNA(treasureMapId=PiratesGlobals.GAME_STYLE_TM_BLACK_PEARL),), rewards=(ReputationReward(amount=ExpRewards.HUGE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3.8visitJack': QuestDNA(obsolete=False, questInt=3756, tasks=(VisitTaskDNA(npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.HUGE), MainStoryReward()), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=True, finalQuest=True, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r1.1sinkNavyShips': QuestDNA(obsolete=False, questInt=3003, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_FERRET, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r1.2defeatNavyGuards': QuestDNA(obsolete=False, questInt=3004, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_JUNGLE_C, enemyType=AvatarTypes.Cadet, num=4, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.1visitScarlet': QuestDNA(obsolete=False, questInt=3006, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.6.5bribeBonita': QuestDNA(obsolete=False, questInt=3011, questLink='c3r2r1r1.Tattoo', tasks=(VisitTaskDNA(location=LocationIds.BONITAS_TATTOOS, npcId=NPCIds.BONITA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.7visitCarver': QuestDNA(obsolete=False, questInt=3015, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.8recoverFlag': QuestDNA(obsolete=False, questInt=3016, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Flag, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.9captureSteadman': QuestDNA(obsolete=False, questInt=3017, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_STEADMAN, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_SEA_VIPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.10maroonSteadman': QuestDNA(obsolete=False, questInt=3018, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_STEADMAN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.11stealList': QuestDNA(obsolete=False, questInt=3019, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.TRADING_COMPANY, containerId=PropIds.T_EITC_DESK, item=QuestItems.List, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.12recoverWarrants': QuestDNA(obsolete=False, questInt=3020, tasks=(RecoverShipItemTaskDNA(item=QuestItems.ArrestWarrant, num=4, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_BULWARK, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.13visitGrog': QuestDNA(obsolete=False, questInt=3025, tasks=(VisitTaskDNA(location=LocationIds.DOCTOR_GROGS, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r1.1recoverClaw': QuestDNA(obsolete=False, questInt=3012, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneDust, num=2, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r1.2recoverRod': QuestDNA(obsolete=False, questInt=3013, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CopperRod, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r1.3recoverBlood': QuestDNA(obsolete=False, questInt=3014, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=3, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r2.1Carrou': QuestDNA(obsolete=False, questInt=3021, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.JEHAN_CARROU, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r2.2DArcis': QuestDNA(obsolete=False, questInt=3022, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Handkerchief, num=1, enemyType=AvatarTypes.Sergeant, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r2.3Coteau': QuestDNA(obsolete=False, questInt=3023, tasks=(VisitTaskDNA(npcId=NPCIds.MALLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r3.1Guano': QuestDNA(obsolete=False, questInt=3026, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatGuano, num=6, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r3.2Hair': QuestDNA(obsolete=False, questInt=3027, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hair, num=4, enemyType=AvatarTypes.Undead, level=4, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r3.3Blood': QuestDNA(obsolete=False, questInt=3028, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=4, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r1.1tattoo': QuestDNA(obsolete=False, questInt=4920, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_C, item=QuestItems.BoneDust, num=4, enemyType=AvatarTypes.Sludge, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r1.2tattoo': QuestDNA(obsolete=False, questInt=4921, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_C, item=QuestItems.Blood, num=6, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r2.1ArcisHenchmen': QuestDNA(obsolete=False, questInt=4980, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_CAVE, enemyType=AvatarTypes.Guard, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r2.2ClaudeDArcis': QuestDNA(obsolete=False, questInt=4981, tasks=(DefeatNPCTaskDNA(location=LocationIds.TORTUGA_CAVE, npcId=NPCIds.CLAUDE_DARCIS),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r3.1tattooRemoval': QuestDNA(obsolete=False, questInt=4923, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_A_GRAVEYARD, item=QuestItems.LiverVial, num=10, enemyType=AvatarTypes.MireKnife, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1r3.2tattooRemoval': QuestDNA(obsolete=False, questInt=4924, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_A_GRAVEYARD, item=QuestItems.HairPatch, num=8, enemyType=AvatarTypes.Mire, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.8recoverFlags': QuestDNA(obsolete=False, questInt=4922, questLink='c3r2r1.9captureSteadman', tasks=(RecoverShipItemTaskDNA(item=QuestItems.Flag, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_BULWARK, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.BernardBrothers': QuestDNA(obsolete=False, questInt=4982, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_SEA_VIPER, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.14deliverRemedy': QuestDNA(obsolete=False, questInt=19770, tasks=(DeliverItemTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, item=QuestItems.Remedy, num=1, npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.14.5stealWarrant': QuestDNA(obsolete=False, questInt=19771, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.EITC_OUTPOST, containerId=PropIds.T_OUTPOST_DESK, item=QuestItems.ArrestWarrant, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.CARVER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=True, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r1.15visitJoshamee': QuestDNA(obsolete=False, questInt=19772, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8.4recoverPig': QuestDNA(obsolete=False, questInt=3072, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Pig, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5.1visitLucinda': QuestDNA(obsolete=False, questInt=3073, questLink='c3r2r2r8r5.NecklaceMaterials', tasks=(VisitTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, npcId=NPCIds.LUCINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5.1.5bribeLucinda': QuestDNA(obsolete=False, questInt=3074, tasks=(BribeNPCTaskDNA(npcId=NPCIds.LUCINDA, gold=Bribes.MEDIUM, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5.3deliverNecklace': QuestDNA(obsolete=False, questInt=3078, tasks=(DeliverItemTaskDNA(location=LocationIds.JUNEGREER_RESIDENCE, item=QuestItems.Necklace, num=1, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5r2.1recoverTeeth': QuestDNA(obsolete=False, questInt=3075, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tooth, num=7, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5r2.2recoverTeeth': QuestDNA(obsolete=False, questInt=3076, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tooth, num=7, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5.1necklaceMaterials': QuestDNA(obsolete=False, questInt=4933, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_B, item=QuestItems.Tooth, num=4, enemyType=AvatarTypes.MuckCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5.2necklaceMaterials': QuestDNA(obsolete=False, questInt=4934, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_B, item=QuestItems.GourdShaker, num=4, enemyType=AvatarTypes.Muck, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5.3necklaceMaterials': QuestDNA(obsolete=False, questInt=4935, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_B, item=QuestItems.BileSack, num=8, enemyType=AvatarTypes.RabidBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r4.4recoverClaw': QuestDNA(obsolete=False, questInt=3087, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrabClaw, num=10, enemyType=AvatarTypes.Crab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r4.5recoverMud': QuestDNA(obsolete=False, questInt=3088, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Mud, num=1, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.1visitGreer': QuestDNA(obsolete=False, questInt=3079, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.2visitMallet': QuestDNA(obsolete=False, questInt=3080, tasks=(VisitTaskDNA(npcId=NPCIds.MALLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.3visitFabiola': QuestDNA(obsolete=False, questInt=3081, tasks=(VisitTaskDNA(npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.3.5bribeFabiola': QuestDNA(obsolete=False, questInt=3082, tasks=(BribeNPCTaskDNA(npcId=NPCIds.FABIOLA, gold=Bribes.MEDIUM, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.8deliverDoll': QuestDNA(obsolete=False, questInt=3094, tasks=(DeliverItemTaskDNA(item=QuestItems.Doll, num=1, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r4.1recoverWings': QuestDNA(obsolete=False, questInt=3083, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WaspWings, num=5, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r4.2recoverScales': QuestDNA(obsolete=False, questInt=3084, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorScales, num=8, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r4.3recoverPoison': QuestDNA(obsolete=False, questInt=3085, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Poison, num=8, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5r3.1recoverSpecial': QuestDNA(obsolete=False, questInt=4936, tasks=(RecoverShipItemTaskDNA(item=QuestItems.JunesItem, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_CORVETTE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r5r3.2recoverSpecial': QuestDNA(obsolete=False, questInt=4937, tasks=(RecoverShipItemTaskDNA(item=QuestItems.LoveLetter, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_PANTHER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r3.1curseCure': QuestDNA(obsolete=False, questInt=4940, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_C, item=QuestItems.Stinger, num=6, enemyType=AvatarTypes.KillerWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ANGEL_OBONNEY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r3.2curseCure': QuestDNA(obsolete=False, questInt=4941, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_C, item=QuestItems.GallBladder, num=6, enemyType=AvatarTypes.DireScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ANGEL_OBONNEY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6r3.3curseCure': QuestDNA(obsolete=False, questInt=4942, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_C, enemyType=AvatarTypes.VampireBat, num=3, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ANGEL_OBONNEY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.1visitStormhawk': QuestDNA(obsolete=False, questInt=4938, tasks=(VisitTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, npcId=NPCIds.EDWARD_STORMHAWK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.2visitAngel': QuestDNA(obsolete=False, questInt=4939, tasks=(VisitTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, npcId=NPCIds.ANGEL_OBONNEY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.4deliverCure': QuestDNA(obsolete=False, questInt=4943, tasks=(DeliverItemTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, item=QuestItems.Cure, num=1, npcId=NPCIds.EDWARD_STORMHAWK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_STORMHAWK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r6.5deliverDoll': QuestDNA(obsolete=False, questInt=4944, tasks=(DeliverItemTaskDNA(location=LocationIds.JUNEGREER_RESIDENCE, item=QuestItems.Doll, num=1, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8.1visitGreer': QuestDNA(obsolete=False, questInt=3096, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8.2visitOrinda': QuestDNA(obsolete=False, questInt=3097, tasks=(VisitTaskDNA(npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8.5deliverParrot': QuestDNA(obsolete=False, questInt=3103, tasks=(DeliverItemTaskDNA(item=QuestItems.Parrot, num=1, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8r4.1recoverHoneyShips': QuestDNA(obsolete=False, questInt=3099, tasks=(RecoverShipItemTaskDNA(item=QuestItems.HoneyBarrel, num=10, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8r4r2.2bribeMarsh': QuestDNA(obsolete=False, questInt=3101, tasks=(BribeNPCTaskDNA(npcId=NPCIds.BEN_FLATTS, gold=Bribes.LARGE, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8r4r2.3deliverHoney': QuestDNA(obsolete=False, questInt=3102, tasks=(DeliverItemTaskDNA(item=QuestItems.HoneyBarrel, num=10, npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8.1recoverJewelry': QuestDNA(obsolete=False, questInt=4946, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, item=QuestItems.Earring, num=4, enemyType=AvatarTypes.Thug, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CASSANDRA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8.2recoverJewelry': QuestDNA(obsolete=False, questInt=4947, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, item=QuestItems.Ring, num=4, enemyType=AvatarTypes.Sergeant, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CASSANDRA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8.2recoverHoney': QuestDNA(obsolete=False, questInt=4945, tasks=(RecoverShipItemTaskDNA(item=QuestItems.HoneyBarrel, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_GREYHOUND, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CASSANDRA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r8.1visitCassandra': QuestDNA(obsolete=False, questInt=4983, tasks=(VisitTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, npcId=NPCIds.CASSANDRA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r9.1visitGreer': QuestDNA(obsolete=False, questInt=3104, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r9.2recoverDice': QuestDNA(obsolete=False, questInt=3105, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.ANY_PORT_ROYAL_JUNGLE, item=QuestItems.Dice, num=6, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GORDON_GREER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r9.3deliverDice': QuestDNA(obsolete=False, questInt=3106, tasks=(DeliverItemTaskDNA(item=QuestItems.Dice, num=6, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r11.1visitGreer': QuestDNA(obsolete=False, questInt=3107, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r11.2visitCassandra': QuestDNA(obsolete=False, questInt=3108, tasks=(VisitTaskDNA(npcId=NPCIds.CASSANDRA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r11.3recoverEarrings': QuestDNA(obsolete=False, questInt=3109, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Earring, num=2, enemyType=AvatarTypes.TradingCo, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CASSANDRA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r11.4deliverDress': QuestDNA(obsolete=False, questInt=3110, tasks=(DeliverItemTaskDNA(item=QuestItems.Dress, num=1, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.1visitGreer': QuestDNA(obsolete=False, questInt=3050, tasks=(VisitTaskDNA(location=LocationIds.FORT_CHARLES, npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.2visitBingham': QuestDNA(obsolete=False, questInt=3051, tasks=(VisitTaskDNA(location=LocationIds.FORT_CHARLES, npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.2.5bribeBingham': QuestDNA(obsolete=False, questInt=3052, tasks=(BribeNPCTaskDNA(npcId=NPCIds.BINGHAM, gold=Bribes.SMALL, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.3recoverRum': QuestDNA(obsolete=False, questInt=3053, questLink='c3r2r2.5visitGreer', tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=2, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.4blackjack': QuestDNA(obsolete=False, questInt=3054, tasks=(BlackjackTaskDNA(gold=PokerPots.MINOR),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.5visitGreer': QuestDNA(obsolete=False, questInt=3055, tasks=(VisitTaskDNA(location=LocationIds.FORT_CHARLES, npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.6visitBlakeley': QuestDNA(obsolete=False, questInt=3056, tasks=(VisitTaskDNA(location=LocationIds.BLAKELEYS_RESIDENCE, npcId=NPCIds.BLAKELEY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.7visitJune': QuestDNA(obsolete=False, questInt=3057, tasks=(VisitTaskDNA(location=LocationIds.JUNEGREER_RESIDENCE, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.9deliverList': QuestDNA(obsolete=False, questInt=3111, tasks=(DeliverItemTaskDNA(location=LocationIds.FORT_CHARLES, item=QuestItems.List, num=1, npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GORDON_GREER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.10.5visitJune': QuestDNA(obsolete=False, questInt=3133, tasks=(VisitTaskDNA(location=LocationIds.JUNEGREER_RESIDENCE, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.10.51visitBlakeley': QuestDNA(obsolete=False, questInt=3134, tasks=(VisitTaskDNA(location=LocationIds.BLAKELEYS_RESIDENCE, npcId=NPCIds.BLAKELEY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.10.52disruptRitual': QuestDNA(obsolete=False, questInt=3135, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_B, enemyType=AvatarTypes.Undead, num=8, level=12),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.BLAKELEY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.10.53visitGreer': QuestDNA(obsolete=False, questInt=3136, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.11visitJoshamee': QuestDNA(obsolete=False, questInt=3137, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r1.1visitSmitty': QuestDNA(obsolete=False, questInt=3058, tasks=(VisitTaskDNA(location=LocationIds.SMITTYS_JEWELRY, npcId=NPCIds.JEWELER_SMITTY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r1.3deliverRing': QuestDNA(obsolete=False, questInt=3062, tasks=(DeliverItemTaskDNA(item=QuestItems.GlassRing, num=1, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r1r2.1recoverTin': QuestDNA(obsolete=False, questInt=3059, tasks=(RecoverShipItemTaskDNA(item=QuestItems.TinShipment, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r1r2.2recoverSand': QuestDNA(obsolete=False, questInt=3060, tasks=(RecoverShipItemTaskDNA(item=QuestItems.SandShipment, num=2, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r1.1ringMaterials': QuestDNA(obsolete=False, questInt=4927, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, item=QuestItems.Ore, num=10, enemyType=AvatarTypes.Marine, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r1.2ringMaterials': QuestDNA(obsolete=False, questInt=4929, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, containerId=PropIds.RC_BARRELS, item=QuestItems.SandShipment, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r2.1visitCraven': QuestDNA(obsolete=False, questInt=3063, tasks=(VisitTaskDNA(npcId=NPCIds.BASTIEN_CRAVEN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r2.1.5bribeCraven': QuestDNA(obsolete=False, questInt=3064, tasks=(BribeNPCTaskDNA(npcId=NPCIds.BASTIEN_CRAVEN, gold=Bribes.MEDIUM, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r2.2sinkShips': QuestDNA(obsolete=False, questInt=3065, tasks=(DefeatShipTaskDNA(num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BASTIEN_CRAVEN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r2.3sinkNavyShips': QuestDNA(obsolete=False, questInt=3066, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=2, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BASTIEN_CRAVEN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r2.4deliverPlates': QuestDNA(obsolete=False, questInt=3067, tasks=(DeliverItemTaskDNA(item=QuestItems.WoodenPlates, num=8, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r3.1recoverChickens': QuestDNA(obsolete=False, questInt=3068, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.PR_CRATES, item=QuestItems.Chicken, num=6, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r3.2recoverChickens': QuestDNA(obsolete=False, questInt=3069, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chicken, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r3.3deliverEggs': QuestDNA(obsolete=False, questInt=3070, tasks=(DeliverItemTaskDNA(item=QuestItems.Egg, num=12, npcId=NPCIds.BLAKELEY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BLAKELEY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r3.4visitJune': QuestDNA(obsolete=False, questInt=3071, tasks=(VisitTaskDNA(location=LocationIds.JUNEGREER_RESIDENCE, npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r3.1chickenCrates': QuestDNA(obsolete=False, questInt=4930, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, containerId=PropIds.PR_CRATES, item=QuestItems.Chicken, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r8r3.2recoverChicken': QuestDNA(obsolete=False, questInt=4932, questLink='c3r2r2r8r3.3deliverEggs', tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chicken, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JUNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r1.1visitBowdash': QuestDNA(obsolete=False, questInt=3112, tasks=(VisitTaskDNA(npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r1.2sinkShips': QuestDNA(obsolete=False, questInt=3113, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=4, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r1.3visitGreer': QuestDNA(obsolete=False, questInt=3114, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2.1visitGrog': QuestDNA(obsolete=False, questInt=3115, tasks=(VisitTaskDNA(location=LocationIds.DOCTOR_GROGS, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2.3recoverRum': QuestDNA(obsolete=False, questInt=3120, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RumBottle, num=3, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2.4visitGreer': QuestDNA(obsolete=False, questInt=3121, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2r2.1recoverWaspEggs': QuestDNA(obsolete=False, questInt=3116, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WaspEggs, num=4, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2r2.2recoverCrabBile': QuestDNA(obsolete=False, questInt=3117, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bile, num=8, enemyType=AvatarTypes.Crab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2r2.3recoverSaliva': QuestDNA(obsolete=False, questInt=3118, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorSaliva, num=9, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.1visitOrinda': QuestDNA(obsolete=False, questInt=3122, tasks=(VisitTaskDNA(location=LocationIds.TORTUGA_ISLAND, npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.2captureAlthea': QuestDNA(obsolete=False, questInt=3123, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.ALTHEA, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.3maroonAlthea': QuestDNA(obsolete=False, questInt=3124, questLink='c3r2r2r10r3.6deliverBracelet', tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.ALTHEA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.4visitFlatts': QuestDNA(obsolete=False, questInt=3125, tasks=(VisitTaskDNA(npcId=NPCIds.BEN_FLATTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.5smuggleRum': QuestDNA(obsolete=False, questInt=3126, tasks=(SmuggleItemTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, item=QuestItems.RumBarrel, num=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.6deliverBracelet': QuestDNA(obsolete=False, questInt=3127, questLink='c3r2r2r10r4Lucinda', tasks=(DeliverItemTaskDNA(location=LocationIds.TORTUGA_ISLAND, item=QuestItems.Bracelet, num=1, npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.7visitGreer': QuestDNA(obsolete=False, questInt=3800, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r3.2captureAltheaNew': QuestDNA(obsolete=False, questInt=4954, questLink='c3r2r2r10r3.3maroonAlthea', tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.ALTHEA, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_GREYHOUND, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.1visitLucinda': QuestDNA(obsolete=False, questInt=3128, tasks=(VisitTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, npcId=NPCIds.LUCINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.2visitDaisy': QuestDNA(obsolete=False, questInt=3129, tasks=(VisitTaskDNA(npcId=NPCIds.DAISY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.3recoverNeedles': QuestDNA(obsolete=False, questInt=3130, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Needle, num=4, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DAISY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.4visitLucinda': QuestDNA(obsolete=False, questInt=3131, tasks=(VisitTaskDNA(npcId=NPCIds.LUCINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.5visitGreer': QuestDNA(obsolete=False, questInt=3132, tasks=(VisitTaskDNA(npcId=NPCIds.GORDON_GREER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.1stolenVoodoo': QuestDNA(obsolete=False, questInt=4955, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.FORT_CHARLES, item=QuestItems.Sugar, num=5, enemyType=AvatarTypes.Stalker, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.2stolenVoodoo': QuestDNA(obsolete=False, questInt=4956, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.FORT_CHARLES, item=QuestItems.GunpowderPouch, num=5, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.3stolenVoodoo': QuestDNA(obsolete=False, questInt=4957, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.FORT_CHARLES, containerId=PropIds.FC_SHELF, item=QuestItems.EmptyRumBottle, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r4.3recoverRareItem': QuestDNA(obsolete=False, questInt=4958, questLink='c3r2r2.10.5visitJune', tasks=(RecoverShipItemTaskDNA(item=QuestItems.SaltedRib, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_PHANTOM, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r1.1visitWilliam': QuestDNA(obsolete=False, questInt=4948, tasks=(VisitTaskDNA(location=LocationIds.ROWDYROOSTER_TAVERN, npcId=NPCIds.WILLIAM_TURK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r1.2sinkNavyShips': QuestDNA(obsolete=False, questInt=4950, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=8, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2r2.1remedy': QuestDNA(obsolete=False, questInt=4951, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, item=QuestItems.EyeSocket, num=8, enemyType=AvatarTypes.Corpse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2r2.2remedy': QuestDNA(obsolete=False, questInt=4952, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, item=QuestItems.Toenail, num=8, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2.3plunderRum': QuestDNA(obsolete=False, questInt=4953, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FineRum, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_VANGUARD, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r10r2.1visitDocGrog': QuestDNA(obsolete=False, questInt=4984, tasks=(VisitTaskDNA(location=LocationIds.DOCTOR_GROGS, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r1.1recoverRum': QuestDNA(obsolete=False, questInt=4925, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_BULWARK, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2r1.2recoverRum': QuestDNA(obsolete=False, questInt=4926, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FineRum, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_PANTHER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.10.1disruptRitual': QuestDNA(obsolete=False, questInt=4959, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_B, enemyType=AvatarTypes.Corpse, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BLAKELEY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r2.10.2disruptRitual': QuestDNA(obsolete=False, questInt=4960, tasks=(DefeatNPCTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_B, npcId=NPCIds.GENERAL_BLOODLESS),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.BLAKELEY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1.4recoverNavy': QuestDNA(obsolete=False, questInt=3161, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.EngravedPearl, num=2, enemyType=AvatarTypes.Navy, level=5, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.1visitOrinda': QuestDNA(obsolete=False, questInt=3162, tasks=(VisitTaskDNA(npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.2visitFlatts': QuestDNA(obsolete=False, questInt=3163, tasks=(VisitTaskDNA(location=LocationIds.FLATTS_WEAPONS, npcId=NPCIds.BEN_FLATTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.3sinkNavyShips': QuestDNA(obsolete=False, questInt=3164, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=5, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.4recoverArm': QuestDNA(obsolete=False, questInt=3165, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, item=QuestItems.PearlSack, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.5visitFabiola': QuestDNA(obsolete=False, questInt=3166, tasks=(VisitTaskDNA(location=LocationIds.TORTUGA_ISLAND, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.7deliverCutts': QuestDNA(obsolete=False, questInt=3171, tasks=(DeliverItemTaskDNA(location=LocationIds.TORTUGA_ISLAND, item=QuestItems.EngravedPearl, num=5, npcId=NPCIds.HENDRY_CUTTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5r6.1GatorSaliva': QuestDNA(obsolete=False, questInt=3167, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorSaliva, num=6, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5r6.2WaspVenom': QuestDNA(obsolete=False, questInt=3168, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Venom, num=8, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5r6.3ScorpionBlood': QuestDNA(obsolete=False, questInt=3169, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=10, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.3sinkShips': QuestDNA(obsolete=False, questInt=4967, questLink='c3r2r3r1r5.4recoverArm', tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=6, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.1curseRemoval': QuestDNA(obsolete=False, questInt=4969, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.GatorSaliva, num=4, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.2curseRemoval': QuestDNA(obsolete=False, questInt=4970, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.VenomSack, num=1, enemyType=AvatarTypes.RancidFlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r5.3curseRemoval': QuestDNA(obsolete=False, questInt=4971, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.Blood, num=6, enemyType=AvatarTypes.Corpse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r6.1visitCarver': QuestDNA(obsolete=False, questInt=3172, tasks=(VisitTaskDNA(npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r6.2visitFabiola': QuestDNA(obsolete=False, questInt=3173, tasks=(VisitTaskDNA(location=LocationIds.TORTUGA_ISLAND, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r6.3recoverSkeletonShips': QuestDNA(obsolete=False, questInt=3174, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedWood, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r6.4deliverCutts': QuestDNA(obsolete=False, questInt=3175, tasks=(DeliverItemTaskDNA(location=LocationIds.TORTUGA_ISLAND, item=QuestItems.EngravedPearl, num=2, npcId=NPCIds.HENDRY_CUTTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r6.3phantomShips': QuestDNA(obsolete=False, questInt=4972, questLink='c3r2r3r1r6.4deliverCutts', tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedWood, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_PHANTOM, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1.4pearlsOnNavy': QuestDNA(obsolete=False, questInt=4966, questLink='c3r2r3r1r5Smuggler', tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.FORT_CHARLES, item=QuestItems.EngravedPearl, num=5, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.1visitScarlet': QuestDNA(obsolete=False, questInt=3138, tasks=(VisitTaskDNA(npcId=NPCIds.SCARLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.2recoverEffects': QuestDNA(obsolete=False, questInt=3139, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.PersonalEffects, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.3visitMillie': QuestDNA(obsolete=False, questInt=3140, tasks=(VisitTaskDNA(location=LocationIds.MILLIES_COTTAGE, npcId=NPCIds.MILLIE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.4visitCutts': QuestDNA(obsolete=False, questInt=3153, tasks=(VisitTaskDNA(location=LocationIds.TORTUGA_ISLAND, npcId=NPCIds.HENDRY_CUTTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.8visitJack': QuestDNA(obsolete=False, questInt=3181, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.9recoverPapers': QuestDNA(obsolete=False, questInt=3182, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Document, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_WARSHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.10deliverJack': QuestDNA(obsolete=False, questInt=3183, tasks=(DeliverItemTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, item=QuestItems.Document, num=1, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.11deliverPearl': QuestDNA(obsolete=False, questInt=3184, tasks=(DeliverItemTaskDNA(location=LocationIds.TORTUGA_ISLAND, item=QuestItems.EngravedPearl, num=1, npcId=NPCIds.HENDRY_CUTTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.12deliverMillie': QuestDNA(obsolete=False, questInt=3185, questLink='c3r2r3.14visitJoshamee', tasks=(DeliverItemTaskDNA(location=LocationIds.MILLIES_COTTAGE, item=QuestItems.Necklace, num=1, npcId=NPCIds.MILLIE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MILLIE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.13visitCutts': QuestDNA(obsolete=False, questInt=3186, tasks=(VisitTaskDNA(npcId=NPCIds.HENDRY_CUTTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.14visitJoshamee': QuestDNA(obsolete=False, questInt=3187, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1.1RecoverSkeletons': QuestDNA(obsolete=False, questInt=3154, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EngravedPearl, num=2, enemyType=AvatarTypes.Undead, level=7, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1.3recoverShips': QuestDNA(obsolete=False, questInt=3160, tasks=(RecoverShipItemTaskDNA(item=QuestItems.EngravedPearl, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r2.1visitBowdash': QuestDNA(obsolete=False, questInt=3155, tasks=(VisitTaskDNA(location=LocationIds.KINGSARM_TAVERN, npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r2.2poker': QuestDNA(obsolete=False, questInt=3156, tasks=(PokerTaskDNA(gold=PokerPots.SMALL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r2.3poker': QuestDNA(obsolete=False, questInt=3157, tasks=(PokerTaskDNA(gold=PokerPots.MEDIUM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r2.4poker': QuestDNA(obsolete=False, questInt=3158, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r2.5deliverCutts': QuestDNA(obsolete=False, questInt=3159, tasks=(DeliverItemTaskDNA(location=LocationIds.TORTUGA_ISLAND, item=QuestItems.EngravedPearl, num=2, npcId=NPCIds.HENDRY_CUTTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r2.1sinkShips': QuestDNA(obsolete=False, questInt=4963, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_CORVETTE, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r2.2sinkShips': QuestDNA(obsolete=False, questInt=4964, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_SENTINEL, num=2, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1.1recoverPearls': QuestDNA(obsolete=False, questInt=4961, questLink='c3r2r3r1r2Cufflinks', tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, item=QuestItems.EngravedPearl, num=4, enemyType=AvatarTypes.Corpse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1.3pearlsOnShips': QuestDNA(obsolete=False, questInt=4965, questLink='c3r2r3r1Pearls2', tasks=(RecoverShipItemTaskDNA(item=QuestItems.EngravedPearl, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BLOODHOUND, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r7.1visitMallet': QuestDNA(obsolete=False, questInt=3176, tasks=(VisitTaskDNA(location=LocationIds.TORTUGA_JUNGLE_A_GRAVEYARD, npcId=NPCIds.MALLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r7.2deliverFabiola': QuestDNA(obsolete=False, questInt=3177, tasks=(DeliverItemTaskDNA(item=QuestItems.Map, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r7.3recoverEffects': QuestDNA(obsolete=False, questInt=3178, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.PersonalEffects, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r7.4recoverCrabs': QuestDNA(obsolete=False, questInt=3179, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EngravedPearl, num=2, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r7.5deliverCutts': QuestDNA(obsolete=False, questInt=3180, tasks=(DeliverItemTaskDNA(location=LocationIds.TORTUGA_ISLAND, item=QuestItems.PearlSack, num=1, npcId=NPCIds.HENDRY_CUTTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.HENDRY_CUTTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r7.1albertosRemains': QuestDNA(obsolete=False, questInt=4974, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.RUMRUNNER_ISLE, item=QuestItems.PearlSack, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MALLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3r1r7.2albertosRemains': QuestDNA(obsolete=False, questInt=4975, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.RUMRUNNER_ISLE, item=QuestItems.EngravedPearl, num=5, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MALLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.1navyDocument': QuestDNA(obsolete=False, questInt=4977, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_VANGUARD, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r3.2navyDocument': QuestDNA(obsolete=False, questInt=4978, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Document, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_CENTURION, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.1visitCarver': QuestDNA(obsolete=False, questInt=3200, tasks=(VisitTaskDNA(npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.2bribeCarver': QuestDNA(obsolete=False, questInt=3201, tasks=(BribeNPCTaskDNA(npcId=NPCIds.CARVER, gold=Bribes.MEDIUM, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.3visitNill': QuestDNA(obsolete=False, questInt=3202, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.NILL_OFFRILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.4blackjack': QuestDNA(obsolete=False, questInt=3203, questLink='c3r2r4r6Creditors', tasks=(BlackjackTaskDNA(gold=PokerPots.MINOR),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NILL_OFFRILL,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.5poker': QuestDNA(obsolete=False, questInt=3204, tasks=(PokerTaskDNA(gold=PokerPots.MEDIUM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NILL_OFFRILL,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.7visitNill': QuestDNA(obsolete=False, questInt=3242, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.NILL_OFFRILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.9visitJohn': QuestDNA(obsolete=False, questInt=3256, tasks=(VisitTaskDNA(npcId=NPCIds.BRONZE_JOHN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.10deliverDice': QuestDNA(obsolete=False, questInt=3257, tasks=(DeliverItemTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, item=QuestItems.DicePair, num=1, npcId=NPCIds.NILL_OFFRILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NILL_OFFRILL,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.11poker': QuestDNA(obsolete=False, questInt=3258, tasks=(PokerTaskDNA(gold=PokerPots.AVERAGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NILL_OFFRILL,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.12visitJoshamee': QuestDNA(obsolete=False, questInt=3259, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.9visitBastien': QuestDNA(obsolete=False, questInt=3809, tasks=(VisitTaskDNA(location=LocationIds.RUMRUNNER_ISLE, npcId=NPCIds.BASTIEN_CRAVEN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.1bastiensRequest': QuestDNA(obsolete=False, questInt=3811, tasks=(DefeatTaskDNA(location=LocationIds.RUMRUNNER_ALL, enemyType=AvatarTypes.KillerWasp, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BASTIEN_CRAVEN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.2bastiensRequest': QuestDNA(obsolete=False, questInt=3812, tasks=(DefeatTaskDNA(location=LocationIds.RUMRUNNER_ALL, enemyType=AvatarTypes.DreadScorpion, num=3, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BASTIEN_CRAVEN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4.3bastiensRequest': QuestDNA(obsolete=False, questInt=3813, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.RUMRUNNER_CELLAR, containerId=PropIds.RR_CELLAR_CRATE, item=QuestItems.TenYearRum, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BASTIEN_CRAVEN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.1visitGrog': QuestDNA(obsolete=False, questInt=3205, tasks=(VisitTaskDNA(location=LocationIds.DOCTOR_GROGS, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.3bribeCarver': QuestDNA(obsolete=False, questInt=3207, tasks=(BribeNPCTaskDNA(npcId=NPCIds.CARVER, gold=Bribes.SMALL, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.4deliverMedicine': QuestDNA(obsolete=False, questInt=3208, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=1, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.8deliverJar': QuestDNA(obsolete=False, questInt=3212, tasks=(DeliverItemTaskDNA(item=QuestItems.Jar, num=1, npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.10visitGrog': QuestDNA(obsolete=False, questInt=3214, tasks=(VisitTaskDNA(npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.11recoverCrabs': QuestDNA(obsolete=False, questInt=3215, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bile, num=15, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.18recoverBile': QuestDNA(obsolete=False, questInt=3222, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bile, num=10, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.21recoverChest': QuestDNA(obsolete=False, questInt=3225, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.22visitNill': QuestDNA(obsolete=False, questInt=3260, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.NILL_OFFRILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.1grogsRequest': QuestDNA(obsolete=False, questInt=3802, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, item=QuestItems.Bile, num=8, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.2grogsRequest': QuestDNA(obsolete=False, questInt=3803, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, item=QuestItems.Bile, num=12, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r1.3grogsRequest': QuestDNA(obsolete=False, questInt=3804, questLink='c3r2r4r6r1.22visitNill', tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_VANGUARD, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.1visitBowdash': QuestDNA(obsolete=False, questInt=3226, tasks=(VisitTaskDNA(location=LocationIds.KINGSARM_TAVERN, npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.2recoverFlags': QuestDNA(obsolete=False, questInt=3227, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Flag, num=8, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.3captureBillington': QuestDNA(obsolete=False, questInt=3228, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_BILLINGTON, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_CENTURION, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.4maroonBillington': QuestDNA(obsolete=False, questInt=3229, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_BILLINGTON),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.5deliverScepter': QuestDNA(obsolete=False, questInt=3230, tasks=(DeliverItemTaskDNA(location=LocationIds.KINGSARM_TAVERN, item=QuestItems.HookArm, num=1, npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.11recoverKey': QuestDNA(obsolete=False, questInt=3236, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.Key, num=1, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.14recoverDiamond': QuestDNA(obsolete=False, questInt=3239, questLink='c3r2r4.7visitNill', tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.Diamond, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.15stealCigars': QuestDNA(obsolete=False, questInt=3240, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.BOWDASH_CABINET, item=QuestItems.CigarBox, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r6r2.16recoverChest': QuestDNA(obsolete=False, questInt=3241, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.ISLA_CANGREJOS, item=QuestItems.Chest, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.1visitBenedek': QuestDNA(obsolete=False, questInt=3243, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.BENEDEK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.2captureWallace': QuestDNA(obsolete=False, questInt=3244, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.WALLACE, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BLOODHOUND, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.3maroonWallace': QuestDNA(obsolete=False, questInt=3245, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.WALLACE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.4deliverMoney': QuestDNA(obsolete=False, questInt=3246, tasks=(DeliverItemTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, item=QuestItems.CoinBag, num=1, npcId=NPCIds.BENEDEK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.5recoverRum': QuestDNA(obsolete=False, questInt=3247, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBottle, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.6visitMarsh': QuestDNA(obsolete=False, questInt=3248, tasks=(VisitTaskDNA(npcId=NPCIds.GRAHAM_MARSH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.7sinkNavyShips': QuestDNA(obsolete=False, questInt=3249, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, num=7, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GRAHAM_MARSH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.8visitFlatts': QuestDNA(obsolete=False, questInt=3250, tasks=(VisitTaskDNA(npcId=NPCIds.BEN_FLATTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.9poker': QuestDNA(obsolete=False, questInt=3251, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.10deliverMoney': QuestDNA(obsolete=False, questInt=3252, tasks=(DeliverItemTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, item=QuestItems.CoinBag, num=1, npcId=NPCIds.BENEDEK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.11captureOHenry': QuestDNA(obsolete=False, questInt=3253, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.OHENRY, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_PHANTOM, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.12recoverChain': QuestDNA(obsolete=False, questInt=3254, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.GoldChain, num=1, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.13visitNill': QuestDNA(obsolete=False, questInt=3255, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.NILL_OFFRILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.5recoverBottles': QuestDNA(obsolete=False, questInt=3805, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, item=QuestItems.RumBottle, num=3, enemyType=AvatarTypes.CorpseCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.6visitBenFlatts': QuestDNA(obsolete=False, questInt=3806, tasks=(VisitTaskDNA(location=LocationIds.FLATTS_WEAPONS, npcId=NPCIds.BEN_FLATTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.7sinkShips': QuestDNA(obsolete=False, questInt=3807, questLink='c3r2r4r8.10deliverMoney', tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, num=7, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r4r8.12recoverBling': QuestDNA(obsolete=False, questInt=3808, questLink='c3r2r4r8.13visitNill', tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.GoldChain, num=5, enemyType=AvatarTypes.RancidFlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.4recoverGuano': QuestDNA(obsolete=False, questInt=3308, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatGuano, num=10, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.5recoverSplinter': QuestDNA(obsolete=False, questInt=3309, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Splinter, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.6recoverDust': QuestDNA(obsolete=False, questInt=3310, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Dust, num=10, enemyType=AvatarTypes.Undead, level=7, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.7recoverEarth': QuestDNA(obsolete=False, questInt=3312, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Earth, num=2, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.8recoverLichens': QuestDNA(obsolete=False, questInt=3313, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Earth, num=1, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.9recoverWater': QuestDNA(obsolete=False, questInt=3314, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BattleSaltWater, num=4, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_CORVETTE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.10recoverEggs': QuestDNA(obsolete=False, questInt=3316, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScorpionEgg, num=20, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.11recoverMoney': QuestDNA(obsolete=False, questInt=3317, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BloodyTreasure, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.12recoverNightshade': QuestDNA(obsolete=False, questInt=3318, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Nightshade, num=4, enemyType=AvatarTypes.Corpse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.13recoverWhiskers': QuestDNA(obsolete=False, questInt=3319, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Whisker, num=10, enemyType=AvatarTypes.Sergeant, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.1visitGrog': QuestDNA(obsolete=False, questInt=3300, tasks=(VisitTaskDNA(location=LocationIds.DOCTOR_GROGS, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.3deliverJack': QuestDNA(obsolete=False, questInt=3321, tasks=(DeliverItemTaskDNA(item=QuestItems.List, num=1, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.4recoverEyes': QuestDNA(obsolete=False, questInt=3322, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Eye, num=4, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.5deliverJack': QuestDNA(obsolete=False, questInt=3323, tasks=(DeliverItemTaskDNA(item=QuestItems.Eye, num=4, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.6deliverEyes': QuestDNA(obsolete=False, questInt=3324, questLink='c3r2r5.10administerRemedy', tasks=(DeliverItemTaskDNA(location=LocationIds.DOCTOR_GROGS, item=QuestItems.Eye, num=4, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.7deliverMallet': QuestDNA(obsolete=False, questInt=3325, tasks=(DeliverItemTaskDNA(item=QuestItems.Remedy, num=1, npcId=NPCIds.MALLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MALLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.8bribeMallet': QuestDNA(obsolete=False, questInt=3326, tasks=(BribeNPCTaskDNA(npcId=NPCIds.MALLET, gold=Bribes.LARGE, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.9deliverRemedy': QuestDNA(obsolete=False, questInt=3327, tasks=(DeliverItemTaskDNA(item=QuestItems.Remedy, num=1, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.10administerRemedy': QuestDNA(obsolete=False, questInt=3328, tasks=(DeliverItemTaskDNA(location=LocationIds.DOCTOR_GROGS, item=QuestItems.Remedy, num=1, npcId=NPCIds.LE_CERDO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LE_CERDO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.11visitJoshamee': QuestDNA(obsolete=False, questInt=3329, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.2krakenEyes': QuestDNA(obsolete=False, questInt=3814, tasks=(RecoverShipItemTaskDNA(item=QuestItems.KrakenEye, num=8, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r3.1grogsMedicineA': QuestDNA(obsolete=False, questInt=3816, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_ALL, item=QuestItems.Hair, num=20, enemyType=AvatarTypes.Corpse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r3.2grogsMedicineA': QuestDNA(obsolete=False, questInt=3817, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_ALL, item=QuestItems.GatorSaliva, num=20, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r4.1grogsMedicineB': QuestDNA(obsolete=False, questInt=3819, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DRIFTWOOD_ISLAND, item=QuestItems.Stinger, num=14, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r4.2grogsMedicineB': QuestDNA(obsolete=False, questInt=3820, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DRIFTWOOD_ISLAND, item=QuestItems.Bile, num=14, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r5.1grogsMedicineC': QuestDNA(obsolete=False, questInt=3822, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.BoneDust, num=10, enemyType=AvatarTypes.CorpseCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r5.2grogsMedicineC': QuestDNA(obsolete=False, questInt=3823, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.CrocWater, num=8, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r5.3grogsMedicineC': QuestDNA(obsolete=False, questInt=3824, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_SWAMP, item=QuestItems.Venom, num=8, enemyType=AvatarTypes.RancidFlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.6recoverShips': QuestDNA(obsolete=False, questInt=3825, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_IRONWALL, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r7.1grogsMedicineD': QuestDNA(obsolete=False, questInt=3827, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.ISLA_CANGREJOS, item=QuestItems.Egg, num=20, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r7.2grogsMedicineD': QuestDNA(obsolete=False, questInt=3828, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.ISLA_CANGREJOS, item=QuestItems.Bile, num=1, enemyType=AvatarTypes.ClawChief, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r7.3grogsMedicineD': QuestDNA(obsolete=False, questInt=3829, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Splinter, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_PHANTOM, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5.8visitJack': QuestDNA(obsolete=False, questInt=3830, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r9.1undeadJob': QuestDNA(obsolete=False, questInt=3832, tasks=(DefeatTaskDNA(location=LocationIds.CUTTHROAT_ALL, enemyType=AvatarTypes.CorpseCutlass, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r9.2undeadJob': QuestDNA(obsolete=False, questInt=3833, tasks=(DefeatTaskDNA(location=LocationIds.CUTTHROAT_ALL, enemyType=AvatarTypes.SpanishUndeadA, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r9.3undeadJob': QuestDNA(obsolete=False, questInt=3834, tasks=(DefeatTaskDNA(location=LocationIds.CUTTHROAT_ALL, enemyType=AvatarTypes.SpanishUndeadB, num=6, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.2recoverCrocwater': QuestDNA(obsolete=False, questInt=3306, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrocWater, num=5, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2.3recoverEntrails': QuestDNA(obsolete=False, questInt=3307, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DRIFTWOOD_ALL, item=QuestItems.Entrails, num=2, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2r1.1recoverEyeShips': QuestDNA(obsolete=False, questInt=3301, tasks=(RecoverShipItemTaskDNA(item=QuestItems.KrakenEye, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r2r5r2r1.2defeatCrabs': QuestDNA(obsolete=False, questInt=3302, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.RockCrab, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.5recoverFleas': QuestDNA(obsolete=False, questInt=3483, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Flea, num=6, enemyType=AvatarTypes.Undead, level=7, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.6recoverTail': QuestDNA(obsolete=False, questInt=3484, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Stinger, num=1, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.7recoverTooth': QuestDNA(obsolete=False, questInt=3485, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tooth, num=1, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28r4.1visitTomas': QuestDNA(obsolete=False, questInt=3481, tasks=(VisitTaskDNA(npcId=NPCIds.JUNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28r4.2deliverHairballs': QuestDNA(obsolete=False, questInt=3482, tasks=(DeliverItemTaskDNA(item=QuestItems.Hairball, num=4, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.1visitOrinda': QuestDNA(obsolete=False, questInt=3400, tasks=(VisitTaskDNA(location=LocationIds.TORTUGA_ISLAND, npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.2deliverCargo': QuestDNA(obsolete=False, questInt=3401, tasks=(DeliverItemTaskDNA(item=QuestItems.Cargo, num=1, npcId=NPCIds.GRAHAM_MARSH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GRAHAM_MARSH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.3deliverCoins': QuestDNA(obsolete=False, questInt=3402, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.4recoverChest': QuestDNA(obsolete=False, questInt=3403, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=1, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.5visitDuchamps': QuestDNA(obsolete=False, questInt=3404, tasks=(VisitTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.6visitOlivier': QuestDNA(obsolete=False, questInt=3405, tasks=(VisitTaskDNA(npcId=NPCIds.OLIVIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.7recoverBarrel': QuestDNA(obsolete=False, questInt=3406, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.RumBarrel, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.8deliverBarrel': QuestDNA(obsolete=False, questInt=3407, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBarrel, num=1, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.9sinkShips': QuestDNA(obsolete=False, questInt=3408, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, num=5, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.10sinkShips': QuestDNA(obsolete=False, questInt=3409, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.TradingCo, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.11visitGunner': QuestDNA(obsolete=False, questInt=3410, tasks=(VisitTaskDNA(location=LocationIds.GUNNERS_SHACK, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.28visitRomany': QuestDNA(obsolete=False, questInt=3432, tasks=(VisitTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.30deliverGunner': QuestDNA(obsolete=False, questInt=3437, questLink='c3r3r1r31twentyFiveRum', tasks=(DeliverItemTaskDNA(location=LocationIds.GUNNERS_SHACK, item=QuestItems.VoodooRumBottle, num=1, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.14deliverRum': QuestDNA(obsolete=False, questInt=3443, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=67, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.15visitGunner': QuestDNA(obsolete=False, questInt=3444, tasks=(VisitTaskDNA(npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.16visitPedro': QuestDNA(obsolete=False, questInt=3445, tasks=(VisitTaskDNA(npcId=NPCIds.PAUPER_PEDRO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.17bribePedro': QuestDNA(obsolete=False, questInt=3446, tasks=(BribeNPCTaskDNA(npcId=NPCIds.PAUPER_PEDRO, gold=Bribes.MEDIUM, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.18visitFernando': QuestDNA(obsolete=False, questInt=3447, tasks=(VisitTaskDNA(npcId=NPCIds.FERNANDO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.19bribeFernando': QuestDNA(obsolete=False, questInt=3448, tasks=(BribeNPCTaskDNA(npcId=NPCIds.FERNANDO, gold=Bribes.MEDIUM, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.20deliverRum': QuestDNA(obsolete=False, questInt=3449, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=14, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.20.5visitGunner': QuestDNA(obsolete=False, questInt=3450, tasks=(VisitTaskDNA(npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.22deliverRum': QuestDNA(obsolete=False, questInt=3461, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=5, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.23visitGunner': QuestDNA(obsolete=False, questInt=3462, questLink='c3r3r1r25SingaporeanRum', tasks=(DeliverItemTaskDNA(location=LocationIds.GUNNERS_SHACK, item=QuestItems.SkeletonRum, num=1, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.24visitJoshamee': QuestDNA(obsolete=False, questInt=3463, tasks=(VisitTaskDNA(npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.26deliverRum': QuestDNA(obsolete=False, questInt=3475, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=5, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.27visitGunner': QuestDNA(obsolete=False, questInt=3476, tasks=(DeliverItemTaskDNA(location=LocationIds.GUNNERS_SHACK, item=QuestItems.SingaporeanRum, num=1, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.29deliverRum': QuestDNA(obsolete=False, questInt=3486, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=5, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.30visitGunner': QuestDNA(obsolete=False, questInt=3487, tasks=(VisitTaskDNA(npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.32deliverRum': QuestDNA(obsolete=False, questInt=3500, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=1, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.33visitGunner': QuestDNA(obsolete=False, questInt=3501, tasks=(VisitTaskDNA(location=LocationIds.GUNNERS_SHACK, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.34visitBarbossa': QuestDNA(obsolete=False, questInt=3502, tasks=(VisitTaskDNA(npcId=NPCIds.BARBOSSA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.BARBOSSA), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.35captureTrent': QuestDNA(obsolete=False, questInt=3503, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.TRENT, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.36maroonTrent': QuestDNA(obsolete=False, questInt=3504, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.TRENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.37deliverKey': QuestDNA(obsolete=False, questInt=3505, tasks=(DeliverItemTaskDNA(item=QuestItems.Key, num=1, npcId=NPCIds.BARBOSSA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BARBOSSA,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.BARBOSSA), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.38deliverRum': QuestDNA(obsolete=False, questInt=3506, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=1, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.39visitGunner': QuestDNA(obsolete=False, questInt=3507, tasks=(DeliverItemTaskDNA(location=LocationIds.GUNNERS_SHACK, item=QuestItems.TwentyFiveYearRum, num=1, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.40captureJones': QuestDNA(obsolete=False, questInt=3508, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_JONES, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BARRACUDA, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.41visitMorris': QuestDNA(obsolete=False, questInt=3509, tasks=(VisitTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, npcId=NPCIds.MORRIS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.42visitPedro': QuestDNA(obsolete=False, questInt=3510, tasks=(VisitTaskDNA(npcId=NPCIds.PAUPER_PEDRO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.43bribePedro': QuestDNA(obsolete=False, questInt=3511, tasks=(BribeNPCTaskDNA(npcId=NPCIds.PAUPER_PEDRO, gold=Bribes.SMALL, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.44deliverDrink': QuestDNA(obsolete=False, questInt=3512, tasks=(DeliverItemTaskDNA(item=QuestItems.Drink, num=1, npcId=NPCIds.MORRIS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.45recoverFlags': QuestDNA(obsolete=False, questInt=3513, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Flag, num=4, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.46visitPedro': QuestDNA(obsolete=False, questInt=3514, tasks=(VisitTaskDNA(npcId=NPCIds.PAUPER_PEDRO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.47bribePedro': QuestDNA(obsolete=False, questInt=3515, tasks=(BribeNPCTaskDNA(npcId=NPCIds.PAUPER_PEDRO, gold=Bribes.SMALL, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.48deliverDrink': QuestDNA(obsolete=False, questInt=3516, tasks=(DeliverItemTaskDNA(item=QuestItems.Drink, num=1, npcId=NPCIds.MORRIS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.49stealSchedule': QuestDNA(obsolete=False, questInt=3517, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_DESK, item=QuestItems.Schedule, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.50recoverRum': QuestDNA(obsolete=False, questInt=3518, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBottle, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_WARSHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.51deliverRum': QuestDNA(obsolete=False, questInt=3519, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=1, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.52visitGunner': QuestDNA(obsolete=False, questInt=3520, tasks=(DeliverItemTaskDNA(location=LocationIds.GUNNERS_SHACK, item=QuestItems.Cutler100, num=4, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.53visitJoshamee': QuestDNA(obsolete=False, questInt=3521, tasks=(VisitTaskDNA(npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.2recoverChests': QuestDNA(obsolete=False, questInt=3835, questLink='c3r3r1.5visitDuchamps', tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_KINGFISHER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r6.1duchampsCompetition': QuestDNA(obsolete=False, questInt=3837, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, num=8, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r6.2duchampsCompetition': QuestDNA(obsolete=False, questInt=3838, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_IRONWALL, num=2, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.1voodooRumIngredientsA': QuestDNA(obsolete=False, questInt=3881, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedDarkSugar, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_MONARCH, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.2voodooRumIngredientsA': QuestDNA(obsolete=False, questInt=3882, tasks=(RecoverShipItemTaskDNA(item=QuestItems.DreadBitters, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_MARAUDER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.3voodooRumIngredientsA': QuestDNA(obsolete=False, questInt=3883, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedBarnacles, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_REVENANT, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r29.1voodooRumIngredientsB': QuestDNA(obsolete=False, questInt=3885, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.Flea, num=8, enemyType=AvatarTypes.Carrion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r29.2voodooRumIngredientsB': QuestDNA(obsolete=False, questInt=3886, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.Stinger, num=12, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r29.3voodooRumIngredientsB': QuestDNA(obsolete=False, questInt=3887, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.Tooth, num=8, enemyType=AvatarTypes.SpanishUndeadC, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.42recoverFlags': QuestDNA(obsolete=False, questInt=3892, questLink='c3r3r1.49stealSchedule', tasks=(RecoverShipItemTaskDNA(item=QuestItems.Flag, num=12, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1.50plunderRum': QuestDNA(obsolete=False, questInt=3893, questLink='c3r3r1.52visitGunner', tasks=(RecoverShipItemTaskDNA(item=QuestItems.Cutler100, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_MARAUDER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12.1fishRum': QuestDNA(obsolete=False, questInt=3411, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.FishRumBottle, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12.2Grog': QuestDNA(obsolete=False, questInt=3412, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RumBottle, num=1, enemyType=AvatarTypes.Navy, level=5, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12.3lightRum': QuestDNA(obsolete=False, questInt=3413, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RumBottle, num=1, enemyType=AvatarTypes.Navy, level=9, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12.4darkRum': QuestDNA(obsolete=False, questInt=3414, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RumBottle, num=1, enemyType=AvatarTypes.Navy, level=9, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12.5fiveYearRum': QuestDNA(obsolete=False, questInt=3415, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBottle, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12.6tenYearRum': QuestDNA(obsolete=False, questInt=3416, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBottle, num=1, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12.7skeletonRum': QuestDNA(obsolete=False, questInt=3417, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RumBottle, num=1, enemyType=AvatarTypes.Undead, level=7, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12r2.1recoverRum': QuestDNA(obsolete=False, questInt=3840, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.GrogBottle, num=16, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12r2.2recoverRum': QuestDNA(obsolete=False, questInt=3841, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.LightRumBottle, num=16, enemyType=AvatarTypes.Stalker, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12r2.3recoverRum': QuestDNA(obsolete=False, questInt=3842, tasks=(RecoverNPCItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.DarkRumBottle, npcId=NPCIds.SAMUEL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12r3.1recoverRum': QuestDNA(obsolete=False, questInt=3844, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FiveYearRum, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12r3.2recoverRum': QuestDNA(obsolete=False, questInt=3845, tasks=(RecoverShipItemTaskDNA(item=QuestItems.TenYearRum, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r12r3.3recoverRum': QuestDNA(obsolete=False, questInt=3846, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BoneRumBottle, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_PHANTOM, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r2.1findRum': QuestDNA(obsolete=False, questInt=3848, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_BARRELS, item=QuestItems.NavyRum, num=8, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r2.2findRum': QuestDNA(obsolete=False, questInt=3849, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_CRATES, item=QuestItems.EITCRum, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r1.1visitRico': QuestDNA(obsolete=False, questInt=3418, tasks=(VisitTaskDNA(location=LocationIds.SKULLSTHUNDER_TAVERN, npcId=NPCIds.RICO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r1.2bribeRico': QuestDNA(obsolete=False, questInt=3419, tasks=(BribeNPCTaskDNA(npcId=NPCIds.RICO, gold=Bribes.AVERAGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r1.3visitGarrett': QuestDNA(obsolete=False, questInt=3420, tasks=(VisitTaskDNA(npcId=NPCIds.GARRETT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r1.4bribeGarrett': QuestDNA(obsolete=False, questInt=3421, tasks=(BribeNPCTaskDNA(npcId=NPCIds.GARRETT, gold=Bribes.HUGE, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r1.5deliverRum': QuestDNA(obsolete=False, questInt=3422, tasks=(DeliverItemTaskDNA(location=LocationIds.GUNNERS_SHACK, item=QuestItems.RumBottle, num=10, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r2.1recoverRum': QuestDNA(obsolete=False, questInt=3423, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBottle, num=10, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r2.2recoverRum': QuestDNA(obsolete=False, questInt=3424, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBottle, num=10, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r3.1poker': QuestDNA(obsolete=False, questInt=3425, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r3.2blackjack': QuestDNA(obsolete=False, questInt=3426, tasks=(BlackjackTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4.1recoverLadle': QuestDNA(obsolete=False, questInt=3427, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Ladle, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_WARSHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4.1getEmptyBottles': QuestDNA(obsolete=False, questInt=3850, questLink='c3r3r1r13r4r2.GrogIngredients', tasks=(RecoverShipItemTaskDNA(item=QuestItems.EmptyBottleBox, num=12, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r2.1grogIngredients': QuestDNA(obsolete=False, questInt=3852, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.Sugar, num=8, enemyType=AvatarTypes.SpanishUndeadB, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r2.2grogIngredients': QuestDNA(obsolete=False, questInt=3853, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.WaterCanteen, num=16, enemyType=AvatarTypes.CorpseCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r2.3grogIngredients': QuestDNA(obsolete=False, questInt=3854, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.Mud, num=5, enemyType=AvatarTypes.SpanishUndeadC, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r3.1lightRumIngredients': QuestDNA(obsolete=False, questInt=3856, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Molasses, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BLOODHOUND, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r3.2lightRumIngredients': QuestDNA(obsolete=False, questInt=3857, tasks=(RecoverShipItemTaskDNA(item=QuestItems.WaterBarrel, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_CENTURION, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r3.3lightRumIngredients': QuestDNA(obsolete=False, questInt=3858, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Vanilla, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_IRONWALL, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r4.1darkRumIngredients': QuestDNA(obsolete=False, questInt=3860, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.MolassesCup, num=5, enemyType=AvatarTypes.Hiredgun, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r4.2darkRumIngredients': QuestDNA(obsolete=False, questInt=3861, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.WaterCanteen, num=5, enemyType=AvatarTypes.Officer, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r4.3darkRumIngredients': QuestDNA(obsolete=False, questInt=3862, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, containerId=PropIds.DF_BQ_BARRELS, item=QuestItems.Vanilla, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r2.1recoverSugar': QuestDNA(obsolete=False, questInt=3428, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Sugar, num=8, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r2.2recoverWater': QuestDNA(obsolete=False, questInt=3429, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WaterCanteen, num=3, enemyType=AvatarTypes.TradingCo, level=8, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r2.3recoverMud': QuestDNA(obsolete=False, questInt=3430, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Mud, num=1, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r2.4recoverBottle': QuestDNA(obsolete=False, questInt=3431, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bottle, num=1, enemyType=AvatarTypes.Navy, level=5, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r3.1recoverMolasses': QuestDNA(obsolete=False, questInt=3433, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Molasses, num=12, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r3.2recoverWater': QuestDNA(obsolete=False, questInt=3434, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WaterCanteen, num=8, enemyType=AvatarTypes.TradingCo, level=8, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r3.3recoverVanilla': QuestDNA(obsolete=False, questInt=3435, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Vanilla, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r3.4recoverBottle': QuestDNA(obsolete=False, questInt=3436, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bottle, num=1, enemyType=AvatarTypes.Navy, level=9, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r4.1recoverMolasses': QuestDNA(obsolete=False, questInt=3438, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Molasses, num=4, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r4.2recoverWater': QuestDNA(obsolete=False, questInt=3439, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WaterCanteen, num=10, enemyType=AvatarTypes.TradingCo, level=8, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r4.3recoverVanilla': QuestDNA(obsolete=False, questInt=3440, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Vanilla, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r13r4r4.4recoverBottle': QuestDNA(obsolete=False, questInt=3441, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bottle, num=1, enemyType=AvatarTypes.Navy, level=5, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1.1visitRomany': QuestDNA(obsolete=False, questInt=3451, tasks=(VisitTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r3.1skelRumIngredientsB': QuestDNA(obsolete=False, questInt=3864, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.Hair, num=14, enemyType=AvatarTypes.CorpseCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r3.2skelRumIngredientsB': QuestDNA(obsolete=False, questInt=3865, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.BoneDust, num=6, enemyType=AvatarTypes.CarrionKnife, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r3.3skelRumIngredientsB': QuestDNA(obsolete=False, questInt=3866, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_C, item=QuestItems.Toenail, num=6, enemyType=AvatarTypes.Carrion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r4.1skelRumIngredientsC': QuestDNA(obsolete=False, questInt=3868, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.SwampGas, num=12, enemyType=AvatarTypes.RancidFlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r4.2skelRumIngredientsC': QuestDNA(obsolete=False, questInt=3869, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.Stinger, num=12, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r4.3skelRumIngredientsC': QuestDNA(obsolete=False, questInt=3870, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.Bladder, num=12, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1.2skelRumIngredientsA': QuestDNA(obsolete=False, questInt=3894, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Splinter, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_PHANTOM, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r2.1recoverMolasses': QuestDNA(obsolete=False, questInt=3453, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Molasses, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r2.2recoverWater': QuestDNA(obsolete=False, questInt=3454, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Water, num=3, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r2.3recoverDust': QuestDNA(obsolete=False, questInt=3455, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneDust, num=10, enemyType=AvatarTypes.Undead, level=7, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r2.4recoverGas': QuestDNA(obsolete=False, questInt=3456, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.SwampGas, num=1, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r2.5recoverStingers': QuestDNA(obsolete=False, questInt=3457, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Stinger, num=10, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r21r1r2.6recoverBladder': QuestDNA(obsolete=False, questInt=3458, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bladder, num=1, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25.1visitPauper': QuestDNA(obsolete=False, questInt=3871, tasks=(VisitTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, npcId=NPCIds.PAUPER_PEDRO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r2.1singapRumIngredientsA': QuestDNA(obsolete=False, questInt=3873, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CaneSugarBarrel, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_VANGUARD, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r2.2singapRumIngredientsA': QuestDNA(obsolete=False, questInt=3874, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Honey, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_KINGFISHER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r2.3singapRumIngredientsA': QuestDNA(obsolete=False, questInt=3875, tasks=(RecoverShipItemTaskDNA(item=QuestItems.NutmegCrate, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_MARAUDER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r3.1singapRumIngredientsB': QuestDNA(obsolete=False, questInt=3877, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, item=QuestItems.Cinnamon, num=20, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r3.2singapRumIngredientsB': QuestDNA(obsolete=False, questInt=3878, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_BARRELS, item=QuestItems.Coconut, num=8, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r3.3singapRumIngredientsB': QuestDNA(obsolete=False, questInt=3879, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_CRATES, item=QuestItems.Feather, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1.1visitCarver': QuestDNA(obsolete=False, questInt=3464, tasks=(VisitTaskDNA(npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1.2deliverPint': QuestDNA(obsolete=False, questInt=3465, tasks=(DeliverItemTaskDNA(item=QuestItems.Pint, num=1, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOSHAMEE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1r3.1recoverMolasses': QuestDNA(obsolete=False, questInt=3466, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Molasses, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1r3.2recoverHoney': QuestDNA(obsolete=False, questInt=3467, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Honey, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1r3.3recoverWater': QuestDNA(obsolete=False, questInt=3468, tasks=(RecoverShipItemTaskDNA(item=QuestItems.MoonlitWater, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1r3.4recoverCinnamon': QuestDNA(obsolete=False, questInt=3469, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Cinnamon, num=12, enemyType=AvatarTypes.Navy, level=9, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1r3.5recoverCoconut': QuestDNA(obsolete=False, questInt=3470, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Coconut, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r1r3.6recoverFeather': QuestDNA(obsolete=False, questInt=3471, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Feather, num=1, enemyType=AvatarTypes.Navy, level=15, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r2.1captureArcher': QuestDNA(obsolete=False, questInt=3473, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_ARCHER, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_WARSHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r25r2.2maroonArcher': QuestDNA(obsolete=False, questInt=3474, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_ARCHER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.1recoverMolasses': QuestDNA(obsolete=False, questInt=3477, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Molasses, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.2recoverWater': QuestDNA(obsolete=False, questInt=3478, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Water, num=2, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r28.3recoverBarnacles': QuestDNA(obsolete=False, questInt=3479, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Barnacles, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r1.1visitJoshamee': QuestDNA(obsolete=False, questInt=3488, tasks=(VisitTaskDNA(npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r1.2visitBenedek': QuestDNA(obsolete=False, questInt=3489, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.BENEDEK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r1.3recoverEffects': QuestDNA(obsolete=False, questInt=3490, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.PersonalEffects, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2r2.4smuggleRum': QuestDNA(obsolete=False, questInt=3496, tasks=(SmuggleItemTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, item=QuestItems.RumBarrel, num=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2r2.5smuggleHoney': QuestDNA(obsolete=False, questInt=3497, tasks=(SmuggleItemTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, item=QuestItems.Honey, num=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2r2.6smuggleCinnamon': QuestDNA(obsolete=False, questInt=3498, tasks=(SmuggleItemTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, item=QuestItems.Cinnamon, num=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2.1visitFernando': QuestDNA(obsolete=False, questInt=3491, tasks=(VisitTaskDNA(location=LocationIds.SKULLSTHUNDER_TAVERN, npcId=NPCIds.FERNANDO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2.1fernandoChores': QuestDNA(obsolete=False, questInt=3889, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_CENTURION, num=2, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2.2fernandoChores': QuestDNA(obsolete=False, questInt=3890, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_IRONWALL, num=2, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2.3fernandoChores': QuestDNA(obsolete=False, questInt=3891, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.SKEL_PHANTOM, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2r2.1sinkNavyShips': QuestDNA(obsolete=False, questInt=3492, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, num=5, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2r2.2sinkEITCShips': QuestDNA(obsolete=False, questInt=3493, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.TradingCo, num=5, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r1r31r2r2.3sinkSkeletonShips': QuestDNA(obsolete=False, questInt=3494, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Undead, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.1visitFabiola': QuestDNA(obsolete=False, questInt=3550, tasks=(VisitTaskDNA(npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.2visitOrinda': QuestDNA(obsolete=False, questInt=3551, tasks=(VisitTaskDNA(location=LocationIds.TORTUGA_ISLAND, npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.3captureReginald': QuestDNA(obsolete=False, questInt=3552, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_REGINALD, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_MAN_O_WAR, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.4maroonReginald': QuestDNA(obsolete=False, questInt=3553, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_REGINALD),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.5captureDennison': QuestDNA(obsolete=False, questInt=3554, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_DENNISON, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.6maroonDennison': QuestDNA(obsolete=False, questInt=3555, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_DENNISON),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.7captureHedley': QuestDNA(obsolete=False, questInt=3556, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_HEDLEY, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.8maroonHedley': QuestDNA(obsolete=False, questInt=3557, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_HEDLEY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.9captureBiggleton': QuestDNA(obsolete=False, questInt=3558, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_BIGGLETON, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_WARSHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.10maroonBiggleton': QuestDNA(obsolete=False, questInt=3559, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_BIGGLETON),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.11captureNorman': QuestDNA(obsolete=False, questInt=3560, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_NORMAN, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_WARSHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.12maroonNorman': QuestDNA(obsolete=False, questInt=3561, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_NORMAN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.13captureFitzpatrick': QuestDNA(obsolete=False, questInt=3562, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_FITZPATRICK, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.14maroonFitzpatrick': QuestDNA(obsolete=False, questInt=3563, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_FITZPATRICK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.15captureHamilton': QuestDNA(obsolete=False, questInt=3564, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_HAMILTON, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.16maroonHamilton': QuestDNA(obsolete=False, questInt=3565, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_HAMILTON),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.17visitJohn': QuestDNA(obsolete=False, questInt=3566, tasks=(VisitTaskDNA(npcId=NPCIds.BRONZE_JOHN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.18recoverRum': QuestDNA(obsolete=False, questInt=3567, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BRONZE_JOHN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.19visitMary': QuestDNA(obsolete=False, questInt=3568, tasks=(VisitTaskDNA(location=LocationIds.PERDIDA_JUNGLE_B, npcId=NPCIds.SCARY_MARY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.20.5recoverBelongings': QuestDNA(obsolete=False, questInt=3573, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.PERDIDA_JUNGLE_B, item=QuestItems.PersonalEffects, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.21visitJoshamee': QuestDNA(obsolete=False, questInt=3574, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.5visitWoodruff': QuestDNA(obsolete=False, questInt=3707, tasks=(VisitTaskDNA(location=LocationIds.ISLA_CANGREJOS, npcId=NPCIds.WOODRUFF),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r6.1woodruffsRequest': QuestDNA(obsolete=False, questInt=3709, tasks=(DefeatTaskDNA(location=LocationIds.ISLA_CANGREJOS, enemyType=AvatarTypes.CrusherCrab, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r6.2woodruffsRequest': QuestDNA(obsolete=False, questInt=3710, tasks=(DefeatNPCTaskDNA(location=LocationIds.ISLA_CANGREJOS, npcId=NPCIds.CROQUETTES_DE_CRABE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.7woodruffsRequest': QuestDNA(obsolete=False, questInt=3711, questLink='c3r3r2.19visitMary', tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r20.1waspIssues': QuestDNA(obsolete=False, questInt=3712, tasks=(DefeatTaskDNA(location=LocationIds.PERDIDA_ALL, enemyType=AvatarTypes.AngryWasp, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r20.2waspIssues': QuestDNA(obsolete=False, questInt=3713, tasks=(DefeatTaskDNA(location=LocationIds.PERDIDA_ALL, enemyType=AvatarTypes.SoldierWasp, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.22captureDennison': QuestDNA(obsolete=False, questInt=3721, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_DENNISON, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BARRACUDA, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2.23maroonDennison': QuestDNA(obsolete=False, questInt=3722, questLink='c3r3r2.20.5recoverBelongings', tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_DENNISON),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r21.1maryRevenge': QuestDNA(obsolete=False, questInt=3732, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_KINGFISHER, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r21.2maryRevenge': QuestDNA(obsolete=False, questInt=3733, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_MARAUDER, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r21.3maryRevenge': QuestDNA(obsolete=False, questInt=3734, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.SKEL_REVENANT, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r24.1missingTreasure': QuestDNA(obsolete=False, questInt=3740, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PERDIDA_JUNGLE_B, item=QuestItems.Charm, num=14, enemyType=AvatarTypes.SoldierWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r24.2missingTreasure': QuestDNA(obsolete=False, questInt=3741, tasks=(RecoverNPCItemTaskDNA(location=LocationIds.PERDIDA_JUNGLE_B, item=QuestItems.GoldChain, npcId=NPCIds.HIVE_QUEEN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARY_MARY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r20.1sinkNavy': QuestDNA(obsolete=False, questInt=3569, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_WARSHIP, faction=AvatarTypes.Navy, num=10, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r20.2sinkEITC': QuestDNA(obsolete=False, questInt=3570, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.TradingCo, num=10, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r2r20.3sinkSkeleton': QuestDNA(obsolete=False, questInt=3571, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Undead, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7.4recoverWater': QuestDNA(obsolete=False, questInt=3615, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Water, num=6, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r5.1visitMallet': QuestDNA(obsolete=False, questInt=3616, tasks=(VisitTaskDNA(npcId=NPCIds.MALLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r5.2bribeMallet': QuestDNA(obsolete=False, questInt=3617, tasks=(BribeNPCTaskDNA(npcId=NPCIds.MALLET, gold=Bribes.MEDIUM, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r5.3deliverWater': QuestDNA(obsolete=False, questInt=3618, tasks=(DeliverItemTaskDNA(item=QuestItems.Water, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r6.1visitScarlet': QuestDNA(obsolete=False, questInt=3619, tasks=(VisitTaskDNA(npcId=NPCIds.SCARLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r6.2recoverHoneysuckle': QuestDNA(obsolete=False, questInt=3620, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Honeysuckle, num=18, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r6.3deliverHoneysuckle': QuestDNA(obsolete=False, questInt=3621, tasks=(DeliverItemTaskDNA(item=QuestItems.Honeysuckle, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r7.1visitBowdash': QuestDNA(obsolete=False, questInt=3622, tasks=(VisitTaskDNA(npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r7.2poker': QuestDNA(obsolete=False, questInt=3623, tasks=(PokerTaskDNA(gold=PokerPots.MEDIUM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r7.3recoverSap': QuestDNA(obsolete=False, questInt=3624, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Sap, num=5, enemyType=AvatarTypes.Undead, level=12, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r7.4deliverSap': QuestDNA(obsolete=False, questInt=3625, tasks=(DeliverItemTaskDNA(item=QuestItems.Sap, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.11deliverChest': QuestDNA(obsolete=False, questInt=3340, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Chest, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r12.1lastKey': QuestDNA(obsolete=False, questInt=3342, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.Cadaver, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r12.2lastKey': QuestDNA(obsolete=False, questInt=3343, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.CadaverCutlass, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r12.3lastKey': QuestDNA(obsolete=False, questInt=3344, tasks=(RecoverNPCItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, item=QuestItems.Key, npcId=NPCIds.BONERATTLER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.1visitCarver': QuestDNA(obsolete=False, questInt=3600, questLink='c3r3r3.3visitGiladoga', tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.2visitMcVane': QuestDNA(obsolete=False, questInt=3601, tasks=(VisitTaskDNA(npcId=NPCIds.JOHNNY_MCVANE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.3visitGiladoga': QuestDNA(obsolete=False, questInt=3602, questLink='c3r3r3.4keyDelivery', tasks=(VisitTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.4deliverKey': QuestDNA(obsolete=False, questInt=3603, tasks=(DeliverItemTaskDNA(item=QuestItems.Key, num=1, npcId=NPCIds.BLACKSMITH_FLINTY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BLACKSMITH_FLINTY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.5bribeFlinty': QuestDNA(obsolete=False, questInt=3604, tasks=(BribeNPCTaskDNA(npcId=NPCIds.BLACKSMITH_FLINTY, gold=Bribes.SMALL, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.6deliverKey': QuestDNA(obsolete=False, questInt=3605, tasks=(DeliverItemTaskDNA(item=QuestItems.Key, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.8deliverKey': QuestDNA(obsolete=False, questInt=3626, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.10recoverChest': QuestDNA(obsolete=False, questInt=3694, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_STORM_REAPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.11visitJack': QuestDNA(obsolete=False, questInt=3695, tasks=(VisitTaskDNA(npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.12recoverKey': QuestDNA(obsolete=False, questInt=3696, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Key, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.13deliverKey': QuestDNA(obsolete=False, questInt=3697, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.14visitJoshamee': QuestDNA(obsolete=False, questInt=3698, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.4keyDelivery': QuestDNA(obsolete=False, questInt=3757, tasks=(DeliverItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.Key, num=1, npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.5romanysRequestA': QuestDNA(obsolete=False, questInt=3759, tasks=(RecoverShipItemTaskDNA(item=QuestItems.WaterBarrel, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_REVENANT, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.7romanysRequestC': QuestDNA(obsolete=False, questInt=3760, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BrassInstrument, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_MONARCH, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r6.1romanysRequestB': QuestDNA(obsolete=False, questInt=3762, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.WaterFlask, num=6, enemyType=AvatarTypes.Officer, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r6.2romanysRequestB': QuestDNA(obsolete=False, questInt=3763, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.GatorStomach, num=15, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r6.3romanysRequestB': QuestDNA(obsolete=False, questInt=3764, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.BileSack, num=15, enemyType=AvatarTypes.RancidFlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.8visitFernando': QuestDNA(obsolete=False, questInt=3765, tasks=(VisitTaskDNA(location=LocationIds.SKULLSTHUNDER_TAVERN, npcId=NPCIds.FERNANDO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.9winAtPoker': QuestDNA(obsolete=False, questInt=3766, tasks=(PokerTaskDNA(gold=PokerPots.MEDIUM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FERNANDO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r10.1fernandosRequest': QuestDNA(obsolete=False, questInt=3768, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.Carrion, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FERNANDO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r10.2fernandosRequest': QuestDNA(obsolete=False, questInt=3769, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.Cadaver, num=3, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FERNANDO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r10.3fernandosRequest': QuestDNA(obsolete=False, questInt=3770, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.CarrionKnife, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FERNANDO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3.11deliverToRomany': QuestDNA(obsolete=False, questInt=3771, questLink='c3r3r3.8deliverKey', tasks=(DeliverItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.ForgivenessLetter, num=1, npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r1.1visitOrinda': QuestDNA(obsolete=False, questInt=3606, tasks=(VisitTaskDNA(npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r1.2recoverWater': QuestDNA(obsolete=False, questInt=3607, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Water, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r1.3deliverWater': QuestDNA(obsolete=False, questInt=3608, tasks=(DeliverItemTaskDNA(item=QuestItems.Water, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r2.1visitCarver': QuestDNA(obsolete=False, questInt=3609, tasks=(VisitTaskDNA(npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r2.2recoverWater': QuestDNA(obsolete=False, questInt=3610, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.LatrineWater, num=15, enemyType=AvatarTypes.Cadet, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r2.3deliverWater': QuestDNA(obsolete=False, questInt=3611, tasks=(DeliverItemTaskDNA(item=QuestItems.Water, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r3.1visitBenedek': QuestDNA(obsolete=False, questInt=3612, tasks=(VisitTaskDNA(npcId=NPCIds.BENEDEK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r3.2recoverWater': QuestDNA(obsolete=False, questInt=3613, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Water, num=1, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r7r3.3deliverWater': QuestDNA(obsolete=False, questInt=3614, tasks=(DeliverItemTaskDNA(item=QuestItems.Water, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1.1visitCraven': QuestDNA(obsolete=False, questInt=3627, tasks=(VisitTaskDNA(npcId=NPCIds.BASTIEN_CRAVEN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1.2visitFlatts': QuestDNA(obsolete=False, questInt=3628, tasks=(VisitTaskDNA(npcId=NPCIds.BEN_FLATTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1.3sinkNavyShips': QuestDNA(obsolete=False, questInt=3629, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, num=12, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1.4deliverRum': QuestDNA(obsolete=False, questInt=3630, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBarrel, num=1, npcId=NPCIds.GRAHAM_MARSH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GRAHAM_MARSH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1.5deliverMoney': QuestDNA(obsolete=False, questInt=3631, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.BEN_FLATTS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BEN_FLATTS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1.6deliverKey': QuestDNA(obsolete=False, questInt=3632, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1.1visitGarrett': QuestDNA(obsolete=False, questInt=3772, tasks=(VisitTaskDNA(location=LocationIds.GARRETTS_HOUSE, npcId=NPCIds.GARRETT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1r2.1garrettsRequest': QuestDNA(obsolete=False, questInt=3774, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_MARAUDER, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARRETT,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1r2.2garrettsRequest': QuestDNA(obsolete=False, questInt=3775, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_BARRACUDA, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARRETT,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r1r2.3garrettsRequest': QuestDNA(obsolete=False, questInt=3776, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_MAN_O_WAR, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARRETT,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.1visitMallet': QuestDNA(obsolete=False, questInt=3633, tasks=(VisitTaskDNA(npcId=NPCIds.MALLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.2visitBenedek': QuestDNA(obsolete=False, questInt=3634, tasks=(VisitTaskDNA(npcId=NPCIds.BENEDEK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.3recoverChest': QuestDNA(obsolete=False, questInt=3635, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.4deliverFabiola': QuestDNA(obsolete=False, questInt=3636, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.6deliverGold': QuestDNA(obsolete=False, questInt=3642, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.BENEDEK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.7recoverCoins': QuestDNA(obsolete=False, questInt=3643, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.CoinBag, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.8blackjack': QuestDNA(obsolete=False, questInt=3644, tasks=(BlackjackTaskDNA(gold=PokerPots.MEDIUM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BENEDEK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.9deliverKey': QuestDNA(obsolete=False, questInt=3645, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.1visitRico': QuestDNA(obsolete=False, questInt=3777, tasks=(VisitTaskDNA(location=LocationIds.SKULLSTHUNDER_TAVERN, npcId=NPCIds.RICO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.2ricosRequest': QuestDNA(obsolete=False, questInt=3778, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_OGRE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.RICO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.3visitPelagia': QuestDNA(obsolete=False, questInt=3779, tasks=(VisitTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, npcId=NPCIds.PELAGIA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2r4.1pelagiasRequest': QuestDNA(obsolete=False, questInt=3781, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, item=QuestItems.Kneecap, num=10, enemyType=AvatarTypes.CarrionKnife, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2r4.2pelagiasRequest': QuestDNA(obsolete=False, questInt=3782, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, item=QuestItems.SkeletonRib, num=5, enemyType=AvatarTypes.Cadaver, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2r4.3pelagiasRequest': QuestDNA(obsolete=False, questInt=3783, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, item=QuestItems.PinkyRing, num=5, enemyType=AvatarTypes.CadaverCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.5deliverItem': QuestDNA(obsolete=False, questInt=3784, tasks=(DeliverItemTaskDNA(location=LocationIds.SKULLSTHUNDER_TAVERN, item=QuestItems.PinkyRing, num=5, npcId=NPCIds.RICO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.RICO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.6recoverSome': QuestDNA(obsolete=False, questInt=3785, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.Gems, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.RICO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2.7winAtBlackjack': QuestDNA(obsolete=False, questInt=3786, questLink='c3r3r3r9r2.9deliverKey', tasks=(BlackjackTaskDNA(gold=PokerPots.SMALL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.RICO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2r5.1recoverHair': QuestDNA(obsolete=False, questInt=3637, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hair, num=5, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2r5.2recoverTears': QuestDNA(obsolete=False, questInt=3638, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tear, num=3, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2r5.3recoverBlood': QuestDNA(obsolete=False, questInt=3639, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=2, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r2r5.4recoverGuano': QuestDNA(obsolete=False, questInt=3640, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatGuano, num=10, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.1visitBowdash': QuestDNA(obsolete=False, questInt=3646, tasks=(VisitTaskDNA(npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.2capturePenrod': QuestDNA(obsolete=False, questInt=3647, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.PENROD, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_WARSHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.3maroonPenrod': QuestDNA(obsolete=False, questInt=3648, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.PENROD),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.4deliverGold': QuestDNA(obsolete=False, questInt=3649, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.5sinkNavyShips': QuestDNA(obsolete=False, questInt=3650, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, num=6, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.6poker': QuestDNA(obsolete=False, questInt=3651, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.7deliverKey': QuestDNA(obsolete=False, questInt=3652, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.1visitDuchamps': QuestDNA(obsolete=False, questInt=3787, tasks=(VisitTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.2capturePenrodNew': QuestDNA(obsolete=False, questInt=3788, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.PENROD, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_MAN_O_WAR, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.3maroonPenrodNew': QuestDNA(obsolete=False, questInt=3789, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.PENROD),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.4deliverMoney': QuestDNA(obsolete=False, questInt=3790, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Money, num=1, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3r5.1duchampsRequest': QuestDNA(obsolete=False, questInt=3792, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_MONARCH, num=4, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3r5.2duchampsRequest': QuestDNA(obsolete=False, questInt=3793, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_MAN_O_WAR, num=2, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3r5.3duchampsRequest': QuestDNA(obsolete=False, questInt=3794, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_PREDATOR, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r3.6winAtPoker': QuestDNA(obsolete=False, questInt=3795, questLink='c3r3r3r9r3.7deliverKey', tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DUCHAMPS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.1recoverChest': QuestDNA(obsolete=False, questInt=3653, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Chest, num=1, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.2visitFabiola': QuestDNA(obsolete=False, questInt=3654, tasks=(VisitTaskDNA(npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.4deliverList': QuestDNA(obsolete=False, questInt=3659, tasks=(DeliverItemTaskDNA(item=QuestItems.List, num=1, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.5visitCarver': QuestDNA(obsolete=False, questInt=3660, tasks=(VisitTaskDNA(npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.6bribeCarver': QuestDNA(obsolete=False, questInt=3661, tasks=(BribeNPCTaskDNA(npcId=NPCIds.CARVER, gold=Bribes.SMALL, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.7deliverRum': QuestDNA(obsolete=False, questInt=3662, tasks=(DeliverItemTaskDNA(item=QuestItems.Rum, num=1, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.8visitCarver': QuestDNA(obsolete=False, questInt=3663, tasks=(VisitTaskDNA(npcId=NPCIds.CARVER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.9bribeCarver': QuestDNA(obsolete=False, questInt=3664, tasks=(BribeNPCTaskDNA(npcId=NPCIds.CARVER, gold=Bribes.LARGE, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.10deliverRum': QuestDNA(obsolete=False, questInt=3665, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBottle, num=1, npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOC_GROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.11deliverOil': QuestDNA(obsolete=False, questInt=3666, tasks=(DeliverItemTaskDNA(item=QuestItems.Oil, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.12deliverKey': QuestDNA(obsolete=False, questInt=3667, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4r3.1openChest': QuestDNA(obsolete=False, questInt=3724, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.Dagger, num=12, enemyType=AvatarTypes.Hiredgun, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4r3.2openChest': QuestDNA(obsolete=False, questInt=3725, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.Sword, num=12, enemyType=AvatarTypes.Officer, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4r3.3openChest': QuestDNA(obsolete=False, questInt=3726, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.BrassButton, num=6, enemyType=AvatarTypes.Mercenary, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.1recoverChestNew': QuestDNA(obsolete=False, questInt=3758, tasks=(RecoverNPCItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.Chest, npcId=NPCIds.DREADTOOTH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4.2deliverChest': QuestDNA(obsolete=False, questInt=3796, tasks=(DeliverItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.Chest, num=1, npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4r3.1recoverCologne': QuestDNA(obsolete=False, questInt=3655, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Perfume, num=5, enemyType=AvatarTypes.Navy, level=15, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4r3.2recoverOil': QuestDNA(obsolete=False, questInt=3656, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Oil, num=10, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r4r3.3recoverBile': QuestDNA(obsolete=False, questInt=3657, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bile, num=12, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5.1visitPelagia': QuestDNA(obsolete=False, questInt=3641, tasks=(VisitTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, npcId=NPCIds.PELAGIA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5.1visitGrog': QuestDNA(obsolete=False, questInt=3668, tasks=(VisitTaskDNA(npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5.3deliverMemoryCure': QuestDNA(obsolete=False, questInt=3672, questLink='c3r3r3r9r5.4recoverKey', tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.MemoryCure, num=1, npcId=NPCIds.MORRIS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5.3deliverRemedy': QuestDNA(obsolete=False, questInt=3673, tasks=(DeliverItemTaskDNA(item=QuestItems.Remedy, num=1, npcId=NPCIds.RETAVICK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.RETAVICK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5.4recoverKey': QuestDNA(obsolete=False, questInt=3674, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Key, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_STORM_REAPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5.5deliverKey': QuestDNA(obsolete=False, questInt=3675, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5r2.1cureMemory': QuestDNA(obsolete=False, questInt=3797, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, containerId=PropIds.KH_HAYSTACKS, item=QuestItems.Hay, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5r2.2cureMemory': QuestDNA(obsolete=False, questInt=3798, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.KINGSHEAD_ALL, item=QuestItems.MedicineKit, num=16, enemyType=AvatarTypes.Officer, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5r2.3cureMemory': QuestDNA(obsolete=False, questInt=3799, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.KINGSHEAD_ALL, item=QuestItems.HerbSack, num=10, enemyType=AvatarTypes.Mercenary, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5r2.1recoverTeeth': QuestDNA(obsolete=False, questInt=3669, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tooth, num=12, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5r2.2recoverVenom': QuestDNA(obsolete=False, questInt=3670, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Venom, num=3, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r5r2.3recoverSap': QuestDNA(obsolete=False, questInt=3671, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Sap, num=6, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r6.2adoriasRequest': QuestDNA(obsolete=False, questInt=3315, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, enemyType=AvatarTypes.Cadaver, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r6.1adoriasRequest': QuestDNA(obsolete=False, questInt=3331, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, enemyType=AvatarTypes.CadaverCutlass, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r6.1visitAdoria': QuestDNA(obsolete=False, questInt=3330, tasks=(VisitTaskDNA(location=LocationIds.DOLORES_TAILOR, npcId=NPCIds.ADORIA_DOLORES),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r6.1visitAnne': QuestDNA(obsolete=False, questInt=3676, tasks=(VisitTaskDNA(npcId=NPCIds.SEAMSTRESS_ANNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r6.2defeatSkeletons': QuestDNA(obsolete=False, questInt=3677, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_JUNGLE_A_GRAVEYARD, enemyType=AvatarTypes.Undead, num=20, level=7),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SEAMSTRESS_ANNE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r6.3deliverKey': QuestDNA(obsolete=False, questInt=3678, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.1visitMercedes': QuestDNA(obsolete=False, questInt=3332, tasks=(VisitTaskDNA(location=LocationIds.CORAZON_TATTOOS, npcId=NPCIds.MERCEDES_CORAZON),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.2captureCollierNew': QuestDNA(obsolete=False, questInt=3333, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.COLLIER, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_OGRE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.3maroonCollierNew': QuestDNA(obsolete=False, questInt=3334, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.COLLIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.4deliverNecklaceNew': QuestDNA(obsolete=False, questInt=3335, questLink='c3r3r3r9r7.6deliverKey', tasks=(DeliverItemTaskDNA(location=LocationIds.CORAZON_TATTOOS, item=QuestItems.Necklace, num=1, npcId=NPCIds.MERCEDES_CORAZON),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MERCEDES_CORAZON,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.1visitScarlet': QuestDNA(obsolete=False, questInt=3679, tasks=(VisitTaskDNA(npcId=NPCIds.SCARLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.2captureCollier': QuestDNA(obsolete=False, questInt=3680, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.COLLIER, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.3maroonCollier': QuestDNA(obsolete=False, questInt=3681, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.COLLIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.4deliverNecklace': QuestDNA(obsolete=False, questInt=3682, tasks=(DeliverItemTaskDNA(item=QuestItems.Necklace, num=1, npcId=NPCIds.SCARLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.5bribeScarlet': QuestDNA(obsolete=False, questInt=3683, tasks=(BribeNPCTaskDNA(npcId=NPCIds.SCARLET, gold=Bribes.LARGE, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r7.6deliverKey': QuestDNA(obsolete=False, questInt=3684, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.1recoverOrdersNew': QuestDNA(obsolete=False, questInt=3336, questLink='c3r3r3r9r8.2visitPauper', tasks=(RecoverShipItemTaskDNA(item=QuestItems.EnlistmentOrder, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_MAN_O_WAR, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.2visitPauper': QuestDNA(obsolete=False, questInt=3337, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.EnlistmentOrder, num=3, npcId=NPCIds.PAUPER_PEDRO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.3paupersRequest': QuestDNA(obsolete=False, questInt=3338, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.Salve, num=12, enemyType=AvatarTypes.Mercenary, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PAUPER_PEDRO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.4recoverKey': QuestDNA(obsolete=False, questInt=3339, questLink='c3r3r3r9r8.9deliverKey', tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.Key, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.1recoverOrders': QuestDNA(obsolete=False, questInt=3685, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Orders, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_WARSHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.2visitBlakeley': QuestDNA(obsolete=False, questInt=3686, tasks=(VisitTaskDNA(npcId=NPCIds.BLAKELEY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.3visitWoodruff': QuestDNA(obsolete=False, questInt=3687, tasks=(VisitTaskDNA(npcId=NPCIds.WOODRUFF),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.4recoverSalve': QuestDNA(obsolete=False, questInt=3688, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Salve, num=12, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.5deliverWax': QuestDNA(obsolete=False, questInt=3689, tasks=(DeliverItemTaskDNA(item=QuestItems.Wax, num=1, npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FABIOLA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.6bribeFabiola': QuestDNA(obsolete=False, questInt=3690, tasks=(BribeNPCTaskDNA(npcId=NPCIds.FABIOLA, gold=Bribes.MEDIUM, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.7deliverKey': QuestDNA(obsolete=False, questInt=3691, tasks=(DeliverItemTaskDNA(item=QuestItems.Key, num=1, npcId=NPCIds.WOODRUFF),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.8recoverKey': QuestDNA(obsolete=False, questInt=3692, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Key, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r3r9r8.9deliverKey': QuestDNA(obsolete=False, questInt=3693, tasks=(DeliverItemTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, item=QuestItems.Key, num=1, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GILADOGA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r6r1r2.1recoverBeams': QuestDNA(obsolete=False, questInt=3737, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Beam, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_WARSHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r6r1r2.2recoverBolts': QuestDNA(obsolete=False, questInt=3738, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Bolt, num=8, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r6r1.1needMoreFood': QuestDNA(obsolete=False, questInt=3362, questLink='c3r3r4r6r1r2.MastMaterials', tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DRIFTWOOD_ISLAND, item=QuestItems.Meat, num=20, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r6r1r2.1mastMaterials': QuestDNA(obsolete=False, questInt=3364, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Bowsprit, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_STORM_REAPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r6r1r2.2mastMaterials': QuestDNA(obsolete=False, questInt=3365, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Steelband, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_REVENANT, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r6r1.1recoverMeat': QuestDNA(obsolete=False, questInt=3736, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=20, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r8.1sailMaterials': QuestDNA(obsolete=False, questInt=3367, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.KINGSHEAD_ALL, item=QuestItems.Rope, num=12, enemyType=AvatarTypes.Mercenary, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r8.2sailMaterials': QuestDNA(obsolete=False, questInt=3368, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.KINGSHEAD_ALL, item=QuestItems.ClothPiece, num=14, enemyType=AvatarTypes.Dragoon, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r9.1shipArmor': QuestDNA(obsolete=False, questInt=3370, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Cannon, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_WARLORD, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r9.2shipFigure': QuestDNA(obsolete=False, questInt=3371, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Figure, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_BLACK_HARBINGER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.10recoverRum': QuestDNA(obsolete=False, questInt=3372, questLink='c3r3r4r11.DavyJonesArmy', tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_PREDATOR, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r11.1davyJonesArmy': QuestDNA(obsolete=False, questInt=3374, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_ALL, enemyType=AvatarTypes.Drip, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r11.2davyJonesArmy': QuestDNA(obsolete=False, questInt=3375, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_CAVE_B, enemyType=AvatarTypes.Drizzle, num=3, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r11.3davyJonesArmy': QuestDNA(obsolete=False, questInt=3376, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.TORMENTA_CAVE_B, item=QuestItems.Rudder, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.1visitBowdash': QuestDNA(obsolete=False, questInt=3700, tasks=(VisitTaskDNA(npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.2visitSmith': QuestDNA(obsolete=False, questInt=3701, tasks=(VisitTaskDNA(location=LocationIds.DRIFTWOOD_ISLAND, npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.3.5visitSmith': QuestDNA(obsolete=False, questInt=3714, tasks=(VisitTaskDNA(npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.4.5visitSmith': QuestDNA(obsolete=False, questInt=3727, tasks=(VisitTaskDNA(npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.5.5visitSmith': QuestDNA(obsolete=False, questInt=3735, tasks=(VisitTaskDNA(npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.7visitSmith': QuestDNA(obsolete=False, questInt=3742, tasks=(VisitTaskDNA(npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.8recoverSails': QuestDNA(obsolete=False, questInt=3743, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Sailcloth, num=10, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.9recoverRopes': QuestDNA(obsolete=False, questInt=3744, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Rope, num=8, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.10recoverCannons': QuestDNA(obsolete=False, questInt=3745, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Cannon, num=2, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_WARSHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.11recoverFigure': QuestDNA(obsolete=False, questInt=3746, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Figure, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.12recoverRum': QuestDNA(obsolete=False, questInt=3747, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=10, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.12.5visitBowdash': QuestDNA(obsolete=False, questInt=3748, tasks=(VisitTaskDNA(npcId=NPCIds.BOWDASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.12.51recoverKey': QuestDNA(obsolete=False, questInt=3749, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Key, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.BOWDASH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.12.52visitSmith': QuestDNA(obsolete=False, questInt=3750, tasks=(VisitTaskDNA(npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4.13visitJoshamee': QuestDNA(obsolete=False, questInt=3751, tasks=(VisitTaskDNA(npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1.1shipMaterials': QuestDNA(obsolete=False, questInt=3345, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_MARAUDER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1.2needFood': QuestDNA(obsolete=False, questInt=3346, questLink='c3r3r4r3r1r3.StarboardMaterials', tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DRIFTWOOD_ISLAND, item=QuestItems.Meat, num=10, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1r3.1starboardMaterials': QuestDNA(obsolete=False, questInt=3348, tasks=(RecoverShipItemTaskDNA(item=QuestItems.NailBox, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_MONARCH, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1r3.2starboardMaterials': QuestDNA(obsolete=False, questInt=3349, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BoltPack, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_MAN_O_WAR, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1.1recoverMeat': QuestDNA(obsolete=False, questInt=3702, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=15, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1r2.1recoverWood': QuestDNA(obsolete=False, questInt=3703, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=20, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1r2.2recoverNails': QuestDNA(obsolete=False, questInt=3704, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Nail, num=12, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1r2.3recoverNails': QuestDNA(obsolete=False, questInt=3705, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Nail, num=8, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r3r1r2.4recoverPitch': QuestDNA(obsolete=False, questInt=3706, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.NAVY_BARRELS, item=QuestItems.Pitch, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1r2.1portHullMaterials': QuestDNA(obsolete=False, questInt=3355, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BARRACUDA, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1r2.2portHullMaterials': QuestDNA(obsolete=False, questInt=3356, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.KINGSHEAD_ALL, containerId=PropIds.KH_BARRELS, item=QuestItems.Pitch, num=16, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1r2.3portHullMaterials': QuestDNA(obsolete=False, questInt=3357, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.KINGSHEAD_ALL, containerId=PropIds.KH_CRATES, item=QuestItems.Wire, num=16, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1.1recoverMeat': QuestDNA(obsolete=False, questInt=3715, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=15, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1r2.1recoverWood': QuestDNA(obsolete=False, questInt=3716, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=30, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1r2.2recoverNails': QuestDNA(obsolete=False, questInt=3717, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Nail, num=16, enemyType=AvatarTypes.Undead, level=7, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1r2.3recoverBeams': QuestDNA(obsolete=False, questInt=3718, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Beam, num=8, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r4r1r2.4recoverBolts': QuestDNA(obsolete=False, questInt=3719, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Bolt, num=6, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r5r1r2.1recoverWood': QuestDNA(obsolete=False, questInt=3729, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=20, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r5r1r2.2recoverNails': QuestDNA(obsolete=False, questInt=3730, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Nail, num=10, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r5r1.1needMoreFood': QuestDNA(obsolete=False, questInt=3358, questLink='c3r3r4r5r1r2.CabinMaterials', tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DRIFTWOOD_ISLAND, item=QuestItems.Meat, num=15, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r5r1r2.1cabinMaterials': QuestDNA(obsolete=False, questInt=3360, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_OGRE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r5r1r2.2cabinMaterials': QuestDNA(obsolete=False, questInt=3361, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Beam, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_PREDATOR, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'c3r3r4r5r1.1recoverMeat': QuestDNA(obsolete=False, questInt=3728, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=15, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5r1.1acquireCopper': QuestDNA(obsolete=False, questInt=2309, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CopperRod, num=4, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ERASMUS_GRIMSDITCH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5r1.2acquireGunPowder': QuestDNA(obsolete=False, questInt=2310, tasks=(RecoverShipItemTaskDNA(item=QuestItems.GunPowder, num=4, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ERASMUS_GRIMSDITCH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5r1.3defeatAlligatorBoss': QuestDNA(obsolete=False, questInt=2311, tasks=(DefeatNPCTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, npcId=NPCIds.DREADTOOTH),), rewards=(ReputationReward(amount=ExpRewards.SMALL), PistolUpgradeReward(amount=ItemId.PISTOL_L5)), returnGiverIds=(NPCIds.ERASMUS_GRIMSDITCH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5.1visitErasmus': QuestDNA(obsolete=False, questInt=2302, tasks=(VisitTaskDNA(npcId=NPCIds.ERASMUS_GRIMSDITCH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(DidQuest(questIds=('at1.0visitThayer',)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5.2acquirePistolParts': QuestDNA(obsolete=False, questInt=2303, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUTTHROAT_ISLAND, item=QuestItems.SpanishPistolComponent, num=6, enemyType=AvatarTypes.Spanish, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ERASMUS_GRIMSDITCH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5.3visitDelilah': QuestDNA(obsolete=False, questInt=2304, tasks=(VisitTaskDNA(npcId=NPCIds.DELILAH_DUNSMORE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5.4defeatFormerLove': QuestDNA(obsolete=False, questInt=2305, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.SAMUEL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5.5findGems': QuestDNA(obsolete=False, questInt=2306, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Gems, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DELILAH_DUNSMORE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5.6acquireWoodStocks': QuestDNA(obsolete=False, questInt=2307, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, item=QuestItems.GunStock, num=8, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pul5.7deliverToErasmus': QuestDNA(obsolete=False, questInt=2308, tasks=(VisitTaskDNA(npcId=NPCIds.ERASMUS_GRIMSDITCH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r1.1acquireArmor': QuestDNA(obsolete=False, questInt=2358, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUTTHROAT_ISLAND, item=QuestItems.SpanishArmor, num=1, enemyType=AvatarTypes.Spanish, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r1.2acquireHair': QuestDNA(obsolete=False, questInt=2359, tasks=(RecoverShipItemTaskDNA(item=QuestItems.LockOfHair, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r1.3findEarring': QuestDNA(obsolete=False, questInt=2360, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Earring, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r2.1defeatUndead': QuestDNA(obsolete=False, questInt=2361, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Muck, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r2.2defeatGeneralBloodless': QuestDNA(obsolete=False, questInt=2362, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.GENERAL_BLOODLESS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r3.1defeatUndead': QuestDNA(obsolete=False, questInt=2363, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Corpse, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r3.2defeatGeneralHex': QuestDNA(obsolete=False, questInt=2364, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.GENERAL_HEX),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r4.1defeatUndead': QuestDNA(obsolete=False, questInt=2365, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, enemyType=AvatarTypes.Corpse, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r4.2defeatGeneralSandspine': QuestDNA(obsolete=False, questInt=2366, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.GENERAL_SANDSPINE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r5.1defeatUndead': QuestDNA(obsolete=False, questInt=2367, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Carrion, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5r5.2defeatGeneralDarkhart': QuestDNA(obsolete=False, questInt=2368, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.GENERAL_DARKHART),), rewards=(ReputationReward(amount=ExpRewards.SMALL), DollUpgradeReward(amount=ItemId.DOLL_L5)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdul5.1visitTia': QuestDNA(obsolete=False, questInt=2357, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(DidQuest(questIds=('vdu4.0visitTiaDalma',)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5r1.1acquireSailcloth': QuestDNA(obsolete=False, questInt=2404, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Sailcloth, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5r1.2acquireWoodPlanks': QuestDNA(obsolete=False, questInt=2405, tasks=(RecoverShipItemTaskDNA(item=QuestItems.WoodenPlates, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5r1.3acquireRopes': QuestDNA(obsolete=False, questInt=2406, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Rope, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5r1.4acquireRigging': QuestDNA(obsolete=False, questInt=2407, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Spar, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5r2.1findNavySteel': QuestDNA(obsolete=False, questInt=2411, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, containerId=PropIds.KH_CRATES, item=QuestItems.NavySteel, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PHILLIP_FULLER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5r2.2acquireBoneHandle': QuestDNA(obsolete=False, questInt=2412, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneHandle, num=1, enemyType=AvatarTypes.Corpse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PHILLIP_FULLER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5.1visitBalthasar': QuestDNA(obsolete=False, questInt=2403, tasks=(VisitTaskDNA(npcId=NPCIds.BALTHASAR),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(DidQuest(questIds=('wt1.visitWillTurner',)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5.2visitMiguel': QuestDNA(obsolete=False, questInt=2408, tasks=(VisitTaskDNA(npcId=NPCIds.MIGUEL_MONTOYA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5.3defeatUndeadFrench': QuestDNA(obsolete=False, questInt=2409, tasks=(DefeatTaskDNA(location=LocationIds.ISLA_CANGREJOS, enemyType=AvatarTypes.French, num=6, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MIGUEL_MONTOYA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5.4visitPhillip': QuestDNA(obsolete=False, questInt=2410, tasks=(VisitTaskDNA(npcId=NPCIds.PHILLIP_FULLER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5.5defeatBossScorpion': QuestDNA(obsolete=False, questInt=2413, tasks=(DefeatNPCTaskDNA(location=LocationIds.RUMRUNNER_ISLE, npcId=NPCIds.VENOM_LASH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5.6visitGrog': QuestDNA(obsolete=False, questInt=2414, tasks=(VisitTaskDNA(npcId=NPCIds.DOC_GROG),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cul5.7visitFuller': QuestDNA(obsolete=False, questInt=2415, tasks=(VisitTaskDNA(npcId=NPCIds.PHILLIP_FULLER),), rewards=(CutlassUpgradeReward(amount=ItemId.CUTLASS_L5), ReputationReward(amount=ExpRewards.SMALL)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.1visitFerrar': QuestDNA(obsolete=False, questInt=2451, tasks=(VisitTaskDNA(npcId=NPCIds.FERRERA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(DidQuest(questIds=('jw1.visitJohnWallace',)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.2findNecklace': QuestDNA(obsolete=False, questInt=2452, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Necklace, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.3visitOrinda': QuestDNA(obsolete=False, questInt=2453, tasks=(VisitTaskDNA(npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.4defeatExHusband': QuestDNA(obsolete=False, questInt=2454, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.UNDEAD_TIMOTHY_DARTAN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.5visitMcKidd': QuestDNA(obsolete=False, questInt=2455, tasks=(VisitTaskDNA(npcId=NPCIds.BILLY_MCKIDD),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.6captureSwain': QuestDNA(obsolete=False, questInt=2456, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_SWAIN, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.7maroonSwain': QuestDNA(obsolete=False, questInt=2457, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.CAPTAIN_SWAIN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.8visitTia': QuestDNA(obsolete=False, questInt=2458, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.9defeatWitchdoctorBoss': QuestDNA(obsolete=False, questInt=2459, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.BONERATTLER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.10visitGrimm': QuestDNA(obsolete=False, questInt=2460, tasks=(VisitTaskDNA(npcId=NPCIds.ENSIGN_GRIMM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.10.5bribeGrimm': QuestDNA(obsolete=False, questInt=2461, tasks=(BribeNPCTaskDNA(npcId=NPCIds.ENSIGN_GRIMM, gold=Bribes.LARGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.11findDaggers': QuestDNA(obsolete=False, questInt=2462, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.StolenDaggers, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dul5.12visitFerrar': QuestDNA(obsolete=False, questInt=2463, tasks=(VisitTaskDNA(npcId=NPCIds.FERRERA),), rewards=(DaggerUpgradeReward(amount=ItemId.DAGGER_L5), ReputationReward(amount=ExpRewards.SMALL)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5r1.1acquireEITCBadge': QuestDNA(obsolete=False, questInt=2509, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.NEBAN_THE_HIRED_GUN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROLAND_RAGGART,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5r1.2acquireGoldHandleRapier': QuestDNA(obsolete=False, questInt=2510, tasks=(DefeatNPCTaskDNA(npcId=NPCIds.REMINGTON_THE_ASSASSIN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROLAND_RAGGART,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5r2.1defeatThugs': QuestDNA(obsolete=False, questInt=2511, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Thug, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5r2.2defeatGrunts': QuestDNA(obsolete=False, questInt=2512, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Stalker, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5r2.3defeatHiredGuns': QuestDNA(obsolete=False, questInt=2513, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Hiredgun, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5r2.4defeatMercenaries': QuestDNA(obsolete=False, questInt=2514, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Mercenary, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5r2.5defeatAssassins': QuestDNA(obsolete=False, questInt=2515, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Professional, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL), WandUpgradeReward(amount=ItemId.WAND_L5)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5.1visitRoland': QuestDNA(obsolete=False, questInt=2503, tasks=(VisitTaskDNA(npcId=NPCIds.ROLAND_RAGGART),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(DidQuest(questIds=('vsu4.0visitTiaDalma',)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5.2captureEITCCaptain': QuestDNA(obsolete=False, questInt=2504, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.CAPTAIN_ACKERS, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5.3visitRoland': QuestDNA(obsolete=False, questInt=2505, tasks=(VisitTaskDNA(npcId=NPCIds.ROLAND_RAGGART),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5.4maroonEITCCaptain': QuestDNA(obsolete=False, questInt=2506, tasks=(MaroonNPCTaskDNA(location=LocationIds.RUMRUNNER_ISLE, npcId=NPCIds.CAPTAIN_ACKERS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5.5retrieveStatuettes': QuestDNA(obsolete=False, questInt=2507, tasks=(RecoverShipItemTaskDNA(item=QuestItems.WoodenStatuette, num=6, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROLAND_RAGGART,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsul5.6acquireHighLevelUndeadBones': QuestDNA(obsolete=False, questInt=2508, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.SkeletonBone, num=7, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROLAND_RAGGART,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6.1duchamps': QuestDNA(obsolete=False, questInt=10132, tasks=(VisitTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, npcId=NPCIds.DUCHAMPS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.CAPT_EZEKIEL_ROTT,)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=15, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6.2ezekielRott': QuestDNA(obsolete=False, questInt=10133, tasks=(VisitTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, npcId=NPCIds.CAPT_EZEKIEL_ROTT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r3.1getInfo': QuestDNA(obsolete=False, questInt=10135, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CodedOrder, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_VANGUARD, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CAPT_EZEKIEL_ROTT,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r3.2getInfo': QuestDNA(obsolete=False, questInt=10136, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CodedOrder, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BLOODHOUND, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.CAPT_EZEKIEL_ROTT,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6.4visitNathan': QuestDNA(obsolete=False, questInt=10137, tasks=(VisitTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, npcId=NPCIds.NATHAN_GOULD),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r5.1gatherInfo': QuestDNA(obsolete=False, questInt=10139, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, item=QuestItems.SecretRecord, num=10, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r5.2gatherInfo': QuestDNA(obsolete=False, questInt=10140, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_SHELF, item=QuestItems.Intelligence, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r6.1interceptMessages': QuestDNA(obsolete=False, questInt=10142, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Message, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_CENTURION, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r6.2interceptMessages': QuestDNA(obsolete=False, questInt=10143, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Message, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_IRONWALL, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6.7visitSamuel': QuestDNA(obsolete=False, questInt=10144, tasks=(VisitTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, npcId=NPCIds.SAMUEL_SHAW),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r8.1defeatResistance': QuestDNA(obsolete=False, questInt=10146, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, enemyType=AvatarTypes.Officer, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r8.2defeatResistance': QuestDNA(obsolete=False, questInt=10147, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, enemyType=AvatarTypes.Hiredgun, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r8.3defeatResistance': QuestDNA(obsolete=False, questInt=10148, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, containerId=PropIds.DF_BQ_CRATES, item=QuestItems.ExcavationRecord, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r9.1disruptDefenses': QuestDNA(obsolete=False, questInt=10150, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, enemyType=AvatarTypes.Mercenary, num=3, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r9.2disruptDefenses': QuestDNA(obsolete=False, questInt=10151, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, enemyType=AvatarTypes.Dragoon, num=2, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r9.3disruptDefenses': QuestDNA(obsolete=False, questInt=10152, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_D, item=QuestItems.LostMap, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6.10visitJeremiah': QuestDNA(obsolete=False, questInt=10153, tasks=(DeliverItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.LostMap, num=1, npcId=NPCIds.JEREMIAH_DEDMAN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JEREMIAH_DEDMAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r11.1sinkExpedition': QuestDNA(obsolete=False, questInt=10155, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_KINGFISHER, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JEREMIAH_DEDMAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6r11.2sinkExpedition': QuestDNA(obsolete=False, questInt=10156, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_MARAUDER, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JEREMIAH_DEDMAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc6.12sinkPrizedShip': QuestDNA(obsolete=False, questInt=10157, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_OGRE, num=1, level=0, isFlagship=False),), rewards=(GoldAmountReward(amount=3000), ReputationReward(amount=ExpRewards.LARGE)), returnGiverIds=(NPCIds.JEREMIAH_DEDMAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wg.1visitJack': QuestDNA(obsolete=False, questInt=19070, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wg.2visitEwan': QuestDNA(obsolete=False, questInt=19071, tasks=(VisitTaskDNA(location=LocationIds.MCCRAKENS_WEAPONS, npcId=NPCIds.EWAN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wg.5recoverTar': QuestDNA(obsolete=False, questInt=19078, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.NAVY_BARRELS, item=QuestItems.Tar, num=10, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wg.6sinkShips': QuestDNA(obsolete=False, questInt=19079, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.TradingCo, num=4, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EWAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wg.8deliverBombs': QuestDNA(obsolete=False, questInt=19082, tasks=(DeliverItemTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, item=QuestItems.Grenade, num=24, npcId=NPCIds.JACK),), rewards=(GrenadeReward(), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr3.1recoverSaltpeter': QuestDNA(obsolete=False, questInt=19072, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, containerId=PropIds.KH_CRATES, item=QuestItems.Saltpeter, num=10, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr3.2recoverCharcoal': QuestDNA(obsolete=False, questInt=19073, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Charcoal, num=1, maxAttempts=Attempts.RARE, probability=Probability.VERY_RARE, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr3.3recoverSulfur': QuestDNA(obsolete=False, questInt=19074, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.KH_BARRELS, item=QuestItems.Sulfur, num=10, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr4.1recoverFuses': QuestDNA(obsolete=False, questInt=19075, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.KH_CRATES, item=QuestItems.Fuse, num=10, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr4.2recoverFlints': QuestDNA(obsolete=False, questInt=19076, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.FD_BARRELS, item=QuestItems.Flint, num=10, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr4.3recoverCasings': QuestDNA(obsolete=False, questInt=19077, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.KH_BARRELS, item=QuestItems.Casing, num=20, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr3.1grenadeMaterialsA': QuestDNA(obsolete=False, questInt=19704, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.FORT_CHARLES, item=QuestItems.Fuse, num=16, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr3.2grenadeMaterialsA': QuestDNA(obsolete=False, questInt=19705, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.FORT_CHARLES, containerId=PropIds.FC_CRATES, item=QuestItems.Flint, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr3.3grenadeMaterialsA': QuestDNA(obsolete=False, questInt=19706, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.FORT_CHARLES, containerId=PropIds.FC_BARRELS, item=QuestItems.Casing, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr4.1grenadeMaterialsB': QuestDNA(obsolete=False, questInt=19708, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, item=QuestItems.Saltpeter, num=14, enemyType=AvatarTypes.Officer, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr4.2grenadeMaterialsB': QuestDNA(obsolete=False, questInt=19709, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, containerId=PropIds.KH_CRATES, item=QuestItems.Charcoal, num=8, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr4.3grenadeMaterialsB': QuestDNA(obsolete=False, questInt=19710, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, containerId=PropIds.KH_BARRELS, item=QuestItems.Sulfur, num=8, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr5.1grenadeMaterialsC': QuestDNA(obsolete=False, questInt=19712, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, item=QuestItems.Powder, num=20, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr5.2grenadeMaterialsC': QuestDNA(obsolete=False, questInt=19713, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_CRATES, item=QuestItems.Wire, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr5.3grenadeMaterialsC': QuestDNA(obsolete=False, questInt=19714, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_BARRELS, item=QuestItems.Tar, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr6.SinkShips': QuestDNA(obsolete=False, questInt=19715, questLink='wg.8deliverBombs', tasks=(DefeatShipTaskDNA(hull=ShipGlobals.EITC_IRONWALL, num=5, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EWAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr7.1smuggleBombs': QuestDNA(obsolete=False, questInt=19080, tasks=(SmuggleItemTaskDNA(location=LocationIds.DEL_FUEGO_ISLAND, item=QuestItems.Grenade, num=16),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EWAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wgr7.2deliverBombs': QuestDNA(obsolete=False, questInt=19081, tasks=(DeliverItemTaskDNA(item=QuestItems.Grenade, num=12, npcId=NPCIds.BRONZE_JOHN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EWAN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr2.1recoverStraw': QuestDNA(obsolete=False, questInt=23101, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Straw, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr2.2recoverPitch': QuestDNA(obsolete=False, questInt=23102, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.FORT_CHARLES, containerId=PropIds.FC_BARRELS, item=QuestItems.Pitch, num=2, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr2.3recoverSilk': QuestDNA(obsolete=False, questInt=23103, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Silk, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr2.4recoverWire': QuestDNA(obsolete=False, questInt=23104, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.FORT_CHARLES, containerId=PropIds.FC_CRATES, item=QuestItems.Wire, num=2, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr4.1bloodOfRockCrab': QuestDNA(obsolete=False, questInt=23106, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=2, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr4.2bloodOfScorpion': QuestDNA(obsolete=False, questInt=23107, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=3, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr4.3bloodOfAlligator': QuestDNA(obsolete=False, questInt=23108, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=4, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr4.4bloodOfBat': QuestDNA(obsolete=False, questInt=23109, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=3, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr4.5bloodOfWasp': QuestDNA(obsolete=False, questInt=23110, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=2, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr6.1boneDustOfClod': QuestDNA(obsolete=False, questInt=23112, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Dust, num=3, enemyType=AvatarTypes.WillBurybones, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr6.2boneDustOfSludge': QuestDNA(obsolete=False, questInt=23113, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Dust, num=2, enemyType=AvatarTypes.Sludge, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr6.3boneDustOfMire': QuestDNA(obsolete=False, questInt=23114, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Dust, num=2, enemyType=AvatarTypes.Mire, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr6.4boneDustOfMuck': QuestDNA(obsolete=False, questInt=23115, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Dust, num=1, enemyType=AvatarTypes.Muck, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(DollReward(), ReputationReward(amount=ExpRewards.MEDIUM)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr2.1needMaterials': QuestDNA(obsolete=False, questInt=23116, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Straw, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_BULWARK, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr2.2needMaterials': QuestDNA(obsolete=False, questInt=23117, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Pitch, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_SEA_VIPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr3.1needBlood': QuestDNA(obsolete=False, questInt=23118, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.ANVIL_ISLAND, item=QuestItems.Blood, num=10, enemyType=AvatarTypes.StoneCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr3.2needBlood': QuestDNA(obsolete=False, questInt=23119, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.ANVIL_ISLAND, item=QuestItems.Blood, num=6, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr3.3needBlood': QuestDNA(obsolete=False, questInt=23120, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUBA_ALL, item=QuestItems.Blood, num=10, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr4.1needBoneDust': QuestDNA(obsolete=False, questInt=23121, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_A, item=QuestItems.Dust, num=10, enemyType=AvatarTypes.Sludge, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wdr4.2needBoneDust': QuestDNA(obsolete=False, questInt=23122, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_A, item=QuestItems.Dust, num=6, enemyType=AvatarTypes.Mire, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(DollReward(), ReputationReward(amount=ExpRewards.MEDIUM)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wd.1visitTia': QuestDNA(obsolete=False, questInt=23100, tasks=(VisitTaskDNA(location=LocationIds.CUBA_SWAMP, npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), finalizeInfo={'type': 'cutscene','sceneId': '6.1: Tia Showing Voodoo Doll','giverId': NPCIds.TIA_DALMA}, combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wk.1visitElizabeth': QuestDNA(obsolete=False, questInt=19050, tasks=(VisitTaskDNA(location=LocationIds.GOVERNORS_MANSION, npcId=NPCIds.ELIZABETH),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.ELIZABETH,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wk.2visitWill': QuestDNA(obsolete=False, questInt=19051, tasks=(VisitTaskDNA(location=LocationIds.RAMBLESHACK_INSIDE, npcId=NPCIds.WILL_TURNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wk.4visitElizabeth': QuestDNA(obsolete=False, questInt=19058, tasks=(VisitTaskDNA(location=LocationIds.GOVERNORS_MANSION, npcId=NPCIds.ELIZABETH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wk.5recoverMessage': QuestDNA(obsolete=False, questInt=19059, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Message, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_CORVETTE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ELIZABETH,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wk.6visitWill': QuestDNA(obsolete=False, questInt=19060, tasks=(VisitTaskDNA(location=LocationIds.RAMBLESHACK_INSIDE, npcId=NPCIds.WILL_TURNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wk.7deliverKnives': QuestDNA(obsolete=False, questInt=19061, tasks=(DeliverItemTaskDNA(location=LocationIds.GOVERNORS_MANSION, item=QuestItems.Knife, num=1, npcId=NPCIds.ELIZABETH),), rewards=(DaggerReward(), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.ELIZABETH,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr3.1daggerMaterialsA': QuestDNA(obsolete=False, questInt=19062, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Steel, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_PANTHER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr3.2daggerMaterialsA': QuestDNA(obsolete=False, questInt=19063, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Silver, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_SENTINEL, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr3.1recoverSteel': QuestDNA(obsolete=False, questInt=19052, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Steel, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr3.2recoverSilver': QuestDNA(obsolete=False, questInt=19053, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Silver, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr3.3recoverBone': QuestDNA(obsolete=False, questInt=19054, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bone, num=4, enemyType=AvatarTypes.Mire, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr3.4recoverTongs': QuestDNA(obsolete=False, questInt=19055, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tongs, num=1, enemyType=AvatarTypes.Guard, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr3.5recoverCoal': QuestDNA(obsolete=False, questInt=19056, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.NAVY_BARRELS, item=QuestItems.Coal, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr4.1daggerMaterialsB': QuestDNA(obsolete=False, questInt=19064, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_A_GRAVEYARD, item=QuestItems.Bone, num=14, enemyType=AvatarTypes.MuckCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr4.2daggerMaterialsB': QuestDNA(obsolete=False, questInt=19065, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_A_GRAVEYARD, item=QuestItems.Tongs, num=14, enemyType=AvatarTypes.Muck, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wkr4.3daggerMaterialsB': QuestDNA(obsolete=False, questInt=19066, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.TORTUGA_JUNGLE_A_GRAVEYARD, containerId=PropIds.T_G_BARRELS, item=QuestItems.Coal, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr2.1defeatCorpse': QuestDNA(obsolete=False, questInt=23051, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Carrion, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr2.2defeatCarrion': QuestDNA(obsolete=False, questInt=23052, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Cadaver, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr2.3defeatZombie': QuestDNA(obsolete=False, questInt=23053, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Zombie, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr3.1defeatWasp': QuestDNA(obsolete=False, questInt=23056, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.AngryWasp, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr3.2defeatGator': QuestDNA(obsolete=False, questInt=23057, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.HugeGator, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr3.3defeatScorpion': QuestDNA(obsolete=False, questInt=23058, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.DreadScorpion, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr3.4defeatCrab': QuestDNA(obsolete=False, questInt=23059, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.GiantCrab, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr3.5defeatFlyTrap': QuestDNA(obsolete=False, questInt=23060, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.FlyTrap, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr3.6defeatBat': QuestDNA(obsolete=False, questInt=23061, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.VampireBat, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.1defeatPortRoyal': QuestDNA(obsolete=False, questInt=23062, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.2defeatTortuga': QuestDNA(obsolete=False, questInt=23063, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.3defeatPadresDelFuego': QuestDNA(obsolete=False, questInt=23064, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.4defeatKingshead': QuestDNA(obsolete=False, questInt=23065, tasks=(DefeatTaskDNA(location=LocationIds.KINGSHEAD_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.5defeatCuba': QuestDNA(obsolete=False, questInt=23066, tasks=(DefeatTaskDNA(location=LocationIds.CUBA_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.6defeatRumrunners': QuestDNA(obsolete=False, questInt=23067, tasks=(DefeatTaskDNA(location=LocationIds.RUMRUNNER_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.4defeatDriftwood': QuestDNA(obsolete=False, questInt=23068, tasks=(DefeatTaskDNA(location=LocationIds.DRIFTWOOD_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.5defeatCangrejos': QuestDNA(obsolete=False, questInt=23069, tasks=(DefeatTaskDNA(location=LocationIds.CANGREJOS_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.6defeatPerdida': QuestDNA(obsolete=False, questInt=23070, tasks=(DefeatTaskDNA(location=LocationIds.PERDIDA_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.4defeatCutthroat': QuestDNA(obsolete=False, questInt=23071, tasks=(DefeatTaskDNA(location=LocationIds.CUTTHROAT_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.5defeatTormenta': QuestDNA(obsolete=False, questInt=23072, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.6defeatOutkast': QuestDNA(obsolete=False, questInt=23073, tasks=(DefeatTaskDNA(location=LocationIds.OUTCAST_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr4.6defeatAnvil': QuestDNA(obsolete=False, questInt=23074, tasks=(DefeatTaskDNA(location=LocationIds.ANVIL_ALL, enemyType=AvatarTypes.WillTurner, num=1, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr2.1proveHeart': QuestDNA(obsolete=False, questInt=23076, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.CadaverCutlass, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr2.2proveHeart': QuestDNA(obsolete=False, questInt=23077, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.Cadaver, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr2.3proveHeart': QuestDNA(obsolete=False, questInt=23078, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_CAVE_E, enemyType=AvatarTypes.Zombie, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr5.1powerUpA': QuestDNA(obsolete=False, questInt=23081, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Professional, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr5.2powerUpA': QuestDNA(obsolete=False, questInt=23082, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Dragoon, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr5.3powerUpA': QuestDNA(obsolete=False, questInt=23083, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Zombie, num=16, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr6.1powerUpB': QuestDNA(obsolete=False, questInt=23084, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_ALL, enemyType=AvatarTypes.Drip, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr6.2powerUpB': QuestDNA(obsolete=False, questInt=23085, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_ALL, enemyType=AvatarTypes.Damp, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wsr6.3powerUpB': QuestDNA(obsolete=False, questInt=23086, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_ALL, enemyType=AvatarTypes.Drizzle, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ws.1visitTia': QuestDNA(obsolete=False, questInt=23050, tasks=(VisitTaskDNA(location=LocationIds.CUBA_SWAMP, npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ws.3recoverStump': QuestDNA(obsolete=False, questInt=23054, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Branch, num=1, enemyType=AvatarTypes.Stump, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ws.4recoverHead': QuestDNA(obsolete=False, questInt=23055, tasks=(RecoverShipItemTaskDNA(item=QuestItems.ShrunkenHead, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ws.5deliverDoll': QuestDNA(obsolete=False, questInt=23075, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(StaffReward(bonus=False), ReputationReward(amount=ExpRewards.MEDIUM)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ws.3recoverBranch': QuestDNA(obsolete=False, questInt=23079, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_JUNGLE_B, item=QuestItems.Branch, num=6, enemyType=AvatarTypes.Stump, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ws.4recoverShrunkenHead': QuestDNA(obsolete=False, questInt=23080, questLink='wsr5.PowerUpA', tasks=(RecoverShipItemTaskDNA(item=QuestItems.ShrunkenHead, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_STORM_REAPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ws.7sinkHarbingers': QuestDNA(obsolete=False, questInt=23087, questLink='ws.5deliverDoll', tasks=(DefeatShipTaskDNA(hull=ShipGlobals.SKEL_BLACK_HARBINGER, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.1visitJack': QuestDNA(obsolete=False, questInt=19958, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=False, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=30, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.2sailToRavensCove': QuestDNA(obsolete=False, questInt=19959, tasks=(SailToTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.3searchForSurvivors': QuestDNA(obsolete=False, questInt=19963, tasks=(VisitTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, npcId=NPCIds.EDWARD_BRITTLE),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.helpAllGhosts': QuestDNA(obsolete=False, questInt=19965, tasks=(CompleteQuestContainerTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, containerIds=('rc.ghosts.ThomasFishmeister', 'rc.ghosts.MadamZigana', 'rc.ghosts.SenorFantifico', 'rc.ghosts.WidowThreadbarren', 'rc.ghosts.TheClubhearts')),), returnGiverIds=(NPCIds.EDWARD_BRITTLE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.zigana.brewPotions': QuestDNA(obsolete=False, questInt=19967, tasks=(PotionsTaskDNA(location=LocationIds.POTION_ISLANDS, potionType=ItemGlobals.STAFF_ENCHANT_1, num=3, potionTypeBonus=ItemGlobals.STAFF_ENCHANT_2, numBonus=1),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM), StaffReward(bonus=True)), returnGiverIds=(NPCIds.MADAM_ZIGANA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.fishmeister.catchFish': QuestDNA(obsolete=False, questInt=19969, tasks=(FishingTaskDNA(location=LocationIds.FISHING_ISLANDS, fishType=InventoryType.Collection_Set10_Part5, num=12, fishTypeBonus=InventoryType.Collection_Set11, numBonus=1),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM), CharmReward(bonus=True)), returnGiverIds=(NPCIds.THOMAS_FISHMEISTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.fantifico.visitTiaDalma': QuestDNA(obsolete=False, questInt=19981, tasks=(VisitTaskDNA(location=LocationIds.CUBA_SWAMP, npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.fantifico.1potionIngredients': QuestDNA(obsolete=False, questInt=19983, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.TwistedRoot, num=6, enemyType=AvatarTypes.TwistedStump, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.fantifico.2potionIngredients': QuestDNA(obsolete=False, questInt=19984, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GiantBladder, num=10, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.fantifico.3potionIngredients': QuestDNA(obsolete=False, questInt=19985, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FatChicken, num=8, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_DREADNOUGHT, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.fantifico.deliverPotion': QuestDNA(obsolete=False, questInt=19986, tasks=(DeliverItemTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, item=QuestItems.RevivingPotion, num=1, npcId=NPCIds.SENOR_FANTIFICO),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.SENOR_FANTIFICO,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, questMod=[NPCIds.SENOR_FANTIFICO, ['switchVisualMode', '"notChickenFantifico"'], ['switchVisualMode', '"notChickenFantifico"'], ['switchVisualMode', '"chickenFantifico"']], timeLimit=0),'rc.ghosts.threadbarren.1retrieveSails': QuestDNA(obsolete=False, questInt=19989, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedSail, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_PHANTOM, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WIDOW_THREADBARREN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.threadbarren.2retrieveSails': QuestDNA(obsolete=False, questInt=19990, tasks=(RecoverShipItemTaskDNA(item=QuestItems.TornSail, num=7, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_REVENANT, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WIDOW_THREADBARREN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.threadbarren.3retrieveSails': QuestDNA(obsolete=False, questInt=19991, tasks=(RecoverShipItemTaskDNA(item=QuestItems.UndeadSail, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.SKEL_STORM_REAPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WIDOW_THREADBARREN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.clubhearts.undeadPoker': QuestDNA(obsolete=False, questInt=19993, tasks=(SkeletonPokerTaskDNA(gold=PokerPots.BIG, goldBonus=PokerPots.GIANT, containerId=PropIds.UNDEAD_POKER_TABLE),), rewards=(ClothingQuestReward(amount=ClothingGlobals.POKER_BONUS_HAT, bonus=True), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.BEN_CLUBHEART,), instanceInfo=(INSTANCE_REF_TYPE_AREA, LocationIds.UNDEAD_POKER_SHACK_INTERIOR), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.ghosts.clubhearts.disguise': QuestDNA(obsolete=False, questInt=19996, tasks=(GoToTaskDNA(location=LocationIds.TORTUGA_JUNGLE_B_SWAMPY, npcId=NPCIds.SKELETON_POKER_BOUNCER),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.1findJournals': QuestDNA(obsolete=False, questInt=19972, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.RAVENS_COVE_MINE, treasureId=TreasureIds.RC_CHESTS, item=QuestItems.Journal, num=4, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.3defendTraitor': QuestDNA(obsolete=False, questInt=19974, tasks=(DefendNPCTaskDNA(location=LocationIds.RAVENS_COVE_MINE, enemyType=AvatarTypes.TraitorGhost, containerId=PropIds.RC_GRAVE_2),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.5useDowsingRod': QuestDNA(obsolete=False, questInt=19976, tasks=(DowsingRodTaskDNA(location=LocationIds.RAVENS_COVE_MINE, treasureId=TreasureIds.RC_CHESTS_2, num=4, item=QuestItems.Idol),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.6getLastIdol': QuestDNA(obsolete=False, questInt=19977, tasks=(DefeatAroundPropTaskDNA(location=LocationIds.RAVENS_COVE_MINE, enemyType=AvatarTypes.Ghost, containerId=PropIds.RC_GRAVE_3, itemId=QuestItems.Idol),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.7defeatKudgel': QuestDNA(obsolete=False, questInt=19978, tasks=(DefeatNPCTaskDNA(location=LocationIds.RAVENS_COVE_MINE, npcId=NPCIds.KUDGEL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, questMod=[NPCIds.KUDGEL, None, ['turnAggro', ''], ['turnFriendlyAndHide', '']], timeLimit=0),'rc.le.9defeatElPatron': QuestDNA(obsolete=False, questInt=19994, tasks=(DefeatNPCTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, goalLocation=LocationIds.RAVENS_COVE_SHIP, npcId=NPCIds.EL_PATRON),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.10lootTreasure': QuestDNA(obsolete=False, questInt=19995, tasks=(LootPropTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, containerId=PropIds.RC_CHEST_1),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.2lureGhosts': QuestDNA(obsolete=False, questInt=19973, tasks=(DefeatNearPropTaskDNA(location=LocationIds.RAVENS_COVE_MINE, enemyType=AvatarTypes.MutineerGhost, num=5, level=0, containerId=PropIds.RC_GRAVE_1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.2AlureGhosts': QuestDNA(obsolete=False, questInt=20002, tasks=(DefeatNearPropTaskDNA(location=LocationIds.RAVENS_COVE_MINE, enemyType=AvatarTypes.DeviousGhost, num=5, level=0, containerId=PropIds.RC_GRAVE_1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.8exploreElPatronsShip': QuestDNA(obsolete=False, questInt=20003, tasks=(GoToTaskDNA(containerId=PropIds.RC_CHEST_1),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.le.4FindPartsBats': QuestDNA(obsolete=False, questInt=20004, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tooth, num=13, enemyType=AvatarTypes.FireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DR_BELLROG,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.3bTalkToEdward': QuestDNA(obsolete=False, questInt=19979, tasks=(GoToTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, npcId=NPCIds.EDWARD_BRITTLE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.talkToBellrog': QuestDNA(obsolete=False, questInt=19997, tasks=(VisitTaskDNA(location=LocationIds.RAVENS_COVE_MINE, npcId=NPCIds.DR_BELLROG),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rc.useMineShaft': QuestDNA(obsolete=False, questInt=19998, tasks=(GoToTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, containerId=PropIds.RC_MINE_SHAFT_1),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=False, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rct.findHiddenPieces': QuestDNA(obsolete=False, questInt=20000, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.RAVENS_COVE_ISLAND, containerId=PropIds.RC_CRATES, item=QuestItems.TotemPiece, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(RavensCoveTeleportReward(),), returnGiverIds=(NPCIds.EDWARD_BRITTLE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pvr1.1acquireCrossbones': QuestDNA(obsolete=False, questInt=2529, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bone, num=2, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.SID_TACKEM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pvr1.2acquireNavyCoat': QuestDNA(obsolete=False, questInt=2530, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.NavyCoat, num=1, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.SID_TACKEM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pvr1.3acquireNavyButtons': QuestDNA(obsolete=False, questInt=2531, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BrassButton, num=5, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.SID_TACKEM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pvr1.4acquireGatorSkin': QuestDNA(obsolete=False, questInt=2532, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorSkin, num=3, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.INFREQUENT, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.SID_TACKEM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pvr1.5acquireScorpionBlood': QuestDNA(obsolete=False, questInt=2533, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScorpionBlood, num=3, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.SID_TACKEM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.1visitPirate': QuestDNA(obsolete=False, questInt=2528, tasks=(VisitTaskDNA(npcId=NPCIds.SID_TACKEM),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), prereqs=(GetFrom(questGivers=(NPCIds.ERIN_AMOROUS,)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, holiday=HolidayGlobals.VALENTINESDAY, timeLimit=0),'pv.2deliverValentine': QuestDNA(obsolete=False, questInt=2534, tasks=(VisitTaskDNA(npcId=NPCIds.DEDRIE_DUNNAM),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.3visitPirate': QuestDNA(obsolete=False, questInt=2535, tasks=(VisitTaskDNA(npcId=NPCIds.SID_TACKEM),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.4visitErin': QuestDNA(obsolete=False, questInt=2536, tasks=(VisitTaskDNA(npcId=NPCIds.ERIN_AMOROUS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.5visitScarlet': QuestDNA(obsolete=False, questInt=2537, tasks=(VisitTaskDNA(npcId=NPCIds.SCARLET),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.6bribeGiladoga': QuestDNA(obsolete=False, questInt=2538, tasks=(BribeNPCTaskDNA(npcId=NPCIds.GILADOGA, gold=Bribes.MEDIUM, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.7visitScarlet': QuestDNA(obsolete=False, questInt=2539, tasks=(VisitTaskDNA(npcId=NPCIds.SCARLET),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.8deliverFlower': QuestDNA(obsolete=False, questInt=2540, tasks=(VisitTaskDNA(npcId=NPCIds.DEDRIE_DUNNAM),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pv.9collectReward': QuestDNA(obsolete=False, questInt=2541, tasks=(VisitTaskDNA(npcId=NPCIds.SID_TACKEM),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL), ClothingQuestReward(amount=ClothingGlobals.VALENTINES_SHIRT, bonus=False)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.1acquireMastsOfSunkenShips': QuestDNA(obsolete=False, questInt=4105, tasks=(RecoverShipItemTaskDNA(item=QuestItems.SunkenShipMast, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.2acquireSkeletonBones': QuestDNA(obsolete=False, questInt=4106, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.SkeletonBone, num=8, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.3acquirePortRoyalBattleEarth': QuestDNA(obsolete=False, questInt=4107, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.4acquireTortugaBattleEarth': QuestDNA(obsolete=False, questInt=4108, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.5acquirePadresDelFuegoBattleEarth': QuestDNA(obsolete=False, questInt=4109, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.6acquireKingsheadBattleEarth': QuestDNA(obsolete=False, questInt=4110, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.KINGSHEAD_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.7acquireCubaBattleEarth': QuestDNA(obsolete=False, questInt=4111, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUBA_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.8acquireRumrunnersBattleEarth': QuestDNA(obsolete=False, questInt=4112, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.RUMRUNNER_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.9acquireDriftwoodBattleEarth': QuestDNA(obsolete=False, questInt=4113, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DRIFTWOOD_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.10acquireCangrejosBattleEarth': QuestDNA(obsolete=False, questInt=4114, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CANGREJOS_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.11acquirePerdidaBattleEarth': QuestDNA(obsolete=False, questInt=4115, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PERDIDA_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.12acquireCutthroatBattleEarth': QuestDNA(obsolete=False, questInt=4116, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUTTHROAT_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.13acquireTormentaBattleEarth': QuestDNA(obsolete=False, questInt=4117, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORMENTA_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.14acquireOutkastBattleEarth': QuestDNA(obsolete=False, questInt=4118, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.OUTCAST_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r1.15acquireAnvilBattleEarth': QuestDNA(obsolete=False, questInt=4119, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.ANVIL_ALL, item=QuestItems.BattleEarth, num=1, enemyType=AvatarTypes.WillTurner, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r2.1retrieveScorpionVenom': QuestDNA(obsolete=False, questInt=4123, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScorpionVenom, num=6, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r2.2retrieveAlligatorTeeth': QuestDNA(obsolete=False, questInt=4124, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorTooth, num=6, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r2.3retrieveWaspStinger': QuestDNA(obsolete=False, questInt=4125, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Stinger, num=6, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r2.4retrieveCrabClaw': QuestDNA(obsolete=False, questInt=4126, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrabClaw, num=6, enemyType=AvatarTypes.Crab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r2.5retrieveBatClaw': QuestDNA(obsolete=False, questInt=4127, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatClaw, num=6, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4r2.6retrieveBattleSaltWater': QuestDNA(obsolete=False, questInt=4128, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BattleSaltWater, num=6, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4.1visitRomanyBev': QuestDNA(obsolete=False, questInt=4103, tasks=(VisitTaskDNA(npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4.2returnToTia': QuestDNA(obsolete=False, questInt=4104, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4.4retrieveFirstPieceOfRelic': QuestDNA(obsolete=False, questInt=4121, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RelicPiece, num=1, enemyType=AvatarTypes.Cadaver, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4.5retrieveRestOfPiecesOfRelic': QuestDNA(obsolete=False, questInt=4122, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RelicPiece, num=5, enemyType=AvatarTypes.Carrion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4.6returnToTia': QuestDNA(obsolete=False, questInt=4129, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(DollUpgradeReward(amount=ItemId.DOLL_L4), ReputationReward(amount=ExpRewards.SMALL)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vdu4.0visitTiaDalma': QuestDNA(obsolete=False, questInt=4130, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r1.1acquireGatorEyes': QuestDNA(obsolete=False, questInt=4152, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorEye, num=4, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r1.2acquireWasps': QuestDNA(obsolete=False, questInt=4153, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Wasp, num=6, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r1.3acquireScorpionEyes': QuestDNA(obsolete=False, questInt=4154, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScorpionEye, num=6, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r1.4acquireBatEyes': QuestDNA(obsolete=False, questInt=4155, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatEye, num=6, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r2.1acquireSkeletonRibs': QuestDNA(obsolete=False, questInt=4158, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.SkeletonRib, num=15, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r2.2acquireNavyBadges': QuestDNA(obsolete=False, questInt=4159, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Badge, num=5, enemyType=AvatarTypes.Officer, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r2.3acquireScorpionStingers': QuestDNA(obsolete=False, questInt=4160, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Stinger, num=5, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r2.4acquireCrabShells': QuestDNA(obsolete=False, questInt=4161, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrabShell, num=5, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r3.1acquireStumpBranch': QuestDNA(obsolete=False, questInt=4163, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Branch, num=5, enemyType=AvatarTypes.Stump, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r3.2acquireFlyTrapRoot': QuestDNA(obsolete=False, questInt=4164, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FlyTrapRoot, num=5, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r3.3acquireWritsOfAuthority': QuestDNA(obsolete=False, questInt=4165, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WritOfAuthority, num=3, enemyType=AvatarTypes.Mercenary, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4r3.4acquireStrongerRibs': QuestDNA(obsolete=False, questInt=4166, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.SkeletonRib, num=15, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4.1visitRoland': QuestDNA(obsolete=False, questInt=4151, tasks=(VisitTaskDNA(npcId=NPCIds.ROLAND_RAGGART),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4.3acquireOrb': QuestDNA(obsolete=False, questInt=4157, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CloudyBlueOrb, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.EXTREMELY_RARE, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_WARSHIP, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4.5returnToRoland': QuestDNA(obsolete=False, questInt=4167, tasks=(VisitTaskDNA(npcId=NPCIds.ROLAND_RAGGART),), rewards=(WandUpgradeReward(amount=ItemId.WAND_L4), ReputationReward(amount=ExpRewards.SMALL)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'vsu4.0visitTiaDalma': QuestDNA(obsolete=False, questInt=4168, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc1r1.1governorsMessage': QuestDNA(obsolete=False, questInt=10102, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, enemyType=AvatarTypes.Cadet, num=12, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CAPT_EZEKIEL_ROTT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=1, minWeapLevel=0, hideButton=False, timeLimit=0),'dc1r1.2governorsMessage': QuestDNA(obsolete=False, questInt=10103, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, goalLocation=LocationIds.GOVERNORS_MANSION_COURTYARD, containerId=PropIds.PR_BARREL_1, item=QuestItems.Message, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CAPT_EZEKIEL_ROTT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc1r2.1defensePlans': QuestDNA(obsolete=False, questInt=10105, tasks=(DefeatTaskDNA(location=LocationIds.FORT_CHARLES, enemyType=AvatarTypes.Navy, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.CAPT_EZEKIEL_ROTT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc1r2.2defensePlans': QuestDNA(obsolete=False, questInt=10106, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.FORT_CHARLES, containerId=PropIds.FC_SHELF, item=QuestItems.DefensePlans, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(GoldAmountReward(amount=500), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.CAPT_EZEKIEL_ROTT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc2r1.1voodooRelics': QuestDNA(obsolete=False, questInt=10109, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, enemyType=AvatarTypes.Marine, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=8, minWeapLevel=0, hideButton=False, timeLimit=0),'dc2r1.2voodooRelics': QuestDNA(obsolete=False, questInt=10110, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, item=QuestItems.VoodooRelic, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc2r2.2voodooRelics': QuestDNA(obsolete=False, questInt=10111, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_A, item=QuestItems.VoodooRelic, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(GoldAmountReward(amount=1000), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc2r2.1voodooRelics': QuestDNA(obsolete=False, questInt=10159, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_A, enemyType=AvatarTypes.Navy, num=4, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SAMUEL_SHAW,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc3r1.1voodooRelics': QuestDNA(obsolete=False, questInt=10114, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_C, item=QuestItems.Meat, num=4, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILL_BARRETT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=12, minWeapLevel=0, hideButton=False, timeLimit=0),'dc3r1.2voodooRelics': QuestDNA(obsolete=False, questInt=10115, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_C, item=QuestItems.Meat, num=14, enemyType=AvatarTypes.DireScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILL_BARRETT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc3r1.3voodooRelics': QuestDNA(obsolete=False, questInt=10116, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.PORT_ROYAL_JUNGLE_C, item=QuestItems.VoodooRelic, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILL_BARRETT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc3.2voodooRelics': QuestDNA(obsolete=False, questInt=10117, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_B, item=QuestItems.VoodooRelic, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(GoldAmountReward(amount=2000), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.BILL_BARRETT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc4r1.1poisonNavy': QuestDNA(obsolete=False, questInt=10120, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, enemyType=AvatarTypes.Sergeant, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=16, minWeapLevel=0, hideButton=False, timeLimit=0),'dc4r1.2poisonNavy': QuestDNA(obsolete=False, questInt=10121, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, enemyType=AvatarTypes.Thug, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc4r1.3poisonNavy': QuestDNA(obsolete=False, questInt=10122, tasks=(PoisonContainerTaskDNA(location=LocationIds.PORT_ROYAL_CAVE_A, containerId=PropIds.RC_BARRELS, item=QuestItems.TBD, num=3, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc4r2.1poisonFortCharles': QuestDNA(obsolete=False, questInt=10124, tasks=(DefeatTaskDNA(location=LocationIds.FORT_CHARLES, enemyType=AvatarTypes.Veteran, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc4r2.2poisonFortCharles': QuestDNA(obsolete=False, questInt=10125, tasks=(PoisonContainerTaskDNA(location=LocationIds.FORT_CHARLES, containerId=PropIds.FC_BARRELS, item=QuestItems.TBD, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(GoldAmountReward(amount=2500), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.NATHAN_GOULD,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc5r1.1defeatNavy': QuestDNA(obsolete=False, questInt=10128, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_VANGUARD, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JEREMIAH_DEDMAN,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=20, minWeapLevel=0, hideButton=False, timeLimit=0),'dc5r1.2defeatNavy': QuestDNA(obsolete=False, questInt=10129, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_CENTURION, num=3, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JEREMIAH_DEDMAN,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dc5r1.3defeatNavy': QuestDNA(obsolete=False, questInt=10130, tasks=(DefeatShipTaskDNA(hull=ShipGlobals.NAVY_KINGFISHER, num=1, level=0, isFlagship=False),), rewards=(GoldAmountReward(amount=3000), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.JEREMIAH_DEDMAN,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpr.2LucindasTrust': QuestDNA(obsolete=False, questInt=21007, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ALL, enemyType=AvatarTypes.Corpse, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpr.3LucindasTrust': QuestDNA(obsolete=False, questInt=21008, questLink='tptpr.4recoverFirstMedal', tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ALL, enemyType=AvatarTypes.Sergeant, num=8, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpr.1visitLucinda': QuestDNA(obsolete=False, questInt=21013, tasks=(VisitTaskDNA(location=LocationIds.PORT_ROYAL_ISLAND, npcId=NPCIds.LUCINDA),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpr.2gainLucindaTrust': QuestDNA(obsolete=False, questInt=21014, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Corpse, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpr.3gainLucindaTrustAgain': QuestDNA(obsolete=False, questInt=21015, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Veteran, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpr.4recoverFirstMedal': QuestDNA(obsolete=False, questInt=21016, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.FirstMedal, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.FREQUENT),), rewards=(PortRoyalTeleportReward(), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptcr1.1NavyCoats': QuestDNA(obsolete=False, questInt=21021, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.NavyCoat, num=1, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptcr1.2FlyTrapRoots': QuestDNA(obsolete=False, questInt=21022, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FlyTrapRoot, num=1, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(CubaTeleportReward(), ReputationReward(amount=ExpRewards.MEDIUM)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptcr2.1payment': QuestDNA(obsolete=False, questInt=21023, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_ALL, item=QuestItems.GatorScales, num=20, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptcr2.2payment': QuestDNA(obsolete=False, questInt=21024, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_ALL, item=QuestItems.FlyTrapRoot, num=3, enemyType=AvatarTypes.RancidFlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(CubaTeleportReward(), ReputationReward(amount=ExpRewards.MEDIUM)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptc.1visitTiaDalma': QuestDNA(obsolete=False, questInt=21020, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdfr1.1FaceWeakUndead': QuestDNA(obsolete=False, questInt=21026, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Corpse, num=6, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdfr1.2FaceStrongerUndead': QuestDNA(obsolete=False, questInt=21027, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Carrion, num=6, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdfr1.3FaceStrongUndead': QuestDNA(obsolete=False, questInt=21028, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Cadaver, num=6, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdfr2.1payment': QuestDNA(obsolete=False, questInt=21030, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.CarrionKnife, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdfr2.2payment': QuestDNA(obsolete=False, questInt=21031, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Carrion, num=14, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdfr2.3payment': QuestDNA(obsolete=False, questInt=21032, tasks=(DefeatTaskDNA(location=LocationIds.DEL_FUEGO_ALL, enemyType=AvatarTypes.Cadaver, num=4, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdf.1visitRomany': QuestDNA(obsolete=False, questInt=21025, tasks=(VisitTaskDNA(npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptpdf.2FindArtifact': QuestDNA(obsolete=False, questInt=21029, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.EyeOfNabai, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(PadresDelFuegoTeleportReward(), ReputationReward(amount=ExpRewards.MEDIUM)), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt2.recoverNavyCoats': QuestDNA(obsolete=False, questInt=23005, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.NavyCoat, num=5, enemyType=AvatarTypes.Guard, level=0, probability=Probability.INFREQUENT, maxAttempts=Attempts.RARE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt2.recoverNavyPants': QuestDNA(obsolete=False, questInt=23006, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.NavyPants, num=5, enemyType=AvatarTypes.Guard, level=0, probability=Probability.INFREQUENT, maxAttempts=Attempts.RARE),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt2.recoverABadge': QuestDNA(obsolete=False, questInt=23007, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.SargeantsBadge, num=1, enemyType=AvatarTypes.Sergeant, level=0, probability=Probability.INFREQUENT, maxAttempts=Attempts.FREQUENT),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt2.recoverNavyMuskets': QuestDNA(obsolete=False, questInt=23003, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.NavyMuskets, num=5, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), prereqs=(GetFrom(questGivers=(NPCIds.SHANE_MCGREENY,)),), returnGiverIds=(NPCIds.SHANE_MCGREENY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=10, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt2.recoverLocationDocument': QuestDNA(obsolete=False, questInt=23008, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.FortTreasureDocument, num=1, enemyType=AvatarTypes.Veteran, level=0, probability=Probability.INFREQUENT, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(PlayingCardTier2Reward(),), returnGiverIds=(NPCIds.SHANE_MCGREENY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tr.1visitElizabeth': QuestDNA(obsolete=False, questInt=19800, tasks=(VisitTaskDNA(npcId=NPCIds.ELIZABETH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tr.2captureLuther': QuestDNA(obsolete=False, questInt=19801, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.LUTHER, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_CENTURION, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tr.3visitElizabeth': QuestDNA(obsolete=False, questInt=19802, tasks=(VisitTaskDNA(npcId=NPCIds.ELIZABETH),), rewards=(CollectReward(amount=InventoryType.Collection_Set3),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tr2.1deliverPaintings': QuestDNA(obsolete=False, questInt=19803, tasks=(DeliverItemTaskDNA(item=QuestItems.Painting, num=9, npcId=NPCIds.ELIZABETH),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.ELIZABETH,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.ELIZABETH), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tt.2recoverTeeth': QuestDNA(obsolete=False, questInt=19809, questLink='TreasureTeeth2', tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_ALL, item=QuestItems.Tooth, num=25, enemyType=AvatarTypes.CorpseCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(CollectReward(amount=InventoryType.Collection_Set5),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tt.1visitJack': QuestDNA(obsolete=False, questInt=19810, tasks=(VisitTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tt.2recoverTooth': QuestDNA(obsolete=False, questInt=19811, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Tooth, num=1, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(CollectReward(amount=InventoryType.Collection_Set5),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tt2.1deliverTeeth': QuestDNA(obsolete=False, questInt=19812, tasks=(DeliverItemTaskDNA(location=LocationIds.FAITHFULBRIDE_TAVERN, item=QuestItems.Tooth, num=28, npcId=NPCIds.JACK),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tt2.2recoverGold': QuestDNA(obsolete=False, questInt=19813, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Treasure, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(GoldReward(amount=18), ReputationReward(amount=ExpRewards.LARGE)), returnGiverIds=(NPCIds.JACK,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.JACK), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tm.1visitWill': QuestDNA(obsolete=False, questInt=19820, tasks=(VisitTaskDNA(npcId=NPCIds.WILL_TURNER),), rewards=(CollectReward(amount=InventoryType.Collection_Set4),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tm2.1deliverMedals': QuestDNA(obsolete=False, questInt=19821, tasks=(DeliverItemTaskDNA(item=QuestItems.Medal, num=14, npcId=NPCIds.WILL_TURNER),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.WILL_TURNER,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tm2.2recoverReagent': QuestDNA(obsolete=False, questInt=19822, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Reagent, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.VERY_RARE, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(GoldReward(amount=21), ReputationReward(amount=ExpRewards.SMALL)), returnGiverIds=(NPCIds.WILL_TURNER,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tm2.2recoverReagents': QuestDNA(obsolete=False, questInt=19823, questLink='TreasureRings', tasks=(RecoverShipItemTaskDNA(item=QuestItems.Reagent, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_MARAUDER, level=0, isFlagship=False),), rewards=(GoldReward(amount=21), ReputationReward(amount=ExpRewards.SMALL)), returnGiverIds=(NPCIds.WILL_TURNER,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.WILL_TURNER), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'trr.1visitBarbossa': QuestDNA(obsolete=False, questInt=19830, tasks=(VisitTaskDNA(npcId=NPCIds.BARBOSSA),), rewards=(CollectReward(amount=InventoryType.Collection_Set6),), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.BARBOSSA), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'trr2.1deliverRings': QuestDNA(obsolete=False, questInt=19831, tasks=(DeliverItemTaskDNA(item=QuestItems.Ring, num=10, npcId=NPCIds.BARBOSSA),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.BARBOSSA,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.BARBOSSA), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'trr2.2recoverRing': QuestDNA(obsolete=False, questInt=19832, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Ring, num=1, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.BARBOSSA,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.BARBOSSA), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'trr2.2recoverRings': QuestDNA(obsolete=False, questInt=19927, questLink='TreasureChess', tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Ring, num=25, enemyType=AvatarTypes.CadaverCutlass, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.BARBOSSA,), instanceInfo=(INSTANCE_REF_TYPE_OBJECT, NPCIds.BARBOSSA), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tc.1visitJoshamee': QuestDNA(obsolete=False, questInt=19835, tasks=(VisitTaskDNA(npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tc.2poker': QuestDNA(obsolete=False, questInt=19836, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(CollectReward(amount=InventoryType.Collection_Set7),), returnGiverIds=(NPCIds.JOSHAMEE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tc2.1deliverChess': QuestDNA(obsolete=False, questInt=19837, tasks=(DeliverItemTaskDNA(item=QuestItems.ChessPiece, num=32, npcId=NPCIds.JOSHAMEE),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.JOSHAMEE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tf.1visitTia': QuestDNA(obsolete=False, questInt=19840, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(CollectReward(amount=InventoryType.Collection_Set8),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tf2.1deliverFigurines': QuestDNA(obsolete=False, questInt=19841, tasks=(DeliverItemTaskDNA(item=QuestItems.Figurine, num=15, npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), returnGiverIds=(NPCIds.TIA_DALMA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ccbm.1poker': QuestDNA(obsolete=False, questInt=19945, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.BLACK_MACK,)),), returnGiverIds=(NPCIds.BLACK_MACK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ccbm.2defeatSkeleton': QuestDNA(obsolete=False, questInt=19946, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=1, level=0),), rewards=(PlayingCardReward(amount=1),), returnGiverIds=(NPCIds.BLACK_MACK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ccbm.1winAtPoker': QuestDNA(obsolete=False, questInt=19947, tasks=(PokerTaskDNA(gold=PokerPots.SMALL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.BLACK_MACK,)),), returnGiverIds=(NPCIds.BLACK_MACK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ccbm.2defeatUndead': QuestDNA(obsolete=False, questInt=19948, questLink='TeleportTotem', tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ALL, enemyType=AvatarTypes.MireKnife, num=16, level=0),), rewards=(PlayingCardReward(amount=1),), returnGiverIds=(NPCIds.BLACK_MACK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptr1.1recoverBat': QuestDNA(obsolete=False, questInt=21002, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatWings, num=3, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptr1.2recoverWasp': QuestDNA(obsolete=False, questInt=21003, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EssenceOfWasp, num=3, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptr1.3recoverLeaf': QuestDNA(obsolete=False, questInt=21005, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FlyTrapLeaf, num=1, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptr1.1tortugaPayment': QuestDNA(obsolete=False, questInt=21017, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUBA_ALL, item=QuestItems.Tooth, num=20, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptr1.2tortugaPayment': QuestDNA(obsolete=False, questInt=21018, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUBA_ALL, item=QuestItems.AlligatorTail, num=16, enemyType=AvatarTypes.BayouGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tptr1.3tortugaPayment': QuestDNA(obsolete=False, questInt=21019, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.CUBA_ALL, item=QuestItems.FlyTrapLeaf, num=3, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tpt.1visitTia': QuestDNA(obsolete=False, questInt=21001, tasks=(VisitTaskDNA(npcId=NPCIds.TIA_DALMA),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'tpt.2recoverArtifact': QuestDNA(obsolete=False, questInt=21006, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.TortuganArtifact, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(TeleportTotemReward(), ReputationReward(amount=ExpRewards.MEDIUM)), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'bw1.1recoverpowder': QuestDNA(obsolete=False, questInt=22000, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Powder, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_GREYHOUND, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), prereqs=(GetFrom(questGivers=(NPCIds.BARTHOLOMEW_WATKINS,)),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'bw1.1recovercotton': QuestDNA(obsolete=False, questInt=22002, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CottonYard, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.EITC_BLOODHOUND, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), prereqs=(GetFrom(questGivers=(NPCIds.BARTHOLOMEW_WATKINS,)),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'bw1.1recoveriron': QuestDNA(obsolete=False, questInt=22004, tasks=(RecoverShipItemTaskDNA(item=QuestItems.IronBar, num=1, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, hull=ShipGlobals.NAVY_FERRET, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), prereqs=(GetFrom(questGivers=(NPCIds.BARTHOLOMEW_WATKINS,)),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'lu1.recovercrabshells': QuestDNA(obsolete=False, questInt=22300, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrabShell, num=2, enemyType=AvatarTypes.Crab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(GoldReward(amount=5),), prereqs=(GetFrom(questGivers=(NPCIds.LUCINDA,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'lu1.recoveralligatortails': QuestDNA(obsolete=False, questInt=22302, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.AlligatorTail, num=2, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'lu1.recoverscorpionblood': QuestDNA(obsolete=False, questInt=22306, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScorpionBlood, num=2, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_FREQUENT),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dd1.recoverwood': QuestDNA(obsolete=False, questInt=22400, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), prereqs=(GetFrom(questGivers=(NPCIds.DARBY_DRYDOCK,)),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dd1.recoveriron': QuestDNA(obsolete=False, questInt=22402, tasks=(RecoverShipItemTaskDNA(item=QuestItems.IronBar, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dd1.recovercopper': QuestDNA(obsolete=False, questInt=22404, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CopperRod, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dd1.recovercloth': QuestDNA(obsolete=False, questInt=22406, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Sailcloth, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jm1.1recoverrumbarrels': QuestDNA(obsolete=False, questInt=22500, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), prereqs=(GetFrom(questGivers=(NPCIds.JOSIE_MCREEDY,)),), returnGiverIds=(NPCIds.JOSIE_MCREEDY,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jm1.3recoverwhiskeybarrels': QuestDNA(obsolete=False, questInt=22502, tasks=(RecoverShipItemTaskDNA(item=QuestItems.WhiskeyBarrel, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.JOSIE_MCREEDY,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jm1.5recoverglasses': QuestDNA(obsolete=False, questInt=22504, tasks=(RecoverShipItemTaskDNA(item=QuestItems.SetOfBarGlasses, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.JOSIE_MCREEDY,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jm1.7recoverhoney': QuestDNA(obsolete=False, questInt=22506, tasks=(RecoverShipItemTaskDNA(item=QuestItems.HoneyBarrel, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.JOSIE_MCREEDY,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rs1.1recovertools': QuestDNA(obsolete=False, questInt=22600, tasks=(RecoverShipItemTaskDNA(item=QuestItems.SmithingTools, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), prereqs=(GetFrom(questGivers=(NPCIds.R_SMITH_PEWTERER,)),), returnGiverIds=(NPCIds.R_SMITH_PEWTERER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rs1.3recoveriron': QuestDNA(obsolete=False, questInt=22602, tasks=(RecoverShipItemTaskDNA(item=QuestItems.IronBar, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.R_SMITH_PEWTERER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'rs1.5recovercoal': QuestDNA(obsolete=False, questInt=22604, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CoalBag, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(GoldReward(amount=5),), returnGiverIds=(NPCIds.R_SMITH_PEWTERER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pc.1visitSam': QuestDNA(obsolete=False, questInt=22900, tasks=(VisitTaskDNA(npcId=NPCIds.SAM_SEABONES),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), prereqs=(GetFrom(questGivers=(NPCIds.PETER_CHIPPARR,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pc.2visitPeter': QuestDNA(obsolete=False, questInt=22901, tasks=(VisitTaskDNA(npcId=NPCIds.PETER_CHIPPARR),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pc.3QuestionNavyOfficers': QuestDNA(obsolete=False, questInt=22902, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.PeterAttackerName, num=1, enemyType=AvatarTypes.Navy, level=0, probability=Probability.RARE, maxAttempts=Attempts.FREQUENT),), rewards=(GoldReward(amount=5), ReputationReward(amount=ExpRewards.TRIVIAL)), returnGiverIds=(NPCIds.PETER_CHIPPARR,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pc.5FindNavySwine': QuestDNA(obsolete=False, questInt=22904, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.OFFICER_MILLER, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.INFREQUENT, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pc.6MaroonNavySwine': QuestDNA(obsolete=False, questInt=22905, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.OFFICER_MILLER),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pc.7visitPeter3': QuestDNA(obsolete=False, questInt=22906, tasks=(VisitTaskDNA(npcId=NPCIds.PETER_CHIPPARR),), rewards=(GoldReward(amount=5), ReputationReward(amount=ExpRewards.SMALL)), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mercenary_job': QuestDNA(obsolete=False, questInt=20027, tasks=(RandomizedDefeatTaskDNA(),), prereqs=(GetFrom(questGivers=(NPCIds.JOSIE_MCREEDY,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'naval_mercenary_job': QuestDNA(obsolete=False, questInt=20028, tasks=(RandomizedDefeatShipTaskDNA(),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mercenary_job_tortuga': QuestDNA(obsolete=False, questInt=20029, tasks=(RandomizedDefeatTaskDNA(),), prereqs=(GetFrom(questGivers=(NPCIds.JOHNNY_MCVANE,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'naval_mercenary_job_tortuga': QuestDNA(obsolete=False, questInt=20030, tasks=(RandomizedDefeatShipTaskDNA(),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt1.defeatCadets': QuestDNA(obsolete=False, questInt=23000, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ALL, enemyType=AvatarTypes.Cadet, num=8, level=0),), prereqs=(GetFrom(questGivers=(NPCIds.SHANE_MCGREENY,)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt1.retrievekey': QuestDNA(obsolete=False, questInt=23001, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.PrisonKey, num=1, enemyType=AvatarTypes.Guard, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(PlayingCardTier1Reward(),), returnGiverIds=(NPCIds.SHANE_MCGREENY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'0': QuestDNA(obsolete=False, questInt=20011, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=2, level=0),), rewards=(GoldReward(amount=3),), prereqs=(GetFrom(questGivers=(NPCIds.SAM_SEABONES,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'1141416661.17sdnaik': QuestDNA(obsolete=False, questInt=20015, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Earring, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.FREQUENT),), prereqs=(GetFrom(questGivers=(NPCIds.SAM_SEABONES,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'1141781456.75sdnaik': QuestDNA(obsolete=False, questInt=20017, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.Earring, num=1, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(GoldReward(amount=3),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'2': QuestDNA(obsolete=False, questInt=20018, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Key, num=1, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(GoldReward(amount=3),), prereqs=(GetFrom(questGivers=(NPCIds.SAM_SEABONES,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt3.stealGuardSchedule': QuestDNA(obsolete=False, questInt=23020, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.PORT_ROYAL_ALL, item=QuestItems.GuardSchedule, num=1, enemyType=AvatarTypes.Sergeant, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), prereqs=(GetFrom(questGivers=(NPCIds.SHANE_MCGREENY,)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=20, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt3.defeatVeterans': QuestDNA(obsolete=False, questInt=23021, tasks=(DefeatTaskDNA(location=LocationIds.PORT_ROYAL_ALL, enemyType=AvatarTypes.Veteran, num=2, level=0),), returnGiverIds=(NPCIds.SHANE_MCGREENY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt3.stealShipSchedule': QuestDNA(obsolete=False, questInt=23023, tasks=(RecoverShipItemTaskDNA(item=QuestItems.NavySchedule, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt3.maroonCaptain': QuestDNA(obsolete=False, questInt=23024, tasks=(MaroonNPCTaskDNA(location=LocationIds.ANY_WILD_ISLAND, npcId=NPCIds.COMMANDER_GENTRY),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt3.startCrimeWave': QuestDNA(obsolete=False, questInt=23025, tasks=(VisitTaskDNA(npcId=NPCIds.SIMON_HORNBOW),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt3.getReward': QuestDNA(obsolete=False, questInt=23026, tasks=(VisitTaskDNA(npcId=NPCIds.SHANE_MCGREENY),), rewards=(PlayingCardTier3Reward(),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'cards.prt3.captureCaptain': QuestDNA(obsolete=False, questInt=23027, tasks=(CaptureShipNPCTaskDNA(npcId=NPCIds.COMMANDER_GENTRY, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.INFREQUENT, hull=ShipIds.ANY_WARSHIP, faction=AvatarTypes.Navy, level=0, isFlagship=False),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'FathersDay2008.1visitGiladoga': QuestDNA(obsolete=False, questInt=10002, tasks=(VisitTaskDNA(location=LocationIds.RATSKELLAR_TAVERN, npcId=NPCIds.GILADOGA),), rewards=(ReputationReward(amount=ExpRewards.MEDIUM),), prereqs=(GetFrom(questGivers=(NPCIds.JACK_ROWDY_ROOSTER,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'FathersDay2008.3visitBronzeJohn': QuestDNA(obsolete=False, questInt=10005, tasks=(VisitTaskDNA(npcId=NPCIds.BRONZE_JOHN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'FathersDay2008t2.1bribeBronzeJohn': QuestDNA(obsolete=False, questInt=10006, tasks=(BribeNPCTaskDNA(npcId=NPCIds.BRONZE_JOHN, gold=Bribes.LARGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BRONZE_JOHN,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'FathersDay2008t4.1sinkShips': QuestDNA(obsolete=False, questInt=10007, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CaptTeague, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, hull=ShipIds.ANY_LARGE_SHIP, level=0, isFlagship=False),), rewards=(TempDoubleRepReward(amount=DoubleRepTime.THREEHOUR), GoldAmountReward(amount=500)), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'FathersDay2008t1.1RockCrabs': QuestDNA(obsolete=False, questInt=10003, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=3, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'FathersDay2008t1.2WitchDoctor': QuestDNA(obsolete=False, questInt=10004, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Paper, num=1, enemyType=AvatarTypes.Muck, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mercenary_job_em': QuestDNA(obsolete=False, questInt=20031, tasks=(RandomizedDefeatTaskDNA(),), prereqs=(GetFrom(questGivers=(NPCIds.CAPTAIN_JOB,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa1.trackDownJewels': QuestDNA(obsolete=False, questInt=24002, tasks=(VisitTaskDNA(npcId=NPCIds.OLIVIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.PERLA_ALODIA,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa1.bribeOlivier': QuestDNA(obsolete=False, questInt=24003, tasks=(BribeNPCTaskDNA(npcId=NPCIds.OLIVIER, gold=Bribes.LARGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa1.gatherRubyStones': QuestDNA(obsolete=False, questInt=24004, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Rubies, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PERLA_ALODIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa1.gatherAmethystStones': QuestDNA(obsolete=False, questInt=24005, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Amethyst, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PERLA_ALODIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa1.gatherSapphireStones': QuestDNA(obsolete=False, questInt=24006, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Sapphire, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PERLA_ALODIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa1.defeatPerlasEnemy': QuestDNA(obsolete=False, questInt=24007, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=10, level=15),), rewards=(JewelryQuestReward(amount=JewelryGlobals.PERLA_ALODIA_QUEST_A),), returnGiverIds=(NPCIds.PERLA_ALODIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.sinkEITCShipA': QuestDNA(obsolete=False, questInt=24105, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_EITC_CORVETTE, faction=AvatarTypes.TradingCo, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.sinkEITCShipB': QuestDNA(obsolete=False, questInt=24106, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_EITC_SEA_VIPER, faction=AvatarTypes.TradingCo, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.sinkEITCShipC': QuestDNA(obsolete=False, questInt=24107, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_EITC_MARAUDER, faction=AvatarTypes.TradingCo, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.sinkEITCShipD': QuestDNA(obsolete=False, questInt=24108, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_EITC_BARRACUDA, faction=AvatarTypes.TradingCo, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.visitJohnnyMcvane': QuestDNA(obsolete=False, questInt=24102, tasks=(VisitTaskDNA(npcId=NPCIds.JOHNNY_MCVANE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.DAJIN_MING,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.visitOrindaLeJeune': QuestDNA(obsolete=False, questInt=24103, tasks=(VisitTaskDNA(npcId=NPCIds.ORINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.sinkFirstEITCShip': QuestDNA(obsolete=False, questInt=24104, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.TradingCo, num=1, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.visitDajinMing': QuestDNA(obsolete=False, questInt=24109, tasks=(VisitTaskDNA(npcId=NPCIds.DAJIN_MING),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.defeatNavyShips': QuestDNA(obsolete=False, questInt=24111, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=10, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DAJIN_MING,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm1.visitOrindaLeJeune2': QuestDNA(obsolete=False, questInt=24114, tasks=(VisitTaskDNA(npcId=NPCIds.ORINDA),), rewards=(JewelryQuestReward(amount=JewelryGlobals.DAJIN_MING_QUEST_A),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.visitBingham': QuestDNA(obsolete=False, questInt=24201, tasks=(VisitTaskDNA(npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.JEWELER_SMITTY,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatBinghamListA': QuestDNA(obsolete=False, questInt=24202, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatBinghamListB': QuestDNA(obsolete=False, questInt=24203, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Scorpion, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatBinghamListC': QuestDNA(obsolete=False, questInt=24204, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Bat, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatBinghamListD': QuestDNA(obsolete=False, questInt=24205, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Wasp, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatBinghamListE': QuestDNA(obsolete=False, questInt=24206, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Alligator, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.visitJimWavemonger': QuestDNA(obsolete=False, questInt=24208, tasks=(VisitTaskDNA(npcId=NPCIds.JIM_WAVEMONGER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatWarmongerListA': QuestDNA(obsolete=False, questInt=24209, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CopperRod, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JIM_WAVEMONGER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatWarmongerListB': QuestDNA(obsolete=False, questInt=24210, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Oil, num=3, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JIM_WAVEMONGER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatWarmongerListC': QuestDNA(obsolete=False, questInt=24211, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Steel, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JIM_WAVEMONGER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.defeatWarmongerListD': QuestDNA(obsolete=False, questInt=24212, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Coal, num=10, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JIM_WAVEMONGER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.visitBingham2': QuestDNA(obsolete=False, questInt=24214, tasks=(VisitTaskDNA(npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js1.visitJewelerSmitty': QuestDNA(obsolete=False, questInt=24215, tasks=(VisitTaskDNA(npcId=NPCIds.JEWELER_SMITTY),), rewards=(JewelryQuestReward(amount=JewelryGlobals.JEWELER_SMITTY_QUEST_A),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.visitLucinda': QuestDNA(obsolete=False, questInt=24301, tasks=(VisitTaskDNA(npcId=NPCIds.LUCINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.SOLOMON_ODOUGAL,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.visitJimWavemonger': QuestDNA(obsolete=False, questInt=24307, tasks=(VisitTaskDNA(npcId=NPCIds.JIM_WAVEMONGER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.recoverCursedWood': QuestDNA(obsolete=False, questInt=24308, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.CursedWood, num=2, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.deliverFineInk': QuestDNA(obsolete=False, questInt=24309, tasks=(DeliverItemTaskDNA(item=QuestItems.FineInk, num=1, npcId=NPCIds.SOLOMON_ODOUGAL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.visitWilliamTurk': QuestDNA(obsolete=False, questInt=24310, tasks=(VisitTaskDNA(npcId=NPCIds.WILLIAM_TURK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.playPoker': QuestDNA(obsolete=False, questInt=24311, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.playBlackjack': QuestDNA(obsolete=False, questInt=24312, tasks=(BlackjackTaskDNA(gold=PokerPots.MEDIUM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.deliverTattooPattern': QuestDNA(obsolete=False, questInt=24314, tasks=(DeliverItemTaskDNA(item=QuestItems.TattooPattern, num=1, npcId=NPCIds.SOLOMON_ODOUGAL),), rewards=(TattooQuestReward(amount=TattooGlobals.SOLOMON_ODOUGAL_QUEST_A),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.recoverBlood': QuestDNA(obsolete=False, questInt=24302, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Blood, num=10, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.recoverGatorSaliva': QuestDNA(obsolete=False, questInt=24303, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorSaliva, num=5, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.recoverNeedle': QuestDNA(obsolete=False, questInt=24304, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Needle, num=5, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.recoverBoneDust': QuestDNA(obsolete=False, questInt=24305, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneDust, num=10, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd1.recoverSulfur': QuestDNA(obsolete=False, questInt=24306, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Sulfur, num=5, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.visitButcherBrown': QuestDNA(obsolete=False, questInt=24401, tasks=(VisitTaskDNA(npcId=NPCIds.BUTCHER_BROWN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.LALA_LOVEL,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverAlligatorMeat': QuestDNA(obsolete=False, questInt=24403, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=5, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverFlyTrapMeat': QuestDNA(obsolete=False, questInt=24404, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=5, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverSkeletonMeat': QuestDNA(obsolete=False, questInt=24405, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=5, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverRockCrabMeat': QuestDNA(obsolete=False, questInt=24406, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=5, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverBatMeat': QuestDNA(obsolete=False, questInt=24407, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Meat, num=5, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.visitLala': QuestDNA(obsolete=False, questInt=24408, tasks=(VisitTaskDNA(npcId=NPCIds.LALA_LOVEL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.visitFabiola': QuestDNA(obsolete=False, questInt=24409, tasks=(VisitTaskDNA(npcId=NPCIds.FABIOLA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverBoneDust': QuestDNA(obsolete=False, questInt=24410, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BoneDust, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverWax': QuestDNA(obsolete=False, questInt=24411, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Wax, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverTar': QuestDNA(obsolete=False, questInt=24412, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Tar, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverBattleSaltWater': QuestDNA(obsolete=False, questInt=24413, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BattleSaltWater, num=5, maxAttempts=Attempts.VERY_FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.visitLala2': QuestDNA(obsolete=False, questInt=24415, tasks=(VisitTaskDNA(npcId=NPCIds.LALA_LOVEL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.visitBlacksmithFlinty': QuestDNA(obsolete=False, questInt=24416, tasks=(VisitTaskDNA(npcId=NPCIds.BLACKSMITH_FLINTY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.recoverIronBars': QuestDNA(obsolete=False, questInt=24417, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.IronBar, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BLACKSMITH_FLINTY,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll1.visitLala3': QuestDNA(obsolete=False, questInt=24418, tasks=(VisitTaskDNA(npcId=NPCIds.LALA_LOVEL),), rewards=(TattooQuestReward(amount=TattooGlobals.LALA_LOVEL_QUEST_A),), returnGiverIds=(NPCIds.LALA_LOVEL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.visitShochettPrymme': QuestDNA(obsolete=False, questInt=24501, tasks=(VisitTaskDNA(npcId=NPCIds.SHOCHETT_PRYMME),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.MERCEDES_CORAZON,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.recoverEITCList': QuestDNA(obsolete=False, questInt=24508, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_CABINET, item=QuestItems.Document, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.deliverDocument': QuestDNA(obsolete=False, questInt=24509, tasks=(DeliverItemTaskDNA(item=QuestItems.Document, num=1, npcId=NPCIds.RICO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.RICO,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.recoverInformation': QuestDNA(obsolete=False, questInt=24510, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Message, num=1, enemyType=AvatarTypes.TradingCo, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.bribeRico': QuestDNA(obsolete=False, questInt=24511, tasks=(BribeNPCTaskDNA(npcId=NPCIds.RICO, gold=Bribes.LARGE, bribeType=1),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.RICO,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.recoverDeskKey': QuestDNA(obsolete=False, questInt=24512, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_BARRELS, item=QuestItems.Key, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.recoverDeed': QuestDNA(obsolete=False, questInt=24513, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_DESK, item=QuestItems.Deed, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.deliverDeed': QuestDNA(obsolete=False, questInt=24514, tasks=(DeliverItemTaskDNA(item=QuestItems.Deed, num=1, npcId=NPCIds.MERCEDES_CORAZON),), rewards=(TattooQuestReward(amount=TattooGlobals.MERCEDES_CORAZON_QUEST_A),), returnGiverIds=(NPCIds.MERCEDES_CORAZON,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.defeatSkeletons': QuestDNA(obsolete=False, questInt=24502, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneShavings, num=10, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.defeatVampireBat': QuestDNA(obsolete=False, questInt=24503, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatWings, num=2, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.defeatFlyTrapsA': QuestDNA(obsolete=False, questInt=24504, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FlyTrapRoot, num=5, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.defeatFlyTrapsB': QuestDNA(obsolete=False, questInt=24505, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FlyTrapLeaf, num=5, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.defeatDreadScorpions': QuestDNA(obsolete=False, questInt=24506, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScorpionVenom, num=5, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc1.defeatAlligators': QuestDNA(obsolete=False, questInt=24507, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.AlligatorTail, num=10, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.visitOlivier': QuestDNA(obsolete=False, questInt=24601, tasks=(VisitTaskDNA(npcId=NPCIds.OLIVIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.PERLA_ALODIA,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverNavyFlags': QuestDNA(obsolete=False, questInt=24602, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Flag, num=6, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverEITCFlags': QuestDNA(obsolete=False, questInt=24603, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Flag, num=6, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverNavyPants': QuestDNA(obsolete=False, questInt=24605, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.NavyPants, num=10, enemyType=AvatarTypes.Navy, level=10, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverNavyCoats': QuestDNA(obsolete=False, questInt=24606, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.NavyCoat, num=10, enemyType=AvatarTypes.Navy, level=10, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverEITCCoats': QuestDNA(obsolete=False, questInt=24607, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EITCCoat, num=10, enemyType=AvatarTypes.TradingCo, level=10, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverEITCPants': QuestDNA(obsolete=False, questInt=24608, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EITCPants, num=10, enemyType=AvatarTypes.TradingCo, level=10, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.visitPerla': QuestDNA(obsolete=False, questInt=24610, tasks=(VisitTaskDNA(npcId=NPCIds.PERLA_ALODIA),), rewards=(JewelryQuestReward(amount=JewelryGlobals.PERLA_ALODIA_QUEST_B),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverWarrants': QuestDNA(obsolete=False, questInt=24611, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_ALL, item=QuestItems.ArrestWarrant, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverPrisonKeys': QuestDNA(obsolete=False, questInt=24612, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, item=QuestItems.PrisonKey, num=5, enemyType=AvatarTypes.Navy, level=10, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'pa2.recoverSchedule': QuestDNA(obsolete=False, questInt=24613, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_DESK, item=QuestItems.NavySchedule, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.recoverShopApplication': QuestDNA(obsolete=False, questInt=24701, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.EITC_OUTPOST, containerId=PropIds.T_OUTPOST_DESK, item=QuestItems.ShopApplication, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.DAJIN_MING,)),), returnGiverIds=(NPCIds.DAJIN_MING,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.deliverShopApplication': QuestDNA(obsolete=False, questInt=24702, tasks=(DeliverItemTaskDNA(item=QuestItems.ShopApplication, num=1, npcId=NPCIds.DAJIN_MING),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.visitBoatswainBill': QuestDNA(obsolete=False, questInt=24703, tasks=(VisitTaskDNA(npcId=NPCIds.BOATSWAIN_BILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.recoverCoinBag': QuestDNA(obsolete=False, questInt=24704, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.BOATSWAINS_HOUSE, containerId=PropIds.T_BOATSWAIN_DESK, item=QuestItems.CoinBag, num=1, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOATSWAIN_BILL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.deliverCoinBag': QuestDNA(obsolete=False, questInt=24705, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.BIG_PHIL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BIG_PHIL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.recoverChickens': QuestDNA(obsolete=False, questInt=24706, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chicken, num=6, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BIG_PHIL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.recoverPigs': QuestDNA(obsolete=False, questInt=24707, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Pig, num=6, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BIG_PHIL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.visitSeamstressAnne': QuestDNA(obsolete=False, questInt=24710, tasks=(VisitTaskDNA(npcId=NPCIds.SEAMSTRESS_ANNE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.recoverAlligatorHides': QuestDNA(obsolete=False, questInt=24711, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.recoverFlyTrapHides': QuestDNA(obsolete=False, questInt=24712, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.recoverBatHides': QuestDNA(obsolete=False, questInt=24713, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.visitBoatswainBill2': QuestDNA(obsolete=False, questInt=24715, tasks=(VisitTaskDNA(npcId=NPCIds.BOATSWAIN_BILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BOATSWAIN_BILL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.deliverContract': QuestDNA(obsolete=False, questInt=24716, tasks=(DeliverItemTaskDNA(item=QuestItems.Contract, num=1, npcId=NPCIds.DAJIN_MING),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DAJIN_MING,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.defeatEITC': QuestDNA(obsolete=False, questInt=24717, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.TradingCo, num=5, level=0),), rewards=(JewelryQuestReward(amount=JewelryGlobals.DAJIN_MING_QUEST_B),), returnGiverIds=(NPCIds.DAJIN_MING,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'dm2.visitBoatswainBill3': QuestDNA(obsolete=False, questInt=24718, tasks=(VisitTaskDNA(npcId=NPCIds.BOATSWAIN_BILL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.visitSmitty': QuestDNA(obsolete=False, questInt=24801, tasks=(VisitTaskDNA(npcId=NPCIds.JEWELER_SMITTY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.SARAH,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.deliverBloodSample': QuestDNA(obsolete=False, questInt=24802, tasks=(DeliverItemTaskDNA(item=QuestItems.BloodSample, num=1, npcId=NPCIds.LUCINDA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.LUCINDA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.deliverList': QuestDNA(obsolete=False, questInt=24803, tasks=(DeliverItemTaskDNA(item=QuestItems.List, num=1, npcId=NPCIds.EDWARD_SHACKLEBY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_SHACKLEBY,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.bribeEdward': QuestDNA(obsolete=False, questInt=24804, tasks=(BribeNPCTaskDNA(npcId=NPCIds.EDWARD_SHACKLEBY, gold=Bribes.LARGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_SHACKLEBY,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.recoverMedicine': QuestDNA(obsolete=False, questInt=24805, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Remedy, num=6, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_CORVETTE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SARAH,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.recoverBandages': QuestDNA(obsolete=False, questInt=24806, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Bandages, num=4, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_SEA_VIPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SARAH,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.recoverMedicalTools': QuestDNA(obsolete=False, questInt=24807, tasks=(RecoverShipItemTaskDNA(item=QuestItems.MedicalTools, num=2, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_BARRACUDA, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SARAH,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.findSmittysStuff': QuestDNA(obsolete=False, questInt=24809, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.PersonalEffects, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SARAH,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.deliverMessage': QuestDNA(obsolete=False, questInt=24810, tasks=(DeliverItemTaskDNA(item=QuestItems.Message, num=1, npcId=NPCIds.EDWARD_STORMHAWK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_STORMHAWK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'js2.defeatNavyGuards': QuestDNA(obsolete=False, questInt=24811, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Navy, num=10, level=0),), rewards=(JewelryQuestReward(amount=JewelryGlobals.JEWELER_SMITTY_QUEST_B),), returnGiverIds=(NPCIds.SARAH,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.visitFernando': QuestDNA(obsolete=False, questInt=24901, tasks=(VisitTaskDNA(npcId=NPCIds.FERNANDO),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.MERCEDES_CORAZON,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.recoverVenom': QuestDNA(obsolete=False, questInt=24902, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Venom, num=5, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.recoverClaw': QuestDNA(obsolete=False, questInt=24903, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrabClaw, num=5, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.recoverBoneDust': QuestDNA(obsolete=False, questInt=24904, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneDust, num=5, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.recoverBarnacles': QuestDNA(obsolete=False, questInt=24906, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Barnacles, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.recoverSaltWater': QuestDNA(obsolete=False, questInt=24907, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BattleSaltWater, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.recoverCursedWood': QuestDNA(obsolete=False, questInt=24908, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedWood, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.deliverSalve': QuestDNA(obsolete=False, questInt=24910, tasks=(DeliverItemTaskDNA(item=QuestItems.Salve, num=1, npcId=NPCIds.OLIVIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.playBlackjack': QuestDNA(obsolete=False, questInt=24911, tasks=(BlackjackTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.FERNANDO,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'mc2.visitMercedes': QuestDNA(obsolete=False, questInt=24912, tasks=(VisitTaskDNA(npcId=NPCIds.MERCEDES_CORAZON),), rewards=(TattooQuestReward(amount=TattooGlobals.MERCEDES_CORAZON_QUEST_B),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.visitSlim': QuestDNA(obsolete=False, questInt=25001, tasks=(VisitTaskDNA(npcId=NPCIds.SLIM),), prereqs=(GetFrom(questGivers=(NPCIds.LALA_LOVEL,)),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.deliverCoinBag': QuestDNA(obsolete=False, questInt=25002, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.JACK_REDRAT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JACK_REDRAT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.recoverDiary': QuestDNA(obsolete=False, questInt=25003, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.Diary, num=1, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JACK_REDRAT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.defeatWildWoodA': QuestDNA(obsolete=False, questInt=25004, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_JUNGLE_C, enemyType=AvatarTypes.Scorpion, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.defeatWildWoodB': QuestDNA(obsolete=False, questInt=25005, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_JUNGLE_C, enemyType=AvatarTypes.Undead, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.defeatWildWoodC': QuestDNA(obsolete=False, questInt=25006, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Alligator, num=2, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.defeatWildWoodD': QuestDNA(obsolete=False, questInt=25007, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Bat, num=2, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.recoverPlanks': QuestDNA(obsolete=False, questInt=25009, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.recoverNails': QuestDNA(obsolete=False, questInt=25010, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Nail, num=15, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.recoverSaw': QuestDNA(obsolete=False, questInt=25011, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Saw, num=5, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.recoverBeams': QuestDNA(obsolete=False, questInt=25012, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Beam, num=5, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.recoverTin': QuestDNA(obsolete=False, questInt=25013, tasks=(RecoverShipItemTaskDNA(item=QuestItems.TinShipment, num=5, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.visitLala': QuestDNA(obsolete=False, questInt=25015, tasks=(VisitTaskDNA(npcId=NPCIds.LALA_LOVEL),), rewards=(TattooQuestReward(amount=TattooGlobals.LALA_LOVEL_QUEST_B),), returnGiverIds=(NPCIds.LALA_LOVEL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.1cleanupWildwoods': QuestDNA(obsolete=False, questInt=25017, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_JUNGLE_C, enemyType=AvatarTypes.Scorpion, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'ll2.2cleanupWildwoods': QuestDNA(obsolete=False, questInt=25018, tasks=(DefeatTaskDNA(location=LocationIds.TORTUGA_JUNGLE_C, enemyType=AvatarTypes.Undead, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.deliverTattooPattern': QuestDNA(obsolete=False, questInt=25101, tasks=(DeliverItemTaskDNA(item=QuestItems.TattooPattern, num=1, npcId=NPCIds.DARBY_DRYDOCK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.SOLOMON_ODOUGAL,)),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.findShipLog': QuestDNA(obsolete=False, questInt=25102, tasks=(RecoverContainerItemTaskDNA(containerId=PropIds.PR_CRATES, item=QuestItems.ShipLog, num=1, maxAttempts=Attempts.VERY_RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.visitSolomon': QuestDNA(obsolete=False, questInt=25103, tasks=(VisitTaskDNA(npcId=NPCIds.SOLOMON_ODOUGAL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.recoverFamilyHeirlooms': QuestDNA(obsolete=False, questInt=25104, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FamilyHeirlooms, num=1, maxAttempts=Attempts.VERY_RARE, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_MARAUDER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.visitBingham': QuestDNA(obsolete=False, questInt=25105, tasks=(VisitTaskDNA(npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.bribeBingham': QuestDNA(obsolete=False, questInt=25106, tasks=(BribeNPCTaskDNA(npcId=NPCIds.BINGHAM, gold=Bribes.LARGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.defeatEITC': QuestDNA(obsolete=False, questInt=25107, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.TradingCo, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.findPaintingsA': QuestDNA(obsolete=False, questInt=25108, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.ISLA_CANGREJOS, item=QuestItems.Painting, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.findPaintingsB': QuestDNA(obsolete=False, questInt=25109, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.RUMRUNNER_ISLE, item=QuestItems.Painting, num=2, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.findPaintingsC': QuestDNA(obsolete=False, questInt=25110, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.TORTUGA_ALL, item=QuestItems.Painting, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.deliverList': QuestDNA(obsolete=False, questInt=25112, tasks=(DeliverItemTaskDNA(item=QuestItems.List, num=1, npcId=NPCIds.SOLOMON_ODOUGAL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SOLOMON_ODOUGAL,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'sd2.deliverPainting': QuestDNA(obsolete=False, questInt=25113, tasks=(DeliverItemTaskDNA(item=QuestItems.Painting, num=1, npcId=NPCIds.JIM_WAVEMONGER),), rewards=(TattooQuestReward(amount=TattooGlobals.SOLOMON_ODOUGAL_QUEST_B),), returnGiverIds=(NPCIds.JIM_WAVEMONGER,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.visitBingham': QuestDNA(obsolete=False, questInt=25201, tasks=(VisitTaskDNA(npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.deliverOrderA': QuestDNA(obsolete=False, questInt=25202, tasks=(DeliverItemTaskDNA(item=QuestItems.Gun, num=1, npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.deliverOrderB': QuestDNA(obsolete=False, questInt=25203, tasks=(DeliverItemTaskDNA(item=QuestItems.Gun, num=1, npcId=NPCIds.JACK_REDRAT),), rewards=(GoldReward(amount=7), ReputationReward(amount=ExpRewards.SMALL)), returnGiverIds=(NPCIds.JACK_REDRAT,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.deliverOrderC': QuestDNA(obsolete=False, questInt=25204, tasks=(DeliverItemTaskDNA(item=QuestItems.Gun, num=1, npcId=NPCIds.OLIVIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.deliverOrderD': QuestDNA(obsolete=False, questInt=25205, tasks=(DeliverItemTaskDNA(item=QuestItems.Gun, num=1, npcId=NPCIds.BILLY_MCKIDD),), rewards=(GoldReward(amount=4), ReputationReward(amount=ExpRewards.SMALL)), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.deliverOrderE': QuestDNA(obsolete=False, questInt=25206, tasks=(DeliverItemTaskDNA(item=QuestItems.Gun, num=1, npcId=NPCIds.BASTIEN_CRAVEN),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BASTIEN_CRAVEN,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.deliverOrderF': QuestDNA(obsolete=False, questInt=25207, tasks=(DeliverItemTaskDNA(item=QuestItems.Gun, num=1, npcId=NPCIds.ORINDA),), rewards=(GoldReward(amount=6), ReputationReward(amount=ExpRewards.SMALL)), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.playPoker': QuestDNA(obsolete=False, questInt=25209, tasks=(PokerTaskDNA(gold=PokerPots.HUGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.playBlackjack': QuestDNA(obsolete=False, questInt=25210, tasks=(BlackjackTaskDNA(gold=PokerPots.HUGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.defeatBigAlligators': QuestDNA(obsolete=False, questInt=25212, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.BigGator, num=20, level=0, weaponType=InventoryType.PistolRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.defeatSkeletons': QuestDNA(obsolete=False, questInt=25213, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=15, level=0, weaponType=InventoryType.PistolRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.defeatFlyTrap': QuestDNA(obsolete=False, questInt=25214, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.FlyTrap, num=10, level=0, weaponType=InventoryType.PistolRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.defeatVampireBat': QuestDNA(obsolete=False, questInt=25215, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.VampireBat, num=10, level=0, weaponType=InventoryType.PistolRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.defeatScorpion': QuestDNA(obsolete=False, questInt=25216, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Scorpion, num=10, level=0, weaponType=InventoryType.PistolRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.defeatNavy': QuestDNA(obsolete=False, questInt=25218, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Navy, num=15, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.defeatEITC': QuestDNA(obsolete=False, questInt=25219, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.TradingCo, num=15, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.returnOrder': QuestDNA(obsolete=False, questInt=25221, tasks=(DeliverItemTaskDNA(item=QuestItems.GunOrder, num=1, npcId=NPCIds.ALEXANDER_THAYER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.visitThayer': QuestDNA(obsolete=False, questInt=25222, tasks=(VisitTaskDNA(npcId=NPCIds.ALEXANDER_THAYER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.recoverAntiquePistols': QuestDNA(obsolete=False, questInt=25223, tasks=(RecoverShipItemTaskDNA(item=QuestItems.AntiquePistol, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(PistolUpgradeReward(amount=ItemId.PISTOL_L4),), returnGiverIds=(NPCIds.ALEXANDER_THAYER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'at1.0visitThayer': QuestDNA(obsolete=False, questInt=25224, tasks=(VisitTaskDNA(npcId=NPCIds.ALEXANDER_THAYER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.defeatWasps': QuestDNA(obsolete=False, questInt=25301, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Wasp, num=10, level=0, weaponType=InventoryType.DaggerRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.defeatScorpions': QuestDNA(obsolete=False, questInt=25302, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.DreadScorpion, num=10, level=0, weaponType=InventoryType.DaggerRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.defeatSkeletons': QuestDNA(obsolete=False, questInt=25303, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=10, level=0, weaponType=InventoryType.DaggerRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.defeatCrabs': QuestDNA(obsolete=False, questInt=25304, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.GiantCrab, num=5, level=0, weaponType=InventoryType.DaggerRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.defeatAlligators': QuestDNA(obsolete=False, questInt=25305, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.HugeGator, num=5, level=0, weaponType=InventoryType.DaggerRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.visitBingham': QuestDNA(obsolete=False, questInt=25307, tasks=(VisitTaskDNA(npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.deliverShipPlans': QuestDNA(obsolete=False, questInt=25308, tasks=(DeliverItemTaskDNA(item=QuestItems.ShipPlans, num=1, npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.deliverBackgroundCheck': QuestDNA(obsolete=False, questInt=25309, tasks=(DeliverItemTaskDNA(item=QuestItems.BackgroundCheck, num=1, npcId=NPCIds.JOHN_WALLACE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_WALLACE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.visitBingham2': QuestDNA(obsolete=False, questInt=25310, tasks=(VisitTaskDNA(npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.visitShochett': QuestDNA(obsolete=False, questInt=25311, tasks=(VisitTaskDNA(npcId=NPCIds.SHOCHETT_PRYMME),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SHOCHETT_PRYMME,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverHidesA': QuestDNA(obsolete=False, questInt=25312, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=5, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverHidesB': QuestDNA(obsolete=False, questInt=25313, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverHidesC': QuestDNA(obsolete=False, questInt=25314, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.HugeGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverBoneDust': QuestDNA(obsolete=False, questInt=25323, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneDust, num=5, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.deliverFineSteelBars': QuestDNA(obsolete=False, questInt=25316, tasks=(DeliverItemTaskDNA(item=QuestItems.FineSteelBar, num=5, npcId=NPCIds.JOHN_WALLACE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_WALLACE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverCursedWood': QuestDNA(obsolete=False, questInt=25317, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedWood, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverLeatherStraps': QuestDNA(obsolete=False, questInt=25318, tasks=(RecoverShipItemTaskDNA(item=QuestItems.LeatherStraps, num=10, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverBladeSharpener': QuestDNA(obsolete=False, questInt=25319, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BladeSharpener, num=5, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.recoverArrestWarrant': QuestDNA(obsolete=False, questInt=25321, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ArrestWarrant, num=3, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.VERY_RARE),), rewards=(DaggerUpgradeReward(amount=ItemId.DAGGER_L4),), returnGiverIds=(NPCIds.JOHN_WALLACE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'jw1.visitJohnWallace': QuestDNA(obsolete=False, questInt=25322, tasks=(VisitTaskDNA(npcId=NPCIds.JOHN_WALLACE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.deliverPirateLorePage': QuestDNA(obsolete=False, questInt=25401, tasks=(DeliverItemTaskDNA(item=QuestItems.PirateLorePage, num=1, npcId=NPCIds.JIM_WAVEMONGER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JIM_WAVEMONGER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverChestOfPirateLore': QuestDNA(obsolete=False, questInt=25402, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.PirateLoreChest, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JIM_WAVEMONGER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.deliverMedal': QuestDNA(obsolete=False, questInt=25403, tasks=(DeliverItemTaskDNA(item=QuestItems.Medal, num=1, npcId=NPCIds.WILL_TURNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverEITCManual': QuestDNA(obsolete=False, questInt=25404, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EITCManual, num=1, enemyType=AvatarTypes.TradingCo, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverLorePagesA': QuestDNA(obsolete=False, questInt=25405, tasks=(RecoverShipItemTaskDNA(item=QuestItems.PirateLorePage, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_MARAUDER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverLorePagesB': QuestDNA(obsolete=False, questInt=25406, tasks=(RecoverShipItemTaskDNA(item=QuestItems.PirateLorePage, num=5, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_BARRACUDA, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverLorePagesC': QuestDNA(obsolete=False, questInt=25407, tasks=(RecoverShipItemTaskDNA(item=QuestItems.PirateLorePage, num=15, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_CORVETTE, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverLorePagesD': QuestDNA(obsolete=False, questInt=25408, tasks=(RecoverShipItemTaskDNA(item=QuestItems.PirateLorePage, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, hull=ShipIds.ANY_EITC_SEA_VIPER, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.deliverUnfinishedBookOfPirateLore': QuestDNA(obsolete=False, questInt=25410, tasks=(DeliverItemTaskDNA(item=QuestItems.UnfinishedPirateLoreBook, num=1, npcId=NPCIds.BILLY_MCKIDD),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.playPoker': QuestDNA(obsolete=False, questInt=25411, tasks=(PokerTaskDNA(gold=PokerPots.HUGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.playBlackjack': QuestDNA(obsolete=False, questInt=25412, tasks=(BlackjackTaskDNA(gold=PokerPots.HUGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.defeatSkeletons': QuestDNA(obsolete=False, questInt=25414, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=10, level=0, weaponType=InventoryType.CutlassRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.defeatFlyTraps': QuestDNA(obsolete=False, questInt=25415, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.RancidFlyTrap, num=10, level=0, weaponType=InventoryType.CutlassRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.defeatBigGators': QuestDNA(obsolete=False, questInt=25416, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.BigGator, num=10, level=0, weaponType=InventoryType.CutlassRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.defeatGiantCrabs': QuestDNA(obsolete=False, questInt=25417, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.GiantCrab, num=5, level=0, weaponType=InventoryType.CutlassRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.defeatWasps': QuestDNA(obsolete=False, questInt=25418, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Wasp, num=10, level=0, weaponType=InventoryType.CutlassRep),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverRestOfBookA': QuestDNA(obsolete=False, questInt=25420, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.KINGSHEAD_ISLAND, item=QuestItems.PirateLorePage, num=4, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverRestOfBookB': QuestDNA(obsolete=False, questInt=25421, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.RUMRUNNER_ISLE, item=QuestItems.PirateLorePage, num=4, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.recoverRestOfBookC': QuestDNA(obsolete=False, questInt=25422, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.ISLA_CANGREJOS, item=QuestItems.PirateLorePage, num=8, maxAttempts=Attempts.ALWAYS, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BILLY_MCKIDD,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.deliverBookOfLore': QuestDNA(obsolete=False, questInt=25424, tasks=(DeliverItemTaskDNA(item=QuestItems.PirateLoreBook, num=1, npcId=NPCIds.WILL_TURNER),), rewards=(CutlassUpgradeReward(amount=ItemId.CUTLASS_L4),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'wt1.visitWillTurner': QuestDNA(obsolete=False, questInt=25425, tasks=(VisitTaskDNA(npcId=NPCIds.WILL_TURNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPBreadCrumb': QuestDNA(obsolete=False, questInt=27001, tasks=(VisitTaskDNA(npcId=NPCIds.SPANISH_SHIPWRIGHT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.O_MALLEY, NPCIds.CARLOS_CIENFUEGOS, NPCIds.DARBY_DRYDOCK, NPCIds.BALTHASAR)),), returnGiverIds=(NPCIds.SPANISH_SHIPWRIGHT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPVisitLordA': QuestDNA(obsolete=False, questInt=27002, tasks=(VisitTaskDNA(npcId=NPCIds.GARCIA_DE_AVARCIA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SPANISH_SHIPWRIGHT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPFirstTrial': QuestDNA(obsolete=False, questInt=27003, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, num=1, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SPANISH_SHIPWRIGHT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPVisitLordB': QuestDNA(obsolete=False, questInt=27004, tasks=(VisitTaskDNA(npcId=NPCIds.PIERRE_LE_PORC),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SPANISH_SHIPWRIGHT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPSecondTrial': QuestDNA(obsolete=False, questInt=27005, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, num=1, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SPANISH_SHIPWRIGHT,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskB': QuestDNA(obsolete=False, questInt=28006, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskC': QuestDNA(obsolete=False, questInt=28007, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskJ': QuestDNA(obsolete=False, questInt=28014, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, damage=50000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskK': QuestDNA(obsolete=False, questInt=28015, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, damage=50000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskA': QuestDNA(obsolete=False, questInt=28005, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, damage=10000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.GARCIA_DE_AVARCIA,)),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskF': QuestDNA(obsolete=False, questInt=28010, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskG': QuestDNA(obsolete=False, questInt=28011, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskL': QuestDNA(obsolete=False, questInt=28016, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, damage=25000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskM': QuestDNA(obsolete=False, questInt=28017, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, damage=25000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskN': QuestDNA(obsolete=False, questInt=28018, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, num=25, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'spanish.ShipPVPTaskP': QuestDNA(obsolete=False, questInt=28020, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPFrench, damage=50000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=True),), rewards=(TattooQuestReward(amount=TattooGlobals.SHIP_PVP_SPANISH_QUEST_A),), returnGiverIds=(NPCIds.GARCIA_DE_AVARCIA,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskB': QuestDNA(obsolete=False, questInt=29006, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskC': QuestDNA(obsolete=False, questInt=29007, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskJ': QuestDNA(obsolete=False, questInt=29014, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, damage=50000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskK': QuestDNA(obsolete=False, questInt=29015, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, damage=50000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskA': QuestDNA(obsolete=False, questInt=29005, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, damage=10000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.PIERRE_LE_PORC,)),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskF': QuestDNA(obsolete=False, questInt=29010, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskG': QuestDNA(obsolete=False, questInt=29011, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, num=5, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskL': QuestDNA(obsolete=False, questInt=29016, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, damage=25000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillShip, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskM': QuestDNA(obsolete=False, questInt=29017, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, damage=25000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, killWeapon=PiratesGlobals.ShipPVPKillCannon, withoutSink=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskN': QuestDNA(obsolete=False, questInt=29018, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, num=25, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'french.ShipPVPTaskP': QuestDNA(obsolete=False, questInt=29020, tasks=(ShipPVPDefeatTaskDNA(enemyClass=PiratesGlobals.ShipPVPSpanish, damage=50000, gameType=PiratesGlobals.ShipPVPSiege, killType=PiratesGlobals.ShipPVPShip, withoutSink=True),), rewards=(TattooQuestReward(amount=TattooGlobals.SHIP_PVP_FRENCH_QUEST_A),), returnGiverIds=(NPCIds.PIERRE_LE_PORC,), combineOp=QuestDNA.OR, droppable=True, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.visitWoodruff': QuestDNA(obsolete=False, questInt=30001, tasks=(VisitTaskDNA(npcId=NPCIds.WOODRUFF),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.ORINDA,)),), returnGiverIds=(NPCIds.ORINDA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=True, minLevel=15, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatFrenchUndeadA': QuestDNA(obsolete=False, questInt=30002, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.FrenchUndeadA, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatFrenchUndeadB': QuestDNA(obsolete=False, questInt=30003, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.FrenchUndeadB, num=15, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatFrenchUndeadC': QuestDNA(obsolete=False, questInt=30004, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.FrenchUndeadC, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatFrenchUndeadD': QuestDNA(obsolete=False, questInt=30005, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.FrenchUndeadD, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatSpanishUndeadA': QuestDNA(obsolete=False, questInt=30006, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.SpanishUndeadA, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatSpanishUndeadB': QuestDNA(obsolete=False, questInt=30007, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.SpanishUndeadB, num=15, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatSpanishUndeadC': QuestDNA(obsolete=False, questInt=30008, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.SpanishUndeadC, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatSpanishUndeadD': QuestDNA(obsolete=False, questInt=30009, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.SpanishUndeadD, num=5, level=0),), rewards=(ReputationReward(amount=ExpRewards.TRIVIAL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatFrenchShipA': QuestDNA(obsolete=False, questInt=30011, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_FRENCH_SHADOW_CROW, num=1, level=0, isFlagship=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatFrenchShipB': QuestDNA(obsolete=False, questInt=30012, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_FRENCH_HELLHOUND, num=1, level=0, isFlagship=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatFrenchShipC': QuestDNA(obsolete=False, questInt=30013, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_FRENCH_BLOOD_SCOURGE, num=1, level=0, isFlagship=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatSpanishShipA': QuestDNA(obsolete=False, questInt=30015, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_SPANISH_SHADOW_CROW, num=1, level=0, isFlagship=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatSpanishShipB': QuestDNA(obsolete=False, questInt=30016, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_SPANISH_HELLHOUND, num=1, level=0, isFlagship=True),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'om1.defeatSpanishShipC': QuestDNA(obsolete=False, questInt=30017, tasks=(DefeatShipTaskDNA(hull=ShipIds.ANY_SPANISH_BLOOD_SCOURGE, num=1, level=0, isFlagship=True),), rewards=(ReputationReward(amount=ExpRewards.LARGE),), returnGiverIds=(NPCIds.WOODRUFF,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=True, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitIsaiah': QuestDNA(obsolete=False, questInt=30101, tasks=(VisitTaskDNA(npcId=NPCIds.ISAIAH_CALLECUTTER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.AMELIA_SUNFELLOW,)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=15, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverHides': QuestDNA(obsolete=False, questInt=30102, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverFlyTrapThread': QuestDNA(obsolete=False, questInt=30103, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FlyTrapThread, num=5, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=False, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitJohnnyMcVane': QuestDNA(obsolete=False, questInt=30105, tasks=(VisitTaskDNA(npcId=NPCIds.JOHNNY_MCVANE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.playPoker': QuestDNA(obsolete=False, questInt=30106, tasks=(PokerTaskDNA(gold=PokerPots.HUGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHNNY_MCVANE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.playBlackjack': QuestDNA(obsolete=False, questInt=30107, tasks=(BlackjackTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHNNY_MCVANE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverRareFeathers': QuestDNA(obsolete=False, questInt=30109, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RareFeather, num=10, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitAmeliaSunfellow': QuestDNA(obsolete=False, questInt=30110, tasks=(VisitTaskDNA(npcId=NPCIds.AMELIA_SUNFELLOW),), rewards=(ClothingQuestReward(amount=ClothingGlobals.INTERMEDIATE_OUTFIT_PART_A, bonus=False),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitBingham': QuestDNA(obsolete=False, questInt=30111, tasks=(VisitTaskDNA(npcId=NPCIds.BINGHAM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.bribeBingham': QuestDNA(obsolete=False, questInt=30112, tasks=(BribeNPCTaskDNA(npcId=NPCIds.BINGHAM, gold=Bribes.HUGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverManifests': QuestDNA(obsolete=False, questInt=30113, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EITCManifest, num=5, enemyType=AvatarTypes.TradingCo, level=5, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverBinghamsTip': QuestDNA(obsolete=False, questInt=30114, tasks=(RecoverTreasureItemTaskDNA(item=QuestItems.BinghamsDiary, num=1, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BINGHAM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.deliverManifests': QuestDNA(obsolete=False, questInt=30116, tasks=(DeliverItemTaskDNA(item=QuestItems.EITCManifest, num=5, npcId=NPCIds.AMELIA_SUNFELLOW),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.AMELIA_SUNFELLOW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverBoltsOfCloth': QuestDNA(obsolete=False, questInt=30118, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BoltOfCloth, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.AMELIA_SUNFELLOW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverFineScissors': QuestDNA(obsolete=False, questInt=30119, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FineScissors, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.AMELIA_SUNFELLOW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverSilkThread': QuestDNA(obsolete=False, questInt=30120, tasks=(RecoverShipItemTaskDNA(item=QuestItems.SilkThread, num=15, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.AMELIA_SUNFELLOW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.returnIsaiah': QuestDNA(obsolete=False, questInt=30121, tasks=(VisitTaskDNA(npcId=NPCIds.ISAIAH_CALLECUTTER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverNeedles': QuestDNA(obsolete=False, questInt=30122, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Needle, num=20, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ClothingQuestReward(amount=ClothingGlobals.INTERMEDIATE_OUTFIT_PART_B, bonus=False),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitScarlet': QuestDNA(obsolete=False, questInt=30123, tasks=(VisitTaskDNA(npcId=NPCIds.SCARLET),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.bribeScarlet': QuestDNA(obsolete=False, questInt=30124, tasks=(BribeNPCTaskDNA(npcId=NPCIds.SCARLET, gold=Bribes.LARGE, bribeType=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverScarletsPearlA': QuestDNA(obsolete=False, questInt=30127, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScarletsPearl, num=5, enemyType=AvatarTypes.Undead, level=10, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverScarletsPearlB': QuestDNA(obsolete=False, questInt=30128, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScarletsPearl, num=4, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverScarletsPearlC': QuestDNA(obsolete=False, questInt=30129, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScarletsPearl, num=2, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverScarletsPearlD': QuestDNA(obsolete=False, questInt=30130, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScarletsPearl, num=2, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverScarletsPearlE': QuestDNA(obsolete=False, questInt=30131, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScarletsPearl, num=1, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.returnIsaiahB': QuestDNA(obsolete=False, questInt=30133, tasks=(VisitTaskDNA(npcId=NPCIds.ISAIAH_CALLECUTTER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitBigPhil': QuestDNA(obsolete=False, questInt=30134, tasks=(VisitTaskDNA(npcId=NPCIds.BIG_PHIL),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BIG_PHIL,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverChickensForPhil': QuestDNA(obsolete=False, questInt=30135, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chicken, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BIG_PHIL,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverPigsForPhil': QuestDNA(obsolete=False, questInt=30136, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Pig, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BIG_PHIL,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.scarletsLettersA': QuestDNA(obsolete=False, questInt=30125, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_CAVE, item=QuestItems.LetterFromScarlet, num=2, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.scarletsLettersB': QuestDNA(obsolete=False, questInt=30126, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORTUGA_CAVE, item=QuestItems.LetterFromScarlet, num=2, enemyType=AvatarTypes.TradingCo, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.FREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SCARLET,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.returnIsaiahC': QuestDNA(obsolete=False, questInt=30139, tasks=(VisitTaskDNA(npcId=NPCIds.ISAIAH_CALLECUTTER),), rewards=(ClothingQuestReward(amount=ClothingGlobals.INTERMEDIATE_OUTFIT_PART_C, bonus=False), ClothingQuestReward(amount=ClothingGlobals.INTERMEDIATE_OUTFIT_PART_D, bonus=False)), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitAmeliaSunfellowB': QuestDNA(obsolete=False, questInt=30140, tasks=(VisitTaskDNA(npcId=NPCIds.AMELIA_SUNFELLOW),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.deliverCoinBag': QuestDNA(obsolete=False, questInt=30141, tasks=(DeliverItemTaskDNA(item=QuestItems.CoinBag, num=1, npcId=NPCIds.JOHN_SMITH),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.findJohnsStuff': QuestDNA(obsolete=False, questInt=30142, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.DRIFTWOOD_ISLAND, item=QuestItems.PersonalEffects, num=1, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverWaspWings': QuestDNA(obsolete=False, questInt=30143, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WaspWings, num=15, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverWaspEggs': QuestDNA(obsolete=False, questInt=30144, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.WaspEggs, num=15, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverWaspEssence': QuestDNA(obsolete=False, questInt=30145, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EssenceOfWasp, num=15, enemyType=AvatarTypes.AngryWasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverCrabClaws': QuestDNA(obsolete=False, questInt=30146, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrabClaw, num=10, enemyType=AvatarTypes.GiantCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverCrabShells': QuestDNA(obsolete=False, questInt=30147, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CrabShell, num=10, enemyType=AvatarTypes.RockCrab, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.JOHN_SMITH,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.visitAmeliaSunfellowC': QuestDNA(obsolete=False, questInt=30150, tasks=(VisitTaskDNA(npcId=NPCIds.AMELIA_SUNFELLOW),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverBeltBuckles': QuestDNA(obsolete=False, questInt=30151, tasks=(RecoverTreasureItemTaskDNA(location=LocationIds.ISLA_CANGREJOS, item=QuestItems.BeltBuckle, num=5, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ClothingQuestReward(amount=ClothingGlobals.INTERMEDIATE_OUTFIT_PART_E, bonus=False),), returnGiverIds=(NPCIds.AMELIA_SUNFELLOW,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.returnIsaiahD': QuestDNA(obsolete=False, questInt=30152, tasks=(VisitTaskDNA(npcId=NPCIds.ISAIAH_CALLECUTTER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverShoeDesigns': QuestDNA(obsolete=False, questInt=30153, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FineShoeDesign, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverScorpionShells': QuestDNA(obsolete=False, questInt=30155, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.ScorpionShell, num=20, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverBoneShavings': QuestDNA(obsolete=False, questInt=30156, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneShavings, num=10, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverAlligatorHides': QuestDNA(obsolete=False, questInt=30157, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.recoverVampireBatGuano': QuestDNA(obsolete=False, questInt=30158, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatGuano, num=5, enemyType=AvatarTypes.VampireBat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQI.sinkEITCShips': QuestDNA(obsolete=False, questInt=30159, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.TradingCo, num=20, level=0, isFlagship=False),), rewards=(ClothingQuestReward(amount=ClothingGlobals.INTERMEDIATE_OUTFIT_PART_F, bonus=False),), returnGiverIds=(NPCIds.ISAIAH_CALLECUTTER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitRomanyBev': QuestDNA(obsolete=False, questInt=30201, tasks=(VisitTaskDNA(npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.ADORIA_DOLORES,)),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=20, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverShopApplication': QuestDNA(obsolete=False, questInt=30202, tasks=(RecoverContainerItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, containerId=PropIds.FD_ALL, item=QuestItems.ShopApplication, num=1, maxAttempts=Attempts.FREQUENT, probability=Probability.ALWAYS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitValentina': QuestDNA(obsolete=False, questInt=30203, tasks=(VisitTaskDNA(npcId=NPCIds.VALENTINA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.VALENTINA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.defeatNavyGuards': QuestDNA(obsolete=False, questInt=30204, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Veteran, num=20, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.VALENTINA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverCursedWood': QuestDNA(obsolete=False, questInt=30205, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedWood, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.VALENTINA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.deliverChest': QuestDNA(obsolete=False, questInt=30206, tasks=(DeliverItemTaskDNA(item=QuestItems.CursedChest, num=1, npcId=NPCIds.BARBOSSA),), rewards=(ClothingQuestReward(amount=ClothingGlobals.ADVANCED_OUTFIT_PART_A, bonus=False),), returnGiverIds=(NPCIds.BARBOSSA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitRomanyBevB': QuestDNA(obsolete=False, questInt=30207, tasks=(VisitTaskDNA(npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverButtons': QuestDNA(obsolete=False, questInt=30210, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CursedButtons, num=10, enemyType=AvatarTypes.Undead, level=15, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverBoneDust': QuestDNA(obsolete=False, questInt=30211, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneDust, num=5, enemyType=AvatarTypes.Undead, level=20, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverHides': QuestDNA(obsolete=False, questInt=30212, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Hide, num=10, enemyType=AvatarTypes.DreadScorpion, level=10, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverCursedBark': QuestDNA(obsolete=False, questInt=30214, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CursedBark, num=5, enemyType=AvatarTypes.Stump, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.deliverKrakenCloth': QuestDNA(obsolete=False, questInt=30209, tasks=(DeliverItemTaskDNA(item=QuestItems.KrakenCloth, num=1, npcId=NPCIds.ADORIA_DOLORES),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverCursedCloth': QuestDNA(obsolete=False, questInt=30215, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedCloth, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverCursedThreads': QuestDNA(obsolete=False, questInt=30216, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedThread, num=5, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverCursedNeedles': QuestDNA(obsolete=False, questInt=30217, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CursedNeedle, num=20, enemyType=AvatarTypes.Undead, level=15, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ClothingQuestReward(amount=ClothingGlobals.ADVANCED_OUTFIT_PART_B, bonus=False), ClothingQuestReward(amount=ClothingGlobals.ADVANCED_OUTFIT_PART_C, bonus=False)), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitValentinaB': QuestDNA(obsolete=False, questInt=30218, tasks=(VisitTaskDNA(npcId=NPCIds.VALENTINA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.VALENTINA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.deliverVoodooArtifact': QuestDNA(obsolete=False, questInt=30219, tasks=(DeliverItemTaskDNA(item=QuestItems.VoodooArtifact, num=1, npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=False, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverVoodooArtifactsA': QuestDNA(obsolete=False, questInt=30220, tasks=(RecoverShipItemTaskDNA(item=QuestItems.VoodooArtifact, num=10, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverVoodooArtifactsB': QuestDNA(obsolete=False, questInt=30222, tasks=(RecoverShipItemTaskDNA(item=QuestItems.VoodooArtifact, num=10, maxAttempts=Attempts.RARE, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitMaggieRigrage': QuestDNA(obsolete=False, questInt=30223, tasks=(VisitTaskDNA(npcId=NPCIds.MAGGIE_RIGRAGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverFamilyHeirloomsA': QuestDNA(obsolete=False, questInt=30224, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FamilyHeirlooms, num=15, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MAGGIE_RIGRAGE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverFamilyHeirloomsB': QuestDNA(obsolete=False, questInt=30225, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FamilyHeirlooms, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MAGGIE_RIGRAGE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverFamilyHeirloomsC': QuestDNA(obsolete=False, questInt=30227, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FamilyHeirlooms, num=5, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MAGGIE_RIGRAGE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverFamilyHeirloomsD': QuestDNA(obsolete=False, questInt=30228, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FamilyHeirlooms, num=5, enemyType=AvatarTypes.Stump, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MAGGIE_RIGRAGE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverFamilyHeirloomsE': QuestDNA(obsolete=False, questInt=30230, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FamilyHeirlooms, num=5, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MAGGIE_RIGRAGE,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitRomanyBevC': QuestDNA(obsolete=False, questInt=30231, tasks=(VisitTaskDNA(npcId=NPCIds.ROMANY_BEV),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ROMANY_BEV,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitAdoriaDolores': QuestDNA(obsolete=False, questInt=30232, tasks=(VisitTaskDNA(npcId=NPCIds.ADORIA_DOLORES),), rewards=(ClothingQuestReward(amount=ClothingGlobals.ADVANCED_OUTFIT_PART_D, bonus=False),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitMorris': QuestDNA(obsolete=False, questInt=30233, tasks=(VisitTaskDNA(npcId=NPCIds.MORRIS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.playPoker': QuestDNA(obsolete=False, questInt=30234, tasks=(PokerTaskDNA(gold=PokerPots.HUGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.playBlackjack': QuestDNA(obsolete=False, questInt=30236, tasks=(BlackjackTaskDNA(gold=PokerPots.HUGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.MORRIS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitAdoriaDoloresB': QuestDNA(obsolete=False, questInt=30237, tasks=(VisitTaskDNA(npcId=NPCIds.ADORIA_DOLORES),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.deliverRumBarrel': QuestDNA(obsolete=False, questInt=30238, tasks=(DeliverItemTaskDNA(item=QuestItems.RumBarrel, num=1, npcId=NPCIds.GUNNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverRumBottles': QuestDNA(obsolete=False, questInt=30239, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RumBottle, num=10, enemyType=AvatarTypes.Navy, level=15, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverRumBarrels': QuestDNA(obsolete=False, questInt=30241, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RumBarrel, num=20, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.GUNNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitAdoriaDoloresC': QuestDNA(obsolete=False, questInt=30242, tasks=(VisitTaskDNA(npcId=NPCIds.ADORIA_DOLORES),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitOlivier': QuestDNA(obsolete=False, questInt=30243, tasks=(VisitTaskDNA(npcId=NPCIds.OLIVIER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverRottenMeat': QuestDNA(obsolete=False, questInt=30244, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.RottenMeat, num=10, enemyType=AvatarTypes.Undead, level=20, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverFlyTrapRoots': QuestDNA(obsolete=False, questInt=30246, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.FlyTrapRoot, num=10, enemyType=AvatarTypes.FlyTrap, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverGatorSaliva': QuestDNA(obsolete=False, questInt=30247, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorSaliva, num=5, enemyType=AvatarTypes.BigGator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.OLIVIER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitAdoriaDoloresD': QuestDNA(obsolete=False, questInt=30248, tasks=(VisitTaskDNA(npcId=NPCIds.ADORIA_DOLORES),), rewards=(ClothingQuestReward(amount=ClothingGlobals.ADVANCED_OUTFIT_PART_E, bonus=False),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.deliverCompass': QuestDNA(obsolete=False, questInt=30249, tasks=(DeliverItemTaskDNA(item=QuestItems.Compass, num=1, npcId=NPCIds.DOG_LOCKGRIM),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOG_LOCKGRIM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverLockgrimsLetter': QuestDNA(obsolete=False, questInt=30250, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.LockgrimsLetter, num=1, enemyType=AvatarTypes.DreadScorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.RARE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOG_LOCKGRIM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.defeatFlotsam': QuestDNA(obsolete=False, questInt=30251, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_CAVE_B, enemyType=AvatarTypes.Damp, num=2, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOG_LOCKGRIM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.defeatSpikeskull': QuestDNA(obsolete=False, questInt=30252, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_CAVE_B, enemyType=AvatarTypes.Drizzle, num=2, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOG_LOCKGRIM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.defeatKelpbrain': QuestDNA(obsolete=False, questInt=30253, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_CAVE_B, enemyType=AvatarTypes.Spray, num=2, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOG_LOCKGRIM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.defeatBrinescum': QuestDNA(obsolete=False, questInt=30254, tasks=(DefeatTaskDNA(location=LocationIds.TORMENTA_CAVE_B, enemyType=AvatarTypes.Splatter, num=2, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DOG_LOCKGRIM,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitAdoriaDoloresE': QuestDNA(obsolete=False, questInt=30256, tasks=(VisitTaskDNA(npcId=NPCIds.ADORIA_DOLORES),), rewards=(ClothingQuestReward(amount=ClothingGlobals.ADVANCED_OUTFIT_PART_F, bonus=False),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverNavyChests': QuestDNA(obsolete=False, questInt=30257, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Chest, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverNavyChestKeys': QuestDNA(obsolete=False, questInt=30258, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.DEL_FUEGO_FORT_DUNDEE, item=QuestItems.Key, num=10, enemyType=AvatarTypes.Navy, level=15, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitShochett': QuestDNA(obsolete=False, questInt=30259, tasks=(VisitTaskDNA(npcId=NPCIds.SHOCHETT_PRYMME),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SHOCHETT_PRYMME,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverTentaclesA': QuestDNA(obsolete=False, questInt=30260, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORMENTA_CAVE_B, item=QuestItems.Tentacle, num=3, enemyType=AvatarTypes.Drool, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SHOCHETT_PRYMME,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverTentaclesB': QuestDNA(obsolete=False, questInt=30261, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORMENTA_CAVE_B, item=QuestItems.Tentacle, num=2, enemyType=AvatarTypes.Drench, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SHOCHETT_PRYMME,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverTentaclesC': QuestDNA(obsolete=False, questInt=30262, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORMENTA_CAVE_B, item=QuestItems.Tentacle, num=2, enemyType=AvatarTypes.Douse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SHOCHETT_PRYMME,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.recoverUrchinfistEye': QuestDNA(obsolete=False, questInt=30263, tasks=(RecoverAvatarItemTaskDNA(location=LocationIds.TORMENTA_CAVE_B, item=QuestItems.UrchinfistEye, num=1, enemyType=AvatarTypes.Douse, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.SHOCHETT_PRYMME,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.deliverTentacles': QuestDNA(obsolete=False, questInt=30265, tasks=(DeliverItemTaskDNA(item=QuestItems.Tentacle, num=7, npcId=NPCIds.ADORIA_DOLORES),), rewards=(ClothingQuestReward(amount=ClothingGlobals.ADVANCED_OUTFIT_PART_G, bonus=False),), returnGiverIds=(NPCIds.ADORIA_DOLORES,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQA.visitValentinaC': QuestDNA(obsolete=False, questInt=30266, tasks=(VisitTaskDNA(npcId=NPCIds.VALENTINA),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.VALENTINA,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.makeBlackjackMoney': QuestDNA(obsolete=False, questInt=30313, tasks=(PokerTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.makePokerMoney': QuestDNA(obsolete=False, questInt=30314, tasks=(BlackjackTaskDNA(gold=PokerPots.LARGE),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.challengingNavy': QuestDNA(obsolete=False, questInt=30315, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Navy, num=10, level=5),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.challengingEITC': QuestDNA(obsolete=False, questInt=30316, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.TradingCo, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.challengingNavyShips': QuestDNA(obsolete=False, questInt=30317, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=10, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.challengingEITCShips': QuestDNA(obsolete=False, questInt=30318, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.TradingCo, num=10, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.recoverFineRum': QuestDNA(obsolete=False, questInt=30321, tasks=(RecoverShipItemTaskDNA(item=QuestItems.FineRum, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.recoverBoneShavings': QuestDNA(obsolete=False, questInt=30322, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BoneShavings, num=10, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.recoverPrisonKey': QuestDNA(obsolete=False, questInt=30323, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.PrisonKey, num=10, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatNavy': QuestDNA(obsolete=False, questInt=30327, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Navy, num=15, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatSkeleton': QuestDNA(obsolete=False, questInt=30328, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Undead, num=15, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatEITC': QuestDNA(obsolete=False, questInt=30329, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.TradingCo, num=15, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatAlligators': QuestDNA(obsolete=False, questInt=30330, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Alligator, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatBats': QuestDNA(obsolete=False, questInt=30331, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Bat, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatScorpions': QuestDNA(obsolete=False, questInt=30332, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Scorpion, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatCrabs': QuestDNA(obsolete=False, questInt=30333, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Crab, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatWasps': QuestDNA(obsolete=False, questInt=30334, tasks=(DefeatTaskDNA(enemyType=AvatarTypes.Wasp, num=10, level=0),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveAntiquePistol': QuestDNA(obsolete=False, questInt=30337, tasks=(RecoverShipItemTaskDNA(item=QuestItems.AntiquePistol, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_SHACKLEBY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveEITCManual': QuestDNA(obsolete=False, questInt=30338, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EITCManual, num=15, enemyType=AvatarTypes.TradingCo, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_SHACKLEBY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveRareFeather': QuestDNA(obsolete=False, questInt=30339, tasks=(RecoverShipItemTaskDNA(item=QuestItems.RareFeather, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_SHACKLEBY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveCompass': QuestDNA(obsolete=False, questInt=30340, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Compass, num=15, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_SHACKLEBY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveNavyShoeStrings': QuestDNA(obsolete=False, questInt=30343, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.NavyShoeString, num=20, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_STORMHAWK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveNavyAnchors': QuestDNA(obsolete=False, questInt=30344, tasks=(RecoverShipItemTaskDNA(item=QuestItems.NavyAnchor, num=15, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_STORMHAWK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveEITCParchment': QuestDNA(obsolete=False, questInt=30345, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.EITCParchment, num=10, enemyType=AvatarTypes.TradingCo, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_STORMHAWK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveEITCEmptyFlasks': QuestDNA(obsolete=False, questInt=30346, tasks=(RecoverShipItemTaskDNA(item=QuestItems.EmptyFlask, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_STORMHAWK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrievePlanksFromNavyShips': QuestDNA(obsolete=False, questInt=30349, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Plank, num=20, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveSailsFromEITCShips': QuestDNA(obsolete=False, questInt=30350, tasks=(RecoverShipItemTaskDNA(item=QuestItems.Sail, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveWheelFromUndeadShips': QuestDNA(obsolete=False, questInt=30351, tasks=(RecoverShipItemTaskDNA(item=QuestItems.ShipWheel, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatEITCShipsB': QuestDNA(obsolete=False, questInt=30352, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.TradingCo, num=20, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatNavyShipsB': QuestDNA(obsolete=False, questInt=30353, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=20, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveClothFromNavyShip': QuestDNA(obsolete=False, questInt=30355, tasks=(RecoverShipItemTaskDNA(item=QuestItems.BoltOfCloth, num=15, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Navy, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveCottonFromEITCShip': QuestDNA(obsolete=False, questInt=30356, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CottonYard, num=15, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.TradingCo, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveFabricFromNavyGuards': QuestDNA(obsolete=False, questInt=30357, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.NavyFabric, num=15, enemyType=AvatarTypes.Navy, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveThreadFromUndead': QuestDNA(obsolete=False, questInt=30358, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CursedThread, num=15, enemyType=AvatarTypes.Undead, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveCoinBagsFromEITCGuards': QuestDNA(obsolete=False, questInt=30359, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.CoinBag, num=15, enemyType=AvatarTypes.TradingCo, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveCursedSailClothFromUndead': QuestDNA(obsolete=False, questInt=30361, tasks=(RecoverShipItemTaskDNA(item=QuestItems.CursedSailCloth, num=10, maxAttempts=Attempts.INFREQUENT, probability=Probability.ALWAYS, faction=AvatarTypes.Undead, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveBileFromScorpions': QuestDNA(obsolete=False, questInt=30362, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Bile, num=10, enemyType=AvatarTypes.Scorpion, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveVenomFromWasps': QuestDNA(obsolete=False, questInt=30363, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.Venom, num=10, enemyType=AvatarTypes.Wasp, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveBatGuanoFromBats': QuestDNA(obsolete=False, questInt=30364, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.BatGuano, num=10, enemyType=AvatarTypes.Bat, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.retrieveGatorSalivaFromGators': QuestDNA(obsolete=False, questInt=30365, tasks=(RecoverAvatarItemTaskDNA(item=QuestItems.GatorSaliva, num=10, enemyType=AvatarTypes.Alligator, level=0, probability=Probability.ALWAYS, maxAttempts=Attempts.INFREQUENT),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitWilliamTurkA': QuestDNA(obsolete=False, questInt=30312, tasks=(VisitTaskDNA(npcId=NPCIds.WILLIAM_TURK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), prereqs=(GetFrom(questGivers=(NPCIds.NATHANIEL_TRUEHOUND,)),), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=10, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitNathanielA': QuestDNA(obsolete=False, questInt=30319, tasks=(VisitTaskDNA(npcId=NPCIds.NATHANIEL_TRUEHOUND),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitWilliamTurkB': QuestDNA(obsolete=False, questInt=30320, tasks=(VisitTaskDNA(npcId=NPCIds.WILLIAM_TURK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILLIAM_TURK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.deliverLuckyDeckToNathaniel': QuestDNA(obsolete=False, questInt=30324, tasks=(DeliverItemTaskDNA(item=QuestItems.LuckyDeck, num=1, npcId=NPCIds.NATHANIEL_TRUEHOUND),), rewards=(ClothingQuestReward(amount=ClothingGlobals.BASIC_OUTFIT_PART_A, bonus=False),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitWillTurnerA': QuestDNA(obsolete=False, questInt=30325, tasks=(VisitTaskDNA(npcId=NPCIds.WILL_TURNER),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.defeatNavyShips': QuestDNA(obsolete=False, questInt=30326, tasks=(DefeatShipTaskDNA(faction=AvatarTypes.Navy, num=20, level=0, isFlagship=False),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=True, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitNathanielB': QuestDNA(obsolete=False, questInt=30335, tasks=(VisitTaskDNA(npcId=NPCIds.NATHANIEL_TRUEHOUND),), rewards=(ClothingQuestReward(amount=ClothingGlobals.BASIC_OUTFIT_PART_B, bonus=False),), returnGiverIds=(NPCIds.WILL_TURNER,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitEdwardShackleby': QuestDNA(obsolete=False, questInt=30336, tasks=(VisitTaskDNA(npcId=NPCIds.EDWARD_SHACKLEBY),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_SHACKLEBY,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitNathanielC': QuestDNA(obsolete=False, questInt=30341, tasks=(VisitTaskDNA(npcId=NPCIds.NATHANIEL_TRUEHOUND),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitEdwardStormhawk': QuestDNA(obsolete=False, questInt=30342, tasks=(VisitTaskDNA(npcId=NPCIds.EDWARD_STORMHAWK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.EDWARD_STORMHAWK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitNathanielD': QuestDNA(obsolete=False, questInt=30347, tasks=(VisitTaskDNA(npcId=NPCIds.NATHANIEL_TRUEHOUND),), rewards=(ClothingQuestReward(amount=ClothingGlobals.BASIC_OUTFIT_PART_C, bonus=False),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitDarbyDryDock': QuestDNA(obsolete=False, questInt=30348, tasks=(VisitTaskDNA(npcId=NPCIds.DARBY_DRYDOCK),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.DARBY_DRYDOCK,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitNathanielE': QuestDNA(obsolete=False, questInt=30354, tasks=(VisitTaskDNA(npcId=NPCIds.NATHANIEL_TRUEHOUND),), rewards=(ClothingQuestReward(amount=ClothingGlobals.BASIC_OUTFIT_PART_D, bonus=False),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitBartholomewWatkins': QuestDNA(obsolete=False, questInt=30360, tasks=(VisitTaskDNA(npcId=NPCIds.BARTHOLOMEW_WATKINS),), rewards=(ReputationReward(amount=ExpRewards.SMALL),), returnGiverIds=(NPCIds.BARTHOLOMEW_WATKINS,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0),'OQB.visitNathanielF': QuestDNA(obsolete=False, questInt=30366, tasks=(VisitTaskDNA(npcId=NPCIds.NATHANIEL_TRUEHOUND),), rewards=(ClothingQuestReward(amount=ClothingGlobals.BASIC_OUTFIT_PART_E, bonus=False),), returnGiverIds=(NPCIds.NATHANIEL_TRUEHOUND,), combineOp=QuestDNA.OR, droppable=False, playStinger=True, displayGoal=True, progressBlock=False, finalQuest=False, acquireOnce=True, requiresVoyage=False, completeRequiresVisit=True, velvetRoped=False, minLevel=0, minWeapLevel=0, hideButton=False, timeLimit=0)}
for questId, questDNA in QuestDict.items():
    questDNA.setQuestId(questId)

if __dev__:
    for questDNA in QuestDict.values():
        questDNA.check()

questIntDict = {}
for questId, questDNA in QuestDict.items():
    questIntDict[questDNA.questInt] = questId

def getQuestIdFromQuestInt(questInt):
    return questIntDict.get(questInt)


questSpawns = {LocationIds.RAVENS_COVE_ISLAND: ['rc.3searchForSurvivors', 6]}