from pandac.PandaModules import Point3, VBase3, Vec4, Vec3
objectStruct = {
    'LevelEnvironment': {
        'BASE': {
            'EnvEffect': 1
        },
        'Dawn': {
            'AmbientColor': Vec4(0.44, 0.54, 0.69, 1),
            'BackColor': Vec4(0.45, 0.39, 0.35, 1),
            'Direction': Vec3(0.0, 35.0, 330.0),
            'FogColor': Vec4(0.32, 0.32, 0.28, 0),
            'FogExp': 0.004,
            'FrontColor': Vec4(1.51, 1.32, 1.03, 1),
            'SeaColor': Vec4(0.5, 0.4, 0.2, 1),
            'SeaFactor': Vec3(0.0, 0.0, 0.0),
            'SkyType': 10
        },
        'Day': {
            'AmbientColor': Vec4(0.44, 0.54, 0.69, 1),
            'BackColor': Vec4(0.45, 0.39, 0.35, 1),
            'FogColor': Vec4(0.32, 0.32, 0.28, 0),
            'FogExp': 0.004,
            'FrontColor': Vec4(1.51, 1.33, 1.04, 1),
            'SeaColor': Vec4(0.5, 0.4, 0.2, 1),
            'SeaFactor': Vec3(0.0, 0.0, 0.0),
            'SkyType': 10
        },
        'Dusk': {
            'AmbientColor': Vec4(0.44, 0.54, 0.69, 1),
            'BackColor': Vec4(0.45, 0.39, 0.35, 1),
            'Direction': Vec3(0.0, 35.0, 175.0),
            'FogColor': Vec4(0.32, 0.32, 0.28, 0),
            'FogExp': 0.004,
            'FrontColor': Vec4(1.51, 1.32, 1.03, 1),
            'SeaColor': Vec4(0.5, 0.4, 0.2, 1),
            'SeaFactor': Vec3(0.0, 0.0, 0.0),
            'SkyType': 10
        },
        'Night': {
            'AmbientColor': Vec4(0.13, 0.22, 0.21, 1),
            'BackColor': Vec4(0.9, 1.3, 1.28, 1),
            'Direction': Vec3(0.0, 40.0, 90.0),
            'FogColor': Vec4(0.09, 0.18, 0.2, 0),
            'FogExp': 0.0055,
            'FrontColor': Vec4(0.23, 0.25, 0.32, 1),
            'SeaColor': Vec4(0.5, 0.4, 0.2, 1),
            'SeaFactor': Vec3(0.0, 0.0, 0.0),
            'SkyType': 11
        },
        'Stars': {
            'AmbientColor': Vec4(0.13, 0.22, 0.21, 1),
            'BackColor': Vec4(0.9, 1.3, 1.28, 1),
            'Direction': Vec3(0.0, 40.0, 20.0),
            'FogColor': Vec4(0.09, 0.18, 0.2, 0),
            'FogExp': 0.0055,
            'FrontColor': Vec4(0.23, 0.25, 0.32, 1),
            'SeaColor': Vec4(0.5, 0.4, 0.2, 1),
            'SeaFactor': Vec3(0.0, 0.0, 0.0),
            'SkyType': 11
        }
    },
    'Objects': {
        '1151689243.57hreister': {
            'Type': 'Island',
            'Name': 'pirateerCove1',
            'File': '',
            'Objects': {
                '1151689490.21hreister': {
                    'Type': 'Player Spawn Node',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(35.883, 16.415, 140.855),
                    'Scale': VBase3(0.728, 0.728, 0.728),
                    'Spawnables': 'Team 2'
                },
                '1151690471.18hreister': {
                    'Type': 'Event Sphere',
                    'Collide Type': 'Object',
                    'Event Type': 'Port',
                    'Extra Param': 'Team 2',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(223.914, 0.066, -15.4),
                    'Scale': VBase3(120.0, 120.0, 120.0)
                },
                '1156210410.53bbathen': {
                    'Type': 'Rock',
                    'GridPos': Point3(17.228, -264.876, 16.741),
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Objects': {},
                    'Pos': Point3(17.228, -291.741, -14.091),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/zz_dont_use_rock_Dk_1F'
                    }
                },
                '1156210474.53bbathen': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(21.102, 1.441, 0.0),
                    'Pos': Point3(-12.668, -150.971, 66.122),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/fern_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/fern_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/fern_trunk_a_idle',
                        'Model': 'models/vegetation/fern_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1156271007.17bbathen': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-155.654, -11.41, 24.698),
                    'Objects': {},
                    'Pos': Point3(-326.2, -131.985, 44.308),
                    'Scale': VBase3(4.051, 4.051, 4.051),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_sphere'
                    }
                },
                '1156272251.25bbathen': {
                    'Type': 'Tree',
                    'Hpr': VBase3(42.505, 0.0, 0.0),
                    'Pos': Point3(-9.312, -168.894, 63.809),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1156356079.1bbathen': {
                    'Type': 'Tree - Animated',
                    'GridPos': Point3(-11.726, -142.15, 101.938),
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(-16.169, -161.4, 70.042),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1159462943.35kmuller': {
                    'Type': 'Pier',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Objects': {
                        '1159571614.58kmuller': {
                            'Type': 'Ship_Props',
                            'GridPos': Point3(125.163, -13.766, 5.738),
                            'Hpr': VBase3(86.435, -29.516, -7.526),
                            'Pos': Point3(-5.188, -3.626, 9.031),
                            'Scale': VBase3(1.953, 1.953, 1.953),
                            'Visual': {
                                'Model': 'models/props/anchor'
                            }
                        },
                        '1159577833.43kmuller': {
                            'Type': 'Rope',
                            'GridPos': Point3(137.554, 6.72, 5.414),
                            'Hpr': Point3(0.0, 0.0, 0.0),
                            'Pos': Point3(19.015, 36.385, 8.398),
                            'Scale': VBase3(1.0, 1.0, 1.0),
                            'Visual': {
                                'Model': 'models/props/rope_pile'
                            }
                        },
                        '1159577902.76kmuller': {
                            'Type': 'Barrel',
                            'GridPos': Point3(136.747, 0.721, 5.601),
                            'Hpr': VBase3(65.711, 0.0, 0.0),
                            'Pos': Point3(14.048, 31.793, 8.764),
                            'Scale': VBase3(0.66, 0.66, 0.66),
                            'Visual': {
                                'Model': 'models/props/barrel_group_3'
                            }
                        },
                        '1159578015.84kmuller': {
                            'Type': 'Prop_Groups',
                            'GridPos': Point3(118.205, -12.353, 5.461),
                            'Hpr': VBase3(-167.721, 0.0, 0.0),
                            'Pos': Point3(-22.167, 6.258, 8.489),
                            'Scale': VBase3(1.953, 1.953, 1.953),
                            'Visual': {
                                'Color': (0.8999999761581421, 0.8999999761581421, 0.699999988079071, 1.0),
                                'Model': 'models/props/prop_group_A'
                            }
                        },
                        '1160092193.11kmuller': {
                            'Type': 'Crane',
                            'GridPos': Point3(150.355, 15.875, 5.461),
                            'Hpr': VBase3(87.511, 33.421, 2.485),
                            'Pos': Point3(44.015, 54.265, 8.489),
                            'Scale': VBase3(1.06, 1.06, 1.06),
                            'Visual': {
                                'Model': 'models/props/Crane_A'
                            }
                        }
                    },
                    'Pos': Point3(127.819, -11.909, 1.114),
                    'Scale': VBase3(0.512, 0.512, 0.512),
                    'Visual': {
                        'Model': 'models/islands/pier_platform'
                    }
                },
                '1159551936.72kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-25.412, -16.788, 8.189),
                    'Pos': Point3(280.455, -289.323, -30.008),
                    'Scale': VBase3(1.45, 1.45, 1.45),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1159552023.43kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-139.427, 0.0, 0.0),
                    'Pos': Point3(482.128, 143.608, -16.095),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.75, 0.9300000071525574, 1.0, 1.0),
                        'Model': 'models/props/mound_brown_small'
                    }
                },
                '1159552271.06kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-8.308, -0.089, 5.907),
                    'Pos': Point3(-308.509, 139.874, -167.699),
                    'Scale': VBase3(1.052, 1.052, 1.052),
                    'Visual': {
                        'Color': (0.5, 0.5, 0.5, 1.0),
                        'Model': 'models/props/mound_light_lrg'
                    }
                },
                '1159552371.25kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-28.803, 6.184, -1.43),
                    'Pos': Point3(-310.336, 1.171, 31.467),
                    'Scale': VBase3(1.09, 1.09, 1.09),
                    'Visual': {
                        'Color': (0.5, 0.5, 0.5, 1.0),
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1159552660.83kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-63.724, 0.0, 0.0),
                    'Pos': Point3(-259.716, -184.014, 27.584),
                    'Scale': VBase3(10.561, 10.561, 10.561),
                    'Visual': {
                        'Color': (0.7490196228027344, 0.7137255072593689, 0.6000000238418579, 1.0),
                        'Model': 'models/props/rock_4_sphere'
                    }
                },
                '1159552691.26kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-9.53, 13.579, 0.0),
                    'Pos': Point3(-228.164, -134.528, 51.035),
                    'Scale': VBase3(5.431, 5.431, 5.431),
                    'Visual': {
                        'Color': (0.7686274647712708, 0.7333333492279053, 0.6117647290229797, 1.0),
                        'Model': 'models/props/rock_group_5_sphere'
                    }
                },
                '1159552807.56kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-71.639, 12.297, 0.0),
                    'Pos': Point3(136.747, -316.567, 19.022),
                    'Scale': VBase3(2.649, 2.649, 2.649),
                    'Visual': {
                        'Model': 'models/props/rock_group_5_sphere'
                    }
                },
                '1159555763.83kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-66.696, -3.435, 9.957),
                    'Pos': Point3(-2.472, -153.201, 65.9),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159555884.76kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(76.199, -189.379, 51.86),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.800000011920929, 1.0, 1.0),
                        'Model': 'models/vegetation/gen_tree_b'
                    }
                },
                '1159556024.17kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-96.648, 3.168, 8.571),
                    'Pos': Point3(-267.884, -152.159, 39.972),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159567540.84kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, -2.362),
                    'Pos': Point3(328.194, 142.054, 58.608),
                    'Scale': VBase3(0.797, 0.797, 0.797),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1159567716.55kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-29.826, 0.0, 2.816),
                    'Pos': Point3(317.172, -313.58, -20.67),
                    'Scale': VBase3(0.384, 0.384, 0.384),
                    'Visual': {
                        'Model': 'models/props/mound_light_med2'
                    }
                },
                '1159567796.47kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-31.983, -18.166, 10.863),
                    'Pos': Point3(334.222, -330.656, 3.103),
                    'Scale': VBase3(1.341, 1.341, 1.341),
                    'Visual': {
                        'Color': (0.75, 0.9300000071525574, 1.0, 1.0),
                        'Model': 'models/props/rock_1_floor'
                    }
                },
                '1159568081.89kmuller': {
                    'Type': 'Treasure Duck',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(276.485, -380.981, 9.725),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_d' #models/islands/treasureDuck'
                    }
                },
                '1159568276.33kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-26.052, 0.0, 0.0),
                    'Pos': Point3(-187.158, -214.384, 27.33),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.800000011920929, 1.0, 0.6000000238418579, 1.0),
                        'Model': 'models/vegetation/gen_tree_d'
                    }
                },
                '1159568349.97kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-50.85, -0.147, -0.135),
                    'Pos': Point3(-241.507, -140.072, 56.57),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.800000011920929, 0.6000000238418579, 1.0, 1.0),
                        'Model': 'models/vegetation/gen_tree_b'
                    }
                },
                '1159568456.23kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(-287.462, -139.622, 40.603),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.5, 0.5, 0.5, 1.0),
                        'Model': 'models/vegetation/gen_tree_c'
                    }
                },
                '1159569544.56kmuller': {
                    'Type': 'Cart',
                    'Hpr': VBase3(56.416, 0.0, 0.0),
                    'Pos': Point3(94.718, 91.434, 93.657),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/cart_flat'
                    }
                },
                '1159569614.05kmuller': {
                    'Type': 'Cart',
                    'Hpr': VBase3(-145.546, 0.0, 0.0),
                    'Pos': Point3(184.031, 159.463, 50.767),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/cart_broken'
                    }
                },
                '1159569712.45kmuller': {
                    'Type': 'Crate',
                    'Hpr': VBase3(-12.104, 0.0, 0.0),
                    'Pos': Point3(131.149, 231.726, 94.608),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.8999999761581421, 0.8999999761581421, 0.699999988079071, 1.0),
                        'Model': 'models/props/crates_group_1'
                    }
                },
                '1159569773.83kmuller': {
                    'Type': 'Crate',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(129.324, 225.442, 94.664),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.800000011920929, 0.800000011920929, 0.800000011920929, 1.0),
                        'Model': 'models/props/crate'
                    }
                },
                '1159569900.09kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(134.877, 0.0, 0.0),
                    'Pos': Point3(155.355, 227.199, 94.949),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group01'
                    }
                },
                '1159570204.98kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(1.691, 0.0, 0.0),
                    'Pos': Point3(90.689, 57.114, 26.048),
                    'Scale': VBase3(1.08, 1.08, 1.08),
                    'Visual': {
                        'Model': 'models/props/rock_1_sphere'
                    }
                },
                '1159570260.37kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(37.952, 0.0, -17.231),
                    'Pos': Point3(92.15, 53.89, 29.103),
                    'Scale': VBase3(2.63, 2.63, 2.63),
                    'Visual': {
                        'Model': 'models/props/rock_3_sphere'
                    }
                },
                '1159571261.97kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(59.691, 0.0, 0.0),
                    'Pos': Point3(81.947, 43.111, 27.714),
                    'Scale': VBase3(3.17, 3.17, 3.17),
                    'Visual': {
                        'Model': 'models/props/rock_4_sphere'
                    }
                },
                '1159571492.72kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(154.83, 39.311, -20.125),
                    'Pos': Point3(80.323, 40.333, 39.115),
                    'Scale': VBase3(3.693, 3.693, 3.693),
                    'Visual': {
                        'Model': 'models/props/rock_2_floor'
                    }
                },
                '1159572021.7kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(330.908, -314.948, 7.616),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1159572104.36kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(321.917, -329.264, 18.439),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1159572148.33kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 3.927, 0.0),
                    'Pos': Point3(297.844, -354.741, 16.787),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159572175.89kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(106.77, -1.135, -15.362),
                    'Pos': Point3(281.254, -342.8, 26.356),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159572361.37kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-38.292, -25.467, 2.768),
                    'Pos': Point3(326.575, -323.236, 14.535),
                    'Scale': VBase3(0.727, 0.727, 0.727),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159572620.67kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(460.879, 93.691, 27.747),
                    'Scale': VBase3(1.938, 1.938, 1.938),
                    'Visual': {
                        'Model': 'models/vegetation/palm_tree_d'
                    }
                },
                '1159572763.56kmuller': {
                    'Type': 'Bush',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(461.453, 93.801, 28.456),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1159572937.51kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, 0.0, 12.267),
                    'Pos': Point3(481.777, 79.103, 25.15),
                    'Scale': VBase3(1.532, 1.532, 1.532),
                    'Visual': {
                        'Model': 'models/props/rock_4_floor'
                    }
                },
                '1159572983.98kmuller': {
                    'Type': 'Rock',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(476.518, 81.198, 27.329),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_1_floor'
                    }
                },
                '1159573082.42kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-42.664, -2.98, -0.456),
                    'Pos': Point3(449.88, 82.217, 30.68),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159573356.83kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(427.429, 84.88, 32.386),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1159573502.25kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-28.985, 0.262, 4.839),
                    'Pos': Point3(375.19, 74.616, 39.76),
                    'Scale': VBase3(0.598, 0.598, 0.598),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1159573636.08kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(378.551, 76.318, 38.858),
                    'Scale': VBase3(1.286, 1.286, 1.286),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_d'
                    }
                },
                '1159573702.3kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, -0.247, 0.0),
                    'Pos': Point3(383.415, 62.067, 37.646),
                    'Scale': VBase3(0.774, 0.774, 0.774),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1159573798.31kmuller': {
                    'Type': 'Rock',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(379.555, 70.661, 39.143),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_5_floor'
                    }
                },
                '1159573818.67kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-30.933, 0.0, 3.472),
                    'Pos': Point3(367.928, 90.031, 40.487),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_floor'
                    }
                },
                '1159574029.58kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(95.713, 7.08, -14.89),
                    'Pos': Point3(367.985, 135.344, 49.503),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_sphere'
                    }
                },
                '1159574144.55kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-332.954, -94.582, 43.9),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.699999988079071, 0.699999988079071, 0.699999988079071, 1.0),
                        'Model': 'models/vegetation/gen_tree_e'
                    }
                },
                '1159574235.97kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-131.798, 0.0, 0.0),
                    'Pos': Point3(-421.345, 36.296, -71.178),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_med2'
                    }
                },
                '1159574274.31kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-170.734, 8.107, 0.0),
                    'Pos': Point3(-461.749, 192.478, -61.648),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_med'
                    }
                },
                '1159574356.55kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(19.438, 0.0, 0.0),
                    'Pos': Point3(-257.86, 319.743, -77.905),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_med2'
                    }
                },
                '1159574445.28kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-177.502, 8.982, 0.0),
                    'Pos': Point3(-228.172, 278.025, 21.224),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1159574574.47kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(10.394, 1.051, 5.712),
                    'Pos': Point3(-85.33, 274.699, -25.217),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_med2'
                    }
                },
                '1159574802.43kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(40.671, 0.789, 2.772),
                    'Pos': Point3(-147.316, 303.321, 30.059),
                    'Scale': VBase3(1.596, 1.596, 1.596),
                    'Visual': {
                        'Model': 'models/props/rock_group_2_sphere'
                    }
                },
                '1159575469.14kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-125.848, 12.939, -9.174),
                    'Pos': Point3(89.134, 377.402, 4.296),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_leaves'
                    }
                },
                '1159576451.58kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 4.113, 0.0),
                    'Pos': Point3(287.95, -351.596, 21.63),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1159576510.05kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, 16.11, 0.0),
                    'Objects': {
                        '1159576548.67kmuller': {
                            'Type': 'Bush',
                            'GridPos': Point3(312.343, -358.994, 14.296),
                            'Hpr': VBase3(82.232, 4.091, 10.747),
                            'Pos': Point3(2.667, -0.516, -2.022),
                            'Scale': VBase3(0.849, 0.849, 0.849),
                            'Visual': {
                                'Model': 'models/vegetation/bush_leaves'
                            }
                        }
                    },
                    'Pos': Point3(309.676, -359.059, 16.382),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_2_floor'
                    }
                },
                '1159576738.75kmuller': {
                    'Type': 'Bush',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-332.517, -120.151, 47.565),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1159576857.62kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-20.51, 0.715, 0.267),
                    'Pos': Point3(-313.366, -131.823, 44.085),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159576923.68kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-367.705, -82.429, 37.277),
                    'Scale': VBase3(1.272, 1.272, 1.272),
                    'Visual': {
                        'Color': (0.5, 0.5, 0.5, 1.0),
                        'Model': 'models/vegetation/gen_tree_a'
                    }
                },
                '1159577147.55kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(10.256, 3.661, 10.531),
                    'Objects': {
                        '1159828247.64kmuller': {
                            'Type': 'Bush',
                            'GridPos': Point3(487.764, 89.707, 24.025),
                            'Hpr': VBase3(90.909, -7.786, -0.979),
                            'Pos': Point3(3.466, -0.432, -1.202),
                            'Scale': VBase3(1.0, 1.0, 1.0),
                            'Visual': {
                                'Model': 'models/vegetation/bush_leaves'
                            }
                        }
                    },
                    'Pos': Point3(484.571, 89.45, 25.864),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_2_floor'
                    }
                },
                '1159577236.53kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(36.561, 5.564, 7.449),
                    'Pos': Point3(490.406, 112.076, 14.661),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_g'
                    }
                },
                '1159577268.76kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(40.854, 0.0, 2.729),
                    'Pos': Point3(493.761, 107.048, 17.629),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.800000011920929, 1.0, 1.0),
                        'Model': 'models/vegetation/bush_h'
                    }
                },
                '1159577448.97kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(460.697, 55.325, 25.766),
                    'Scale': VBase3(0.773, 0.773, 0.773),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_b'
                    }
                },
                '1159808554.82kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(-46.878, 298.399, 33.572),
                    'Scale': VBase3(4.718, 4.718, 4.718),
                    'Visual': {
                        'Color': (0.4000000059604645, 0.4000000059604645, 0.4000000059604645, 1.0),
                        'Model': 'models/props/rock_4_floor'
                    }
                },
                '1159809108.24kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, -34.054, 0.0),
                    'Pos': Point3(80.822, 376.287, 3.267),
                    'Scale': VBase3(2.398, 2.398, 2.398),
                    'Visual': {
                        'Model': 'models/props/rock_group_2_sphere'
                    }
                },
                '1159809191.47kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(84.187, 338.048, 39.396),
                    'Scale': VBase3(1.936, 1.936, 1.936),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/vegetation/gen_tree_a'
                    }
                },
                '1159809750.24kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(36.344, 0.0, 0.0),
                    'Pos': Point3(-150.182, 284.433, 35.556),
                    'Scale': VBase3(0.638, 0.638, 0.638),
                    'Visual': {
                        'Color': (0.699999988079071, 0.699999988079071, 0.699999988079071, 1.0),
                        'Model': 'models/vegetation/gen_tree_e'
                    }
                },
                '1159809773.05kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-176.594, 0.0, 0.0),
                    'Pos': Point3(-39.495, 343.906, 22.94),
                    'Scale': VBase3(1.216, 1.216, 1.216),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1159809939.04kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(38.122, 0.997, 15.621),
                    'Pos': Point3(86.578, 337.487, 37.666),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1159810168.47kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-161.519, 0.0, 0.0),
                    'Pos': Point3(91.219, 38.666, 24.772),
                    'Scale': VBase3(3.902, 3.902, 3.902),
                    'Visual': {
                        'Model': 'models/props/rock_group_4_sphere'
                    }
                },
                '1159812067.85kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.847, 0.0, 0.0),
                    'Pos': Point3(-188.45, -213.776, 27.064),
                    'Scale': VBase3(0.43, 0.43, 0.43),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1159812173.0kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-62.908, 19.034, 16.857),
                    'Pos': Point3(-212.63, -153.108, 52.036),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159812223.8kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.378, 14.587, -7.248),
                    'Pos': Point3(-196.219, -217.006, 26.664),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_4_floor'
                    }
                },
                '1159812273.94kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(86.074, 8.015, -2.859),
                    'Pos': Point3(-299.491, -77.724, 57.469),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159812329.64kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-80.966, 16.721, 4.683),
                    'Pos': Point3(-247.082, -112.864, 57.642),
                    'Scale': VBase3(1.819, 1.819, 1.819),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159812384.66kmuller': {
                    'Type': 'Bush',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-252.112, -132.109, 48.897),
                    'Scale': VBase3(0.822, 0.822, 0.822),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1159812656.82kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-113.113, 32.167, -16.862),
                    'Pos': Point3(-335.388, -76.389, 52.285),
                    'Scale': VBase3(4.449, 4.449, 4.449),
                    'Visual': {
                        'Model': 'models/props/rock_group_5_sphere'
                    }
                },
                '1159812708.97kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(36.99, -5.562, -4.527),
                    'Pos': Point3(-361.984, 13.21, -5.355),
                    'Scale': VBase3(8.631, 8.631, 8.631),
                    'Visual': {
                        'Color': (0.6705882549285889, 0.6705882549285889, 0.6705882549285889, 1.0),
                        'Model': 'models/props/rock_group_3_sphere'
                    }
                },
                '1159814714.5kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(177.756, 11.238, 4.513),
                    'Pos': Point3(-43.025, 334.308, 30.653),
                    'Scale': VBase3(0.894, 0.894, 0.894),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159814783.22kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-39.413, -26.747, -17.793),
                    'Pos': Point3(-50.081, 351.927, 20.907),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159819753.96kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(115.518, 0.26, 1.451),
                    'Pos': Point3(-21.003, -169.065, 65.699),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_b_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1159820042.97kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(467.778, 107.141, 25.246),
                    'Scale': VBase3(1.356, 1.356, 1.356),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1159820087.38kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, 9.138),
                    'Pos': Point3(475.576, 102.853, 27.603),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159820178.24kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, 9.138),
                    'Pos': Point3(460.584, 109.293, 28.609),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159820306.86kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-51.943, 0.0, 0.0),
                    'Pos': Point3(256.987, -323.304, 33.683),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1159820328.55kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-128.738, 0.0, 0.0),
                    'Pos': Point3(253.189, -317.99, 34.874),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1159820372.1kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-128.738, -13.356, -0.084),
                    'Pos': Point3(279.214, -347.268, 23.679),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1159820467.16kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(163.803, -20.131, 2.185),
                    'Pos': Point3(193.44, -286.21, 52.87),
                    'Scale': VBase3(2.047, 2.047, 2.047),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_sphere'
                    }
                },
                '1159820521.38kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(43.525, 8.369, -1.748),
                    'Pos': Point3(192.752, -284.432, 52.298),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_leaves'
                    }
                },
                '1159820544.63kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(109.042, 11.347, -7.123),
                    'Pos': Point3(194.502, -286.57, 52.933),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_leaves'
                    }
                },
                '1159821155.19kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(87.755, 2.718, 0.0),
                    'Pos': Point3(203.988, -245.912, 56.101),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1159821184.77kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-102.246, -11.31, -3.197),
                    'Pos': Point3(201.691, -219.049, 56.164),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159821255.02kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(-11.216, -0.799, 8.465),
                    'Pos': Point3(209.01, -232.51, 51.212),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/fern_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/fern_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/fern_trunk_a_idle',
                        'Model': 'models/vegetation/fern_short_trunk_d_hi',
                        'PartName': 'trunk'
                    }
                },
                '1159822396.69kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(184.142, 250.274, 71.366),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_d'
                    }
                },
                '1159822453.88kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(484.603, 114.667, 17.269),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1159822498.43kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-35.889, -19.917, 0.0),
                    'Pos': Point3(486.79, 97.751, 23.769),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159823503.19kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-71.391, 0.0, 0.0),
                    'Pos': Point3(-193.766, 340.465, -59.27),
                    'Scale': VBase3(0.914, 0.914, 0.914),
                    'Visual': {
                        'Model': 'models/props/mound_light_med'
                    }
                },
                '1159826560.75kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-27.273, -6.604, 12.575),
                    'Pos': Point3(185.669, 227.143, 72.26),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_2_floor'
                    }
                },
                '1159826605.86kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 8.144, 0.0),
                    'Pos': Point3(187.952, 214.812, 68.462),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159826648.83kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, -2.983, 0.0),
                    'Pos': Point3(185.402, 251.404, 71.699),
                    'Scale': VBase3(0.401, 0.401, 0.401),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1159826706.13kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(8.512, -5.819, 0.869),
                    'Pos': Point3(191.333, 249.819, 69.992),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_5_floor'
                    }
                },
                '1159827084.23kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-39.77, 0.0, 10.969),
                    'Pos': Point3(-313.101, -78.912, 60.218),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159827151.34kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-69.277, 1.86, 4.904),
                    'Pos': Point3(-27.955, -150.499, 67.525),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159827194.69kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(165.885, 3.095, 1.486),
                    'Pos': Point3(5.671, -145.009, 66.589),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159827293.19kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-0.563, 6.241, 7.712),
                    'Pos': Point3(76.367, -196.309, 51.446),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1159827323.89kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-5.138, 14.019, 0.742),
                    'Pos': Point3(78.396, -175.296, 56.556),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159827433.94kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(45.58, 5.441, 1.287),
                    'Pos': Point3(67.107, -195.983, 52.047),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159827751.34kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(60.287, 0.0, 0.0),
                    'Pos': Point3(411.49, 183.338, 75.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group01'
                    }
                },
                '1159827773.75kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(109.138, 0.0, 0.0),
                    'Pos': Point3(403.011, 178.893, 75.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.8500000238418579, 0.8199999928474426, 0.7300000190734863, 1.0),
                        'Model': 'models/props/prop_group_A'
                    }
                },
                '1159827833.78kmuller': {
                    'Type': 'Crate',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(403.815, 181.844, 75.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.699999988079071, 0.7300000190734863, 0.5799999833106995, 1.0),
                        'Model': 'models/props/crates_group_2'
                    }
                },
                '1159827876.98kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-145.221, 0.0, 0.0),
                    'Pos': Point3(389.397, 129.714, 75.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.7960784435272217, 0.7764706015586853, 0.7019608020782471, 1.0),
                        'Model': 'models/props/bench'
                    }
                },
                '1159827903.44kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(32.707, 0.0, 0.0),
                    'Pos': Point3(394.271, 122.577, 75.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.7058823704719543, 0.7882353067398071, 0.6666666865348816, 1.0),
                        'Model': 'models/props/bench'
                    }
                },
                '1159827998.0kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(37.743, 0.0, 0.0),
                    'Pos': Point3(391.822, 125.737, 75.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/table_bar_square'
                    }
                },
                '1159828030.8kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(-25.905, 0.0, 0.0),
                    'Pos': Point3(377.95, 142.431, 75.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group01'
                    }
                },
                '1159828201.78kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, 6.067),
                    'Pos': Point3(465.206, 55.653, 26.669),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159828344.08kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-87.173, -10.9, 0.0),
                    'Pos': Point3(347.49, 147.984, 57.848),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159828386.05kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(58.076, 1.617, 1.007),
                    'Pos': Point3(370.342, 135.758, 46.48),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_leaves'
                    }
                },
                '1159828411.23kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(18.434, 0.571, 0.0),
                    'Pos': Point3(159.217, -226.249, 55.402),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159828441.53kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-117.172, -0.779, -0.4),
                    'Pos': Point3(146.939, -207.249, 56.069),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159828498.22kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, 0.0, -0.741),
                    'Pos': Point3(151.952, -215.029, 56.322),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_floor'
                    }
                },
                '1159828544.45kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(120.408, -25.837, -5.285),
                    'Pos': Point3(113.723, -317.952, 12.713),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159828600.58kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(86.481, -23.93, -6.345),
                    'Pos': Point3(136.749, -311.776, 24.563),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159828637.78kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(126.899, -325.687, 15.514),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1159828651.77kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(99.108, -13.292, 0.809),
                    'Pos': Point3(120.99, -302.217, 22.85),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1159828984.64kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(75.94, 0.0, 0.0),
                    'Pos': Point3(161.967, 220.075, 111.562),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/bench'
                    }
                },
                '1159829030.14kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-123.404, 0.0, 0.0),
                    'Pos': Point3(156.156, 178.561, 92.529),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/chair_bar'
                    }
                },
                '1159830989.97kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(18.391, 0.0, 0.0),
                    'Pos': Point3(-157.11, -78.605, 71.481),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1159831052.66kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(67.36, 2.072, -6.094),
                    'Pos': Point3(-153.165, -114.134, 79.017),
                    'Scale': VBase3(1.228, 1.228, 1.228),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/tree_b_leaf_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/tree_b_leaf_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/tree_b_trunk_idle',
                        'Color': (0.5, 0.5, 0.5, 1.0),
                        'Model': 'models/vegetation/tree_b_trunk_hi',
                        'PartName': 'trunk'
                    }
                },
                '1159831207.56kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-113.717, -0.191, -28.153),
                    'Pos': Point3(-138.076, -323.334, -114.944),
                    'Scale': VBase3(0.685, 0.685, 0.685),
                    'Visual': {
                        'Model': 'models/props/mound_light_lrg'
                    }
                },
                '1159831347.58kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(31.229, -2.062, 0.675),
                    'Pos': Point3(-222.775, -283.243, -62.713),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_med'
                    }
                },
                '1159832143.33kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(42.755, 0.0, 0.0),
                    'Pos': Point3(4.687, 228.048, 91.675),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_d'
                    }
                },
                '1159832489.52kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(110.524, 0.0, 8.257),
                    'Pos': Point3(163.037, 52.918, -17.865),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1159832534.78kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(117.743, -33.477, -10.319),
                    'Pos': Point3(297.482, 152.094, -18.666),
                    'Scale': VBase3(0.817, 0.817, 0.817),
                    'Visual': {
                        'Model': 'models/props/mound_light_med'
                    }
                },
                '1159832931.23kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(208.264, -223.138, 58.732),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/vegetation/gen_tree_c'
                    }
                },
                '1159833586.94kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(50.779, 0.0, 0.716),
                    'Pos': Point3(-145.702, -356.137, -64.892),
                    'Scale': VBase3(0.628, 0.628, 0.628),
                    'Visual': {
                        'Color': (0.7176470756530762, 0.7176470756530762, 0.7176470756530762, 1.0),
                        'Model': 'models/props/mound_light_med2'
                    }
                },
                '1159834163.33kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(149.198, 2.408, 3.313),
                    'Pos': Point3(575.534, -47.766, -20.566),
                    'Scale': VBase3(0.839, 0.839, 0.839),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1159834265.98kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(103.64, -2.721, -7.064),
                    'Pos': Point3(258.667, 135.252, 8.28),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1159834376.53kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(44.333, 144.409, 74.923),
                    'Scale': VBase3(1.305, 1.305, 1.305),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_a'
                    }
                },
                '1159834611.28kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(49.815, 0.0, 0.0),
                    'Pos': Point3(128.452, 88.03, 16.451),
                    'Scale': VBase3(0.606, 0.606, 0.606),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_e'
                    }
                },
                '1159912937.08kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(167.116, 7.695, 9.833),
                    'Pos': Point3(-176.683, 267.52, 38.502),
                    'Scale': VBase3(3.54, 3.54, 3.54),
                    'Visual': {
                        'Color': (0.75, 0.9300000071525574, 1.0, 1.0),
                        'Model': 'models/props/rock_group_5_sphere'
                    }
                },
                '1159912990.38kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-152.567, 8.94, 4.223),
                    'Pos': Point3(-187.428, 268.756, 31.111),
                    'Scale': VBase3(1.777, 1.777, 1.777),
                    'Visual': {
                        'Color': (0.8700000047683716, 1.0, 1.0, 1.0),
                        'Model': 'models/props/rock_group_4_sphere'
                    }
                },
                '1159913095.53kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-44.579, -9.046, -4.602),
                    'Pos': Point3(-140.682, 298.474, 33.247),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159913183.77kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.266, -19.054, -2.695),
                    'Pos': Point3(-49.888, 345.018, 25.327),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1159913401.3kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(110.831, -3.394, 0.0),
                    'Pos': Point3(-202.798, 305.088, 18.795),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_c_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1159913473.06kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(1.956, 0.0, -0.289),
                    'Pos': Point3(-189.168, 318.947, 17.287),
                    'Scale': VBase3(1.267, 1.267, 1.267),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_b_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Color': (0.8999999761581421, 0.8999999761581421, 0.8999999761581421, 1.0),
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1159913539.72kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(8.766, -23.67, -19.13),
                    'Pos': Point3(-194.989, 309.917, 20.765),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1159913595.05kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(18.381, -11.018, -6.88),
                    'Pos': Point3(-201.045, 300.626, 21.689),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1159913660.17kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-1.475, -12.769, -16.236),
                    'Pos': Point3(-171.71, 320.164, 20.767),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1159913690.28kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(48.941, -8.388, 9.337),
                    'Pos': Point3(-181.292, 283.792, 35.341),
                    'Scale': VBase3(0.725, 0.725, 0.725),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1159913748.98kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-154.032, 26.916, 4.68),
                    'Pos': Point3(-151.372, 373.87, 3.101),
                    'Scale': VBase3(1.387, 1.387, 1.387),
                    'Visual': {
                        'Color': (0.8700000047683716, 1.0, 1.0, 1.0),
                        'Model': 'models/props/rock_group_4_floor'
                    }
                },
                '1159913793.27kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-145.596, 23.029, 1.457),
                    'Pos': Point3(-21.825, 286.795, 64.829),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159913823.23kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(92.786, -13.649, 22.445),
                    'Pos': Point3(-8.467, 275.49, 72.805),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1159913908.91kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(7.595, -24.364, -2.264),
                    'Pos': Point3(-115.854, 322.337, 24.034),
                    'Scale': VBase3(1.387, 1.387, 1.387),
                    'Visual': {
                        'Color': (0.8700000047683716, 1.0, 1.0, 1.0),
                        'Model': 'models/props/rock_group_3_floor'
                    }
                },
                '1159913989.36kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(61.066, -9.66, -1.666),
                    'Pos': Point3(64.891, 379.804, 1.268),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160010583.66kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, -25.173, 5.184),
                    'Pos': Point3(-74.792, 209.827, 60.487),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1160010939.56kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(47.681, -29.978, 16.541),
                    'Pos': Point3(77.726, 338.28, 38.807),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160010963.06kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(128.817, 25.461, 11.39),
                    'Pos': Point3(83.998, 328.947, 44.357),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160011009.56kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, -9.072, 3.411),
                    'Pos': Point3(96.653, 337.202, 34.785),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160011037.36kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, -41.615, 11.334),
                    'Pos': Point3(88.535, 345.815, 32.659),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_floor'
                    }
                },
                '1160011089.92kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(36.636, -4.403, 0.0),
                    'Pos': Point3(17.697, 324.902, -4.399),
                    'Scale': VBase3(0.889, 0.889, 0.889),
                    'Visual': {
                        'Model': 'models/props/mound_light_med'
                    }
                },
                '1160011247.69kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.067, -1.558, 2.47),
                    'Pos': Point3(-33.953, 346.627, 20.996),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1160011305.61kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.243, -1.812, 5.652),
                    'Pos': Point3(-39.178, 355.656, 14.729),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160011437.08kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(-9.878, 289.492, 66.937),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_d'
                    }
                },
                '1160011469.1kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-0.162, -1.095, 0.0),
                    'Pos': Point3(-34.678, 221.206, 76.041),
                    'Scale': VBase3(0.614, 0.614, 0.614),
                    'Visual': {
                        'Color': (0.800000011920929, 0.800000011920929, 0.800000011920929, 1.0),
                        'Model': 'models/vegetation/gen_tree_e'
                    }
                },
                '1160011826.73kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-27.592, 0.0, -1.842),
                    'Pos': Point3(-30.723, 416.53, -66.56),
                    'Scale': VBase3(1.246, 1.246, 1.246),
                    'Visual': {
                        'Model': 'models/props/mound_light_med'
                    }
                },
                '1160012059.92kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(96.918, 6.259, 12.762),
                    'Pos': Point3(-49.4, -155.593, 41.912),
                    'Scale': VBase3(0.881, 0.881, 0.881),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1160067780.83kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-27.417, -14.037, -2.109),
                    'Pos': Point3(-115.773, -139.188, 53.919),
                    'Scale': VBase3(0.881, 0.881, 0.881),
                    'Visual': {
                        'Model': 'models/props/mound_light_small'
                    }
                },
                '1160067796.64kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(143.576, 13.549, 4.26),
                    'Pos': Point3(-107.41, -168.629, 8.443),
                    'Scale': VBase3(0.881, 0.881, 0.881),
                    'Visual': {
                        'Model': 'models/props/mound_light_med'
                    }
                },
                '1160070100.39kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(26.0, 198.604, 92.329),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160070151.22kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(187.952, 204.688, 67.192),
                    'Scale': VBase3(1.199, 1.199, 1.199),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_b_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160070188.04kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 3.288, 0.0),
                    'Pos': Point3(197.099, 202.116, 65.955),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160070237.04kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(352.628, 176.1, 56.896),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_c_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160070252.31kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(-72.615, 0.0, 0.0),
                    'Pos': Point3(344.63, 182.295, 56.819),
                    'Scale': VBase3(0.838, 0.838, 0.838),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160070282.93kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(0.0, -3.611, 0.0),
                    'Pos': Point3(351.566, 186.756, 55.655),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/fern_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/fern_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/fern_trunk_a_idle',
                        'Model': 'models/vegetation/fern_trunk_c_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160070329.79kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(15.732, -4.707, 0.764),
                    'Pos': Point3(363.541, 186.54, 54.955),
                    'Scale': VBase3(1.72, 1.72, 1.72),
                    'Visual': {
                        'Model': 'models/props/rock_group_2_sphere'
                    }
                },
                '1160070393.9kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-62.976, -20.854, -11.31),
                    'Pos': Point3(337.428, 185.471, 60.058),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160070437.53kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(32.345, 0.0, 0.0),
                    'Pos': Point3(348.019, 180.197, 57.448),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160070549.34kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-20.419, -1.35, 0.0),
                    'Pos': Point3(72.173, 361.162, 19.872),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/palm_tree_f'
                    }
                },
                '1160070640.36kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(161.002, 312.562, 34.102),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160070663.53kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-7.808, -1.532, -0.21),
                    'Pos': Point3(167.202, 304.321, 38.55),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1160070743.51kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-145.392, 15.265, 1.39),
                    'Pos': Point3(-30.927, 223.217, 78.038),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160070799.83kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-145.392, 15.265, 1.39),
                    'Pos': Point3(-25.991, 215.818, 86.436),
                    'Scale': VBase3(1.229, 1.229, 1.229),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160070833.83kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(165.029, -4.154, 2.078),
                    'Pos': Point3(11.361, 219.557, 91.397),
                    'Scale': VBase3(0.783, 0.783, 0.783),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160070894.62kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(111.199, -1.639, -2.125),
                    'Pos': Point3(25.098, 200.317, 92.375),
                    'Scale': VBase3(0.783, 0.783, 0.783),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160070916.58kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(60.355, 0.614, -2.612),
                    'Pos': Point3(23.501, 211.337, 93.554),
                    'Scale': VBase3(0.783, 0.783, 0.783),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160070991.72kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, -5.66),
                    'Pos': Point3(21.895, 208.787, 94.601),
                    'Scale': VBase3(0.683, 0.683, 0.683),
                    'Visual': {
                        'Model': 'models/vegetation/palm_tree_c'
                    }
                },
                '1160071056.72kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(47.62, -4.17, 4.557),
                    'Pos': Point3(-326.085, -37.66, 29.069),
                    'Scale': VBase3(1.552, 1.552, 1.552),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1160071079.9kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(47.62, -4.17, 4.557),
                    'Pos': Point3(-352.812, -48.277, 28.334),
                    'Scale': VBase3(1.13, 1.13, 1.13),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160071140.53kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, -16.929, 0.0),
                    'Pos': Point3(-336.812, -37.034, 27.363),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160071236.9kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(11.827, 0.0, -5.496),
                    'Pos': Point3(-348.208, -1.613, 5.282),
                    'Scale': VBase3(0.54, 0.54, 0.54),
                    'Visual': {
                        'Model': 'models/vegetation/bush_leaves'
                    }
                },
                '1160071340.84kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-48.646, 2.711, 13.172),
                    'Pos': Point3(-67.926, -258.094, 20.197),
                    'Scale': VBase3(2.63, 2.63, 2.63),
                    'Visual': {
                        'Color': (0.699999988079071, 0.699999988079071, 0.699999988079071, 1.0),
                        'Model': 'models/props/rock_group_2_sphere'
                    }
                },
                '1160071379.56kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(102.008, -15.327, -14.361),
                    'Pos': Point3(-48.88, -189.654, 52.273),
                    'Scale': VBase3(2.027, 2.027, 2.027),
                    'Visual': {
                        'Color': (0.699999988079071, 0.699999988079071, 0.699999988079071, 1.0),
                        'Model': 'models/props/rock_group_5_sphere'
                    }
                },
                '1160071460.87kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(23.171, 21.363, -11.166),
                    'Pos': Point3(-58.666, -195.067, 52.229),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160071505.37kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(87.021, 2.327, -15.038),
                    'Pos': Point3(-47.178, -204.657, 51.918),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160071520.87kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-70.251, 0.0, 0.002),
                    'Pos': Point3(-45.562, -185.832, 59.247),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160071559.14kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(102.008, -15.327, -26.533),
                    'Pos': Point3(-48.554, -211.839, 48.246),
                    'Scale': VBase3(0.933, 0.933, 0.933),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/props/rock_group_3_floor'
                    }
                },
                '1160071600.78kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-15.466, 0.0, 0.0),
                    'Pos': Point3(-138.688, -106.753, 81.334),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160071669.2kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 6.599, 0.0),
                    'Pos': Point3(-164.554, -110.363, 79.458),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160071708.03kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 6.07, 0.0),
                    'Pos': Point3(-143.136, -130.933, 69.369),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160071744.45kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-53.074, -264.403, 18.054),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1160071783.78kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(84.708, 14.214, 17.073),
                    'Pos': Point3(279.637, -202.798, 0.696),
                    'Scale': VBase3(2.533, 2.533, 2.533),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/props/rock_group_2_sphere'
                    }
                },
                '1160071892.84kmuller': {
                    'Type': 'Bush',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(302.645, -242.608, 0.975),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160071938.37kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-50.359, -10.53, 0.0),
                    'Objects': {},
                    'Pos': Point3(308.718, -240.172, -0.395),
                    'Scale': VBase3(1.068, 1.068, 1.068),
                    'Visual': {
                        'Color': (0.8999999761581421, 0.8999999761581421, 0.8999999761581421, 1.0),
                        'Model': 'models/props/rock_group_3_sphere'
                    }
                },
                '1160072055.9kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, -3.686, 0.0),
                    'Pos': Point3(280.713, -222.054, 6.025),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1160072074.39kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(10.732, -16.468, 22.292),
                    'Pos': Point3(296.272, -225.672, 2.046),
                    'Scale': VBase3(1.413, 1.413, 1.413),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/props/rock_group_1_floor'
                    }
                },
                '1160072227.78kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-91.196, -7.916, -9.283),
                    'Pos': Point3(297.641, -303.505, 18.392),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160072751.79kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-62.982, 0.0, 0.0),
                    'Pos': Point3(262.301, 107.755, 26.428),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160072777.86kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(269.067, 108.674, 26.711),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1160072794.73kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-132.077, -12.707, 13.556),
                    'Pos': Point3(255.617, 106.785, 24.122),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160073127.93kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-59.544, 4.067, 17.885),
                    'Pos': Point3(221.481, 148.628, 42.546),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160074592.18kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(168.29, 1.513, -22.778),
                    'Pos': Point3(95.008, 48.7, 24.523),
                    'Scale': VBase3(0.643, 0.643, 0.643),
                    'Visual': {
                        'Model': 'models/vegetation/bush_leaves'
                    }
                },
                '1160074639.42kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(53.523, 0.0, 0.0),
                    'Pos': Point3(86.352, 52.174, 35.019),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160074680.83kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(40.538, 7.483, 0.0),
                    'Pos': Point3(131.332, 88.366, 21.998),
                    'Scale': VBase3(0.576, 0.576, 0.576),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160074730.87kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(421.249, -73.254, 16.898),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160074753.15kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(31.532, 0.0, 0.0),
                    'Pos': Point3(431.711, -73.729, 16.787),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/fern_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/fern_leaf_a_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/fern_trunk_a_idle',
                        'Model': 'models/vegetation/fern_trunk_b_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160074875.92kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(424.053, -76.221, 15.315),
                    'Scale': VBase3(0.638, 0.638, 0.638),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1160074975.68kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(142.233, 166.101, 57.522),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_c_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160075040.51kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': VBase3(0.0, -0.084, 0.0),
                    'Pos': Point3(160.864, 161.963, 51.979),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/fern_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/fern_leaf_b_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/fern_trunk_a_idle',
                        'Model': 'models/vegetation/fern_trunk_b_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160078972.09kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-0.741, 2.594, 23.346),
                    'Pos': Point3(562.973, -33.226, 4.944),
                    'Scale': VBase3(1.27, 1.27, 1.27),
                    'Visual': {
                        'Model': 'models/props/rock_group_1_floor'
                    }
                },
                '1160079118.12kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(21.053, 21.117, 4.326),
                    'Pos': Point3(540.552, -40.39, 9.204),
                    'Scale': VBase3(2.162, 2.162, 2.162),
                    'Visual': {
                        'Model': 'models/props/rock_group_4_sphere'
                    }
                },
                '1160079170.59kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-0.854, 4.256, 11.352),
                    'Pos': Point3(557.397, -32.56, 5.131),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1160079228.18kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(17.003, 8.074, -0.191),
                    'Pos': Point3(454.104, 5.838, 23.737),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160079259.33kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(50.497, 6.641, -2.903),
                    'Pos': Point3(464.071, -10.248, 20.694),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160079290.73kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, -2.148, 0.0),
                    'Pos': Point3(473.454, -23.992, 18.579),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1160079324.75kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-115.239, -5.305, 6.097),
                    'Pos': Point3(491.7, -26.776, 17.696),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160079359.11kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-115.239, -5.305, 6.097),
                    'Pos': Point3(481.808, -14.563, 19.27),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160079435.68kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(170.684, -7.374, -1.301),
                    'Pos': Point3(281.713, 168.513, 62.259),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160079500.98kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(91.723, 2.552, -5.597),
                    'Pos': Point3(314.437, 187.178, 63.04),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160079535.56kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(361.369, 173.694, 52.746),
                    'Scale': VBase3(1.155, 1.155, 1.155),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160080278.09kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-156.207, 368.167, 3.336),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160080364.51kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-43.296, -3.1, -17.568),
                    'Pos': Point3(-222.714, 318.677, 5.448),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160080373.28kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-1.421, -6.652, -12.083),
                    'Pos': Point3(-186.932, 282.3, 32.36),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160080422.5kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(47.099, -19.156, 2.548),
                    'Pos': Point3(-11.831, 286.429, 67.476),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160080475.26kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-74.056, 2.151, 0.0),
                    'Pos': Point3(-1.577, 217.673, 92.905),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160080512.36kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, -11.548, 0.0),
                    'Pos': Point3(-126.946, 318.011, 25.31),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160086520.78kmuller': {
                    'Type': 'Tree - Animated',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(40.026, 204.505, 89.049),
                    'Scale': VBase3(0.91, 0.91, 0.91),
                    'SubObjs': {
                        'Top Model': {
                            'Visual': {
                                'Animate': 'models/vegetation/palm_leaf_a_idle',
                                'Attach': ['trunk', 'def_trunk_attach'],
                                'Model': 'models/vegetation/palm_leaf_c_hi',
                                'PartName': 'leaf'
                            }
                        }
                    },
                    'Visual': {
                        'Animate': 'models/vegetation/palm_trunk_a_idle',
                        'Model': 'models/vegetation/palm_trunk_a_hi',
                        'PartName': 'trunk'
                    }
                },
                '1160086552.83kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.136),
                    'Pos': Point3(49.379, 184.57, 85.513),
                    'Scale': VBase3(0.713, 0.713, 0.713),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/vegetation/gen_tree_c'
                    }
                },
                '1160086744.34kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(18.832, 0.0, 6.255),
                    'Pos': Point3(38.718, 203.037, 89.463),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160086774.59kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, -2.488, 1.288),
                    'Pos': Point3(32.008, 220.03, 92.093),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160086828.04kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(24.379, 223.686, 90.809),
                    'Scale': VBase3(0.765, 0.765, 0.765),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1160086861.17kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(42.501, 215.046, 90.08),
                    'Scale': VBase3(0.765, 0.765, 0.765),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1160086899.48kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-96.673, 6.927, -1.205),
                    'Pos': Point3(-34.135, 237.611, 72.351),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1160086992.89kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(13.218, 230.983, 92.041),
                    'Scale': VBase3(0.596, 0.596, 0.596),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160087011.4kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-86.339, 0.0, 0.0),
                    'Pos': Point3(29.47, 232.637, 90.38),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160087252.09kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, -0.832, 0.0),
                    'Pos': Point3(53.119, 137.973, 70.437),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160087301.14kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-177.955, -11.063, -7.649),
                    'Pos': Point3(50.245, 142.061, 73.139),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160087338.73kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(4.107, 19.493, 0.0),
                    'Pos': Point3(28.468, 183.212, 90.117),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160087445.23kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(473.329, -6.159, 18.322),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1160087465.14kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(488.684, -12.247, 17.428),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160087492.83kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(97.248, 0.0, 0.0),
                    'Pos': Point3(431.742, -65.041, 17.392),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160087516.29kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(80.218, 0.0, 0.0),
                    'Pos': Point3(414.466, -73.684, 16.297),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160087641.17kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(80.22, 0.0, 0.0),
                    'Pos': Point3(436.503, -75.684, 17.371),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/rock_group_4_floor'
                    }
                },
                '1160087704.67kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(4.395, 14.237, -1.195),
                    'Pos': Point3(172.816, 165.617, 54.324),
                    'Scale': VBase3(0.667, 0.667, 0.667),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160087740.81kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(154.378, 167.644, 54.358),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160087785.65kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 2.724, 0.0),
                    'Pos': Point3(143.726, 158.728, 53.384),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1160087817.15kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 18.408, 0.0),
                    'Pos': Point3(150.232, 157.682, 53.102),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160087954.43kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-64.489, -1.234, -25.583),
                    'Pos': Point3(-103.566, 326.473, 24.728),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160088026.84kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(63.815, -24.885, 17.949),
                    'Pos': Point3(-107.016, 378.467, 4.17),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160088062.22kmuller': {
                    'Type': 'Rock',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-116.804, 383.606, -0.307),
                    'Scale': VBase3(2.857, 2.857, 2.857),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/props/rock_2_sphere'
                    }
                },
                '1160088125.18kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-35.025, -0.151, -23.782),
                    'Pos': Point3(-191.851, 273.361, 34.817),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160088191.04kmuller': {
                    'Type': 'Bush',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-210.011, 306.18, 16.645),
                    'Scale': VBase3(1.713, 1.713, 1.713),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160088317.14kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, -14.652, 0.0),
                    'Pos': Point3(201.968, 281.034, 49.329),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160088336.36kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-70.272, -1.852, -4.771),
                    'Pos': Point3(190.306, 280.473, 52.209),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160088369.62kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-59.746, -4.904, -7.624),
                    'Pos': Point3(191.922, 287.117, 48.081),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160088411.08kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-119.794, 0.0, 0.0),
                    'Pos': Point3(217.302, 279.551, 50.867),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160088443.62kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-7.808, -1.532, -0.21),
                    'Pos': Point3(210.381, 276.86, 49.585),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1160088511.83kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(273.3, 235.554, 58.41),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/gen_tree_b'
                    }
                },
                '1160088594.87kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-111.646, 3.021, -4.512),
                    'Pos': Point3(264.946, 239.099, 59.066),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160088612.22kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-111.646, 3.021, -4.512),
                    'Pos': Point3(200.834, 274.307, 59.186),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160088647.56kmuller': {
                    'Type': 'Bush',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(277.709, 235.837, 57.969),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1160089164.34kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 6.793, 0.0),
                    'Pos': Point3(321.433, 149.849, 60.15),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160089330.4kmuller': {
                    'Type': 'Bush',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-202.539, -246.667, 8.775),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160089354.56kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, -14.066),
                    'Pos': Point3(-180.87, -55.706, 85.618),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160089434.12kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 6.07, 0.0),
                    'Pos': Point3(-128.311, -204.148, 45.092),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1160089445.28kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(40.619, 11.66, -14.8),
                    'Pos': Point3(-142.303, -186.426, 49.266),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1160089511.11kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-2.593, 0.378, -8.297),
                    'Pos': Point3(-207.414, 296.708, 20.388),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160089518.79kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-25.191, -20.237, -14.34),
                    'Pos': Point3(-134.811, 310.058, 29.294),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160089552.56kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-175.107, 16.173, 12.039),
                    'Pos': Point3(-162.15, 284.917, 37.807),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1160089691.62kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(110.638, 3.783, 4.366),
                    'Pos': Point3(350.312, 190.082, 56.249),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160089726.83kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(82.929, 1.315, 5.624),
                    'Pos': Point3(270.762, 239.399, 58.241),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160089850.7kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(82.929, 1.315, 5.624),
                    'Pos': Point3(97.363, 68.133, 28.292),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160089852.06kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(82.929, 1.315, 5.624),
                    'Pos': Point3(102.363, 68.133, 28.292),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1160090494.4kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-7.575, 10.045, 2.892),
                    'Pos': Point3(-37.574, -269.966, 14.331),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160090524.81kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 13.05, 0.0),
                    'Pos': Point3(-26.189, -274.824, 14.385),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1160090566.75kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(69.043, 6.153, -15.634),
                    'Pos': Point3(-15.683, -269.629, 19.56),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160090617.5kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 9.956, 0.0),
                    'Pos': Point3(-44.293, -253.916, 24.589),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1160090775.68kmuller': {
                    'Type': 'Barrel',
                    'Hpr': VBase3(54.475, 0.0, 0.0),
                    'Pos': Point3(10.296, -42.144, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/barrel_group_1'
                    }
                },
                '1160090806.33kmuller': {
                    'Type': 'Barrel',
                    'Hpr': VBase3(-67.678, 0.0, 0.0),
                    'Pos': Point3(-56.052, -42.783, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/barrel_group_2'
                    }
                },
                '1160090865.93kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(5.667, 0.0, 0.0),
                    'Pos': Point3(-110.489, -86.468, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/table_bar_square'
                    }
                },
                '1160090885.92kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-84.925, 0.0, 0.0),
                    'Pos': Point3(-116.186, -86.257, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/stool_bar'
                    }
                },
                '1160090923.53kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-128.512, 0.0, 0.0),
                    'Pos': Point3(-108.12, -89.503, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/chair_bar'
                    }
                },
                '1160090947.42kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(6.102, 0.0, 0.0),
                    'Pos': Point3(-110.398, -82.325, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/table_bar_square'
                    }
                },
                '1160090977.17kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-3.384, 0.0, 0.0),
                    'Pos': Point3(-108.821, -78.718, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/stool_bar'
                    }
                },
                '1160091009.33kmuller': {
                    'Type': 'Jugs_and_Jars',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-110.227, -87.201, 96.333),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/winebottle_A'
                    }
                },
                '1160091077.31kmuller': {
                    'Type': 'Light_Fixtures',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-110.953, -82.453, 96.314),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/candle'
                    }
                },
                '1160091126.25kmuller': {
                    'Type': 'Light_Fixtures',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-113.944, -85.822, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/candle'
                    }
                },
                '1160091135.08kmuller': {
                    'Type': 'Light_Fixtures',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(-109.656, -85.1, 96.331),
                    'Scale': VBase3(0.953, 0.953, 0.953),
                    'Visual': {
                        'Model': 'models/props/candle'
                    }
                },
                '1160091187.76kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-98.278, -106.747, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group01'
                    }
                },
                '1160091210.48kmuller': {
                    'Type': 'Crate',
                    'Hpr': VBase3(-0.352, 0.0, 0.0),
                    'Pos': Point3(-116.023, -96.625, 93.711),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/crates_group_2'
                    }
                },
                '1160091216.39kmuller': {
                    'Type': 'Crate',
                    'Hpr': VBase3(-96.315, 0.0, 0.0),
                    'Pos': Point3(-112.788, -103.319, 93.726),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.8999999761581421, 0.8999999761581421, 0.699999988079071, 1.0),
                        'Model': 'models/props/crates_group_1'
                    }
                },
                '1160091308.37kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-163.962, 12.389, 93.738),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group_A'
                    }
                },
                '1160091321.89kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(108.69, 0.0, 0.0),
                    'Pos': Point3(-166.111, 25.955, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group04'
                    }
                },
                '1160091356.11kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(38.246, 0.0, 0.0),
                    'Pos': Point3(-155.786, 21.33, 93.691),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group03'
                    }
                },
                '1160091388.4kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(105.043, 0.0, 0.0),
                    'Pos': Point3(-190.108, 52.404, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group02'
                    }
                },
                '1160091422.15kmuller': {
                    'Type': 'Bucket',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-182.654, 136.44, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (1.0, 0.800000011920929, 0.6000000238418579, 1.0),
                        'Model': 'models/props/bucket'
                    }
                },
                '1160091440.2kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-81.577, 0.0, 0.0),
                    'Pos': Point3(-182.961, 132.141, 93.71),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/bench'
                    }
                },
                '1160091511.29kmuller': {
                    'Type': 'Cups',
                    'Hpr': VBase3(-109.04, 0.0, 0.0),
                    'Pos': Point3(-183.187, 133.886, 95.221),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/beerstein'
                    }
                },
                '1160091550.42kmuller': {
                    'Type': 'Crate',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-228.188, 208.135, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.6000000238418579, 0.6000000238418579, 0.6000000238418579, 1.0),
                        'Model': 'models/props/crates_group_1'
                    }
                },
                '1160091558.12kmuller': {
                    'Type': 'Crate',
                    'Hpr': VBase3(-100.089, 0.0, 0.0),
                    'Pos': Point3(-225.975, 233.983, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.699999988079071, 0.7300000190734863, 0.5799999833106995, 1.0),
                        'Model': 'models/props/crates_group_1'
                    }
                },
                '1160091591.22kmuller': {
                    'Type': 'Barrel',
                    'Hpr': VBase3(36.6, 0.0, 0.0),
                    'Pos': Point3(-227.068, 226.273, 93.707),
                    'Scale': VBase3(0.65, 0.65, 0.65),
                    'Visual': {
                        'Color': (0.6600000262260437, 0.5400000214576721, 0.4699999988079071, 1.0),
                        'Model': 'models/props/barrel_group_2'
                    }
                },
                '1160091642.86kmuller': {
                    'Type': 'Sack',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-227.921, 218.041, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/sack_18stack'
                    }
                },
                '1160091692.7kmuller': {
                    'Type': 'Well',
                    'Hpr': VBase3(-49.098, 0.0, 0.0),
                    'Pos': Point3(-72.458, 134.452, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/wellA'
                    }
                },
                '1160091710.01kmuller': {
                    'Type': 'Bucket',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-68.308, 128.488, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/bucket'
                    }
                },
                '1160091728.72kmuller': {
                    'Type': 'Log_Stack',
                    'Hpr': VBase3(71.682, 0.0, 0.0),
                    'Pos': Point3(-65.179, 126.016, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/Log_stack_a'
                    }
                },
                '1160091760.33kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-77.601, 0.0, 0.0),
                    'Pos': Point3(-62.898, 119.887, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/bench'
                    }
                },
                '1160091784.84kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-37.715, 0.0, 0.0),
                    'Pos': Point3(-115.445, 4.749, 142.159),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/bench'
                    }
                },
                '1160091819.33kmuller': {
                    'Type': 'Cart',
                    'Hpr': VBase3(78.987, 0.0, 0.0),
                    'Pos': Point3(-181.332, 160.144, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/cart_reg'
                    }
                },
                '1160091834.29kmuller': {
                    'Type': 'Cart',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-172.605, 210.218, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/cart_flat'
                    }
                },
                '1160092280.95kmuller': {
                    'Type': 'Cart',
                    'Hpr': VBase3(101.94, 3.936, 22.823),
                    'Pos': Point3(94.819, 2.862, 32.405),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/cart_flat'
                    }
                },
                '1160092413.89kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.299, 0.0),
                    'Pos': Point3(-46.498, -183.626, 59.91),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1160092495.59kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 25.263, 0.0),
                    'Pos': Point3(-57.793, -207.223, 49.378),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1160092671.29kmuller': {
                    'Type': 'Furniture',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(250.936, -278.4, 66.992),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/table_dice'
                    }
                },
                '1160092704.61kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-90.526, 0.0, 0.0),
                    'Pos': Point3(254.838, -280.937, 66.907),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.47058823704719543, 0.47058823704719543, 0.47058823704719543, 1.0),
                        'Model': 'models/props/bench'
                    }
                },
                '1160092721.04kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-90.526, 0.0, 0.0),
                    'Pos': Point3(247.266, -278.443, 67.044),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.47058823704719543, 0.47058823704719543, 0.47058823704719543, 1.0),
                        'Model': 'models/props/bench'
                    }
                },
                '1160092767.84kmuller': {
                    'Type': 'Furniture',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(250.467, -284.4, 67.002),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.7490196228027344, 0.7137255072593689, 0.6000000238418579, 1.0),
                        'Model': 'models/props/stool_bar'
                    }
                },
                '1160092832.95kmuller': {
                    'Type': 'Crate',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(217.535, -283.741, 67.111),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.8980392217636108, 0.8039215803146362, 0.6941176652908325, 1.0),
                        'Model': 'models/props/crates_group_1'
                    }
                },
                '1160092916.95kmuller': {
                    'Type': 'Prop_Groups',
                    'Hpr': VBase3(74.468, 0.0, 0.0),
                    'Pos': Point3(218.474, -291.832, 67.234),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/prop_group02'
                    }
                },
                '1160093600.7kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(15.235, -11.456, -10.554),
                    'Pos': Point3(-211.371, 313.23, 14.27),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160093693.17kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, -2.224, 0.0),
                    'Pos': Point3(-183.609, 328.723, 16.764),
                    'Scale': VBase3(1.943, 1.943, 1.943),
                    'Visual': {
                        'Color': (1.0, 0.9607843160629272, 0.9764705896377563, 1.0),
                        'Model': 'models/props/rock_2_sphere'
                    }
                },
                '1160093754.11kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(33.47, 0.0, 0.0),
                    'Pos': Point3(-150.779, 267.338, 40.81),
                    'Scale': VBase3(0.921, 0.921, 0.921),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1160093931.39kmuller': {
                    'Type': 'Cups',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(250.232, -275.301, 70.011),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/beerstein'
                    }
                },
                '1160093944.89kmuller': {
                    'Type': 'Cups',
                    'Hpr': VBase3(103.859, 0.0, 0.0),
                    'Pos': Point3(251.595, -281.181, 70.012),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/beerstein'
                    }
                },
                '1160093954.0kmuller': {
                    'Type': 'Cups',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(251.682, -277.409, 70.008),
                    'Scale': VBase3(0.425, 0.425, 0.425),
                    'Visual': {
                        'Model': 'models/props/cup_tin'
                    }
                },
                '1160094000.65kmuller': {
                    'Type': 'Bucket',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(250.912, -272.373, 67.017),
                    'Scale': VBase3(0.771, 0.771, 0.771),
                    'Visual': {
                        'Color': (0.800000011920929, 0.7058823704719543, 0.6078431606292725, 1.0),
                        'Model': 'models/props/bucket'
                    }
                },
                '1160094081.4kmuller': {
                    'Type': 'Sack',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-146.715, -1.119, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/sack_18stack'
                    }
                },
                '1160094095.51kmuller': {
                    'Type': 'Sack',
                    'Hpr': VBase3(-86.241, 0.0, 0.0),
                    'Pos': Point3(-150.728, -17.818, 93.891),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/sack_6stack'
                    }
                },
                '1160094149.37kmuller': {
                    'Type': 'Barrel',
                    'Hpr': VBase3(-78.166, 0.0, 0.0),
                    'Pos': Point3(-1.525, 182.301, 93.707),
                    'Scale': VBase3(0.696, 0.696, 0.696),
                    'Visual': {
                        'Model': 'models/props/barrel_group_3'
                    }
                },
                '1160094171.95kmuller': {
                    'Type': 'Barrel',
                    'Hpr': VBase3(-56.527, 0.0, 0.0),
                    'Pos': Point3(-9.033, 193.16, 93.959),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.8627451062202454, 0.8352941274642944, 0.6901960968971252, 1.0),
                        'Model': 'models/props/barrel_group_1'
                    }
                },
                '1160094263.26kmuller': {
                    'Type': 'Furniture',
                    'Hpr': VBase3(-0.286, 0.0, 0.0),
                    'Pos': Point3(0.253, 110.055, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/table_bar_round'
                    }
                },
                '1160094286.72kmuller': {
                    'Type': 'Jugs_and_Jars',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-2.443, 110.069, 96.765),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/winebottle_A'
                    }
                },
                '1160094291.26kmuller': {
                    'Type': 'Jugs_and_Jars',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-1.615, 111.853, 96.741),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/jar'
                    }
                },
                '1160094337.93kmuller': {
                    'Type': 'Jugs_and_Jars',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(0.21, 111.969, 96.734),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/waterpitcher'
                    }
                },
                '1160094383.37kmuller': {
                    'Type': 'Cups',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-5.214, 126.53, 98.397),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/cup_tin'
                    }
                },
                '1162946451.07kmuller': {
                    'Type': 'Crate',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-27.511, 196.845, 93.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/props/crates_group_2'
                    }
                },
                '1162946457.6kmuller': {
                    'Type': 'Crate',
                    'Hpr': VBase3(97.534, 0.0, 0.0),
                    'Pos': Point3(-33.481, 197.092, 93.707),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.5, 0.5, 0.5, 1.0),
                        'Model': 'models/props/crates_group_1'
                    }
                },
                '1162947099.63kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(117.571, -2.42, 21.839),
                    'Pos': Point3(15.729, 279.696, 75.789),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162947202.74kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(117.571, -2.42, 21.839),
                    'Pos': Point3(-25.984, 320.425, 42.45),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162947211.75kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(123.662, 26.471, 24.249),
                    'Pos': Point3(46.649, 306.796, 66.197),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1162947288.49kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-160.826, 24.136, 16.72),
                    'Pos': Point3(-37.28, 247.239, 70.807),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1162947373.41kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-138.351, 30.067, -4.044),
                    'Pos': Point3(-50.695, 299.793, 50.661),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1162947443.38kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-152.258, 27.045, -4.69),
                    'Pos': Point3(-169.607, 337.647, 15.761),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162947520.78kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(51.691, -24.043, 15.513),
                    'Pos': Point3(-167.285, 368.461, 2.524),
                    'Scale': VBase3(1.144, 1.144, 1.144),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162947578.05kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-1.676, -14.538, -8.972),
                    'Pos': Point3(-164.19, 356.409, 7.826),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1162947677.8kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-4.079, -21.126, -13.103),
                    'Pos': Point3(-179.888, 323.441, 20.553),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1162947951.22kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-0.282, -9.162, -3.257),
                    'Pos': Point3(-156.737, 297.009, 29.802),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1162951388.0kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(1.436, 22.391, -15.949),
                    'Pos': Point3(290.6, 92.29, 22.006),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1162951429.17kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-94.417, 14.867, 28.001),
                    'Pos': Point3(268.603, 98.615, 24.378),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162951519.92kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-57.128, 36.855, 15.197),
                    'Pos': Point3(307.899, 99.715, 40.527),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_d'
                    }
                },
                '1162951592.95kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-12.318, 0.0, 5.523),
                    'Pos': Point3(465.401, -55.322, 19.462),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1162951638.95kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(96.601, 4.136, -1.215),
                    'Pos': Point3(475.229, -55.708, 18.628),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1162951686.42kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(423.619, -66.018, 16.418),
                    'Scale': VBase3(0.638, 0.638, 0.638),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1162951881.58kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 5.938, 1.929),
                    'Pos': Point3(158.22, 77.079, 10.095),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1162951922.33kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(100.741, 0.0, 0.0),
                    'Pos': Point3(152.575, 76.736, 12.591),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162951963.28kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(100.741, 0.0, -10.635),
                    'Pos': Point3(167.822, 70.427, 6.794),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162951966.64kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-148.956, -15.305, -0.379),
                    'Pos': Point3(163.662, 76.955, 10.668),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162952014.33kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(151.585, -13.704, -12.433),
                    'Pos': Point3(180.59, 69.857, 1.747),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1162952170.28kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(66.372, 7.475, -14.398),
                    'Pos': Point3(-136.684, -226.16, 30.634),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162952250.53kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-46.718, 0.0, 0.0),
                    'Pos': Point3(-109.574, -235.172, 25.683),
                    'Scale': VBase3(3.418, 3.418, 3.418),
                    'Visual': {
                        'Model': 'models/props/rock_group_4_sphere'
                    }
                },
                '1162952348.38kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-102.423, -244.525, 23.083),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1162952358.42kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 2.966, 0.0),
                    'Pos': Point3(-88.964, -253.405, 20.238),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1162952390.07kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(63.181, 10.562, -19.97),
                    'Pos': Point3(-85.719, -241.531, 29.395),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162952577.75kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-118.613, -5.0, 19.738),
                    'Pos': Point3(-147.907, -224.448, 30.784),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1162952694.5kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(1.83, 15.672, -8.323),
                    'Pos': Point3(-160.064, -218.851, 31.136),
                    'Scale': VBase3(1.86, 1.86, 1.86),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_sphere'
                    }
                },
                '1162952785.89kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(76.929, -3.991, -19.766),
                    'Pos': Point3(-166.916, -213.421, 32.241),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162952837.8kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(67.05, -0.398, -32.331),
                    'Pos': Point3(-182.724, -225.902, 24.103),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1162952885.85kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(67.05, -0.398, -32.331),
                    'Pos': Point3(-174.847, -216.889, 29.162),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162952920.45kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(67.05, -0.398, -20.377),
                    'Pos': Point3(-195.839, -225.889, 22.631),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162952932.47kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-170.305, -25.704, 11.692),
                    'Pos': Point3(-195.529, -237.727, 15.74),
                    'Scale': VBase3(1.55, 1.55, 1.55),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162952982.63kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-26.052, 0.0, 0.0),
                    'Pos': Point3(-190.793, -239.538, 14.523),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Color': (0.800000011920929, 1.0, 0.6000000238418579, 1.0),
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1162953026.39kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-62.483, 12.498, 0.0),
                    'Pos': Point3(-235.265, -243.335, 7.722),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162953044.55kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(4.962, 16.605, -11.471),
                    'Pos': Point3(-261.245, -246.272, 4.254),
                    'Scale': VBase3(3.762, 3.762, 3.762),
                    'Visual': {
                        'Model': 'models/props/rock_group_3_sphere'
                    }
                },
                '1162953100.53kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(166.166, -21.767, 2.598),
                    'Pos': Point3(-260.793, -258.507, 0.961),
                    'Scale': VBase3(1.817, 1.817, 1.817),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1162953168.35kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.446, 7.247, -7.486),
                    'Pos': Point3(-241.216, -252.812, 4.706),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1162953222.92kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.446, 7.247, -7.486),
                    'Pos': Point3(-213.582, -241.87, 8.553),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_a'
                    }
                },
                '1162953281.13kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(161.258, 3.561, 10.526),
                    'Pos': Point3(-371.131, -23.983, 8.06),
                    'Scale': VBase3(1.817, 1.817, 1.817),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1162953328.24kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-101.632, 0.0, 22.373),
                    'Pos': Point3(-149.589, -150.366, 58.654),
                    'Scale': VBase3(2.005, 2.005, 2.005),
                    'Visual': {
                        'Model': 'models/props/rock_group_2_sphere'
                    }
                },
                '1162953389.42kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-27.608, 21.59, -0.066),
                    'Pos': Point3(-153.551, -179.596, 49.632),
                    'Scale': VBase3(1.104, 1.104, 1.104),
                    'Visual': {
                        'Model': 'models/props/rock_group_1_sphere'
                    }
                },
                '1162953437.3kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-176.059, -18.089, 8.3),
                    'Pos': Point3(-156.2, -173.475, 50.329),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1162953492.77kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-133.247, -8.188, 24.529),
                    'Pos': Point3(-145.933, -135.485, 68.109),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1162953520.67kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-97.873, 8.507, 24.426),
                    'Pos': Point3(-154.233, -147.771, 58.998),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_g'
                    }
                },
                '1162953594.86kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 5.026, 0.0),
                    'Pos': Point3(-135.843, -203.063, 42.261),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1162953598.85kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.258, 11.57, -2.242),
                    'Pos': Point3(-122.596, -210.375, 41.505),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1162953621.22kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(42.49, 18.387, -15.286),
                    'Pos': Point3(-134.904, -208.101, 41.841),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162953723.99kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(41.348, 8.094, -23.8),
                    'Pos': Point3(-146.001, -196.369, 44.835),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1162954674.64kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-87.764, 0.43, 10.515),
                    'Pos': Point3(-68.964, -245.528, 29.309),
                    'Scale': VBase3(2.869, 2.869, 2.869),
                    'Visual': {
                        'Model': 'models/props/rock_2_sphere'
                    }
                },
                '1162954767.35kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, -1.219),
                    'Pos': Point3(-77.269, -234.589, 30.675),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1162954816.24kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-73.196, 1.512, 10.34),
                    'Pos': Point3(-57.843, -247.242, 28.958),
                    'Scale': VBase3(1.215, 1.215, 1.215),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162955125.55kmuller': {
                    'Type': 'Rock',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-125.011, -234.94, 29.015),
                    'Scale': VBase3(6.031, 6.031, 6.031),
                    'Visual': {
                        'Model': 'models/props/rock_3_sphere'
                    }
                },
                '1162955275.07kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-18.76, 0.0, 0.0),
                    'Pos': Point3(-160.065, -226.912, 28.621),
                    'Scale': VBase3(3.079, 3.079, 3.079),
                    'Visual': {
                        'Model': 'models/props/rock_3_sphere'
                    }
                },
                '1162955592.95kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, 32.068, 0.0),
                    'Pos': Point3(-98.127, -238.804, 28.82),
                    'Scale': VBase3(2.363, 2.363, 2.363),
                    'Visual': {
                        'Model': 'models/props/rock_3_sphere'
                    }
                },
                '1162955879.58kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(91.186, 0.0, 0.0),
                    'Pos': Point3(300.505, -231.921, -0.182),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162955905.6kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(91.186, 0.0, 0.0),
                    'Pos': Point3(285.889, -207.867, -0.018),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162955907.32kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(91.186, 0.0, 0.0),
                    'Pos': Point3(273.191, -191.901, 0.364),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162955960.77kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(65.358, 0.0, 0.0),
                    'Pos': Point3(289.412, -217.919, -0.083),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1162956054.91kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, -3.686, 0.0),
                    'Pos': Point3(276.592, -215.324, 6.478),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1162956328.92kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-136.725, -12.574, 0.146),
                    'Pos': Point3(94.227, 50.442, 25.566),
                    'Scale': VBase3(1.226, 1.226, 1.226),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162956388.55kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-77.785, -13.594, 0.735),
                    'Pos': Point3(79.532, 57.726, 40.354),
                    'Scale': VBase3(0.759, 0.759, 0.759),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1162956444.36kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(31.185, 22.256, 13.156),
                    'Pos': Point3(76.001, 78.174, 47.775),
                    'Scale': VBase3(0.759, 0.759, 0.759),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162956505.83kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(75.011, 70.683, 47.074),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1162956566.16kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(2.428, 25.161, -19.969),
                    'Pos': Point3(304.327, 87.081, 28.894),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162956638.41kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(0.0, 12.831, -4.757),
                    'Pos': Point3(224.576, 100.559, 14.069),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1162956713.49kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(39.945, -9.029, -3.664),
                    'Pos': Point3(392.996, 6.762, 29.078),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1162956729.3kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.139, 10.317, -3.221),
                    'Pos': Point3(392.356, -3.738, 26.94),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162956889.75kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.139, 10.317, -3.221),
                    'Pos': Point3(388.456, 5.154, 28.806),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162957159.97kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(73.203, 6.127, -14.674),
                    'Pos': Point3(268.034, 163.578, 58.542),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162957187.42kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(127.866, -1.785, -13.435),
                    'Pos': Point3(288.788, 174.47, 62.34),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1162957241.95kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(168.227, -0.108, -9.195),
                    'Pos': Point3(119.942, 231.073, 77.339),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162957274.0kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(148.398, -3.198, -2.489),
                    'Pos': Point3(126.496, 239.68, 76.367),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1162957325.64kmuller': {
                    'Type': 'Tree',
                    'Hpr': VBase3(-104.604, 0.0, 0.0),
                    'Pos': Point3(120.661, 240.376, 75.623),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_b'
                    }
                },
                '1162957630.02kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(-78.425, -261.484, 18.998),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_e'
                    }
                },
                '1162957642.35kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, 0.0),
                    'Pos': Point3(-92.277, -244.369, 24.223),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_a'
                    }
                },
                '1162957844.24kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(0.0, 0.0, 5.74),
                    'Pos': Point3(41.669, 221.965, 91.112),
                    'Scale': VBase3(1.631, 1.631, 1.631),
                    'Visual': {
                        'Model': 'models/props/rock_2_sphere'
                    }
                },
                '1163011485.84kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(0.0, 0.0, 0.111),
                    'Pos': Point3(43.721, 210.112, 88.591),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1163011518.07kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(-46.695, -0.08, 3.327),
                    'Pos': Point3(43.082, 194.101, 85.435),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_i'
                    }
                },
                '1163012062.54kmuller': {
                    'Type': 'Rock',
                    'Hpr': VBase3(-45.254, 0.0, 0.0),
                    'Pos': Point3(-168.824, 293.519, 31.888),
                    'Scale': VBase3(1.356, 1.356, 1.356),
                    'Visual': {
                        'Model': 'models/props/rock_4_sphere'
                    }
                },
                '1163013915.2kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(94.701, 0.0, 0.001),
                    'Pos': Point3(151.939, 236.918, 77.419),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1163013954.48kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(57.372, 0.0, 0.001),
                    'Pos': Point3(161.084, 233.051, 77.275),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_f'
                    }
                },
                '1163013995.17kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(175.132, -13.312, 0.0),
                    'Pos': Point3(116.226, 215.584, 76.608),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1163014973.98kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(31.602, 13.58, 7.513),
                    'Pos': Point3(72.342, 87.797, 52.849),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_c'
                    }
                },
                '1163015118.07kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(71.051, 96.498, 53.161),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_c'
                    }
                },
                '1163015151.39kmuller': {
                    'Type': 'Tree',
                    'Hpr': Point3(0.0, 0.0, 0.0),
                    'Pos': Point3(58.992, 140.841, 69.351),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/fern_tree_d'
                    }
                },
                '1163015175.2kmuller': {
                    'Type': 'Bush',
                    'Hpr': VBase3(77.536, 1.96, 0.0),
                    'Pos': Point3(68.657, 99.891, 54.537),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/vegetation/bush_b'
                    }
                },
                '1164072618.04kmuller': {
                    'Type': 'Simple Fort',
                    'Hpr': VBase3(97.92, 0.0, 0.0),
                    'Pos': Point3(-42.272, 12.711, 93.5),
                    'Scale': VBase3(1.0, 1.0, 1.0),
                    'Visual': {
                        'Model': 'models/buildings/fort_medium'
                    }
                }
            },
            'Undockable': True,
            'Visual': {
                'Model': 'models/islands/pir_m_are_isl_pvpcove'
            }
        }
    },
    'Node Links': [],
    'Layers': {},
    'ObjectIds': {
        '1151689243.57hreister': '["Objects"]["1151689243.57hreister"]',
        '1151689490.21hreister': '["Objects"]["1151689243.57hreister"]["Objects"]["1151689490.21hreister"]',
        '1151690471.18hreister': '["Objects"]["1151689243.57hreister"]["Objects"]["1151690471.18hreister"]',
        '1156210410.53bbathen': '["Objects"]["1151689243.57hreister"]["Objects"]["1156210410.53bbathen"]',
        '1156210474.53bbathen': '["Objects"]["1151689243.57hreister"]["Objects"]["1156210474.53bbathen"]',
        '1156271007.17bbathen': '["Objects"]["1151689243.57hreister"]["Objects"]["1156271007.17bbathen"]',
        '1156272251.25bbathen': '["Objects"]["1151689243.57hreister"]["Objects"]["1156272251.25bbathen"]',
        '1156356079.1bbathen': '["Objects"]["1151689243.57hreister"]["Objects"]["1156356079.1bbathen"]',
        '1159462943.35kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159462943.35kmuller"]',
        '1159551936.72kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159551936.72kmuller"]',
        '1159552023.43kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159552023.43kmuller"]',
        '1159552271.06kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159552271.06kmuller"]',
        '1159552371.25kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159552371.25kmuller"]',
        '1159552660.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159552660.83kmuller"]',
        '1159552691.26kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159552691.26kmuller"]',
        '1159552807.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159552807.56kmuller"]',
        '1159555763.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159555763.83kmuller"]',
        '1159555884.76kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159555884.76kmuller"]',
        '1159556024.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159556024.17kmuller"]',
        '1159567540.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159567540.84kmuller"]',
        '1159567716.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159567716.55kmuller"]',
        '1159567796.47kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159567796.47kmuller"]',
        '1159568081.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159568081.89kmuller"]',
        '1159568276.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159568276.33kmuller"]',
        '1159568349.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159568349.97kmuller"]',
        '1159568456.23kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159568456.23kmuller"]',
        '1159569544.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159569544.56kmuller"]',
        '1159569614.05kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159569614.05kmuller"]',
        '1159569712.45kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159569712.45kmuller"]',
        '1159569773.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159569773.83kmuller"]',
        '1159569900.09kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159569900.09kmuller"]',
        '1159570204.98kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159570204.98kmuller"]',
        '1159570260.37kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159570260.37kmuller"]',
        '1159571261.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159571261.97kmuller"]',
        '1159571492.72kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159571492.72kmuller"]',
        '1159571614.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159462943.35kmuller"]["Objects"]["1159571614.58kmuller"]',
        '1159572021.7kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572021.7kmuller"]',
        '1159572104.36kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572104.36kmuller"]',
        '1159572148.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572148.33kmuller"]',
        '1159572175.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572175.89kmuller"]',
        '1159572361.37kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572361.37kmuller"]',
        '1159572620.67kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572620.67kmuller"]',
        '1159572763.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572763.56kmuller"]',
        '1159572937.51kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572937.51kmuller"]',
        '1159572983.98kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159572983.98kmuller"]',
        '1159573082.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159573082.42kmuller"]',
        '1159573356.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159573356.83kmuller"]',
        '1159573502.25kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159573502.25kmuller"]',
        '1159573636.08kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159573636.08kmuller"]',
        '1159573702.3kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159573702.3kmuller"]',
        '1159573798.31kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159573798.31kmuller"]',
        '1159573818.67kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159573818.67kmuller"]',
        '1159574029.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574029.58kmuller"]',
        '1159574144.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574144.55kmuller"]',
        '1159574235.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574235.97kmuller"]',
        '1159574274.31kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574274.31kmuller"]',
        '1159574356.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574356.55kmuller"]',
        '1159574445.28kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574445.28kmuller"]',
        '1159574574.47kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574574.47kmuller"]',
        '1159574802.43kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159574802.43kmuller"]',
        '1159575469.14kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159575469.14kmuller"]',
        '1159576451.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159576451.58kmuller"]',
        '1159576510.05kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159576510.05kmuller"]',
        '1159576548.67kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159576510.05kmuller"]["Objects"]["1159576548.67kmuller"]',
        '1159576738.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159576738.75kmuller"]',
        '1159576857.62kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159576857.62kmuller"]',
        '1159576923.68kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159576923.68kmuller"]',
        '1159577147.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159577147.55kmuller"]',
        '1159577236.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159577236.53kmuller"]',
        '1159577268.76kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159577268.76kmuller"]',
        '1159577448.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159577448.97kmuller"]',
        '1159577833.43kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159462943.35kmuller"]["Objects"]["1159577833.43kmuller"]',
        '1159577902.76kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159462943.35kmuller"]["Objects"]["1159577902.76kmuller"]',
        '1159578015.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159462943.35kmuller"]["Objects"]["1159578015.84kmuller"]',
        '1159808554.82kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159808554.82kmuller"]',
        '1159809108.24kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159809108.24kmuller"]',
        '1159809191.47kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159809191.47kmuller"]',
        '1159809750.24kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159809750.24kmuller"]',
        '1159809773.05kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159809773.05kmuller"]',
        '1159809939.04kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159809939.04kmuller"]',
        '1159810168.47kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159810168.47kmuller"]',
        '1159812067.85kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812067.85kmuller"]',
        '1159812173.0kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812173.0kmuller"]',
        '1159812223.8kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812223.8kmuller"]',
        '1159812273.94kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812273.94kmuller"]',
        '1159812329.64kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812329.64kmuller"]',
        '1159812384.66kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812384.66kmuller"]',
        '1159812656.82kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812656.82kmuller"]',
        '1159812708.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159812708.97kmuller"]',
        '1159814714.5kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159814714.5kmuller"]',
        '1159814783.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159814783.22kmuller"]',
        '1159819753.96kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159819753.96kmuller"]',
        '1159820042.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820042.97kmuller"]',
        '1159820087.38kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820087.38kmuller"]',
        '1159820178.24kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820178.24kmuller"]',
        '1159820306.86kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820306.86kmuller"]',
        '1159820328.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820328.55kmuller"]',
        '1159820372.1kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820372.1kmuller"]',
        '1159820467.16kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820467.16kmuller"]',
        '1159820521.38kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820521.38kmuller"]',
        '1159820544.63kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159820544.63kmuller"]',
        '1159821155.19kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159821155.19kmuller"]',
        '1159821184.77kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159821184.77kmuller"]',
        '1159821255.02kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159821255.02kmuller"]',
        '1159822396.69kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159822396.69kmuller"]',
        '1159822453.88kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159822453.88kmuller"]',
        '1159822498.43kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159822498.43kmuller"]',
        '1159823503.19kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159823503.19kmuller"]',
        '1159826560.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159826560.75kmuller"]',
        '1159826605.86kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159826605.86kmuller"]',
        '1159826648.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159826648.83kmuller"]',
        '1159826706.13kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159826706.13kmuller"]',
        '1159827084.23kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827084.23kmuller"]',
        '1159827151.34kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827151.34kmuller"]',
        '1159827194.69kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827194.69kmuller"]',
        '1159827293.19kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827293.19kmuller"]',
        '1159827323.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827323.89kmuller"]',
        '1159827433.94kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827433.94kmuller"]',
        '1159827751.34kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827751.34kmuller"]',
        '1159827773.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827773.75kmuller"]',
        '1159827833.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827833.78kmuller"]',
        '1159827876.98kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827876.98kmuller"]',
        '1159827903.44kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827903.44kmuller"]',
        '1159827998.0kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159827998.0kmuller"]',
        '1159828030.8kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828030.8kmuller"]',
        '1159828201.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828201.78kmuller"]',
        '1159828247.64kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159577147.55kmuller"]["Objects"]["1159828247.64kmuller"]',
        '1159828344.08kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828344.08kmuller"]',
        '1159828386.05kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828386.05kmuller"]',
        '1159828411.23kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828411.23kmuller"]',
        '1159828441.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828441.53kmuller"]',
        '1159828498.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828498.22kmuller"]',
        '1159828544.45kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828544.45kmuller"]',
        '1159828600.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828600.58kmuller"]',
        '1159828637.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828637.78kmuller"]',
        '1159828651.77kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828651.77kmuller"]',
        '1159828984.64kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159828984.64kmuller"]',
        '1159829030.14kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159829030.14kmuller"]',
        '1159830989.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159830989.97kmuller"]',
        '1159831052.66kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159831052.66kmuller"]',
        '1159831207.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159831207.56kmuller"]',
        '1159831347.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159831347.58kmuller"]',
        '1159832143.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159832143.33kmuller"]',
        '1159832489.52kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159832489.52kmuller"]',
        '1159832534.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159832534.78kmuller"]',
        '1159832931.23kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159832931.23kmuller"]',
        '1159833586.94kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159833586.94kmuller"]',
        '1159834163.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159834163.33kmuller"]',
        '1159834265.98kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159834265.98kmuller"]',
        '1159834376.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159834376.53kmuller"]',
        '1159834611.28kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159834611.28kmuller"]',
        '1159912937.08kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159912937.08kmuller"]',
        '1159912990.38kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159912990.38kmuller"]',
        '1159913095.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913095.53kmuller"]',
        '1159913183.77kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913183.77kmuller"]',
        '1159913401.3kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913401.3kmuller"]',
        '1159913473.06kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913473.06kmuller"]',
        '1159913539.72kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913539.72kmuller"]',
        '1159913595.05kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913595.05kmuller"]',
        '1159913660.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913660.17kmuller"]',
        '1159913690.28kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913690.28kmuller"]',
        '1159913748.98kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913748.98kmuller"]',
        '1159913793.27kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913793.27kmuller"]',
        '1159913823.23kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913823.23kmuller"]',
        '1159913908.91kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913908.91kmuller"]',
        '1159913989.36kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159913989.36kmuller"]',
        '1160010583.66kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160010583.66kmuller"]',
        '1160010939.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160010939.56kmuller"]',
        '1160010963.06kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160010963.06kmuller"]',
        '1160011009.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011009.56kmuller"]',
        '1160011037.36kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011037.36kmuller"]',
        '1160011089.92kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011089.92kmuller"]',
        '1160011247.69kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011247.69kmuller"]',
        '1160011305.61kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011305.61kmuller"]',
        '1160011437.08kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011437.08kmuller"]',
        '1160011469.1kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011469.1kmuller"]',
        '1160011826.73kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160011826.73kmuller"]',
        '1160012059.92kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160012059.92kmuller"]',
        '1160067780.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160067780.83kmuller"]',
        '1160067796.64kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160067796.64kmuller"]',
        '1160070100.39kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070100.39kmuller"]',
        '1160070151.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070151.22kmuller"]',
        '1160070188.04kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070188.04kmuller"]',
        '1160070237.04kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070237.04kmuller"]',
        '1160070252.31kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070252.31kmuller"]',
        '1160070282.93kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070282.93kmuller"]',
        '1160070329.79kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070329.79kmuller"]',
        '1160070393.9kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070393.9kmuller"]',
        '1160070437.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070437.53kmuller"]',
        '1160070549.34kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070549.34kmuller"]',
        '1160070640.36kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070640.36kmuller"]',
        '1160070663.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070663.53kmuller"]',
        '1160070743.51kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070743.51kmuller"]',
        '1160070799.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070799.83kmuller"]',
        '1160070833.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070833.83kmuller"]',
        '1160070894.62kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070894.62kmuller"]',
        '1160070916.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070916.58kmuller"]',
        '1160070991.72kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160070991.72kmuller"]',
        '1160071056.72kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071056.72kmuller"]',
        '1160071079.9kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071079.9kmuller"]',
        '1160071140.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071140.53kmuller"]',
        '1160071236.9kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071236.9kmuller"]',
        '1160071340.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071340.84kmuller"]',
        '1160071379.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071379.56kmuller"]',
        '1160071460.87kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071460.87kmuller"]',
        '1160071505.37kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071505.37kmuller"]',
        '1160071520.87kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071520.87kmuller"]',
        '1160071559.14kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071559.14kmuller"]',
        '1160071600.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071600.78kmuller"]',
        '1160071669.2kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071669.2kmuller"]',
        '1160071708.03kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071708.03kmuller"]',
        '1160071744.45kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071744.45kmuller"]',
        '1160071783.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071783.78kmuller"]',
        '1160071892.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071892.84kmuller"]',
        '1160071938.37kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160071938.37kmuller"]',
        '1160072055.9kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160072055.9kmuller"]',
        '1160072074.39kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160072074.39kmuller"]',
        '1160072227.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160072227.78kmuller"]',
        '1160072751.79kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160072751.79kmuller"]',
        '1160072777.86kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160072777.86kmuller"]',
        '1160072794.73kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160072794.73kmuller"]',
        '1160073127.93kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160073127.93kmuller"]',
        '1160074592.18kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160074592.18kmuller"]',
        '1160074639.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160074639.42kmuller"]',
        '1160074680.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160074680.83kmuller"]',
        '1160074730.87kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160074730.87kmuller"]',
        '1160074753.15kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160074753.15kmuller"]',
        '1160074875.92kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160074875.92kmuller"]',
        '1160074975.68kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160074975.68kmuller"]',
        '1160075040.51kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160075040.51kmuller"]',
        '1160078972.09kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160078972.09kmuller"]',
        '1160079118.12kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079118.12kmuller"]',
        '1160079170.59kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079170.59kmuller"]',
        '1160079228.18kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079228.18kmuller"]',
        '1160079259.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079259.33kmuller"]',
        '1160079290.73kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079290.73kmuller"]',
        '1160079324.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079324.75kmuller"]',
        '1160079359.11kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079359.11kmuller"]',
        '1160079435.68kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079435.68kmuller"]',
        '1160079500.98kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079500.98kmuller"]',
        '1160079535.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160079535.56kmuller"]',
        '1160080278.09kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160080278.09kmuller"]',
        '1160080364.51kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160080364.51kmuller"]',
        '1160080373.28kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160080373.28kmuller"]',
        '1160080422.5kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160080422.5kmuller"]',
        '1160080475.26kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160080475.26kmuller"]',
        '1160080512.36kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160080512.36kmuller"]',
        '1160086520.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086520.78kmuller"]',
        '1160086552.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086552.83kmuller"]',
        '1160086744.34kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086744.34kmuller"]',
        '1160086774.59kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086774.59kmuller"]',
        '1160086828.04kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086828.04kmuller"]',
        '1160086861.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086861.17kmuller"]',
        '1160086899.48kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086899.48kmuller"]',
        '1160086992.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160086992.89kmuller"]',
        '1160087011.4kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087011.4kmuller"]',
        '1160087252.09kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087252.09kmuller"]',
        '1160087301.14kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087301.14kmuller"]',
        '1160087338.73kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087338.73kmuller"]',
        '1160087445.23kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087445.23kmuller"]',
        '1160087465.14kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087465.14kmuller"]',
        '1160087492.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087492.83kmuller"]',
        '1160087516.29kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087516.29kmuller"]',
        '1160087641.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087641.17kmuller"]',
        '1160087704.67kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087704.67kmuller"]',
        '1160087740.81kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087740.81kmuller"]',
        '1160087785.65kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087785.65kmuller"]',
        '1160087817.15kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087817.15kmuller"]',
        '1160087954.43kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160087954.43kmuller"]',
        '1160088026.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088026.84kmuller"]',
        '1160088062.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088062.22kmuller"]',
        '1160088125.18kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088125.18kmuller"]',
        '1160088191.04kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088191.04kmuller"]',
        '1160088317.14kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088317.14kmuller"]',
        '1160088336.36kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088336.36kmuller"]',
        '1160088369.62kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088369.62kmuller"]',
        '1160088411.08kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088411.08kmuller"]',
        '1160088443.62kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088443.62kmuller"]',
        '1160088511.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088511.83kmuller"]',
        '1160088594.87kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088594.87kmuller"]',
        '1160088612.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088612.22kmuller"]',
        '1160088647.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160088647.56kmuller"]',
        '1160089164.34kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089164.34kmuller"]',
        '1160089330.4kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089330.4kmuller"]',
        '1160089354.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089354.56kmuller"]',
        '1160089434.12kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089434.12kmuller"]',
        '1160089445.28kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089445.28kmuller"]',
        '1160089511.11kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089511.11kmuller"]',
        '1160089518.79kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089518.79kmuller"]',
        '1160089552.56kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089552.56kmuller"]',
        '1160089691.62kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089691.62kmuller"]',
        '1160089726.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089726.83kmuller"]',
        '1160089850.7kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089850.7kmuller"]',
        '1160089852.06kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160089852.06kmuller"]',
        '1160090494.4kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090494.4kmuller"]',
        '1160090524.81kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090524.81kmuller"]',
        '1160090566.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090566.75kmuller"]',
        '1160090617.5kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090617.5kmuller"]',
        '1160090775.68kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090775.68kmuller"]',
        '1160090806.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090806.33kmuller"]',
        '1160090865.93kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090865.93kmuller"]',
        '1160090885.92kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090885.92kmuller"]',
        '1160090923.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090923.53kmuller"]',
        '1160090947.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090947.42kmuller"]',
        '1160090977.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160090977.17kmuller"]',
        '1160091009.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091009.33kmuller"]',
        '1160091077.31kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091077.31kmuller"]',
        '1160091126.25kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091126.25kmuller"]',
        '1160091135.08kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091135.08kmuller"]',
        '1160091187.76kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091187.76kmuller"]',
        '1160091210.48kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091210.48kmuller"]',
        '1160091216.39kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091216.39kmuller"]',
        '1160091308.37kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091308.37kmuller"]',
        '1160091321.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091321.89kmuller"]',
        '1160091356.11kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091356.11kmuller"]',
        '1160091388.4kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091388.4kmuller"]',
        '1160091422.15kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091422.15kmuller"]',
        '1160091440.2kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091440.2kmuller"]',
        '1160091511.29kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091511.29kmuller"]',
        '1160091550.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091550.42kmuller"]',
        '1160091558.12kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091558.12kmuller"]',
        '1160091591.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091591.22kmuller"]',
        '1160091642.86kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091642.86kmuller"]',
        '1160091692.7kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091692.7kmuller"]',
        '1160091710.01kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091710.01kmuller"]',
        '1160091728.72kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091728.72kmuller"]',
        '1160091760.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091760.33kmuller"]',
        '1160091784.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091784.84kmuller"]',
        '1160091819.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091819.33kmuller"]',
        '1160091834.29kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160091834.29kmuller"]',
        '1160092193.11kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1159462943.35kmuller"]["Objects"]["1160092193.11kmuller"]',
        '1160092280.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092280.95kmuller"]',
        '1160092413.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092413.89kmuller"]',
        '1160092495.59kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092495.59kmuller"]',
        '1160092671.29kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092671.29kmuller"]',
        '1160092704.61kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092704.61kmuller"]',
        '1160092721.04kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092721.04kmuller"]',
        '1160092767.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092767.84kmuller"]',
        '1160092832.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092832.95kmuller"]',
        '1160092916.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160092916.95kmuller"]',
        '1160093600.7kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160093600.7kmuller"]',
        '1160093693.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160093693.17kmuller"]',
        '1160093754.11kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160093754.11kmuller"]',
        '1160093931.39kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160093931.39kmuller"]',
        '1160093944.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160093944.89kmuller"]',
        '1160093954.0kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160093954.0kmuller"]',
        '1160094000.65kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094000.65kmuller"]',
        '1160094081.4kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094081.4kmuller"]',
        '1160094095.51kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094095.51kmuller"]',
        '1160094149.37kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094149.37kmuller"]',
        '1160094171.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094171.95kmuller"]',
        '1160094263.26kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094263.26kmuller"]',
        '1160094286.72kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094286.72kmuller"]',
        '1160094291.26kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094291.26kmuller"]',
        '1160094337.93kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094337.93kmuller"]',
        '1160094383.37kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1160094383.37kmuller"]',
        '1162946451.07kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162946451.07kmuller"]',
        '1162946457.6kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162946457.6kmuller"]',
        '1162947099.63kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947099.63kmuller"]',
        '1162947202.74kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947202.74kmuller"]',
        '1162947211.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947211.75kmuller"]',
        '1162947288.49kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947288.49kmuller"]',
        '1162947373.41kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947373.41kmuller"]',
        '1162947443.38kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947443.38kmuller"]',
        '1162947520.78kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947520.78kmuller"]',
        '1162947578.05kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947578.05kmuller"]',
        '1162947677.8kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947677.8kmuller"]',
        '1162947951.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162947951.22kmuller"]',
        '1162951388.0kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951388.0kmuller"]',
        '1162951429.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951429.17kmuller"]',
        '1162951519.92kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951519.92kmuller"]',
        '1162951592.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951592.95kmuller"]',
        '1162951638.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951638.95kmuller"]',
        '1162951686.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951686.42kmuller"]',
        '1162951881.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951881.58kmuller"]',
        '1162951922.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951922.33kmuller"]',
        '1162951963.28kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951963.28kmuller"]',
        '1162951966.64kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162951966.64kmuller"]',
        '1162952014.33kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952014.33kmuller"]',
        '1162952170.28kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952170.28kmuller"]',
        '1162952250.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952250.53kmuller"]',
        '1162952348.38kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952348.38kmuller"]',
        '1162952358.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952358.42kmuller"]',
        '1162952390.07kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952390.07kmuller"]',
        '1162952577.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952577.75kmuller"]',
        '1162952694.5kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952694.5kmuller"]',
        '1162952785.89kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952785.89kmuller"]',
        '1162952837.8kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952837.8kmuller"]',
        '1162952885.85kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952885.85kmuller"]',
        '1162952920.45kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952920.45kmuller"]',
        '1162952932.47kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952932.47kmuller"]',
        '1162952982.63kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162952982.63kmuller"]',
        '1162953026.39kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953026.39kmuller"]',
        '1162953044.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953044.55kmuller"]',
        '1162953100.53kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953100.53kmuller"]',
        '1162953168.35kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953168.35kmuller"]',
        '1162953222.92kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953222.92kmuller"]',
        '1162953281.13kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953281.13kmuller"]',
        '1162953328.24kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953328.24kmuller"]',
        '1162953389.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953389.42kmuller"]',
        '1162953437.3kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953437.3kmuller"]',
        '1162953492.77kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953492.77kmuller"]',
        '1162953520.67kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953520.67kmuller"]',
        '1162953594.86kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953594.86kmuller"]',
        '1162953598.85kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953598.85kmuller"]',
        '1162953621.22kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953621.22kmuller"]',
        '1162953723.99kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162953723.99kmuller"]',
        '1162954674.64kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162954674.64kmuller"]',
        '1162954767.35kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162954767.35kmuller"]',
        '1162954816.24kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162954816.24kmuller"]',
        '1162955125.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162955125.55kmuller"]',
        '1162955275.07kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162955275.07kmuller"]',
        '1162955592.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162955592.95kmuller"]',
        '1162955879.58kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162955879.58kmuller"]',
        '1162955905.6kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162955905.6kmuller"]',
        '1162955907.32kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162955907.32kmuller"]',
        '1162955960.77kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162955960.77kmuller"]',
        '1162956054.91kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956054.91kmuller"]',
        '1162956328.92kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956328.92kmuller"]',
        '1162956388.55kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956388.55kmuller"]',
        '1162956444.36kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956444.36kmuller"]',
        '1162956505.83kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956505.83kmuller"]',
        '1162956566.16kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956566.16kmuller"]',
        '1162956638.41kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956638.41kmuller"]',
        '1162956713.49kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956713.49kmuller"]',
        '1162956729.3kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956729.3kmuller"]',
        '1162956889.75kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162956889.75kmuller"]',
        '1162957159.97kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957159.97kmuller"]',
        '1162957187.42kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957187.42kmuller"]',
        '1162957241.95kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957241.95kmuller"]',
        '1162957274.0kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957274.0kmuller"]',
        '1162957325.64kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957325.64kmuller"]',
        '1162957630.02kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957630.02kmuller"]',
        '1162957642.35kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957642.35kmuller"]',
        '1162957844.24kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1162957844.24kmuller"]',
        '1163011485.84kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163011485.84kmuller"]',
        '1163011518.07kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163011518.07kmuller"]',
        '1163012062.54kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163012062.54kmuller"]',
        '1163013915.2kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163013915.2kmuller"]',
        '1163013954.48kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163013954.48kmuller"]',
        '1163013995.17kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163013995.17kmuller"]',
        '1163014973.98kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163014973.98kmuller"]',
        '1163015118.07kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163015118.07kmuller"]',
        '1163015151.39kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163015151.39kmuller"]',
        '1163015175.2kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1163015175.2kmuller"]',
        '1164072618.04kmuller': '["Objects"]["1151689243.57hreister"]["Objects"]["1164072618.04kmuller"]'
    }
}