from pandac.PandaModules import *
from direct.interval.IntervalGlobal import *
from direct.particles import ParticleEffect
from direct.particles import Particles
from direct.particles import ForceGroup
from EffectController import EffectController

class LavaSplats(NodePath, EffectController):
    cardScale = 128.0

    def __init__(self):
        NodePath.__init__(self, 'LavaSplats')
        EffectController.__init__(self)
        model = loader.loadModel('models/effects/particleMaps')
        self.card = model.find('**/pir_t_efx_msc_lavaSplash')
        self.duration = 10.0
        self.particleDummy = self.attachNewNode(ModelNode('LavaSplatsParticleDummy'))
        self.particleDummy.setDepthWrite(0)
        self.particleDummy.setColorScaleOff()
        self.particleDummy.setLightOff()
        self.particleDummy.setFogOff()
        self.particleDummy.setBin('fixed', 25)
        self.f = ParticleEffect.ParticleEffect('LavaEruption')
        self.p0 = Particles.Particles('particles-1')
        self.p0.setFactory('ZSpinParticleFactory')
        self.p0.setRenderer('SpriteParticleRenderer')
        self.p0.setEmitter('SphereVolumeEmitter')
        self.f0 = ForceGroup.ForceGroup('gravity')
        self.force0 = LinearVectorForce(Vec3(0.0, 0.0, -30.0), 2.0, 0)
        self.force0.setVectorMasks(0, 0, 1)
        self.force0.setActive(1)
        self.f0.addForce(self.force0)
        self.f.addForceGroup(self.f0)
        self.p0.setPoolSize(64)
        self.p0.setBirthRate(100)
        self.p0.setLitterSize(4)
        self.p0.setLitterSpread(0)
        self.p0.setSystemLifespan(0.0)
        self.p0.setLocalVelocityFlag(1)
        self.p0.setSystemGrowsOlderFlag(0)
        self.p0.factory.setLifespanBase(3.0)
        self.p0.factory.setLifespanSpread(0.5)
        self.p0.factory.setMassBase(1.0)
        self.p0.factory.setMassSpread(0.0)
        self.p0.factory.setTerminalVelocityBase(400.0)
        self.p0.factory.setTerminalVelocitySpread(0.0)
        self.p0.factory.setInitialAngle(0.0)
        self.p0.factory.setInitialAngleSpread(180.0)
        self.p0.factory.enableAngularVelocity(1)
        self.p0.factory.setAngularVelocity(0.0)
        self.p0.factory.setAngularVelocitySpread(50.0)
        self.p0.renderer.setAlphaMode(BaseParticleRenderer.PRALPHAOUT)
        self.p0.renderer.setUserAlpha(1.0)
        self.p0.renderer.setFromNode(self.card)
        self.p0.renderer.setColor(Vec4(1.0, 1.0, 1.0, 1.0))
        self.p0.renderer.setXScaleFlag(1)
        self.p0.renderer.setYScaleFlag(1)
        self.p0.renderer.setAnimAngleFlag(1)
        self.p0.renderer.setNonanimatedTheta(0.0)
        self.p0.renderer.setAlphaBlendMethod(BaseParticleRenderer.PPBLENDLINEAR)
        self.p0.renderer.setAlphaDisable(0)
        self.p0.renderer.setColorBlendMode(ColorBlendAttrib.MAdd, ColorBlendAttrib.OIncomingAlpha, ColorBlendAttrib.OOne)
        self.p0.emitter.setEmissionType(BaseParticleEmitter.ETRADIATE)
        self.p0.emitter.setAmplitude(1.0)
        self.p0.emitter.setAmplitudeSpread(0.0)
        self.p0.emitter.setOffsetForce(Vec3(0.0, 0.0, 30.0))
        self.p0.emitter.setExplicitLaunchVector(Vec3(1.0, 0.0, 0.0))
        self.p0.emitter.setRadiateOrigin(Point3(0.0, 0.0, 0.0))
        self.p0.emitter.setRadius(10.0)
        self.f.addParticles(self.p0)

    def setEffectScale(self, effectScale):
        if self.p0:
            self.p0.renderer.setInitialXScale(0.1 * self.cardScale * effectScale)
            self.p0.renderer.setFinalXScale(0.3 * self.cardScale * effectScale)
            self.p0.renderer.setInitialYScale(0.1 * self.cardScale * effectScale)
            self.p0.renderer.setFinalYScale(0.3 * self.cardScale * effectScale)
            self.p0.emitter.setAmplitude(20.0 * effectScale)
            self.p0.emitter.setAmplitudeSpread(5.0 * effectScale)
            self.p0.emitter.setOffsetForce(Vec3(0.0, 0.0, 150.0) * effectScale)
            self.p0.emitter.setRadius(15.0 * effectScale)

    def createTrack(self):
        self.startEffect = Sequence(Func(self.p0.setBirthRate, 0.2), Func(self.p0.clearToInitial), Func(self.f.start, self, self.particleDummy))
        self.endEffect = Sequence(Func(self.p0.setBirthRate, 100), Wait(4.5), Func(self.cleanUpEffect))
        self.track = Sequence(self.startEffect, Wait(self.duration), self.endEffect)