package ultimateguitar

type appPaths struct {
	REFRESH               string
	ALL_FAVORITE_TABS     string
	ALL_FAVORITE_PRO_TABS string
	COMMENTS              string
	COMMENT_LIKE          string
	COMMENT_DISLIKE       string
	TECHNIQUES            string
	TAB_VIDEOS            string
	VIDEO_LIKES           string
	VIDEO_VIEW            string
	VIMEO_VIDEOS          string
	USER_VIDEOS           string
	TAB_TECHNIQUES        string
	LEARNING_TRACKER      string
	CAN_PLAY_TABS         string
	PLAY_LATER_TABS       string
	CAN_PLAY_CHORDS       string
	TAB_INFO              string
	ALL_PLAYLIST          string
	PLAYLIST_TABS         string
	HISTORY               string
	TAB_SETTINGS          string
	TAB_TRACK             string
	ACCOUNT_SETTINGS      string
	APPLICATURE           string
	TAB_PRO_BROTHER       string
	EXPLORE_TABS          string
	EXPLORE_VIDEOS        string
	RANDOM                string
	RATING                string
	SUGGESTION            string
	SEARCH                string
	TAB_PACKS             string
	LOGIN                 string
	OAUTH                 string
	PASSWORD              string
	STATISTIC_DEVICE      string
	STATISTIC_INSTALL     string
	PUSH_TOKEN            string
	NEWS                  string
	UG_SERVER_TIME        string
	UG_SERVICES           string
	ANDROID_TRANSACTION   string
	FEATURED_COLLECTIONS  string
	SONGBOOK_LIKE         string
	SONGBOOK_HIT          string
	PROGRESS_SESSION      string
	PROGRESS_TAB_SESSIONS string
	PROGRESS_TRACKER      string
	AB_TESTS              string
	SEARCH_CHORDS         string
	MY_TABS		      string
}

// AppPaths is to be used as shorthand for populating URIs.
var AppPaths = appPaths{
	REFRESH:               "/auth/refresh",
	ALL_FAVORITE_TABS:     "/list/myTab",
	ALL_FAVORITE_PRO_TABS: "/list/tabPro",
	COMMENTS:              "/tab/comment",
	COMMENT_LIKE:          "/tab/comment/like",
	COMMENT_DISLIKE:       "/tab/comment/dislike",
	TECHNIQUES:            "/list/guitar/technique",
	TAB_VIDEOS:            "/video/tab",
	VIDEO_LIKES:           "/video/like",
	VIDEO_VIEW:            "/video/view",
	VIMEO_VIDEOS:          "/video/my/vimeo",
	USER_VIDEOS:           "/video/user",
	TAB_TECHNIQUES:        "/tab/technique",
	LEARNING_TRACKER:      "/list/learning/tracker",
	CAN_PLAY_TABS:         "/list/canPlay",
	PLAY_LATER_TABS:       "/list/playLater",
	CAN_PLAY_CHORDS:       "/list/chord/library",
	TAB_INFO:              "/tab/info",
	ALL_PLAYLIST:          "/list/songbook/collection",
	PLAYLIST_TABS:         "/list/songbook/tab",
	HISTORY:               "/list/history",
	TAB_SETTINGS:          "/setting/tab",
	TAB_TRACK:             "/setting/track",
	ACCOUNT_SETTINGS:      "/setting/user",
	APPLICATURE:           "/tab/applicature",
	TAB_PRO_BROTHER:       "/tab/tabProBrother",
	EXPLORE_TABS:          "/tab/explore",
	EXPLORE_VIDEOS:        "/video/explore",
	RANDOM:                "/tab/random",
	RATING:                "/tab/rating",
	SUGGESTION:            "/tab/suggestion",
	SEARCH:                "/tab/search",
	SEARCH_CHORDS:         "/tab/search/chords",
	TAB_PACKS:             "/tab/list/tabPack",
	LOGIN:                 "/auth/login",
	OAUTH:                 "/auth/oauth",
	PASSWORD:              "/auth/password",
	STATISTIC_DEVICE:      "/statistic/device",
	STATISTIC_INSTALL:     "/statistic/android/install",
	PUSH_TOKEN:            "/push/androidToken",
	NEWS:                  "/app/news",
	UG_SERVER_TIME:        "/common/hello",
	UG_SERVICES:           "/purchase/service/access",
	ANDROID_TRANSACTION:   "/purchase/transaction/android",
	FEATURED_COLLECTIONS:  "/list/songbook/featured",
	SONGBOOK_LIKE:         "/list/songbook/like",
	SONGBOOK_HIT:          "/list/songbook/hit",
	PROGRESS_SESSION:      "/list/learning/session",
	PROGRESS_TAB_SESSIONS: "/list/learning/tab",
	PROGRESS_TRACKER:      "/list/learning/tracker",
	AB_TESTS:              "/app/ab/test",
	MY_TABS:      "/list/myTab",
}
