A statically built GO/C binary that 
constructs a json dictionary describing the physical topology of
a processing node.

This will be a JSON document repersenting the device tree of the node e.g.

```json
{
    "uuid": [
        12,
        140,
        155,
        235,
        96,
        1,
        124,
        83,
        224,
        58,
        43,
        77,
        181,
        146,
        16,
        230
    ],
    "system": {
        "id": "homelaptop",
        "class": "system",
        "handle": "DMI:000F",
        "product": "23539WU (LENOVO_MT_2353)",
        "description": "Notebook",
        "vendor": "LENOVO",
        "version": "ThinkPad T430s",
        "serial": "R9WF1BH",
        "slot": "",
        "size": {
            "units": "",
            "value": ""
        },
        "capacity": {
            "units": "",
            "value": ""
        },
        "capabilities": {
            "capability": [
                {
                    "id": "smbios-2.7",
                    "description": ""
                },
                {
                    "id": "dmi-2.7",
                    "description": ""
                },
                {
                    "id": "vsyscall32",
                    "description": ""
                }
            ]
        },
        "configuration": {
            "setting": [
                {
                    "id": "administrator_password",
                    "value": ""
                },
                {
                    "id": "chassis",
                    "value": ""
                },
                {
                    "id": "family",
                    "value": ""
                },
                {
                    "id": "power-on_password",
                    "value": ""
                },
                {
                    "id": "sku",
                    "value": ""
                },
                {
                    "id": "uuid",
                    "value": ""
                }
            ]
        },
        "Nodes": [
            {
                "id": "core",
                "class": "bus",
                "handle": "DMI:0010",
                "product": "23539WU",
                "description": "Motherboard",
                "vendor": "LENOVO",
                "version": "Win8 Pro DPK TPG",
                "serial": "1ZPAR2CE1LV",
                "slot": "Not Available",
                "size": {
                    "units": "",
                    "value": ""
                },
                "capacity": {
                    "units": "",
                    "value": ""
                },
                "capabilities": {
                    "capability": null
                },
                "configuration": {
                    "setting": null
                },
                "Nodes": [
                    {
                        "id": "cpu",
                        "class": "processor",
                        "handle": "DMI:0001",
                        "product": "Intel(R) Core(TM) i7-3520M CPU @ 2.90GHz",
                        "description": "CPU",
                        "vendor": "Intel Corp.",
                        "version": "Intel(R) Core(TM) i7-3520M CPU @ 2.90GHz",
                        "serial": "None",
                        "slot": "CPU Socket - U3E1",
                        "size": {
                            "units": "Hz",
                            "value": "2822515000"
                        },
                        "capacity": {
                            "units": "Hz",
                            "value": "3600000000"
                        },
                        "capabilities": {
                            "capability": [
                                {
                                    "id": "x86-64",
                                    "description": ""
                                },
                                {
                                    "id": "fpu",
                                    "description": ""
                                },
                                {
                                    "id": "fpu_exception",
                                    "description": ""
                                },
                                {
                                    "id": "wp",
                                    "description": ""
                                },
                                {
                                    "id": "vme",
                                    "description": ""
                                },
                                {
                                    "id": "de",
                                    "description": ""
                                },
                                {
                                    "id": "pse",
                                    "description": ""
                                },
                                {
                                    "id": "tsc",
                                    "description": ""
                                },
                                {
                                    "id": "msr",
                                    "description": ""
                                },
                                {
                                    "id": "pae",
                                    "description": ""
                                },
                                {
                                    "id": "mce",
                                    "description": ""
                                },
                                {
                                    "id": "cx8",
                                    "description": ""
                                },
                                {
                                    "id": "apic",
                                    "description": ""
                                },
                                {
                                    "id": "sep",
                                    "description": ""
                                },
                                {
                                    "id": "mtrr",
                                    "description": ""
                                },
                                {
                                    "id": "pge",
                                    "description": ""
                                },
                                {
                                    "id": "mca",
                                    "description": ""
                                },
                                {
                                    "id": "cmov",
                                    "description": ""
                                },
                                {
                                    "id": "pat",
                                    "description": ""
                                },
                                {
                                    "id": "pse36",
                                    "description": ""
                                },
                                {
                                    "id": "clflush",
                                    "description": ""
                                },
                                {
                                    "id": "dts",
                                    "description": ""
                                },
                                {
                                    "id": "acpi",
                                    "description": ""
                                },
                                {
                                    "id": "mmx",
                                    "description": ""
                                },
                                {
                                    "id": "fxsr",
                                    "description": ""
                                },
                                {
                                    "id": "sse",
                                    "description": ""
                                },
                                {
                                    "id": "sse2",
                                    "description": ""
                                },
                                {
                                    "id": "ss",
                                    "description": ""
                                },
                                {
                                    "id": "ht",
                                    "description": ""
                                },
                                {
                                    "id": "tm",
                                    "description": ""
                                },
                                {
                                    "id": "pbe",
                                    "description": ""
                                },
                                {
                                    "id": "syscall",
                                    "description": ""
                                },
                                {
                                    "id": "nx",
                                    "description": ""
                                },
                                {
                                    "id": "rdtscp",
                                    "description": ""
                                },
                                {
                                    "id": "constant_tsc",
                                    "description": ""
                                },
                                {
                                    "id": "arch_perfmon",
                                    "description": ""
                                },
                                {
                                    "id": "pebs",
                                    "description": ""
                                },
                                {
                                    "id": "bts",
                                    "description": ""
                                },
                                {
                                    "id": "rep_good",
                                    "description": ""
                                },
                                {
                                    "id": "nopl",
                                    "description": ""
                                },
                                {
                                    "id": "xtopology",
                                    "description": ""
                                },
                                {
                                    "id": "nonstop_tsc",
                                    "description": ""
                                },
                                {
                                    "id": "aperfmperf",
                                    "description": ""
                                },
                                {
                                    "id": "eagerfpu",
                                    "description": ""
                                },
                                {
                                    "id": "pni",
                                    "description": ""
                                },
                                {
                                    "id": "pclmulqdq",
                                    "description": ""
                                },
                                {
                                    "id": "dtes64",
                                    "description": ""
                                },
                                {
                                    "id": "monitor",
                                    "description": ""
                                },
                                {
                                    "id": "ds_cpl",
                                    "description": ""
                                },
                                {
                                    "id": "vmx",
                                    "description": ""
                                },
                                {
                                    "id": "smx",
                                    "description": ""
                                },
                                {
                                    "id": "est",
                                    "description": ""
                                },
                                {
                                    "id": "tm2",
                                    "description": ""
                                },
                                {
                                    "id": "ssse3",
                                    "description": ""
                                },
                                {
                                    "id": "cx16",
                                    "description": ""
                                },
                                {
                                    "id": "xtpr",
                                    "description": ""
                                },
                                {
                                    "id": "pdcm",
                                    "description": ""
                                },
                                {
                                    "id": "pcid",
                                    "description": ""
                                },
                                {
                                    "id": "sse4_1",
                                    "description": ""
                                },
                                {
                                    "id": "sse4_2",
                                    "description": ""
                                },
                                {
                                    "id": "x2apic",
                                    "description": ""
                                },
                                {
                                    "id": "popcnt",
                                    "description": ""
                                },
                                {
                                    "id": "tsc_deadline_timer",
                                    "description": ""
                                },
                                {
                                    "id": "aes",
                                    "description": ""
                                },
                                {
                                    "id": "xsave",
                                    "description": ""
                                },
                                {
                                    "id": "avx",
                                    "description": ""
                                },
                                {
                                    "id": "f16c",
                                    "description": ""
                                },
                                {
                                    "id": "rdrand",
                                    "description": ""
                                },
                                {
                                    "id": "lahf_lm",
                                    "description": ""
                                },
                                {
                                    "id": "epb",
                                    "description": ""
                                },
                                {
                                    "id": "tpr_shadow",
                                    "description": ""
                                },
                                {
                                    "id": "vnmi",
                                    "description": ""
                                },
                                {
                                    "id": "flexpriority",
                                    "description": ""
                                },
                                {
                                    "id": "ept",
                                    "description": ""
                                },
                                {
                                    "id": "vpid",
                                    "description": ""
                                },
                                {
                                    "id": "fsgsbase",
                                    "description": ""
                                },
                                {
                                    "id": "smep",
                                    "description": ""
                                },
                                {
                                    "id": "erms",
                                    "description": ""
                                },
                                {
                                    "id": "xsaveopt",
                                    "description": ""
                                },
                                {
                                    "id": "dtherm",
                                    "description": ""
                                },
                                {
                                    "id": "ida",
                                    "description": ""
                                },
                                {
                                    "id": "arat",
                                    "description": ""
                                },
                                {
                                    "id": "pln",
                                    "description": ""
                                },
                                {
                                    "id": "pts",
                                    "description": ""
                                },
                                {
                                    "id": "cpufreq",
                                    "description": ""
                                }
                            ]
                        },
                        "configuration": {
                            "setting": [
                                {
                                    "id": "cores",
                                    "value": ""
                                },
                                {
                                    "id": "enabledcores",
                                    "value": ""
                                },
                                {
                                    "id": "threads",
                                    "value": ""
                                }
                            ]
                        },
                        "Nodes": [
                            {
                                "id": "cache:0",
                                "class": "memory",
                                "handle": "DMI:0003",
                                "product": "",
                                "description": "L1 cache",
                                "vendor": "",
                                "version": "",
                                "serial": "",
                                "slot": "L1-Cache",
                                "size": {
                                    "units": "bytes",
                                    "value": "32768"
                                },
                                "capacity": {
                                    "units": "bytes",
                                    "value": "32768"
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "internal",
                                            "description": ""
                                        },
                                        {
                                            "id": "write-through",
                                            "description": ""
                                        },
                                        {
                                            "id": "instruction",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "level",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "cache:1",
                                "class": "memory",
                                "handle": "DMI:0004",
                                "product": "",
                                "description": "L2 cache",
                                "vendor": "",
                                "version": "",
                                "serial": "",
                                "slot": "L2-Cache",
                                "size": {
                                    "units": "bytes",
                                    "value": "262144"
                                },
                                "capacity": {
                                    "units": "bytes",
                                    "value": "262144"
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "internal",
                                            "description": ""
                                        },
                                        {
                                            "id": "write-through",
                                            "description": ""
                                        },
                                        {
                                            "id": "unified",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "level",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "cache:2",
                                "class": "memory",
                                "handle": "DMI:0005",
                                "product": "",
                                "description": "L3 cache",
                                "vendor": "",
                                "version": "",
                                "serial": "",
                                "slot": "L3-Cache",
                                "size": {
                                    "units": "bytes",
                                    "value": "4194304"
                                },
                                "capacity": {
                                    "units": "bytes",
                                    "value": "4194304"
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "internal",
                                            "description": ""
                                        },
                                        {
                                            "id": "write-back",
                                            "description": ""
                                        },
                                        {
                                            "id": "unified",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "level",
                                            "value": ""
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        "id": "cache",
                        "class": "memory",
                        "handle": "DMI:0002",
                        "product": "",
                        "description": "L1 cache",
                        "vendor": "",
                        "version": "",
                        "serial": "",
                        "slot": "L1-Cache",
                        "size": {
                            "units": "bytes",
                            "value": "32768"
                        },
                        "capacity": {
                            "units": "bytes",
                            "value": "32768"
                        },
                        "capabilities": {
                            "capability": [
                                {
                                    "id": "internal",
                                    "description": ""
                                },
                                {
                                    "id": "write-through",
                                    "description": ""
                                },
                                {
                                    "id": "data",
                                    "description": ""
                                }
                            ]
                        },
                        "configuration": {
                            "setting": [
                                {
                                    "id": "level",
                                    "value": ""
                                }
                            ]
                        }
                    },
                    {
                        "id": "memory",
                        "class": "memory",
                        "handle": "DMI:0007",
                        "product": "",
                        "description": "System Memory",
                        "vendor": "",
                        "version": "",
                        "serial": "",
                        "slot": "System board or motherboard",
                        "size": {
                            "units": "bytes",
                            "value": "17179869184"
                        },
                        "capacity": {
                            "units": "",
                            "value": ""
                        },
                        "capabilities": {
                            "capability": null
                        },
                        "configuration": {
                            "setting": null
                        },
                        "Nodes": [
                            {
                                "id": "bank:0",
                                "class": "memory",
                                "handle": "DMI:0008",
                                "product": "M471B1G73BH0-CK0",
                                "description": "SODIMM DDR3 Synchronous 1600 MHz (0.6 ns)",
                                "vendor": "Samsung",
                                "version": "",
                                "serial": "1239F3CA",
                                "slot": "ChannelA-DIMM0",
                                "size": {
                                    "units": "bytes",
                                    "value": "8589934592"
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": null
                                },
                                "configuration": {
                                    "setting": null
                                }
                            },
                            {
                                "id": "bank:1",
                                "class": "memory",
                                "handle": "DMI:0009",
                                "product": "M471B1G73BH0-CK0",
                                "description": "SODIMM DDR3 Synchronous 1600 MHz (0.6 ns)",
                                "vendor": "Samsung",
                                "version": "",
                                "serial": "123A0EBC",
                                "slot": "ChannelB-DIMM0",
                                "size": {
                                    "units": "bytes",
                                    "value": "8589934592"
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": null
                                },
                                "configuration": {
                                    "setting": null
                                }
                            }
                        ]
                    },
                    {
                        "id": "firmware",
                        "class": "memory",
                        "handle": "",
                        "product": "",
                        "description": "BIOS",
                        "vendor": "LENOVO",
                        "version": "G7ET63WW (2.05 )",
                        "serial": "",
                        "slot": "",
                        "size": {
                            "units": "bytes",
                            "value": "131072"
                        },
                        "capacity": {
                            "units": "bytes",
                            "value": "16711680"
                        },
                        "capabilities": {
                            "capability": [
                                {
                                    "id": "pci",
                                    "description": ""
                                },
                                {
                                    "id": "pnp",
                                    "description": ""
                                },
                                {
                                    "id": "upgrade",
                                    "description": ""
                                },
                                {
                                    "id": "shadowing",
                                    "description": ""
                                },
                                {
                                    "id": "cdboot",
                                    "description": ""
                                },
                                {
                                    "id": "bootselect",
                                    "description": ""
                                },
                                {
                                    "id": "edd",
                                    "description": ""
                                },
                                {
                                    "id": "int13floppy720",
                                    "description": ""
                                },
                                {
                                    "id": "int5printscreen",
                                    "description": ""
                                },
                                {
                                    "id": "int9keyboard",
                                    "description": ""
                                },
                                {
                                    "id": "int14serial",
                                    "description": ""
                                },
                                {
                                    "id": "int17printer",
                                    "description": ""
                                },
                                {
                                    "id": "int10video",
                                    "description": ""
                                },
                                {
                                    "id": "acpi",
                                    "description": ""
                                },
                                {
                                    "id": "usb",
                                    "description": ""
                                },
                                {
                                    "id": "biosbootspecification",
                                    "description": ""
                                },
                                {
                                    "id": "uefi",
                                    "description": ""
                                }
                            ]
                        },
                        "configuration": {
                            "setting": null
                        }
                    },
                    {
                        "id": "pci",
                        "class": "bridge",
                        "handle": "PCIBUS:0000:00",
                        "product": "3rd Gen Core processor DRAM Controller",
                        "description": "Host bridge",
                        "vendor": "Intel Corporation",
                        "version": "09",
                        "serial": "",
                        "slot": "",
                        "size": {
                            "units": "",
                            "value": ""
                        },
                        "capacity": {
                            "units": "",
                            "value": ""
                        },
                        "capabilities": {
                            "capability": null
                        },
                        "configuration": {
                            "setting": [
                                {
                                    "id": "driver",
                                    "value": ""
                                }
                            ]
                        },
                        "Nodes": [
                            {
                                "id": "display",
                                "class": "display",
                                "handle": "PCI:0000:00:02.0",
                                "product": "3rd Gen Core processor Graphics Controller",
                                "description": "VGA compatible controller",
                                "vendor": "Intel Corporation",
                                "version": "09",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "vga_controller",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        },
                                        {
                                            "id": "rom",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "usb:0",
                                "class": "bus",
                                "handle": "PCI:0000:00:14.0",
                                "product": "7 Series/C210 Series Chipset Family USB xHCI Host Controller",
                                "description": "USB controller",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "xhci",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                },
                                "Nodes": [
                                    {
                                        "id": "usbhost:0",
                                        "class": "bus",
                                        "handle": "USB:4:1",
                                        "product": "xHCI Host Controller",
                                        "description": "",
                                        "vendor": "Linux 4.4.0-21-generic xhci-hcd",
                                        "version": "4.04",
                                        "serial": "",
                                        "slot": "",
                                        "size": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "usb-3.00",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": [
                                                {
                                                    "id": "driver",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "slots",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "speed",
                                                    "value": ""
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "id": "usbhost:1",
                                        "class": "bus",
                                        "handle": "USB:3:1",
                                        "product": "xHCI Host Controller",
                                        "description": "",
                                        "vendor": "Linux 4.4.0-21-generic xhci-hcd",
                                        "version": "4.04",
                                        "serial": "",
                                        "slot": "",
                                        "size": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "usb-2.00",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": [
                                                {
                                                    "id": "driver",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "slots",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "speed",
                                                    "value": ""
                                                }
                                            ]
                                        },
                                        "Nodes": [
                                            {
                                                "id": "usb",
                                                "class": "input",
                                                "handle": "USB:3:2",
                                                "product": "Fitbit Base Station",
                                                "description": "Human interface device",
                                                "vendor": "Fitbit Inc.",
                                                "version": "1.00",
                                                "serial": "",
                                                "slot": "",
                                                "size": {
                                                    "units": "",
                                                    "value": ""
                                                },
                                                "capacity": {
                                                    "units": "",
                                                    "value": ""
                                                },
                                                "capabilities": {
                                                    "capability": [
                                                        {
                                                            "id": "usb-2.00",
                                                            "description": ""
                                                        }
                                                    ]
                                                },
                                                "configuration": {
                                                    "setting": [
                                                        {
                                                            "id": "driver",
                                                            "value": ""
                                                        },
                                                        {
                                                            "id": "maxpower",
                                                            "value": ""
                                                        },
                                                        {
                                                            "id": "speed",
                                                            "value": ""
                                                        }
                                                    ]
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                "id": "communication:0",
                                "class": "communication",
                                "handle": "PCI:0000:00:16.0",
                                "product": "7 Series/C210 Series Chipset Family MEI Controller #1",
                                "description": "Communication controller",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "communication:1",
                                "class": "communication",
                                "handle": "PCI:0000:00:16.3",
                                "product": "7 Series/C210 Series Chipset Family KT Controller",
                                "description": "Serial controller",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "16550",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "network",
                                "class": "network",
                                "handle": "PCI:0000:00:19.0",
                                "product": "82579LM Gigabit Network Connection",
                                "description": "Ethernet interface",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "3c:97:0e:61:eb:a2",
                                "slot": "",
                                "size": {
                                    "units": "bit/s",
                                    "value": "1000000000"
                                },
                                "capacity": {
                                    "units": "",
                                    "value": "1000000000"
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        },
                                        {
                                            "id": "ethernet",
                                            "description": ""
                                        },
                                        {
                                            "id": "physical",
                                            "description": ""
                                        },
                                        {
                                            "id": "tp",
                                            "description": ""
                                        },
                                        {
                                            "id": "10bt",
                                            "description": ""
                                        },
                                        {
                                            "id": "10bt-fd",
                                            "description": ""
                                        },
                                        {
                                            "id": "100bt",
                                            "description": ""
                                        },
                                        {
                                            "id": "100bt-fd",
                                            "description": ""
                                        },
                                        {
                                            "id": "1000bt-fd",
                                            "description": ""
                                        },
                                        {
                                            "id": "autonegotiation",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "autonegotiation",
                                            "value": ""
                                        },
                                        {
                                            "id": "broadcast",
                                            "value": ""
                                        },
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "driverversion",
                                            "value": ""
                                        },
                                        {
                                            "id": "duplex",
                                            "value": ""
                                        },
                                        {
                                            "id": "firmware",
                                            "value": ""
                                        },
                                        {
                                            "id": "ip",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        },
                                        {
                                            "id": "link",
                                            "value": ""
                                        },
                                        {
                                            "id": "multicast",
                                            "value": ""
                                        },
                                        {
                                            "id": "port",
                                            "value": ""
                                        },
                                        {
                                            "id": "speed",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "usb:1",
                                "class": "bus",
                                "handle": "PCI:0000:00:1a.0",
                                "product": "7 Series/C210 Series Chipset Family USB Enhanced Host Controller #2",
                                "description": "USB controller",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "debug",
                                            "description": ""
                                        },
                                        {
                                            "id": "ehci",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                },
                                "Nodes": [
                                    {
                                        "id": "usbhost",
                                        "class": "bus",
                                        "handle": "USB:1:1",
                                        "product": "EHCI Host Controller",
                                        "description": "",
                                        "vendor": "Linux 4.4.0-21-generic ehci_hcd",
                                        "version": "4.04",
                                        "serial": "",
                                        "slot": "",
                                        "size": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "usb-2.00",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": [
                                                {
                                                    "id": "driver",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "slots",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "speed",
                                                    "value": ""
                                                }
                                            ]
                                        },
                                        "Nodes": [
                                            {
                                                "id": "usb",
                                                "class": "bus",
                                                "handle": "USB:1:2",
                                                "product": "Integrated Rate Matching Hub",
                                                "description": "USB hub",
                                                "vendor": "Intel Corp.",
                                                "version": "0.00",
                                                "serial": "",
                                                "slot": "",
                                                "size": {
                                                    "units": "",
                                                    "value": ""
                                                },
                                                "capacity": {
                                                    "units": "",
                                                    "value": ""
                                                },
                                                "capabilities": {
                                                    "capability": [
                                                        {
                                                            "id": "usb-2.00",
                                                            "description": ""
                                                        }
                                                    ]
                                                },
                                                "configuration": {
                                                    "setting": [
                                                        {
                                                            "id": "driver",
                                                            "value": ""
                                                        },
                                                        {
                                                            "id": "slots",
                                                            "value": ""
                                                        },
                                                        {
                                                            "id": "speed",
                                                            "value": ""
                                                        }
                                                    ]
                                                },
                                                "Nodes": [
                                                    {
                                                        "id": "usb:0",
                                                        "class": "generic",
                                                        "handle": "USB:1:3",
                                                        "product": "Biometric Coprocessor",
                                                        "description": "Generic USB device",
                                                        "vendor": "Auth",
                                                        "version": "0.01",
                                                        "serial": "",
                                                        "slot": "",
                                                        "size": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capacity": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capabilities": {
                                                            "capability": [
                                                                {
                                                                    "id": "usb-1.10",
                                                                    "description": ""
                                                                }
                                                            ]
                                                        },
                                                        "configuration": {
                                                            "setting": [
                                                                {
                                                                    "id": "maxpower",
                                                                    "value": ""
                                                                },
                                                                {
                                                                    "id": "speed",
                                                                    "value": ""
                                                                }
                                                            ]
                                                        }
                                                    },
                                                    {
                                                        "id": "usb:1",
                                                        "class": "generic",
                                                        "handle": "USB:1:4",
                                                        "product": "BCM20702A0",
                                                        "description": "Generic USB device",
                                                        "vendor": "Broadcom Corp",
                                                        "version": "1.12",
                                                        "serial": "689423EFABD5",
                                                        "slot": "",
                                                        "size": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capacity": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capabilities": {
                                                            "capability": [
                                                                {
                                                                    "id": "usb-2.00",
                                                                    "description": ""
                                                                }
                                                            ]
                                                        },
                                                        "configuration": {
                                                            "setting": [
                                                                {
                                                                    "id": "driver",
                                                                    "value": ""
                                                                },
                                                                {
                                                                    "id": "speed",
                                                                    "value": ""
                                                                }
                                                            ]
                                                        }
                                                    },
                                                    {
                                                        "id": "usb:2",
                                                        "class": "multimedia",
                                                        "handle": "USB:1:5",
                                                        "product": "Integrated Camera",
                                                        "description": "Video",
                                                        "vendor": "Ricoh Company Ltd.",
                                                        "version": "10.11",
                                                        "serial": "",
                                                        "slot": "",
                                                        "size": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capacity": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capabilities": {
                                                            "capability": [
                                                                {
                                                                    "id": "usb-2.00",
                                                                    "description": ""
                                                                }
                                                            ]
                                                        },
                                                        "configuration": {
                                                            "setting": [
                                                                {
                                                                    "id": "driver",
                                                                    "value": ""
                                                                },
                                                                {
                                                                    "id": "maxpower",
                                                                    "value": ""
                                                                },
                                                                {
                                                                    "id": "speed",
                                                                    "value": ""
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                "id": "multimedia",
                                "class": "multimedia",
                                "handle": "PCI:0000:00:1b.0",
                                "product": "7 Series/C210 Series Chipset Family High Definition Audio Controller",
                                "description": "Audio device",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "pciexpress",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "pci:0",
                                "class": "bridge",
                                "handle": "PCIBUS:0000:02",
                                "product": "7 Series/C210 Series Chipset Family PCI Express Root Port 1",
                                "description": "PCI bridge",
                                "vendor": "Intel Corporation",
                                "version": "c4",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pci",
                                            "description": ""
                                        },
                                        {
                                            "id": "pciexpress",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "normal_decode",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "pci:1",
                                "class": "bridge",
                                "handle": "PCIBUS:0000:03",
                                "product": "7 Series/C210 Series Chipset Family PCI Express Root Port 2",
                                "description": "PCI bridge",
                                "vendor": "Intel Corporation",
                                "version": "c4",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pci",
                                            "description": ""
                                        },
                                        {
                                            "id": "pciexpress",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "normal_decode",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        }
                                    ]
                                },
                                "Nodes": [
                                    {
                                        "id": "network",
                                        "class": "network",
                                        "handle": "PCI:0000:03:00.0",
                                        "product": "Centrino Advanced-N 6205 [Taylor Peak]",
                                        "description": "Wireless interface",
                                        "vendor": "Intel Corporation",
                                        "version": "34",
                                        "serial": "84:3a:4b:31:fe:7c",
                                        "slot": "",
                                        "size": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "pm",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "msi",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "pciexpress",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "bus_master",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "cap_list",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "ethernet",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "physical",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "wireless",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": [
                                                {
                                                    "id": "broadcast",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "driver",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "driverversion",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "firmware",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "ip",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "latency",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "link",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "multicast",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "wireless",
                                                    "value": ""
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            {
                                "id": "pci:2",
                                "class": "bridge",
                                "handle": "PCIBUS:0000:04",
                                "product": "7 Series/C210 Series Chipset Family PCI Express Root Port 3",
                                "description": "PCI bridge",
                                "vendor": "Intel Corporation",
                                "version": "c4",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pci",
                                            "description": ""
                                        },
                                        {
                                            "id": "pciexpress",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "normal_decode",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        }
                                    ]
                                },
                                "Nodes": [
                                    {
                                        "id": "generic",
                                        "class": "generic",
                                        "handle": "PCI:0000:04:00.0",
                                        "product": "MMC/SD Host Controller",
                                        "description": "System peripheral",
                                        "vendor": "Ricoh Co Ltd",
                                        "version": "07",
                                        "serial": "",
                                        "slot": "",
                                        "size": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "msi",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "pm",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "pciexpress",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "bus_master",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "cap_list",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": [
                                                {
                                                    "id": "driver",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "latency",
                                                    "value": ""
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            {
                                "id": "usb:2",
                                "class": "bus",
                                "handle": "PCI:0000:00:1d.0",
                                "product": "7 Series/C210 Series Chipset Family USB Enhanced Host Controller #1",
                                "description": "USB controller",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "debug",
                                            "description": ""
                                        },
                                        {
                                            "id": "ehci",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                },
                                "Nodes": [
                                    {
                                        "id": "usbhost",
                                        "class": "bus",
                                        "handle": "USB:2:1",
                                        "product": "EHCI Host Controller",
                                        "description": "",
                                        "vendor": "Linux 4.4.0-21-generic ehci_hcd",
                                        "version": "4.04",
                                        "serial": "",
                                        "slot": "",
                                        "size": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": ""
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "usb-2.00",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": [
                                                {
                                                    "id": "driver",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "slots",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "speed",
                                                    "value": ""
                                                }
                                            ]
                                        },
                                        "Nodes": [
                                            {
                                                "id": "usb",
                                                "class": "bus",
                                                "handle": "USB:2:2",
                                                "product": "Integrated Rate Matching Hub",
                                                "description": "USB hub",
                                                "vendor": "Intel Corp.",
                                                "version": "0.00",
                                                "serial": "",
                                                "slot": "",
                                                "size": {
                                                    "units": "",
                                                    "value": ""
                                                },
                                                "capacity": {
                                                    "units": "",
                                                    "value": ""
                                                },
                                                "capabilities": {
                                                    "capability": [
                                                        {
                                                            "id": "usb-2.00",
                                                            "description": ""
                                                        }
                                                    ]
                                                },
                                                "configuration": {
                                                    "setting": [
                                                        {
                                                            "id": "driver",
                                                            "value": ""
                                                        },
                                                        {
                                                            "id": "slots",
                                                            "value": ""
                                                        },
                                                        {
                                                            "id": "speed",
                                                            "value": ""
                                                        }
                                                    ]
                                                },
                                                "Nodes": [
                                                    {
                                                        "id": "usb",
                                                        "class": "bus",
                                                        "handle": "USB:2:3",
                                                        "product": "ThinkPad Mini Dock Plus Series 3",
                                                        "description": "USB hub",
                                                        "vendor": "Lenovo",
                                                        "version": "0.00",
                                                        "serial": "",
                                                        "slot": "",
                                                        "size": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capacity": {
                                                            "units": "",
                                                            "value": ""
                                                        },
                                                        "capabilities": {
                                                            "capability": [
                                                                {
                                                                    "id": "usb-2.00",
                                                                    "description": ""
                                                                }
                                                            ]
                                                        },
                                                        "configuration": {
                                                            "setting": [
                                                                {
                                                                    "id": "driver",
                                                                    "value": ""
                                                                },
                                                                {
                                                                    "id": "maxpower",
                                                                    "value": ""
                                                                },
                                                                {
                                                                    "id": "slots",
                                                                    "value": ""
                                                                },
                                                                {
                                                                    "id": "speed",
                                                                    "value": ""
                                                                }
                                                            ]
                                                        },
                                                        "Nodes": [
                                                            {
                                                                "id": "usb",
                                                                "class": "input",
                                                                "handle": "USB:2:4",
                                                                "product": "Microsoft",
                                                                "description": "Keyboard",
                                                                "vendor": "Microsoft",
                                                                "version": "7.97",
                                                                "serial": "",
                                                                "slot": "",
                                                                "size": {
                                                                    "units": "",
                                                                    "value": ""
                                                                },
                                                                "capacity": {
                                                                    "units": "",
                                                                    "value": ""
                                                                },
                                                                "capabilities": {
                                                                    "capability": [
                                                                        {
                                                                            "id": "usb-2.00",
                                                                            "description": ""
                                                                        }
                                                                    ]
                                                                },
                                                                "configuration": {
                                                                    "setting": [
                                                                        {
                                                                            "id": "driver",
                                                                            "value": ""
                                                                        },
                                                                        {
                                                                            "id": "maxpower",
                                                                            "value": ""
                                                                        },
                                                                        {
                                                                            "id": "speed",
                                                                            "value": ""
                                                                        }
                                                                    ]
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                "id": "isa",
                                "class": "bridge",
                                "handle": "PCI:0000:00:1f.0",
                                "product": "QM77 Express Chipset LPC Controller",
                                "description": "ISA bridge",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "isa",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "storage",
                                "class": "storage",
                                "handle": "PCI:0000:00:1f.2",
                                "product": "7 Series Chipset Family 6-port SATA Controller [AHCI mode]",
                                "description": "SATA controller",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "storage",
                                            "description": ""
                                        },
                                        {
                                            "id": "msi",
                                            "description": ""
                                        },
                                        {
                                            "id": "pm",
                                            "description": ""
                                        },
                                        {
                                            "id": "ahci_1.0",
                                            "description": ""
                                        },
                                        {
                                            "id": "bus_master",
                                            "description": ""
                                        },
                                        {
                                            "id": "cap_list",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "driver",
                                            "value": ""
                                        },
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                }
                            },
                            {
                                "id": "serial",
                                "class": "bus",
                                "handle": "PCI:0000:00:1f.3",
                                "product": "7 Series/C210 Series Chipset Family SMBus Controller",
                                "description": "SMBus",
                                "vendor": "Intel Corporation",
                                "version": "04",
                                "serial": "",
                                "slot": "",
                                "size": {
                                    "units": "",
                                    "value": ""
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": null
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "latency",
                                            "value": ""
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        "id": "scsi",
                        "class": "storage",
                        "handle": "",
                        "product": "",
                        "description": "",
                        "vendor": "",
                        "version": "",
                        "serial": "",
                        "slot": "",
                        "size": {
                            "units": "",
                            "value": ""
                        },
                        "capacity": {
                            "units": "",
                            "value": ""
                        },
                        "capabilities": {
                            "capability": [
                                {
                                    "id": "emulated",
                                    "description": ""
                                }
                            ]
                        },
                        "configuration": {
                            "setting": null
                        },
                        "Nodes": [
                            {
                                "id": "disk",
                                "class": "disk",
                                "handle": "SCSI:00:00:00:00",
                                "product": "Samsung SSD 840",
                                "description": "ATA Disk",
                                "vendor": "",
                                "version": "5B0Q",
                                "serial": "S1AXNSADB03901H",
                                "slot": "",
                                "size": {
                                    "units": "bytes",
                                    "value": "512110190592"
                                },
                                "capacity": {
                                    "units": "",
                                    "value": ""
                                },
                                "capabilities": {
                                    "capability": [
                                        {
                                            "id": "partitioned",
                                            "description": ""
                                        },
                                        {
                                            "id": "partitioned:dos",
                                            "description": ""
                                        }
                                    ]
                                },
                                "configuration": {
                                    "setting": [
                                        {
                                            "id": "ansiversion",
                                            "value": ""
                                        },
                                        {
                                            "id": "logicalsectorsize",
                                            "value": ""
                                        },
                                        {
                                            "id": "sectorsize",
                                            "value": ""
                                        },
                                        {
                                            "id": "signature",
                                            "value": ""
                                        }
                                    ]
                                },
                                "Nodes": [
                                    {
                                        "id": "volume:0",
                                        "class": "volume",
                                        "handle": "",
                                        "product": "",
                                        "description": "EXT4 volume",
                                        "vendor": "Linux",
                                        "version": "1.0",
                                        "serial": "b4b85815-008a-4eb2-ac07-8b4788a63624",
                                        "slot": "",
                                        "size": {
                                            "units": "bytes",
                                            "value": "495247687680"
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": "495247687680"
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "primary",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "bootable",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "journaled",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "extended_attributes",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "large_files",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "huge_files",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "dir_nlink",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "extents",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "ext4",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "ext2",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "initialized",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": [
                                                {
                                                    "id": "created",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "filesystem",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "lastmountpoint",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "modified",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "mount.fstype",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "mount.options",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "mounted",
                                                    "value": ""
                                                },
                                                {
                                                    "id": "state",
                                                    "value": ""
                                                }
                                            ]
                                        }
                                    },
                                    {
                                        "id": "volume:1",
                                        "class": "volume",
                                        "handle": "",
                                        "product": "",
                                        "description": "Extended partition",
                                        "vendor": "",
                                        "version": "",
                                        "serial": "",
                                        "slot": "",
                                        "size": {
                                            "units": "bytes",
                                            "value": "16860054528"
                                        },
                                        "capacity": {
                                            "units": "",
                                            "value": "16860054528"
                                        },
                                        "capabilities": {
                                            "capability": [
                                                {
                                                    "id": "primary",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "extended",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "partitioned",
                                                    "description": ""
                                                },
                                                {
                                                    "id": "partitioned:extended",
                                                    "description": ""
                                                }
                                            ]
                                        },
                                        "configuration": {
                                            "setting": null
                                        },
                                        "Nodes": [
                                            {
                                                "id": "logicalvolume",
                                                "class": "volume",
                                                "handle": "",
                                                "product": "",
                                                "description": "Linux swap / Solaris partition",
                                                "vendor": "",
                                                "version": "",
                                                "serial": "",
                                                "slot": "",
                                                "size": {
                                                    "units": "",
                                                    "value": ""
                                                },
                                                "capacity": {
                                                    "units": "",
                                                    "value": "16860053504"
                                                },
                                                "capabilities": {
                                                    "capability": [
                                                        {
                                                            "id": "nofs",
                                                            "description": ""
                                                        }
                                                    ]
                                                },
                                                "configuration": {
                                                    "setting": null
                                                }
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                "id": "battery:0",
                "class": "power",
                "handle": "DMI:002E",
                "product": "45N1037",
                "description": "",
                "vendor": "SANYO",
                "version": "",
                "serial": "",
                "slot": "Rear",
                "size": {
                    "units": "",
                    "value": ""
                },
                "capacity": {
                    "units": "mWh",
                    "value": "44000"
                },
                "capabilities": {
                    "capability": null
                },
                "configuration": {
                    "setting": [
                        {
                            "id": "voltage",
                            "value": ""
                        }
                    ]
                }
            },
            {
                "id": "battery:1",
                "class": "power",
                "handle": "DMI:002F",
                "product": "45N1041",
                "description": "",
                "vendor": "SONY",
                "version": "",
                "serial": "",
                "slot": "Bay",
                "size": {
                    "units": "",
                    "value": ""
                },
                "capacity": {
                    "units": "mWh",
                    "value": "31320"
                },
                "capabilities": {
                    "capability": null
                },
                "configuration": {
                    "setting": [
                        {
                            "id": "voltage",
                            "value": ""
                        }
                    ]
                }
            }
        ]
    }
}
```

This binary will spit this output to STDOUT.

- the mainboard information is extracted from SMBIOS info.

- the cpu/pci bus comes from the linux kernel

- for each layer 2 interface it will attempt to capture LLDP traffic
and extract which switch the interface is connected to a "beacon" to
be used for Ceph placement groups (insuring replication across racks to avoid
power fault lines/network partition events)

- the kernel will have booted from DHCP, we record the server that sent the DHCP response and the 
IP that it gave out. (This identifies which interface is the nodes
management interface)
