Because this tutorial was so well-received, it inspired me to write a book. The book is a much more up to date version of this tutorial and covers a lot more. Click the link below to check it out (there is also a sample chapter available).

### [Professional PHP: Building maintainable and secure applications](http://patricklouys.com/professional-php/)

![](http://patricklouys.com/img/professional-php-thumb.png)

The tutorial is still available in it's original form below.

## Create a PHP application without a framework

### Introduction

If you are new to the language, this tutorial is not for you. This tutorial is aimed at people who have grasped the basics of PHP and know a little bit about object-oriented programming.

You should have at least heard of [SOLID](http://en.wikipedia.org/wiki/SOLID_%28object-oriented_design%29). If you are not familiar with it, now would be a good time to familiarize yourself with the principles before you start with the tutorial.

I saw a lot of people coming into the Stack Overflow PHP chatroom and asking if framework X is any good. Most of the time the answer was that they should just use PHP and not a framework to build their application. But many are overwhelmed by this and don't know where to start.

So my goal with this is to provide an easy resource that people can be pointed to. In most cases a framework does not make sense and writing an application from scratch with the help of some third party packages is much, much easier than some people think.

**This tutorial was written for PHP 7.0 or newer versions.** If you are using an older version, please upgrade it before you start. I recommend that you use the [current stable version](http://php.net/downloads.php).

So let's get started right away with the [first part](01-front-controller.md).

### Parts

1. [Front Controller](01-front-controller.md)
2. [Composer](02-composer.md)
3. [Error Handler](03-error-handler.md)
4. [HTTP](04-http.md)
5. [Router](05-router.md)
6. [Dispatching to a Class](06-dispatching-to-a-class.md)
7. [Inversion of Control](07-inversion-of-control.md)
8. [Dependency Injector](08-dependency-injector.md)
9. [Templating](09-templating.md)
10. [Dynamic Pages](10-dynamic-pages.md)
11. [Page Menu](11-page-menu.md)
12. [Frontend](12-frontend.md)
