<?php
/**
 * This file is part of Part-DB (https://github.com/Part-DB/Part-DB-symfony).
 *
 * Copyright (C) 2019 - 2020 Jan Böhmer (https://github.com/jbtronics)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

namespace App\Tests\Services\Misc;

use App\Services\Misc\FAIconGenerator;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class FAIconGeneratorTest extends WebTestCase
{
    /**
     * @var FAIconGenerator
     */
    protected $service;

    protected function setUp(): void
    {
        // TODO: Change the autogenerated stub

        //Get a service instance.
        self::bootKernel();
        $this->service = self::getContainer()->get(FAIconGenerator::class);
    }

    public function fileExtensionDataProvider(): \Iterator
    {
        yield ['pdf', 'fa-file-pdf'];
        yield ['jpeg','fa-file-image'];
        yield ['txt', 'fa-file-lines'];
        yield ['doc', 'fa-file-word'];
        yield ['zip', 'fa-file-zipper'];
        yield ['png', 'fa-file-image'];
        yield ['jpg', 'fa-file-image'];
        yield ['gif', 'fa-file-image'];
        yield ['svg', 'fa-file-image'];
        yield ['xls', 'fa-file-excel'];
        yield ['xlsx', 'fa-file-excel'];
        yield ['ppt', 'fa-file-powerpoint'];
        yield ['pptx', 'fa-file-powerpoint'];
        yield ['docx', 'fa-file-word'];
        yield ['odt', 'fa-file-word'];
        yield ['ods', 'fa-file-excel'];
        yield ['odp', 'fa-file-powerpoint'];
        yield ['py', 'fa-file-code'];
        yield ['js', 'fa-file-code'];
        yield ['html', 'fa-file-code'];
        yield ['css', 'fa-file-code'];
        yield ['xml', 'fa-file-code'];
        yield ['json', 'fa-file-code'];
        yield ['yml', 'fa-file-code'];
        yield ['yaml', 'fa-file-code'];
        yield ['csv', 'fa-file-csv'];
        yield ['sql', 'fa-file-code'];
        yield ['sh', 'fa-file-code'];
        yield ['bat', 'fa-file-code'];
        yield ['exe', 'fa-file-code'];
        yield ['dll', 'fa-file-code'];
        yield ['lib', 'fa-file-code'];
        yield ['so', 'fa-file-code'];
        yield ['a', 'fa-file-code'];
        yield ['o', 'fa-file-code'];
        yield ['class', 'fa-file-code'];
        yield ['jar', 'fa-file-code'];
        yield ['rar', 'fa-file-zipper'];
        yield ['7z', 'fa-file-zipper'];
        yield ['tar', 'fa-file-zipper'];
        yield ['gz', 'fa-file-zipper'];
        yield ['tgz', 'fa-file-zipper'];
        yield ['bz2', 'fa-file-zipper'];
        yield ['tbz', 'fa-file-zipper'];
        yield ['xz', 'fa-file-zipper'];
        yield ['txz', 'fa-file-zipper'];
        yield ['zip', 'fa-file-zipper'];
        yield ['php', 'fa-file-code'];
        yield ['tmp', 'fa-file'];
        yield ['fgd', 'fa-file'];
    }

    /**
     * @dataProvider fileExtensionDataProvider
     */
    public function testFileExtensionToFAType(string $ext, string $expected): void
    {
        $this->assertSame($expected, $this->service->fileExtensionToFAType($ext), 'Failed for extension .'.$ext);
    }

    public function testGenerateIconHTML(): void
    {
        $this->assertSame('<i class="fa-solid fa-file "></i>', $this->service->generateIconHTML('fa-file'));
        $this->assertSame('<i class="far fa-file "></i>', $this->service->generateIconHTML('fa-file', 'far'));
        $this->assertSame('<i class="far fa-file fa-2x"></i>', $this->service->generateIconHTML('fa-file', 'far', 'fa-2x'));
    }
}
