<?php
/*
 * This file is part of Part-DB (https://github.com/Part-DB/Part-DB-symfony).
 *
 *  Copyright (C) 2019 - 2022 Jan Böhmer (https://github.com/jbtronics)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);

/**
 * This file is part of Part-DB (https://github.com/Part-DB/Part-DB-symfony).
 *
 * Copyright (C) 2019 - 2020 Jan Böhmer (https://github.com/jbtronics)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace App\Tests\Services\LogSystem;

use App\Entity\LogSystem\AbstractLogEntry;
use App\Entity\LogSystem\LogLevel;
use App\Entity\LogSystem\UserLoginLogEntry;
use App\Entity\LogSystem\UserLogoutLogEntry;
use App\Services\LogSystem\EventLogger;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class EventLoggerTest extends WebTestCase
{
    /**
     * @var EventLogger
     */
    protected $service;

    protected function setUp(): void
    {
        // TODO: Change the autogenerated stub

        //Get a service instance.
        self::bootKernel();
        $this->service = self::getContainer()->get(EventLogger::class);
    }

    public function testShouldBeAdded(): void
    {
        $event1 = new UserLoginLogEntry('127.0.0.1');
        $event2 = new UserLogoutLogEntry('127.0.0.1');
        $event2->setLevel(LogLevel::CRITICAL);

        //Test without restrictions
        $this->assertTrue($this->service->shouldBeAdded($event1, LogLevel::DEBUG, [], []));

        //Test minimum log level
        $this->assertFalse($this->service->shouldBeAdded($event1, LogLevel::CRITICAL, [], []));
        $this->assertTrue($this->service->shouldBeAdded($event2, LogLevel::CRITICAL, [], []));

        //Test blacklist
        $this->assertFalse($this->service->shouldBeAdded($event1, LogLevel::DEBUG, [UserLoginLogEntry::class], []));
        $this->assertTrue($this->service->shouldBeAdded($event2, LogLevel::DEBUG, [UserLoginLogEntry::class], []));

        //Test whitelist
        $this->assertFalse($this->service->shouldBeAdded($event1, LogLevel::DEBUG, [], [UserLogoutLogEntry::class]));
        $this->assertTrue($this->service->shouldBeAdded($event2, LogLevel::DEBUG, [], [UserLogoutLogEntry::class]));
    }
}
