<?php

declare(strict_types=1);

/*
 * This file is part of Part-DB (https://github.com/Part-DB/Part-DB-symfony).
 *
 *  Copyright (C) 2019 - 2022 Jan Böhmer (https://github.com/jbtronics)
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
namespace App\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RichTextEditorType extends AbstractType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver); // TODO: Change the autogenerated stub

        $resolver->setDefault('mode', 'markdown-full');
        $resolver->setAllowedValues('mode', ['html-label', 'markdown-single_line', 'markdown-full']);

        $resolver->setDefault('required', false);

    }

    public function finishView(FormView $view, FormInterface $form, array $options): void
    {
        $view->vars['attr'] = array_merge($view->vars['attr'], $this->optionsToAttrArray($options));

        parent::finishView($view, $form, $options); // TODO: Change the autogenerated stub
    }

    protected function optionsToAttrArray(array $options): array
    {
        return [
            //Set novalidate attribute, or we will get problems that form can not be submitted as textarea is not focusable
            'novalidate' => 'novalidate',
            'data-mode' => $options['mode'],
            //Add our data-controller element to the textarea
            'data-controller' => 'elements--ckeditor',
        ];
    }

    public function getParent(): string
    {
        return TextareaType::class;
    }
}
